﻿
#include "g_local.h"


qboolean	Pickup_Weapon (edict_t *ent, edict_t *other);
void		Use_Weapon (edict_t *ent, gitem_t *inv);
void		Use_Weapon2 (edict_t *ent, gitem_t *inv);
void		Drop_Weapon (edict_t *ent, gitem_t *inv);

void Weapon_Bomb (edict_t *ent);
void Weapon_Defuse (edict_t *ent);
// JOSEPH 12-OCT-98
void Weapon_Blackjack (edict_t *ent);
// JOSEPH 19-JAN-99
void Weapon_Crowbar (edict_t *ent);

// RAFAEL
void Weapon_SPistol (edict_t *ent);
void Weapon_Pistol (edict_t *ent);
void Weapon_Tommygun (edict_t *ent);

//void Weapon_Blaster (edict_t *ent);//Q2
void Weapon_Shotgun (edict_t *ent);
//void Weapon_SuperShotgun (edict_t *ent);//Q2
//void Weapon_Machinegun (edict_t *ent);//Q2
//void Weapon_Chaingun (edict_t *ent);//Q2
//void Weapon_HyperBlaster (edict_t *ent);//Q2
void Weapon_RocketLauncher (edict_t *ent);
//void Weapon_Grenade (edict_t *ent);//Q2
void Weapon_GrenadeLauncher (edict_t *ent);
//void Weapon_Railgun (edict_t *ent);//Q2
//void Weapon_BFG (edict_t *ent);//Q2
// RAFAEL
//void Weapon_Ionripper (edict_t *ent);//FREDZ Q2 Xatrix Mod
//void Weapon_Phalanx (edict_t *ent);//FREDZ Q2 Xatrix Mod
//void Weapon_Trap (edict_t *ent);//FREDZ Q2 Xatrix Mod

void Weapon_FlameThrower (edict_t *ent);

void Weapon_Barmachinegun (edict_t *ent);

//gitem_armor_t jacketarmor_info	= { 25,  50, .30, .00, ARMOR_JACKET};//Q2
//gitem_armor_t combatarmor_info	= { 50, 100, .60, .30, ARMOR_COMBAT};//Q2
//gitem_armor_t bodyarmor_info	= {100, 200, .80, .60, ARMOR_BODY};//Q2

//int	jacket_armor_index;//Q2
//int	combat_armor_index;//Q2
//int	body_armor_index;//Q2
//int	power_screen_index;//Q2
//int	power_shield_index;//Q2

//#define HEALTH_IGNORE_MAX	1//Q2
//#define HEALTH_TIMED		2//Q2

//void Use_Quad (edict_t *ent, gitem_t *item);//Q2
// RAFAEL
//void Use_QuadFire (edict_t *ent, gitem_t *item);//Q2 Xatrix Mod

//static int	quad_drop_timeout_hack;//Q2
// RAFAEL
//static int	quad_fire_drop_timeout_hack;//Q2 Xatrix Mod

//======================================================================

/*
===============
GetItemByIndex
===============
*/
gitem_t	*GetItemByIndex (int index)
{
	if (index == 0 || index >= game.num_items)
		return NULL;

	return &itemlist[index];
}


/*
===============
FindItemByClassname

===============
*/
gitem_t	*FindItemByClassname (char *classname)
{
	int		i;
	gitem_t	*it;

	it = itemlist;
	for (i=0 ; i<game.num_items ; i++, it++)
	{
		if (!it->classname)
			continue;
		if (!Q_stricmp(it->classname, classname))
			return it;
	}

	return NULL;
}

/*
===============
FindItem

===============
*/
gitem_t	*FindItem (char *pickup_name)
{
	int		i;
	gitem_t	*it;

	it = itemlist;
	for (i=0 ; i<game.num_items ; i++, it++)
	{
		if (!it->pickup_name)
			continue;
		if (!Q_stricmp(it->pickup_name, pickup_name))
			return it;
	}

	return NULL;
}

//======================================================================

void DoRespawn (edict_t *ent)
{
	if (ent->team)
	{
		edict_t	*master;
		int	count;
		int choice;

		master = ent->teammaster;

		for (count = 0, ent = master; ent; ent = ent->chain, count++)
			;

		choice = rand() % count;

		for (count = 0, ent = master; count < choice; ent = ent->chain, count++)
			;
	}

	ent->svflags &= ~SVF_NOCLIENT;
	ent->solid = SOLID_TRIGGER;
	gi.linkentity (ent);

	// send an effect
	ent->s.event = EV_ITEM_RESPAWN;
}

void SetRespawn (edict_t *ent, float delay)
{
	ent->flags |= FL_RESPAWN;
	ent->svflags |= SVF_NOCLIENT;
	ent->solid = SOLID_NOT;
	ent->nextthink = level.time + delay;
	ent->think = DoRespawn;
	gi.linkentity (ent);
}

//======================================================================
#if 0
qboolean Pickup_Powerup (edict_t *ent, edict_t *other)//FREDZ q2 stuff never used
{
	int		quantity;

	quantity = other->client->pers.inventory[ITEM_INDEX(ent->item)];
	if ((skill->value == 1 && quantity >= 2) || (skill->value >= 2 && quantity >= 1))
		return false;

	// Rafael no coop
	if ((coop->value) && (ent->item->flags & IT_STAY_COOP) && (quantity > 0))
		return false;

	other->client->pers.inventory[ITEM_INDEX(ent->item)]++;

	if (deathmatch->value)
	{
		if (!(ent->spawnflags & DROPPED_ITEM) )
			SetRespawn (ent, ent->item->quantity);

// Ridah, 27-may-99, not used
/*
		if (((int)dmflags->value & DF_INSTANT_ITEMS) || ((ent->item->use == Use_Quad) && (ent->spawnflags & DROPPED_PLAYER_ITEM)))
		{
			if ((ent->item->use == Use_Quad) && (ent->spawnflags & DROPPED_PLAYER_ITEM))
				quad_drop_timeout_hack = (ent->nextthink - level.time) / FRAMETIME;
			ent->item->use (other, ent->item);
		}
		// RAFAEL //Q2 Xatrix mod
		else if (((int)dmflags->value & DF_INSTANT_ITEMS) || ((ent->item->use == Use_QuadFire) && (ent->spawnflags & DROPPED_PLAYER_ITEM)))
		{
			if ((ent->item->use == Use_QuadFire) && (ent->spawnflags & DROPPED_PLAYER_ITEM))
				quad_fire_drop_timeout_hack = (ent->nextthink - level.time) / FRAMETIME;
			ent->item->use (other, ent->item);
		}
*/
	}

	return true;
}
#endif
void Drop_General (edict_t *ent, gitem_t *item)
{
	Drop_Item (ent, item);
	ent->client->pers.inventory[ITEM_INDEX(item)]--;
	ValidateSelectedItem (ent);
}


//======================================================================

// JOSEPH 23-APR-99
qboolean Pickup_Adrenaline (edict_t *ent, edict_t *other)
{
	//if (!deathmatch->value)//Q2
	//	other->max_health += 1;
	if (other->health>=other->max_health)//Pickup Adrenaline only if you got less then max health
		return false;

	if (other->health < other->max_health)
		other->health = other->max_health;

	if (!(ent->spawnflags & DROPPED_ITEM) && (deathmatch->value  || coop->value))//Coop
		SetRespawn (ent, 30);//Says 60 in ent->item->quantity

	return true;
}
// END JOSEPH
#if 0
qboolean Pickup_AncientHead (edict_t *ent, edict_t *other)//FREDZ q2 never used
{
	other->max_health += 2;

	if (!(ent->spawnflags & DROPPED_ITEM) && (deathmatch->value))
		SetRespawn (ent, ent->item->quantity);

	return true;
}

qboolean Pickup_Bandolier (edict_t *ent, edict_t *other)//FREDZ q2 never used
{
	gitem_t	*item;
	int		index;

	if (other->client->pers.max_bullets < 250)
		other->client->pers.max_bullets = 250;
	if (other->client->pers.max_shells < 150)
		other->client->pers.max_shells = 150;
	if (other->client->pers.max_gas < 250)
		other->client->pers.max_gas = 250;
	if (other->client->pers.max_308cal < 120)
		other->client->pers.max_308cal = 120;
	// RAFAEL
//	if (other->client->pers.max_magslug < 75)//Q2 Xatrix mod
//		other->client->pers.max_magslug = 75;

	item = FindItem("Bullets");
	if (item)
	{
		index = ITEM_INDEX(item);
		other->client->pers.inventory[index] += item->quantity;
		if (other->client->pers.inventory[index] > other->client->pers.max_bullets)
			other->client->pers.inventory[index] = other->client->pers.max_bullets;
	}

	item = FindItem("Shells");
	if (item)
	{
		index = ITEM_INDEX(item);
		other->client->pers.inventory[index] += item->quantity;
		if (other->client->pers.inventory[index] > other->client->pers.max_shells)
			other->client->pers.inventory[index] = other->client->pers.max_shells;
	}

	if (!(ent->spawnflags & DROPPED_ITEM) && (deathmatch->value))
		SetRespawn (ent, ent->item->quantity);

	return true;
}
#endif
qboolean Pickup_Pack (edict_t *ent, edict_t *other)
{
	gitem_t	*item;
	int		index;

	if (other->client->pers.max_bullets < 300)
		other->client->pers.max_bullets = 300;
	if (other->client->pers.max_shells < 200)
		other->client->pers.max_shells = 200;
	if (other->client->pers.max_rockets < 100)
		other->client->pers.max_rockets = 100;
	if (other->client->pers.max_grenades < 15)
		other->client->pers.max_grenades = 15;
	if (other->client->pers.max_gas < 300)
		other->client->pers.max_gas = 300;
	if (other->client->pers.max_308cal < 120)
		other->client->pers.max_308cal = 120;
	// RAFAEL
//	if (other->client->pers.max_magslug < 100)//Q2 Xatrix mod
//		other->client->pers.max_magslug = 100;

	item = FindItem("Bullets");
	if (item)
	{
		index = ITEM_INDEX(item);
		other->client->pers.inventory[index] += item->quantity;
		if (other->client->pers.inventory[index] > other->client->pers.max_bullets)
			other->client->pers.inventory[index] = other->client->pers.max_bullets;
	}

	item = FindItem("Shells");
	if (item)
	{
		index = ITEM_INDEX(item);
		other->client->pers.inventory[index] += item->quantity;
		if (other->client->pers.inventory[index] > other->client->pers.max_shells)
			other->client->pers.inventory[index] = other->client->pers.max_shells;
	}

	item = FindItem("Gas");
	if (item)
	{
		index = ITEM_INDEX(item);
		other->client->pers.inventory[index] += item->quantity;
		if (other->client->pers.inventory[index] > other->client->pers.max_gas)
			other->client->pers.inventory[index] = other->client->pers.max_gas;
	}

	item = FindItem("Grenades");
	if (item)
	{
		index = ITEM_INDEX(item);
		other->client->pers.inventory[index] += item->quantity;
		if (other->client->pers.inventory[index] > other->client->pers.max_grenades)
			other->client->pers.inventory[index] = other->client->pers.max_grenades;
	}

	item = FindItem("Rockets");
	if (item)
	{
		index = ITEM_INDEX(item);
		other->client->pers.inventory[index] += item->quantity;
		if (other->client->pers.inventory[index] > other->client->pers.max_rockets)
			other->client->pers.inventory[index] = other->client->pers.max_rockets;
	}

	// JOSEPH 11-APR-99
	item = FindItem("308cal");
	if (item)
	{
		index = ITEM_INDEX(item);
		other->client->pers.inventory[index] += item->quantity;
		if (other->client->pers.inventory[index] > other->client->pers.max_308cal)
			other->client->pers.inventory[index] = other->client->pers.max_308cal;
	}
	// END JOSEPH

	// RAFAEL
/*	item = FindItem ("Mag Slug");//Q2 Xatrix mod
	if (item)
	{
		index = ITEM_INDEX(item);
		other->client->pers.inventory[index] += item->quantity;
		if (other->client->pers.inventory[index] > other->client->pers.max_magslug)
			other->client->pers.inventory[index] = other->client->pers.max_magslug;
	}*/

	if (!(ent->spawnflags & DROPPED_ITEM) && (deathmatch->value))
		SetRespawn (ent, 30);//Says 180  in ent->item->quantity

	return true;
}

//======================================================================
#if 0
void Use_Quad (edict_t *ent, gitem_t *item)//FREDZ q2 never used
{
	int		timeout;

	ent->client->pers.inventory[ITEM_INDEX(item)]--;
	ValidateSelectedItem (ent);

	if (quad_drop_timeout_hack)
	{
		timeout = quad_drop_timeout_hack;
		quad_drop_timeout_hack = 0;
	}
	else
	{
		timeout = 300;
	}

	if (ent->client->quad_framenum > level.framenum)
		ent->client->quad_framenum += timeout;
	else
		ent->client->quad_framenum = level.framenum + timeout;

	// JOSEPH 29-MAR-99
	//gi.sound(ent, CHAN_ITEM, gi.soundindex("items/damage.wav"), 1, ATTN_NORM, 0);
	// END JOSEPH
}


// =====================================================================

// RAFAEL
void Use_QuadFire (edict_t *ent, gitem_t *item)//FREDZ q2 Xatrix mod never used
{
	int		timeout;

	ent->client->pers.inventory[ITEM_INDEX(item)]--;
	ValidateSelectedItem (ent);

	if (quad_fire_drop_timeout_hack)
	{
		timeout = quad_fire_drop_timeout_hack;
		quad_fire_drop_timeout_hack = 0;
	}
	else
	{
		timeout = 300;
	}

	if (ent->client->quadfire_framenum > level.framenum)
		ent->client->quadfire_framenum += timeout;
	else
		ent->client->quadfire_framenum = level.framenum + timeout;

	// JOSEPH 29-MAR-99
	//gi.sound(ent, CHAN_ITEM, gi.soundindex("items/damage.wav"), 1, ATTN_NORM, 0);
	// END JOSEPH
}


//======================================================================

void Use_Breather (edict_t *ent, gitem_t *item)//FREDZ q2 never used
{
	ent->client->pers.inventory[ITEM_INDEX(item)]--;
	ValidateSelectedItem (ent);

	if (ent->client->breather_framenum > level.framenum)
		ent->client->breather_framenum += 300;
	else
		ent->client->breather_framenum = level.framenum + 300;

//	gi.sound(ent, CHAN_ITEM, gi.soundindex("items/damage.wav"), 1, ATTN_NORM, 0);
}

//======================================================================

void Use_Envirosuit (edict_t *ent, gitem_t *item)//FREDZ q2 never used
{
	ent->client->pers.inventory[ITEM_INDEX(item)]--;
	ValidateSelectedItem (ent);

	if (ent->client->enviro_framenum > level.framenum)
		ent->client->enviro_framenum += 300;
	else
		ent->client->enviro_framenum = level.framenum + 300;

//	gi.sound(ent, CHAN_ITEM, gi.soundindex("items/damage.wav"), 1, ATTN_NORM, 0);
}

//======================================================================

void	Use_Invulnerability (edict_t *ent, gitem_t *item)//FREDZ q2 never used
{
	ent->client->pers.inventory[ITEM_INDEX(item)]--;
	ValidateSelectedItem (ent);

	if (ent->client->invincible_framenum > level.framenum)
		ent->client->invincible_framenum += 300;
	else
		ent->client->invincible_framenum = level.framenum + 300;

	// JOSEPH 29-MAR-99 
	//gi.sound(ent, CHAN_ITEM, gi.soundindex("items/protect.wav"), 1, ATTN_NORM, 0);
	// END JOSEPH
}

//======================================================================

void	Use_Silencer (edict_t *ent, gitem_t *item)//Q2
{
	// do not use anymore
	return;

//	ent->client->pers.inventory[ITEM_INDEX(item)]--;
//	ValidateSelectedItem (ent);
//	ent->client->pers.silencer_shots += 30;

//	gi.sound(ent, CHAN_ITEM, gi.soundindex("items/damage.wav"), 1, ATTN_NORM, 0);
}
#endif
//======================================================================

qboolean Pickup_Key (edict_t *ent, edict_t *other)
{
	// JOSEPH 26-JAN-99
	//ent->item->pickup_sound = "world/pickups/keys.wav";
	// END JOSEPH
	
	// Rafael no coop
/*	if (coop->value)//FREDZ q2 stuff
	{
		if (strcmp(ent->classname, "key_fuse") == 0)//key_power_cube
		{
			if (other->client->pers.fusekey & ((ent->spawnflags & 0x0000ff00)>> 8))
				return false;
			other->client->pers.inventory[ITEM_INDEX(ent->item)]++;
			other->client->pers.fusekey |= ((ent->spawnflags & 0x0000ff00) >> 8);
		}
		else
		{
			if (other->client->pers.inventory[ITEM_INDEX(ent->item)])
				return false;
			other->client->pers.inventory[ITEM_INDEX(ent->item)] = 1;
		}
		return true;
	}*/

	//FREDZ updated, only key_fuse should be pickupd twice, but people can walk twice
	if (((strcmp(ent->classname, "item_flashlight") == 0) ||
		(strcmp(ent->classname, "item_coil") == 0) ||
		(strcmp(ent->classname, "item_lizzyhead") == 0) ||
		(strcmp(ent->classname, "item_oilcan") == 0) ||
		(strcmp(ent->classname, "item_safedocs") == 0) ||
		(strcmp(ent->classname, "item_whiskey") == 0) ||
		(strcmp(ent->classname, "item_watch") == 0) ||
		(strcmp(ent->classname, "item_valve") == 0) ||
		(strcmp(ent->classname, "key_fuse") == 0) ||//map ty3
        (strcmp(ent->classname, "key_fuse1") == 0) ||//fix for map pv_b
        (strcmp(ent->classname, "key_fuse2") == 0) ||//fix for map pv_b
		(strcmp(ent->classname, "key_key1") == 0) ||
		(strcmp(ent->classname, "key_key2") == 0) ||
		(strcmp(ent->classname, "key_key3") == 0) ||
		(strcmp(ent->classname, "key_key4") == 0) ||
		(strcmp(ent->classname, "key_key5") == 0) ||
		(strcmp(ent->classname, "key_key6") == 0) ||
		(strcmp(ent->classname, "key_key7") == 0) ||
		(strcmp(ent->classname, "key_key8") == 0) ||
		(strcmp(ent->classname, "key_key9") == 0) ||
		(strcmp(ent->classname, "key_key10") == 0) ||
		(strcmp(ent->classname, "item_battery") == 0)) &&
		other->client->pers.inventory[ITEM_INDEX(ent->item)])
            return false;
	else
		other->client->pers.inventory[ITEM_INDEX(ent->item)]=1;

	if (!(ent->spawnflags & DROPPED_ITEM) && (deathmatch->value || coop->value))//Coop
		SetRespawn (ent, 30);
	return true;
}

//======================================================================

qboolean Add_Ammo (edict_t *ent, gitem_t *item, int count)
{
	int			index;
	int			max;

	if (!ent->client)
		return false;

	if (item->tag == AMMO_BULLETS)
		max = ent->client->pers.max_bullets;
	else if (item->tag == AMMO_SHELLS)
		max = ent->client->pers.max_shells;
	else if (item->tag == AMMO_ROCKETS)
		max = ent->client->pers.max_rockets;
	else if (item->tag == AMMO_GRENADES)
		max = ent->client->pers.max_grenades;
	else if (item->tag == AMMO_GAS)
		max = ent->client->pers.max_gas;
	else if (item->tag == AMMO_308CAL)
		max = ent->client->pers.max_308cal;
//	else if (item->tag == AMMO_MAGSLUG)//Q2 Xatrix mod
//		max = ent->client->pers.max_magslug;
//	else if (item->tag == AMMO_TRAP)//Q2 Xatrix mod
//		max = ent->client->pers.max_trap;
	else
		return false;

	index = ITEM_INDEX(item);

	if (ent->client->pers.inventory[index] == max)
		return false;

	ent->client->pers.inventory[index] += count;

	if (ent->client->pers.inventory[index] > max)
		ent->client->pers.inventory[index] = max;

	return true;
}

qboolean Pickup_Ammo_Cylinder (edict_t *ent, edict_t *other)
{
	gitem_t	*it;
	int		index;

	it = FindItem("Bullets");
	if (it)
	{
		index = ITEM_INDEX(it);
		if (other->client->pers.inventory[index] >= other->client->pers.max_bullets)
			return false;

		other->client->pers.inventory[index] += ent->item->quantity; // get the cylinder quantity
		if (other->client->pers.inventory[index] > other->client->pers.max_bullets)
			other->client->pers.inventory[index] = other->client->pers.max_bullets;
	}

	if (!(ent->spawnflags & (DROPPED_ITEM | DROPPED_PLAYER_ITEM)) && (deathmatch->value))
		SetRespawn (ent, 30);
	
	return true;
}

qboolean Pickup_Ammo (edict_t *ent, edict_t *other)
{
	int			oldcount;
	int			count;
	qboolean	weapon;

	weapon = (ent->item->flags & IT_WEAPON);
	if ( (weapon) && deathmatch->value && ( (int)dmflags->value & DF_INFINITE_AMMO ) )
		count = 1000;
	else if (ent->count)
		count = ent->count;
	else
		count = ent->item->quantity;

	oldcount = other->client->pers.inventory[ITEM_INDEX(ent->item)];

	if (!Add_Ammo (other, ent->item, count))
		return false;

/*	if (weapon && !oldcount)//Q2
	{
		if (other->client->pers.weapon != ent->item && ( !deathmatch->value || other->client->pers.weapon == FindItem("blaster") ) )
			other->client->newweapon = ent->item;
	}*/

	if (!(ent->spawnflags & (DROPPED_ITEM | DROPPED_PLAYER_ITEM)) && (deathmatch->value))
		SetRespawn (ent, 30);
	return true;
}

void Drop_Ammo (edict_t *ent, gitem_t *item)
{
	edict_t	*dropped;
	int		index;

	index = ITEM_INDEX(item);
	
	if (ent->client->pers.inventory[index] <= 0)
		return;
	
	dropped = Drop_Item (ent, item);
	if (ent->client->pers.inventory[index] >= item->quantity)
		dropped->count = item->quantity;
	else
		dropped->count = ent->client->pers.inventory[index];

	// snap
	/*
	if (ent->client->pers.weapon && 
		ent->client->pers.weapon->tag == AMMO_GRENADES &&
		item->tag == AMMO_GRENADES &&
		ent->client->pers.inventory[index] - dropped->count <= 0) {
		cprintf (ent, PRINT_HIGH, "Can't drop current weapon\n");
		G_FreeEdict(dropped);
		return;
	}*/

	ent->client->pers.inventory[index] -= dropped->count;
	ValidateSelectedItem (ent);
}


// JOSEPH 18-MAR-99
qboolean Pickup_Cash (edict_t *ent, edict_t *other)
{

	if (!ent->currentcash)
	//	cprintf (other, PRINT_HIGH, "%i dollars found\n", ent->currentcash);
	//else
		cprintf (other, PRINT_HIGH, "Counterfeit money! 0 dollars found\n", ent->currentcash);


	if (ent->currentcash > 0)
	{
		if (teamplay->value && (teamplay_mode == TM_GRABDALOOT))
		{
			if (other->client->pers.currentcash > MAX_CASH_PLAYER)
				return false;
		}

		other->client->ps.stats[STAT_CASH_PICKUP] = ent->currentcash;
		other->client->pers.currentcash += ent->currentcash;

		if (teamplay->value && (teamplay_mode == TM_GRABDALOOT))
		{
			if (other->client->pers.currentcash > MAX_CASH_PLAYER)
				other->client->pers.currentcash = MAX_CASH_PLAYER;
		}
	}
	else	// negative money is bagged money (used in Teamplay)
	{
		if (teamplay->value && (teamplay_mode == TM_GRABDALOOT))
		{
			if (other->client->pers.bagcash > MAX_BAGCASH_PLAYER)
				other->client->pers.bagcash = MAX_BAGCASH_PLAYER;
		}

		ent->currentcash = -ent->currentcash;
		other->client->pers.bagcash += ent->currentcash;

		if (teamplay->value && (teamplay_mode == TM_GRABDALOOT))
		{
			if (other->client->pers.bagcash > MAX_BAGCASH_PLAYER)
			{
				edict_t *cash;

				// leave the left-over money here in a smaller bag
				if ((other->client->pers.bagcash - MAX_BAGCASH_PLAYER) > 100)
					cash = SpawnTheWeapon( other, "item_cashbaglarge" );
				else
					cash = SpawnTheWeapon( other, "item_cashbagsmall" );

				cash->currentcash = -(other->client->pers.bagcash - MAX_BAGCASH_PLAYER);

				other->client->pers.bagcash = MAX_BAGCASH_PLAYER;
			}
		}
	}

	// flash the screen green
	other->client->bonus_alpha_color = 2;	

	return true;
}
// END JOSEPH

//======================================================================
#if 0
void MegaHealth_think (edict_t *self)//FREDZ only in q2
{
	if (self->owner->health > self->owner->max_health)
	{
		self->nextthink = level.time + 1;
		self->owner->health -= 1;
		return;
	}

	if (!(self->spawnflags & DROPPED_ITEM) && (deathmatch->value))
		SetRespawn (self, 20);
	else
		G_FreeEdict (self);
}
#endif
qboolean Pickup_Pistol_Mods (edict_t *ent, edict_t *other)
{

//	if (ent->count == 1)
    if (!strcmp(ent->classname, "pistol_mod_rof"))
	{
		if ((other->client->pers.inventory[ITEM_INDEX(FindItem("Pistol Rof Mod"))]))
			return false;
		other->client->pers.inventory[ITEM_INDEX(FindItem("Pistol Rof Mod"))]=1;
		//gi.dprintf ("Pistol Mod: Faster ROF\n");
	}
//	else if (ent->count == 2)
    else if (!strcmp(ent->classname, "pistol_mod_reload"))
	{
		if ((other->client->pers.inventory[ITEM_INDEX(FindItem("Pistol Reload Mod"))]))
			return false;
		other->client->pers.inventory[ITEM_INDEX(FindItem("Pistol Reload Mod"))]=1;
		//gi.dprintf ("Pistol Mod: Faster Reload\n");
	}
//	else if (ent->count == 3)
    else if (!strcmp(ent->classname, "pistol_mod_damage"))
	{
		if ((other->client->pers.inventory[ITEM_INDEX(FindItem("Pistol Magnum Mod"))]))
			return false;
		other->client->pers.inventory[ITEM_INDEX(FindItem("Pistol Magnum Mod"))]=1;
		//gi.dprintf ("Pistol Mod: Damage x 2\n");

	}
//	else if (ent->count == 4)
    else if (!strcmp(ent->classname, "hmg_mod_cooling"))
	{
 		if ((other->client->pers.inventory[ITEM_INDEX(FindItem("HMG Cooling Mod"))]))
			return false;
		other->client->pers.inventory[ITEM_INDEX(FindItem("HMG Cooling Mod"))]=1;
		other->client->pers.hmg_shots = 30;
	}
	else
	{
		gi.dprintf ("error in pickup pistol mods\n");
		return false;
	}

//	if (ent->count <= 3)
    if ((!strcmp(ent->classname, "pistol_mod_rof")) || (!strcmp(ent->classname, "pistol_mod_reload")) || (!strcmp(ent->classname, "pistol_mod_damage")))
	{
        if (other->client->pers.weapon == FindItem ("Pistol Silencer") || other->client->pers.weapon == FindItem("Pistol"))
        {
            other->client->newweapon = other->client->pers.weapon;
            ChangeWeapon (other);
        }
	}
//	else if (ent->count == 4)
    else if (!strcmp(ent->classname, "hmg_mod_cooling"))
	{
		if (other->client->pers.weapon == FindItem ("Heavy machinegun") )
		{
			other->client->newweapon = other->client->pers.weapon;
//			other->client->pers.silencer_shots = 20;//FREDZ should only be for Pistol Silencer
			ChangeWeapon (other);
		}
	}

	// ent->item->pickup_sound = "items/pistolmod1.wav";

	if (!(ent->spawnflags & DROPPED_ITEM) && (deathmatch->value))
			SetRespawn (ent, 30);

	return true;
}
#if 0
qboolean Pickup_Health (edict_t *ent, edict_t *other)//Q2
{
	if (!(ent->style & HEALTH_IGNORE_MAX))
		if (other->health >= other->max_health)
			return false;

	other->health += ent->count;

/*//FREDZ files does not excists? only in Q2 Xatrix mod
	if (ent->count == 2)
		ent->item->pickup_sound = "items/s_health.wav";
	else if (ent->count == 10)
		ent->item->pickup_sound = "items/n_health.wav";
	else if (ent->count == 25)
		ent->item->pickup_sound = "items/l_health.wav";
	else // (ent->count == 100)
		ent->item->pickup_sound = "items/m_health.wav";*/

	if (!(ent->style & HEALTH_IGNORE_MAX))
	{
		if (other->health > other->max_health)
			other->health = other->max_health;
	}

	if (ent->style & HEALTH_TIMED)
	{
		ent->think = MegaHealth_think;
		ent->nextthink = level.time + 5;
		ent->owner = other;
		ent->flags |= FL_RESPAWN;
		ent->svflags |= SVF_NOCLIENT;
		ent->solid = SOLID_NOT;
	}
	else
	{
		if (!(ent->spawnflags & DROPPED_ITEM) && (deathmatch->value))
			SetRespawn (ent, 30);
	}

	return true;
}

//======================================================================

int ArmorIndex (edict_t *ent)//Q2
{
	// JOSEPH 1-APR-99
	/*if (!ent->client)
		return 0;

	if (ent->client->pers.inventory[jacket_armor_index] > 0)
		return jacket_armor_index;

	if (ent->client->pers.inventory[combat_armor_index] > 0)
		return combat_armor_index;

	if (ent->client->pers.inventory[body_armor_index] > 0)
		return body_armor_index;*/
	// END JOSEPH

	return 0;
}
#endif
// JOSEPH 2-APR-99
qboolean Pickup_Armor (edict_t *ent, edict_t *other)
{
	if (strcmp(ent->classname, "item_armor_helmet") == 0)
	{
		gitem_t *itemh = FindItem("Helmet Armor");
		gitem_t *itemhh = FindItem("Helmet Armor Heavy");

		if ((other->client->pers.inventory[ITEM_INDEX(itemh)] == 100) ||
		   (other->client->pers.inventory[ITEM_INDEX(itemhh)] == 100))
			return false;

		if (other->client->pers.inventory[ITEM_INDEX(itemhh)])
		{
			other->client->pers.inventory[ITEM_INDEX(itemhh)] += 50;//FREDZ why was 25? when small armor always should be 50 could be better code
			if (other->client->pers.inventory[ITEM_INDEX(itemhh)] > 100)
				other->client->pers.inventory[ITEM_INDEX(itemhh)] = 100;
		}
		else
		{
			other->client->pers.inventory[ITEM_INDEX(itemh)] += 50;
			if (other->client->pers.inventory[ITEM_INDEX(itemh)] > 100)
				other->client->pers.inventory[ITEM_INDEX(itemh)] = 100;
		}
	}
	else if (strcmp(ent->classname, "item_armor_jacket") == 0)
	{
		gitem_t *itemj = FindItem("Jacket Armor");
		gitem_t *itemjh = FindItem("Jacket Armor Heavy");

		if ((other->client->pers.inventory[ITEM_INDEX(itemj)] == 100) ||
		   (other->client->pers.inventory[ITEM_INDEX(itemjh)] == 100))
			return false;

		if (other->client->pers.inventory[ITEM_INDEX(itemjh)])
		{
			other->client->pers.inventory[ITEM_INDEX(itemjh)] += 50;//FREDZ why was 25? when small armor always should be 50 could be better code
			if (other->client->pers.inventory[ITEM_INDEX(itemjh)] > 100)
				other->client->pers.inventory[ITEM_INDEX(itemjh)] = 100;
		}
		else
		{
			other->client->pers.inventory[ITEM_INDEX(itemj)] += 50;
			if (other->client->pers.inventory[ITEM_INDEX(itemj)] > 100)
				other->client->pers.inventory[ITEM_INDEX(itemj)] = 100;
		}
	}
	else if (strcmp(ent->classname, "item_armor_legs") == 0)
	{
		gitem_t *iteml = FindItem("Legs Armor");
		gitem_t *itemlh = FindItem("Legs Armor Heavy");	
		
		if ((other->client->pers.inventory[ITEM_INDEX(iteml)] == 100) ||
		   (other->client->pers.inventory[ITEM_INDEX(itemlh)] == 100))
			return false;

		if (other->client->pers.inventory[ITEM_INDEX(itemlh)])
		{
			other->client->pers.inventory[ITEM_INDEX(itemlh)] += 50;//FREDZ why was 25? when small armor always should be 50 could be better code
			if (other->client->pers.inventory[ITEM_INDEX(itemlh)] > 100)
				other->client->pers.inventory[ITEM_INDEX(itemlh)] = 100;
		}
		else
		{
			other->client->pers.inventory[ITEM_INDEX(iteml)] += 50;
			if (other->client->pers.inventory[ITEM_INDEX(iteml)] > 100)
				other->client->pers.inventory[ITEM_INDEX(iteml)] = 100;
		}
	}
	else if (strcmp(ent->classname, "item_armor_helmet_heavy") == 0)
	{
		gitem_t *itemh = FindItem("Helmet Armor");
		gitem_t *itemhh = FindItem("Helmet Armor Heavy");
		
		if (other->client->pers.inventory[ITEM_INDEX(itemhh)] == 100)
			return false;
		
		if (other->client->pers.inventory[ITEM_INDEX(itemh)])
			other->client->pers.inventory[ITEM_INDEX(itemh)] = 0;			

		other->client->pers.inventory[ITEM_INDEX(itemhh)] = 100;
	}
	else if (strcmp(ent->classname, "item_armor_jacket_heavy") == 0)
	{
		gitem_t *itemj = FindItem("Jacket Armor");
		gitem_t *itemjh = FindItem("Jacket Armor Heavy");
		
		if (other->client->pers.inventory[ITEM_INDEX(itemjh)] == 100)
			return false;		

		if (other->client->pers.inventory[ITEM_INDEX(itemj)])
			other->client->pers.inventory[ITEM_INDEX(itemj)] = 0;			

		other->client->pers.inventory[ITEM_INDEX(itemjh)] = 100;
	}
	else if (strcmp(ent->classname, "item_armor_legs_heavy") == 0)
	{
		gitem_t *iteml = FindItem("Legs Armor");
		gitem_t *itemlh = FindItem("Legs Armor Heavy");	
		
		if (other->client->pers.inventory[ITEM_INDEX(itemlh)] == 100)
			return false;

		if (other->client->pers.inventory[ITEM_INDEX(iteml)])
			other->client->pers.inventory[ITEM_INDEX(iteml)] = 0;			

		other->client->pers.inventory[ITEM_INDEX(itemlh)] = 100;
	}
	
	
	if (!(ent->spawnflags & DROPPED_ITEM) && (deathmatch->value))
		SetRespawn (ent, 45);	// Ridah, armor shouldn't respawn so often

/*	//Q2
    int				old_armor_index;
	gitem_armor_t	*oldinfo;
	gitem_armor_t	*newinfo;
	int				newcount;
	float			salvage;
	int				salvagecount;

	// get info on new armor
	newinfo = (gitem_armor_t *)ent->item->info;

	old_armor_index = ArmorIndex (other);

	// handle armor shards specially
	if (ent->item->tag == ARMOR_SHARD)
	{
		if (!old_armor_index)
			other->client->pers.inventory[jacket_armor_index] = 2;
		else
			other->client->pers.inventory[old_armor_index] += 2;
	}

	// if player has no armor, just use it
	else if (!old_armor_index)
	{
		other->client->pers.inventory[ITEM_INDEX(ent->item)] = newinfo->base_count;
	}

	// use the better armor
	else
	{
		// get info on old armor
		if (old_armor_index == jacket_armor_index)
			oldinfo = &jacketarmor_info;
		else if (old_armor_index == combat_armor_index)
			oldinfo = &combatarmor_info;
		else // (old_armor_index == body_armor_index)
			oldinfo = &bodyarmor_info;

		if (newinfo->normal_protection > oldinfo->normal_protection)
		{
			// calc new armor values
			salvage = oldinfo->normal_protection / newinfo->normal_protection;
			salvagecount = salvage * other->client->pers.inventory[old_armor_index];
			newcount = newinfo->base_count + salvagecount;
			if (newcount > newinfo->max_count)
				newcount = newinfo->max_count;

			// zero count of old armor so it goes away
			other->client->pers.inventory[old_armor_index] = 0;

			// change armor to new item with computed value
			other->client->pers.inventory[ITEM_INDEX(ent->item)] = newcount;
		}
		else
		{
			// calc new armor values
			salvage = newinfo->normal_protection / oldinfo->normal_protection;
			salvagecount = salvage * newinfo->base_count;
			newcount = other->client->pers.inventory[old_armor_index] + salvagecount;
			if (newcount > oldinfo->max_count)
				newcount = oldinfo->max_count;

			// if we're already maxed out then we don't need the new armor
			if (other->client->pers.inventory[old_armor_index] >= newcount)
				return false;

			// update current armor value
			other->client->pers.inventory[old_armor_index] = newcount;
		}
	}

	if (!(ent->spawnflags & DROPPED_ITEM) && (deathmatch->value))
		SetRespawn (ent, 20);*/

	return true;
}
// END JOSEPH

//======================================================================
#if 0
int PowerArmorType (edict_t *ent)//Q2
{
	if (!ent->client)
		return POWER_ARMOR_NONE;

	if (!(ent->flags & FL_POWER_ARMOR))
		return POWER_ARMOR_NONE;

	if (ent->client->pers.inventory[power_shield_index] > 0)
		return POWER_ARMOR_SHIELD;

	if (ent->client->pers.inventory[power_screen_index] > 0)
		return POWER_ARMOR_SCREEN;

	return POWER_ARMOR_NONE;
}

void Use_PowerArmor (edict_t *ent, gitem_t *item)//Q2
{
	int		index;

	if (ent->flags & FL_POWER_ARMOR)
	{
		ent->flags &= ~FL_POWER_ARMOR;
		gi.sound(ent, CHAN_AUTO, gi.soundindex("misc/power2.wav"), 1, ATTN_NORM, 0);//FREDZ q2 file only
	}
	else
	{
		index = ITEM_INDEX(FindItem("gas"));
		if (!ent->client->pers.inventory[index])
		{
			gi.cprintf (ent, PRINT_HIGH, "No gas for power armor.\n");
			return;
		}
		ent->flags |= FL_POWER_ARMOR;
		gi.sound(ent, CHAN_AUTO, gi.soundindex("misc/power1.wav"), 1, ATTN_NORM, 0);//FREDZ q2 file only
	}
}

qboolean Pickup_PowerArmor (edict_t *ent, edict_t *other)//Q2
{
	int		quantity;

	quantity = other->client->pers.inventory[ITEM_INDEX(ent->item)];

	other->client->pers.inventory[ITEM_INDEX(ent->item)]++;

	if (deathmatch->value)
	{
		if (!(ent->spawnflags & DROPPED_ITEM) )
			SetRespawn (ent, ent->item->quantity);
		// auto-use for DM only if we didn't already have one
		if (!quantity)
			ent->item->use (other, ent->item);
	}

	return true;
}

void Drop_PowerArmor (edict_t *ent, gitem_t *item)//Q2
{
	if ((ent->flags & FL_POWER_ARMOR) && (ent->client->pers.inventory[ITEM_INDEX(item)] == 1))
		Use_PowerArmor (ent, item);
	Drop_General (ent, item);
}
#endif
//======================================================================

void Use_JetPack (edict_t *ent, gitem_t *item)//Kingpin code not in Q2
{
	if (ent->flags & FL_JETPACK)
	{
		ent->flags &= ~FL_JETPACK;

		gi.dprintf( "SOUND TODO: JetPack disabled\n" );
		gi.sound(ent, CHAN_AUTO, gi.soundindex("misc/jetpack_off.wav"), 1, ATTN_NORM, 0);//FREDZ file does not exist in q2 or kp
	}
	else
	{
		ent->flags |= FL_JETPACK;

		gi.dprintf( "SOUND TODO: JetPack enabled\n" );
		gi.sound(ent, CHAN_AUTO, gi.soundindex("misc/jetpack_on.wav"), 1, ATTN_NORM, 0);//FREDZ file does not exist in q2 or kp
	}
}

qboolean Pickup_JetPack (edict_t *ent, edict_t *other)
{
	int		quantity;

	quantity = other->client->pers.inventory[ITEM_INDEX(ent->item)];

	other->client->pers.inventory[ITEM_INDEX(ent->item)]++;

	if (deathmatch->value)
	{
		if (!(ent->spawnflags & DROPPED_ITEM) )
			SetRespawn (ent, ent->item->quantity);
		// auto-use for DM only if we didn't already have one
		if (!quantity)
			ent->item->use (other, ent->item);
	}

	other->client->jetpack_power = 2.5;

	return true;
}

// JOSEPH 12-MAR-99-B
qboolean Pickup_Health_Large (edict_t *ent, edict_t *other)
{
	
	if (other->health >= other->max_health)
		return false;

	other->health += 25;

	if (other->health > other->max_health)
			other->health = other->max_health;

	if (!(ent->spawnflags & DROPPED_ITEM) && (deathmatch->value))
		SetRespawn (ent, 30);

	return true;
}

qboolean Pickup_Health_Small (edict_t *ent, edict_t *other)
{
	if (other->health >= other->max_health)
		return false;

	other->health += 15;

	if (other->health > other->max_health)
			other->health = other->max_health;

	if (!(ent->spawnflags & DROPPED_ITEM) && (deathmatch->value))
		SetRespawn (ent, 30);

	return true;
}
// END JOSEPH


//======================================================================

/*
===============
Touch_Item
===============
*/
void Touch_Item (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	qboolean	taken;

	if (!(other->client))
		return;
	if (other->health < 1)
		return;		// dead people can't pickup
	if (!ent->item->pickup)
		return;		// not a grabbable item?

	taken = ent->item->pickup(ent, other);

	// Do Episode specific handling
	EP_ItemPickup( ent, other );


	if (taken)
	{
		// flash the screen
		other->client->bonus_alpha = 0.25;	

		// JOSEPH 2-MAR-99
/*		if (!Q_stricmp(ent->item->pickup_name, "Pistol_Mods"))//FREDZ hmg is not pistol mod?
		{
			if (ent->count == 1)
			{
				ent->item->icon = "/pics/h_pistol_rof.tga";
			}
			else if (ent->count == 2)
			{
				ent->item->icon = "/pics/h_pistol_rl.tga";
			}
			else if (ent->count == 3)
			{
				ent->item->icon = "/pics/h_pistol_mag.tga";
			}
			else if (ent->count == 4)
			{
				ent->item->icon = "/pics/h_heavymachinegun_cooling.tga";
			}
		}*/
		// END JOSEPH

		// show icon and name on status bar
		other->client->ps.stats[STAT_PICKUP_ICON] = gi.imageindex(ent->item->icon);
		other->client->ps.stats[STAT_PICKUP_STRING] = CS_ITEMS+ITEM_INDEX(ent->item);
		// JOSEPH 25-JAN-99
		other->client->pickup_msg_time = level.time + 5.5;
		// END JOSEPH
		// change selected item
		if (ent->item->use)
			other->client->pers.selected_item = other->client->ps.stats[STAT_SELECTED_ITEM] = ITEM_INDEX(ent->item);

		gi.sound(other, CHAN_ITEM, gi.soundindex(ent->item->pickup_sound), 1, ATTN_NORM, 0);
	}

	if (!(ent->spawnflags & ITEM_TARGETS_USED))
	{
		G_UseTargets (ent, other);
		ent->spawnflags |= ITEM_TARGETS_USED;
	}

	if (!taken)
		return;

	if (!((coop->value) &&  (ent->item->flags & IT_STAY_COOP)) || (ent->spawnflags & (DROPPED_ITEM | DROPPED_PLAYER_ITEM)))
	{
		if (ent->flags & FL_RESPAWN)
			ent->flags &= ~FL_RESPAWN;
		else
			G_FreeEdict (ent);
	}
	
}

//======================================================================

static void drop_temp_touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if (other == ent->owner)
		return;

//	gi.bprintf(PRINT_HIGH,"calling drop_temp_touch\n");
	Touch_Item (ent, other, plane, surf);
}


// ============================================================
//    BOMB exploding and respawning routines - snap
// ============================================================

//new
void explode_bomb (edict_t *self, edict_t *inflictor, edict_t *attacker)
{
	vec3_t	origin;
	vec3_t	chunkorigin;
	vec3_t	size;
	int		count;
	int		mass = 800;

	self->dmg = 1000;
	self->fxdensity = 100;

	// bmodel origins are (0 0 0), we need to adjust that here
	VectorScale (self->size, 0.5, size);
	VectorAdd (self->absmin, size, origin);
	VectorCopy (origin, self->s.origin);

	self->takedamage = DAMAGE_NO;

	T_RadiusDamage (self, attacker, self->dmg, NULL, self->dmg, MOD_EXPLOSIVE);

	VectorSubtract (self->s.origin, inflictor->s.origin, self->velocity);
	VectorNormalize (self->velocity);
	VectorScale (self->velocity, 250, self->velocity);

	// start chunks towards the center
	VectorScale (size, 0.5, size);

	// big chunks

	count = 2;

	while(count--)
	{
		chunkorigin[0] = origin[0] + crandom() * size[0];
		chunkorigin[1] = origin[1] + crandom() * size[1];
		chunkorigin[2] = origin[2] + crandom() * size[2];
		ThrowDebris (self, "models/props/metal/metal1.md2", 1, chunkorigin);
	}


	G_UseTargets (self, attacker);

	BecomeExplosion1 (self);

}

// new
void bombquake ()
{
	int		i;
	edict_t	*e;


	for (i=1, e=g_edicts+i; i < globals.num_edicts; i++,e++)
	{
		if (!e->inuse)
			continue;
		if (!e->client)
			continue;
		if (!e->groundentity)
			continue;

		e->groundentity = NULL;
		e->velocity[0] += crandom()* 800;
		e->velocity[1] += crandom()* 800;
		e->velocity[2] = 500 * (100.0 / e->mass);
	}
}

// new
void wait_for_Bomb(edict_t *self)
{

	self->nextthink = level.time + FRAMETIME;

	if (self->armed == TRUE)
	{
		// this bomb was defused by the crash squad
		if(level.defused == TRUE){
			gi.sound (self, CHAN_VOICE, gi.soundindex("world/c4_deact.wav"), 1, ATTN_NORM, 0);

			self->s.effects = 0;
			self->s.skinnum = 0;
			self->light_spawned = FALSE;

			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_SFXSMOKE);
			gi.WritePosition (self->s.origin);
			gi.WriteByte (48);
			gi.WriteByte (0);
			gi.multicast (self->s.origin, MULTICAST_PVS);

			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_WELDING_SPARKS);
			gi.WriteByte (10);
			gi.WritePosition (self->s.origin);
			gi.WriteDir (vec3_origin);
			gi.WriteByte (0xe0 + (rand()&7));
			gi.multicast (self->s.origin, MULTICAST_PVS);

			self->armed = FALSE;

			if(!level.roundover){
				level.round_end_frame = level.framenum;
				level.roundover = TRUE;
				level.roundover_type = BOMB_DEFUSED;
			}
		}
		// after 60 seconds an armed bomb will explode, freeing this entity also
		else if (self->armframe <= (level.framenum - 600)) { // MH: raised to 60s
			gi.sound(self, CHAN_VOICE, gi.soundindex("world/c4boom.wav"), 1, ATTN_NORM, 0);
			bombquake();

			if (!level.roundover) {
				level.round_end_frame = level.framenum;
				level.roundover = TRUE;
				level.roundover_type = TARGET_BOMBED;
			}

			explode_bomb(self, self, self); // MH: explode after setting roundover to prevent deaths counting
		}
		else if(level.framenum == self->soundframe){
			// MH: new bomb flashing and beeping
			if (!self->s.skinnum)
			{
				gi.sound(self, CHAN_VOICE, gi.soundindex("world/c4_1.wav"), 1, ATTN_NORM, 0);
				self->soundframe += 2;
				self->s.effects |= EF_FLAG1; // red light
				self->s.skinnum = 1;
			}
			else if ((level.framenum - self->armframe) >= 570)
			{
				gi.sound(self, CHAN_VOICE, gi.soundindex("world/c4_5.wav"), 1, ATTN_NORM, 0);
				self->soundframe += 15;
			}
			else
			{
				self->soundframe += 1 + (self->armframe + 560 - level.framenum) / 20;
				self->s.effects = 0;
				self->s.skinnum = 0;
			}
		}

	}

}

// snap, changed this 
static void drop_make_touchable (edict_t *ent)
{

//	gi.bprintf(PRINT_HIGH,"calling drop_make touchable\n");

	ent->touch = Touch_Item;
	// Xatrix/Ridah/Navigator/17-mar-1998
	ent->nav_data.flags |= ND_STATIC;
	// END:		Xatrix/Ridah/Navigator/17-mar-1998

	if(deathmatch->value){
		if (!(strcmp (ent->classname, "weapon_bomb"))){
			ent->nextthink = level.time + FRAMETIME;
			ent->think = wait_for_Bomb;
		}
//		else if (!memcmp(ent->classname,"item_cashbag",12)){
//				ent->nextthink = level.time + 120;
//				ent->think = G_FreeEdict;
//		}
		else{
			//  stop the thinker - reduced cpu load
			ent->think = NULL;
			ent->nextthink = 0;
		}	
	}
}

// created this for bomb..
edict_t *Drop_Item_Notoss (edict_t *ent, gitem_t *item)
{
	edict_t	*dropped;

	dropped = G_Spawn();

	dropped->classname = item->classname;
	dropped->item = item;
	dropped->spawnflags = DROPPED_ITEM;
	dropped->s.effects = item->world_model_flags;
	dropped->s.renderfx = RF_GLOW;
	// JOSEPH 15-MAR-99	
//	dropped->s.renderfx2 = RF2_NOSHADOW; 	// MH: enable shadow
	// END JOSEPH
	VectorSet (dropped->mins, -15, -15, -15);
	VectorSet (dropped->maxs, 15, 15, 15);
	gi.setmodel (dropped, dropped->item->world_model);
	dropped->solid = SOLID_TRIGGER;
	dropped->movetype = MOVETYPE_TOSS;  
	dropped->touch = drop_temp_touch;
	dropped->owner = ent;

	VectorCopy (ent->s.origin, dropped->s.origin);

	dropped->think = drop_make_touchable;
	dropped->nextthink = level.time + 1;

	gi.linkentity (dropped);

	// snap - store to struct
	add_ent_to_array(dropped);

	return dropped;
}

// ================================================================
//   END BOMB exploding and respawning functions - snap
// ================================================================

extern int QweryClipIndex (gitem_t *item);
edict_t *Drop_Item (edict_t *ent, gitem_t *item)
{
	edict_t	*dropped;
	vec3_t	forward, right;
	vec3_t	offset;
	int	ammo_index;
	int clip_index;

	dropped = G_Spawn();

	dropped->classname = item->classname;
	dropped->item = item;
	dropped->spawnflags = DROPPED_ITEM;
	dropped->s.effects = item->world_model_flags;
	dropped->s.renderfx = RF_GLOW;
	// JOSEPH 15-MAR-99	
//	dropped->s.renderfx2 = RF2_NOSHADOW; 	// MH: enable shadow
	// END JOSEPH
	VectorSet (dropped->mins, -15, -15, -15);
	VectorSet (dropped->maxs, 15, 15, 15);
	gi.setmodel (dropped, dropped->item->world_model);
	dropped->solid = SOLID_TRIGGER;
	dropped->movetype = MOVETYPE_TOSS;  
	dropped->touch = drop_temp_touch;
	dropped->owner = ent;

	// snap, ammo stuff
	if(item->ammo){
		clip_index = QweryClipIndex(item);
		ammo_index = ITEM_INDEX(FindItem(item->ammo));
		item->droppedammo = ent->client->pers.inventory[ammo_index] + ent->client->pers.weapon_clip[clip_index];
		ent->client->pers.inventory[ammo_index] = 0;
		ent->client->pers.weapon_clip[clip_index] = 0;
		//gi.bprintf (PRINT_HIGH, "droppped ammo: %d\n", item->droppedammo);
	}

	if (ent->client)
	{
		trace_t	trace;

		AngleVectors (ent->client->v_angle, forward, right, NULL);
		VectorSet(offset, 24, 0, -16);
		G_ProjectSource (ent->s.origin, offset, forward, right, dropped->s.origin);
		trace = gi.trace (ent->s.origin, dropped->mins, dropped->maxs,
			dropped->s.origin, ent, CONTENTS_SOLID);
		VectorCopy (trace.endpos, dropped->s.origin);
	}
	else
	{
		AngleVectors (ent->s.angles, forward, right, NULL);
		VectorCopy (ent->s.origin, dropped->s.origin);
	}

	// JOSEPH 28-APR-99
	if (!(ent->svflags & SVF_PROP))
	{
	VectorScale (forward, 100, dropped->velocity);
	dropped->velocity[2] = 300;
	}
	else
	{
		dropped->s.origin[2] += 8;
		dropped->velocity[2] = 200;		
	}
	// END JOSEPH

	dropped->think = drop_make_touchable;
	dropped->nextthink = level.time + 1;

	gi.linkentity (dropped);

	// snap - store to struct
	add_ent_to_array(dropped);

	return dropped;
}

void Use_Item (edict_t *ent, edict_t *other, edict_t *activator)
{
	ent->svflags &= ~SVF_NOCLIENT;
	ent->use = NULL;

	if (ent->spawnflags & ITEM_NO_TOUCH)
	{
		ent->solid = SOLID_BBOX;
		ent->touch = NULL;
	}
	else
	{
		ent->solid = SOLID_TRIGGER;
		ent->touch = Touch_Item;
	}

	gi.linkentity (ent);
}

//======================================================================
// snap, commented this
/*
// JOSEPH 7-DEC-98
edict_t *Shot_Drop_Item (edict_t *ent, gitem_t *item, char* modeloverride)
{
	edict_t	*dropped;
	vec3_t	forward, right;
	vec3_t	offset;

	dropped = G_Spawn();

	dropped->classname = item->classname;
	dropped->item = item;
	dropped->spawnflags = DROPPED_ITEM;
	dropped->s.effects = item->world_model_flags;
	dropped->s.renderfx = RF_GLOW;
	VectorSet (dropped->mins, -15, -15, -15);
	VectorSet (dropped->maxs, 15, 15, 15);
	
	if (modeloverride)
	{
		gi.setmodel (dropped, modeloverride);
	}
	else
	{	
		gi.setmodel (dropped, dropped->item->world_model);
    }

	dropped->solid = SOLID_TRIGGER;
	dropped->movetype = MOVETYPE_TOSS;  
	dropped->touch = drop_temp_touch;
	dropped->owner = ent;

	if (ent->client)
	{
		trace_t	trace;

		AngleVectors (ent->client->v_angle, forward, right, NULL);
		VectorSet(offset, 24, 0, -16);
		G_ProjectSource (ent->s.origin, offset, forward, right, dropped->s.origin);
		trace = gi.trace (ent->s.origin, dropped->mins, dropped->maxs,
			dropped->s.origin, ent, CONTENTS_SOLID);
		VectorCopy (trace.endpos, dropped->s.origin);
	}
	else
	{
		AngleVectors (ent->s.angles, forward, right, NULL);
		VectorCopy (ent->s.origin, dropped->s.origin);
	}

	VectorScale (forward, 250, dropped->velocity);
	
	if ((rand()&1) == 1)
	{
	    VectorScale (right, 150, dropped->velocity);
	}
	else
	{
	    VectorScale (right, -150, dropped->velocity);
	}

	dropped->velocity[2] = 350;

	dropped->think = drop_make_touchable;
	dropped->nextthink = level.time + 1;

	gi.linkentity (dropped);

	return dropped;
}
// END JOSEPH
*/
/*
================
droptofloor
================
*/
void droptofloor (edict_t *ent)
{
	trace_t		tr;
	vec3_t		dest;
	float		*v;

	v = tv(-15,-15,-15);
	VectorCopy (v, ent->mins);
	v = tv(15,15,15);
	VectorCopy (v, ent->maxs);

	if (ent->model)
		gi.setmodel (ent, ent->model);
	else
		gi.setmodel (ent, ent->item->world_model);
	ent->solid = SOLID_TRIGGER;
	ent->movetype = MOVETYPE_TOSS;  
	ent->touch = Touch_Item;

	v = tv(0,0,-128);
	VectorAdd (ent->s.origin, v, dest);
    

	tr = gi.trace (ent->s.origin, ent->mins, ent->maxs, dest, ent, MASK_SOLID);
	if (tr.startsolid)
	{
		// RAFAEL
		if (strcmp (ent->classname, "foodcube") == 0)//Q2 Xatrix mod
		{
			VectorCopy (ent->s.origin, tr.endpos);
			ent->velocity[2] = 0;
		}
		// JOSEPH 7-MAY-99
		else if (strcmp(ent->classname, "key_fuse") == 0)
		{
			v = tv(-7,-7,-16);
			VectorCopy (v, ent->mins);
			v = tv(7, 7, 16);
			VectorCopy (v, ent->maxs);
			ent->movetype = MOVETYPE_NONE; 
			ent->velocity[2] = 0;
			ent->s.origin[2] += 1;
			goto SkipFall;
		}
		// END JOSEPH
		else
		{
			gi.dprintf ("droptofloor: %s startsolid at %s\n", ent->classname, vtos(ent->s.origin));
			G_FreeEdict (ent);
			return;
		}
	}

	VectorCopy (tr.endpos, ent->s.origin);

// JOSEPH 7-MAY-99
SkipFall:
// END JOSEPH

	if (ent->team)
	{
		ent->flags &= ~FL_TEAMSLAVE;
		ent->chain = ent->teamchain;
		ent->teamchain = NULL;

		ent->svflags |= SVF_NOCLIENT;
		ent->solid = SOLID_NOT;
		if (ent == ent->teammaster)
		{
			ent->nextthink = level.time + FRAMETIME;
			ent->think = DoRespawn;
		}
	}

	if (ent->spawnflags & ITEM_NO_TOUCH)
	{
		ent->solid = SOLID_BBOX;
		ent->touch = NULL;
		ent->s.effects &= ~EF_ROTATE;
		ent->s.renderfx &= ~RF_GLOW;
	}

	if (ent->spawnflags & ITEM_TRIGGER_SPAWN)
	{
		ent->svflags |= SVF_NOCLIENT;
		ent->solid = SOLID_NOT;
		ent->use = Use_Item;
	}

	gi.linkentity (ent);
}


/*
===============
PrecacheItem

Precaches all data needed for a given item.
This will be called for each item spawned in a level,
and for each item in each client's inventory.
===============
*/
void PrecacheItem (gitem_t *it)
{
	char	*s, *start;
	char	data[MAX_QPATH];
	int		len;
	gitem_t	*ammo;

	if (!it)
		return;

	if (it->pickup_sound)
		gi.soundindex (it->pickup_sound);
	if (it->world_model)
		gi.modelindex (it->world_model);
	if (it->view_model)
		gi.modelindex (it->view_model);
	if (it->icon)
		gi.imageindex (it->icon);

	// parse everything for its ammo
	if (it->ammo && it->ammo[0])
	{
		ammo = FindItem (it->ammo);
		if (ammo != it)
			PrecacheItem (ammo);
	}

	// parse the space seperated precache string for other items
	s = it->precaches;
	if (!s || !s[0])
		return;

	while (*s)
	{
		start = s;
		while (*s && *s != ' ')
			s++;

		len = s-start;
		if (len >= MAX_QPATH || len < 5)
			gi.error ("PrecacheItem: %s has bad precache string", it->classname);
		memcpy (data, start, len);
		data[len] = 0;
		if (*s)
			s++;

		// determine type based on extension
		if (!strcmp(data+len-3, "md2"))
			gi.modelindex (data);
		
		// RAFAEL
		// weapon mdx
		else if (!strcmp (data+len-3, "mdx"))
		{
			gi.modelindex (data);
		}
		else if (!strcmp(data+len-3, "sp2"))
			gi.modelindex (data);
		else if (!strcmp(data+len-3, "wav"))
			gi.soundindex (data);
		if (!strcmp(data+len-3, "pcx"))
			gi.imageindex (data);
	}
}

/*
============
SpawnItem

Sets the clipping size and plants the object on the floor.

Items can't be immediately dropped to floor, because they might
be on an entity that hasn't spawned yet.
============
*/
void SpawnItem (edict_t *ent, gitem_t *item)
{
	if (!item)
		return;

	PrecacheItem (item);

/*	if (ent->spawnflags)//Q2
	{
		if (strcmp(ent->classname, "key_fuse") != 0)
		{
			ent->spawnflags = 0;
			gi.dprintf("%s at %s has invalid spawnflags set\n", ent->classname, vtos(ent->s.origin));
		}
	}*/

	// some items will be prevented in deathmatch
	if (deathmatch->value)
	{
		if ( (int)dmflags->value & DF_NO_ARMOR )
		{
			if (item->pickup == Pickup_Armor)// || item->pickup == Pickup_PowerArmor)
			{
				G_FreeEdict (ent);
				return;
			}
		}
/*
		if ( (int)dmflags->value & DF_NO_ITEMS )//Q2
		{
			if (item->pickup == Pickup_Powerup)
			{
				G_FreeEdict (ent);
				return;
			}
		}
*/
		if ( (int)dmflags->value & DF_NO_HEALTH )
		{
			if (//item->pickup == Pickup_Health || item->pickup == Pickup_AncientHead
				item->pickup == Pickup_Adrenaline || item->pickup == Pickup_Health_Large || item->pickup == Pickup_Health_Small)
			{
				G_FreeEdict (ent);
				return;
			}
		}
		if ( (int)dmflags->value & DF_INFINITE_AMMO && deathmatch->value )
		{
			if ( (item->flags == IT_AMMO) || (strcmp(ent->classname, "ammo_cylinder") == 0) )
			{
				G_FreeEdict (ent);
				return;
			}
		}

		// Ridah, realmode only has pistol, tommy and shotgun
		if (deathmatch->value && dm_realmode->value && item->classname)
		{
			if (	(item->pickup == Pickup_Weapon)
//				&&	(strstr(item->classname, "weapon") == item->classname)
				&&	(item->ammo && strcmp(item->ammo, "Bullets") && strcmp(item->ammo, "Shells")))
			{
				int	y;

				y = ((int)item->classname[7]) % 3;

				// select another valid weapon to use here
				if (y == 0)
				{
					item = FindItem("Shotgun");
				}
				else if (y == 1)
				{
					item = FindItem("Tommygun");
				}
				else
				{
					item = FindItem("Pistol_Mods");
					ent->model = "models/pu_icon/magmod/tris.md2";
					ent->count = 3;	//magnum mod
				}

			}
			else if (	(item->pickup == Pickup_Ammo)
					&&	((item->tag != AMMO_BULLETS) && (item->tag != AMMO_SHELLS)))
			{
				// select another valid weapon to use here
				if (((int)item->classname[5]) % 2)
				{
					item = FindItem("Bullets");
				}
				else
				{
					item = FindItem("Shells");
				}
			}


			// no armor
			if (item->classname && strstr(item->classname, "item_armor") == item->classname)
			{
				G_FreeEdict (ent);
				return;
			}
/*
			// no health
			if (strstr(item->classname, "item_health") == item->classname)
			{
				G_FreeEdict (ent);
				return;
			}
*/
		}
	}
			
// Ridah, no coop
/*
	if (coop->value && (strcmp(ent->classname, "key_fuse") == 0))
	{
		ent->spawnflags |= (1 << (8 + level.fuse_keys));
		level.fuse_keys++;
	}*/
/*
	// don't let them drop items that stay in a coop game
	if ((coop->value) && (item->flags & IT_STAY_COOP))
	{
		item->drop = NULL;
	}
*/
	// JOSEPH 22-JAN-99
	ent->item = item;
	ent->nextthink = level.time + 2 * FRAMETIME;    // items start after other solids
	ent->think = droptofloor;
	ent->s.effects = item->world_model_flags;
	ent->s.renderfx = RF_GLOW;
	ent->s.renderfx2 = RF2_NOSHADOW; 
	// END JOSEPH
	
	
	if (!(strcmp(ent->classname, "item_lizzyhead")))
	{
		int i;
		memset(&(ent->s.model_parts[0]), 0, sizeof(model_part_t) * MAX_MODEL_PARTS);
		ent->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/pu_icon/head/head.mdx");
		ent->s.num_parts++;
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			ent->s.model_parts[PART_HEAD].baseskin = ent->s.model_parts[PART_HEAD].skinnum[i] = 0;
		gi.GetObjectBounds( "models/pu_icon/head/head.mdx", &ent->s.model_parts[PART_HEAD] );
	}	
	else if (ent->model)
		gi.modelindex (ent->model);

	// Xatrix/Ridah/Navigator/17-mar-1998
	ent->nav_data.flags |= ND_STATIC;
	// END:		Xatrix/Ridah/Navigator/17-mar-1998

}

// JOSEPH 13-FEB-99
/*
void Use_Null (edict_t *ent, gitem_t *item)//FREDZ could also have just use NULL instead
{

}*/
// END JOSEPH

//======================================================================

// JOSEPH 21-APR-99
gitem_t	itemlist[] = 
{
	{
		NULL
	},	// leave index 0 alone

	//
	// ARMOR
	//


// JOSEPH 19-APR-99
/*QUAKED item_armor_helmet (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/pu_icon/armor_head/armor_head.md2" 
*/
	{
		"item_armor_helmet", 
		Pickup_Armor,
		NULL,
		NULL,
		NULL,
		"world/pickups/generic.wav",
		"models/pu_icon/armor_head/armor_head.md2", 0,
		NULL,
/* icon */		"/pics/h_helmet_lt.tga",
/* pickup */	"Helmet Armor",
/* width */		3,
		0,
		NULL,
		IT_ARMOR,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED item_armor_jacket (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/pu_icon/armor/tris.md2" 
*/
	{
		"item_armor_jacket", 
		Pickup_Armor,
		NULL,
		NULL,
		NULL,
		"world/pickups/generic.wav",
		"models/pu_icon/armor/tris.md2", 0,
		NULL,
/* icon */		"/pics/h_chest_lt.tga",
/* pickup */	"Jacket Armor",
/* width */		3,
		0,
		NULL,
		IT_ARMOR,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED item_armor_legs (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/pu_icon/armor_lo/armor_lo.md2" 
*/
	{
		"item_armor_legs", 
		Pickup_Armor,
		NULL,
		NULL,
		NULL,
		"world/pickups/generic.wav",
		"models/pu_icon/armor_lo/armor_lo.md2", 0,
		NULL,
/* icon */		"/pics/h_pants_lt.tga",
/* pickup */	"Legs Armor",
/* width */		3,
		0,
		NULL,
		IT_ARMOR,
		NULL,
		0,
/* precache */ ""
	},


/*QUAKED item_armor_helmet_heavy (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/pu_icon/armor_head/armor_head_hd.md2"
*/
	{
		"item_armor_helmet_heavy", 
		Pickup_Armor,
		NULL,
		NULL,
		NULL,
		"world/pickups/generic.wav",
		"models/pu_icon/armor_head/armor_head_hd.md2", 0,
		NULL,
/* icon */		"/pics/h_helmet_hvy.tga",
/* pickup */	"Helmet Armor Heavy",
/* width */		3,
		0,
		NULL,
		IT_ARMOR,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED item_armor_jacket_heavy (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/pu_icon/armor/armorhdtop.md2"
*/
	{
		"item_armor_jacket_heavy", 
		Pickup_Armor,
		NULL,
		NULL,
		NULL,
		"world/pickups/generic.wav",
		"models/pu_icon/armor/armorhdtop.md2", 0,
		NULL,
/* icon */		"/pics/h_chest_hvy.tga",
/* pickup */	"Jacket Armor Heavy",
/* width */		3,
		0,
		NULL,
		IT_ARMOR,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED item_armor_legs_heavy (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/pu_icon/armor_lo/armor_lo_hd.md2"
*/
	{
		"item_armor_legs_heavy", 
		Pickup_Armor,
		NULL,
		NULL,
		NULL,
		"world/pickups/generic.wav",
		"models/pu_icon/armor_lo/armor_lo_hd.md2", 0,
		NULL,
/* icon */		"/pics/h_pants_hvy.tga",
/* pickup */	"Legs Armor Heavy",
/* width */		3,
		0,
		NULL,
		IT_ARMOR,
		NULL,
		0,
/* precache */ ""
	},

	//
	// WEAPONS 
	//

/*QUAKED weapon_blackjack (.3 .3 1) (-16 -16 -16) (16 16 16)
always owned, never in the world
*/
	{
		"weapon_blackjack", 
		NULL,
		Use_Weapon2,
		NULL,
		Weapon_Blackjack,
		"misc/w_pkup.wav",
		NULL, 0,
		"models/weapons/blakjak/blakjak.mdx",
/* icon */		"h_pipe",
/* pickup */	"Pipe",
		0,
		0,
		NULL,
		IT_WEAPON|IT_STAY_COOP,
		NULL,
		0,
/* precache */ "weapons/melee/swing.wav" 
	},

// JOSEPH 14-APR-99
/*QUAKED weapon_crowbar (.3 .3 1) (-16 -16 -16) (16 16 16)

model="models/weapons/g_crowbar/tris.md2"  
*/
	{
		"weapon_crowbar", 
		Pickup_Weapon,
		Use_Weapon2,
		Drop_Weapon,
		Weapon_Crowbar,
		"misc/w_pkup.wav",
		"models/weapons/g_crowbar/tris.md2", EF_REFL,
		"models/weapons/crowbar/crowbar.mdx",
/* icon */		"/pics/h_cbar.tga",
/* pickup */	"Crowbar",
		0,
		0,
		NULL,
		IT_WEAPON|IT_STAY_COOP,
		NULL,
		0,
/* precache */ "weapons/melee/swing.wav" 
	},
// END JOSEPH
	
/*QUAKED weapon_pistol (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/weapons/g_pistol/tris.md2"  
*/
//FREDZ Posible types of Cold 1911 Pistols:
// M1911 		(1911) 7 Rounds
// M1911A1 		(1926) 7 Rounds - Most likely duo skin model.
// M1911A2 			   7 Rounds
	{
		"weapon_pistol", 
		Pickup_Weapon,
		Use_Weapon2,
		Drop_Weapon,
		Weapon_Pistol,
		"misc/w_pkup.wav",
		// note to Jason 
		// we need a pistol pickup icon
		"models/weapons/g_pistol/tris.md2", EF_REFL,
		"models/weapons/v_colt/pistol.mdx",
/* icon */		"/pics/h_pistol.tga",
/* pickup */	"Pistol",//FREDZ Colt 1911A1
		0,
		1,
		"Bullets",
		IT_WEAPON|IT_STAY_COOP,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED weapon_pistol_s (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/weapons/silencer_mdx/pistol.mdx"
*/
	{
		"weapon_spistol", 
		Pickup_Weapon,
		Use_Weapon2,
		Drop_Weapon,
		Weapon_SPistol,
		"misc/w_pkup.wav",
		// note to Jason 
		// we need a pistol pickup icon
		"models/weapons/silencer_mdx/pistol.mdx", EF_REFL,
		"models/weapons/silencer_mdx/pistol.mdx",
/* icon */		"/pics/h_silencer.tga",
/* pickup */	"Pistol Silencer",
		0,
		1,
		"Bullets",
		IT_MOD|IT_STAY_COOP|IT_SILENCER,
		NULL,
		0,
/* precache */ "weapons/pistol/silencer.wav weapons/pistol/silencerattatch.wav"
	},

/*QUAKED pistol_mod_rof (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/pu_icon/ro_fire_mod/tris.md2"
*/
	{
		"pistol_mod_rof",
		Pickup_Pistol_Mods,
		NULL,
		Drop_Weapon,
		NULL,
		"misc/w_pkup.wav",
		"models/pu_icon/ro_fire_mod/tris.md2", EF_REFL,
		NULL,
		"/pics/h_pistol_rof.tga",
		"Pistol Rof Mod",//Fire Rate
		0,
		0,
		NULL,
		IT_MOD|IT_STAY_COOP,
		NULL,
		0,
		""
	},
/*QUAKED pistol_mod_damage (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/pu_icon/magmod/tris.md2"
*/
	{
		"pistol_mod_damage",
		Pickup_Pistol_Mods,
		NULL,
		Drop_Weapon,
		NULL,
		"misc/w_pkup.wav",
		"models/pu_icon/magmod/tris.md2", EF_REFL,
		NULL,
		"/pics/h_pistol_mag.tga",
		"Pistol Magnum Mod",
		0,
		0,
		NULL,
		IT_MOD|IT_STAY_COOP,
		NULL,
		0,
		""
	},
/*QUAKED pistol_mod_reload (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/pu_icon/reload_mod/tris.md2"
*/
	{
		"pistol_mod_reload",
		Pickup_Pistol_Mods,
		NULL,
		Drop_Weapon,
		NULL,
		"misc/w_pkup.wav",
		"models/pu_icon/reload_mod/tris.md2", EF_REFL,
		NULL,
		"/pics/h_pistol_rl.tga",
		"Pistol Reload Mod",//Also called RDL mod http://web.archive.org/web/20001102010149fw_/http://www.urbangangsta.com/noshock/tool_up/pistol.htm
		0,
		0,
		NULL,
		IT_MOD|IT_STAY_COOP,
		NULL,
		0,
		""
	},
/*QUAKED weapon_shotgun (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/weapons/g_shotgun/tris.md2"  
*/
//https://en.wikipedia.org/wiki/List_of_shotguns
//https://www.militaryfactory.com/smallarms/shotguns.php
//FREDZ Posible types of sawed off shotguns at looks and years`(5 bullets reload in demo):
// Remington Model 10		(1908)USA 5 Rounds
// Winchester Model 1912	(1912)USA 6 Rounds			- Not duo reloading on side
// Ithaca 37				(1933)USA 4, 5 or 7 Rounds	- Most likely duo see front view v_model.
// Remington Model 870		(1950)USA 4 or 7 Rounds		- Not duo reloading on side
// Mossberg 500				(1960)USA 6 Rounds			- Not duo reloading on side
	{
		"weapon_shotgun", 
		Pickup_Weapon,
		Use_Weapon,
		Drop_Weapon,
		Weapon_Shotgun,
		"misc/w_pkup.wav",
		"models/weapons/g_shotgun/tris.md2", EF_REFL,
		"models/weapons/shotgun/shotgun.mdx",
/* icon */		"/pics/h_shotgun.tga",//Sawed-Off Pump Shotgun http://web.archive.org/web/20001102022507fw_/http://www.urbangangsta.com/noshock/tool_up/shotgun.htm
/* pickup */	"Shotgun",
		0,
		1,
		"Shells",
		IT_WEAPON|IT_STAY_COOP,
		NULL,
		0,
/* precache */ "weapons/shotgun/shotgf1b.wav weapons/shotgun/shotgr1b.wav"
	},

/*QUAKED weapon_tommygun (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/weapons/g_tomgun/tris.md2"  
*/
//https://en.wikipedia.org/wiki/Thompson_submachine_gun
//https://guns.fandom.com/wiki/Thompson_submachine_gun
//http://www.imfdb.org/wiki/Thompson_Submachine_Gun
//FREDZ Posible types of Tommyguns:
// M1919	Thompson		(1920)	100 Rounds	- 1st Test version of weapon no sight view	
// M1921	Thompson		(1929)	50 Rounds	- No Compressor on end 
// M1921A	Thompson				50 Rounds	- No Compressor on end 
// M1921AC	Thompson				50 Rounds	- Could be but not much info
// M1921	Military Model						- Unlikely Military
// M1923	Thompson							- Looks diffrent
// M1927	Thompson		(1970)	50 Rounds	- Unlikely looks diffrent extra long	
// M1927A1	Thompson				50 Rounds	- Unlikely looks diffrent extra long
// M1927A3	Thompson				50 Rounds	- Unlikely looks diffrent extra long	
// M1927A5	Thompson				50 Rounds	- Unlikely looks diffrent extra long	
// M1928	Thompson				50 Rounds	- Most likely has compressor on end https://www.youtube.com/watch?v=H7M8m898ijA
// M1928A1	Thompson				50 Rounds	- Looks diffrent	
// M1		Thompson				30 Rounds	- Looks diffrent
// M1A1		Thompson				30 Rounds	- Looks diffrent
	{
		"weapon_tommygun", 
		Pickup_Weapon,
		Use_Weapon,
		Drop_Weapon,
		Weapon_Tommygun,
		"misc/w_pkup.wav",
		"models/weapons/g_tomgun/tris.md2", EF_REFL,
		"models/weapons/v_tomgun/tomgun.mdx",
/* icon */		"/pics/h_tgun.tga",
/* pickup */	"Tommygun",// Thompson submachine gun
		0,
		1,
		"Bullets",
		IT_WEAPON|IT_STAY_COOP,
		NULL,
		0,
/* precache */ "weapons/machinegun/machgf1b.wav"
	},

// JOSEPH 16-APR-99
/*QUAKED weapon_heavymachinegun (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/weapons/g_hmg/tris.md2"  
*/
//https://www.militaryfactory.com/smallarms/detail.php?smallarms_id=58
//FREDZ Posible types of Bar Weapons:
// M1918			(1917)	20 Rounds	- Probrably ment with BAR weapon but Colt R80 without cooling mod looks more look like.
// M1922			(1922)	20 Rounds	- produced in limited numbers has barrel fins
// Colt R75			(1925)	20 Rounds	- Looks diffrent
// FN Mle 1930		(1930)	20 Rounds	- Looks diffrent
// Colt R80			(1931)	20 Rounds	- Looks like cooling mod
// FN Model D		(1932)	20 Rounds	- Looks diffrent
// M1918A1 			(1937)	20 Rounds	- Has barrel fins
// M1918A2 			(1938)	20 Rounds	- Has barrel fins
// Colt R75A		(1942)	20 Rounds	- Has barrel fins
{
		"weapon_heavymachinegun", 
		Pickup_Weapon,
		Use_Weapon,
		Drop_Weapon,
		Weapon_Barmachinegun,
		"misc/w_pkup.wav",
		"models/weapons/g_hmg/tris.md2", EF_REFL,
		"models/weapons/v_hmg/hmg.mdx",
/* icon */		"/pics/h_hmg.tga",
/* pickup */	"Heavy machinegun",//FREDZ M1918 Browning Automatic Rifle
		0,
		1,
		"308cal",
		IT_WEAPON|IT_STAY_COOP,
		NULL,
		0,
/* precache */ ""
	},
// END JOSEPH

/*QUAKED hmg_mod_cooling (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/pu_icon/coolmod/tris.md2"
*/
	{
		"hmg_mod_cooling",
		Pickup_Pistol_Mods,
		NULL,
		Drop_Weapon,
		NULL,
		"misc/w_pkup.wav",
		"models/pu_icon/coolmod/tris.md2", EF_REFL,
		NULL,
		"/pics/h_heavymachinegun_cooling.tga",
		"HMG Cooling Mod",//FREDZ Colt R80	
		0,
		0,
		NULL,
		IT_MOD|IT_STAY_COOP,
		NULL,
		0,
		""
	},

/*QUAKED weapon_grenadelauncher (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/weapons/g_grenade_launcher/tris.md2"    
*/
//https://www.militaryfactory.com/smallarms/grenade-launchers.php
//FREDZ Posible types of Grenade Launcher:
// M79							(1961)USA			1 Rounds	- Has the looks of it
// China Lake grenade launcher	(1967)USA			3 Rounds
// Hawk MM-1 MGL				(1980)USA			12 Rounds
// M32 MGL						(2006)USA			6 Rounds	- To new
// MGL-105						(1983)South Africa	6 Rounds	- Ammo type
// MGL-140						(2008)South Africa	6 Rounds	- To new
// Indumil MGL Mk 1 			(1995)Colombia		6 Rounds	- Ammo type
//All Kingpin weapons are so far USA.
	{
		"weapon_grenadelauncher",
		Pickup_Weapon,
		Use_Weapon,
		Drop_Weapon,
		Weapon_GrenadeLauncher,
		"misc/w_pkup.wav",
		"models/weapons/g_grenade_launcher/tris.md2", EF_REFL,
		"models/weapons/v_grenade_launcher/grenade_launcher.mdx",
/* icon */		"/pics/h_grenade_l.tga",//Multi-grenade launcher http://web.archive.org/web/20001102001151fw_/http://www.urbangangsta.com/noshock/tool_up/grenade.htm
/* pickup */	"Grenade Launcher",//M79
		0,
		1,
		"Grenades",
		IT_WEAPON|IT_STAY_COOP,
		NULL,
		0,
/* precache */ ""
	},

// JOSEPH 28-APR-99
/*QUAKED weapon_bazooka (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/weapons/g_rocket_launcher/tris.md2"  
*/
//https://www.militaryfactory.com/smallarms/rocket-launchers.php
//FREDZ Posible types of Bazooka (missile launcher called in demo):
// M1											(1942)	USA			1 Rounds	- Bazooka nickname, Green color but also wood
// M1A1											(1943)	USA			1 Rounds	- Bazooka nickname, Green color but also wood
// M9											(1943)	USA			1 Rounds	- Airborne Bazooka nickname, Green color
// M9A1											(1944)	USA			1 Rounds	- Airborne Bazooka nickname, Green color
// M18											(1945)	USA			1 Rounds	- Improved Bazooka nickname, Black
// M20											(1945)	USA			1 Rounds	- Super Bazooka nickname, Green color
// M20A1										(1952)	USA			1 Rounds	- Super Bazooka nickname, Green color
// M20A1B1												USA			1 Rounds	- Super Bazooka nickname, Green color
// M25													USA			1 Rounds	-
// M202 FLASH									(1984)	USA			4 Rounds	- Green color, Unlikely aldo maybe future mod that was never made
// M202A1 FLASH											USA			4 Rounds	-
// M202A2 FLASH											USA			4 Rounds	-
// M72 LAW										(1963)	USA			1 Rounds	- Green color	
//Todo: https://en.wikipedia.org/wiki/M72_LAW
// M72A1
// M72A2
// M72A3
// M72A4
// M72A5
// M72A6
// M72A7
// M72A8
// M72A9
// M72A10
// M72E8
// M72E9
// M72E10
// M72E11
// M72 EC
// M72 ASM RC 
// M247
// HAR-66 
// M72AS 
// M190
// Mk 153 (SMAW)								(1980)	USA			1 Rounds	- Green color
// FGM-148 Javelin								(1996)	USA			1 Rounds	- Green and black color, Looks diffrent
// FGM-172 SRAW									(2002)	USA			1 Rounds	- To new
// AirTronic PSRL-1 (RPG-7USA)					(2009)	USA			1 Rounds	- To new
// AirTronic GS-777								(2015)	USA			1 Rounds	- To new
// Panzerfaust 30								(1943)	Germany		1 Rounds	- Brown color, Looks diffrent
// Panzerfaust 60								(1944)	Germany		1 Rounds	- Brown color, Looks diffrent
// Panzerfaust 100								(1944)	Germany		1 Rounds	- Brown color, Looks diffrent
// Panzerfaust 150								(1945)	Germany		1 Rounds	- Brown color, Looks diffrent
// Panzerschreck								(1943)	Germany		1 Rounds	- Green color, has shield Looks diffrent
// Panzerfaust 2 (PzF 44) Model 44-1			(1963)	Germany		1 Rounds	- 
// Panzerfaust 2 (PzF 44) Model 44-1A1					Germany		1 Rounds	- 
// Panzerfaust 2 (PzF 44) Model 44-2					Germany		1 Rounds	- 
// Panzerfaust 2 (PzF 44) Model 44-2A1					Germany		1 Rounds	- 
// Panzerfaust 3 (Pzf 3)						(1987)	Germany		1 Rounds	- 
// Panzerfaust 3-T										Germany		1 Rounds	- 
// Panzerfaust 3-T600									Germany		1 Rounds	- 
// Panzerfaust 3-IT600									Germany		1 Rounds	- 
// Panzerfaust 3LTW										Germany		1 Rounds	- 
// Panzerfaust 3LR										Germany		1 Rounds	- 
// MBB Armbrust (Crossbow)						(1980)	Germany		1 Rounds	- Green color with black, Unlikely
// Dynamit Noble MATADOR						(2000)	Germany		1 Rounds	- Green color, To new
// PIAT											(1942)	UK			1 Rounds	- Green color, Only from ground Unlikely
// NLAW											(2009)	UK			1 Rounds	- To new
// IMI B-300									(1980)	Isreal		1 Rounds	- Green color, Looks diffrent
// Instalaza C90								(1990)	Spain		1 Rounds	- Green color, Unlikely
// Alcotán-100									(1998)	Spain		1 Rounds	- Green color, Looks diffrent
// Breda Folgore 80								(1986)	Italy		1 Rounds	- Not hand gun, Green color
// NORINCO FHJ-84 (Type 84)						(1984)	China		2 Rounds	- Green color, Unlikely
// NORINCO FHJ-01										China		2 Rounds	- Green color, Unlikely
// NORINCO FHJ-02										China		7 Rounds	- Not hand gun, Green color, Unlikely
// NORINCO Type 69 RPG							(1970)	China		1 Rounds	- Brown color, Looks diffrent
// PF-97										(2000)	China		1 Rounds	- Green color but camflouge, To new
// KBP RPO-A (Shmel)							(1980)	Russia		1 Rounds	- Green color but camflouge, Unlikely
// RPO Rys										(1975)	Russia		1 Rounds	- Green color, Looks diffrent
// RPG-1										(1944)	Russia		1 Rounds	- Brown color, Looks diffrent
// RPG-2										(1954)	Russia		1 Rounds	- Green and black color, Looks diffrent
// RPG-7										(1961)	Russia		1 Rounds	- Brown color, Looks diffrent
// RPG-16										(1968)	Russia		1 Rounds	- Brown and black color, Looks diffrent
// RPG-18 (Mukha)								(1972)	Russia		1 Rounds	- Green and black color, Unlikely
// RPG-22										(1985)	Russia		1 Rounds	- Green and black color, Unlikely
// RPG-26										(1985)	Russia		1 Rounds	- Green color, Looks diffrent
// RPG-27										(1989)	Russia		1 Rounds	- Green color, Looks diffrent
// RPG-28 Klyukva (Cranberry) 					(2008)	Russia		1 Rounds	- Green color, To new
// RPG-29 Vampir (Vampire)  					(1989)	Russia		1 Rounds	- Brown color, Unlikely
// RPG-30   									(2012)	Russia		2 types		- Green color, To new
// RPG-32 (Hashim)   							(2012)	Russia		1 Rounds	- Brown color camflouge, To new
// RPG-75					 					(1975)	Czech		1 Rounds	- Green color, Looks diffrent
// RPG-76 Komar (Mosquito)  					(1985)	Polish		1 Rounds	- Green color, Looks diffrent
// Yasin (RPG)				  					(2004)	Palestine	1 Rounds	- Green and brown color, To new
// DP-64										(1989)	Russia		2 Rounds	- Black color, Unlikely
// MRO-A	   									(2003)	Russia		1 Rounds	- Green color, To new
// PSRL-1	   									(2017)	Russia		1 Rounds	- Black color, To new
// LRAC 89-F1									(1980)	France		1 Rounds	- Green color, Looks diffrent
// SEP Dard 120 								(1981)	France		1 Rounds	- Green and black color, Unlikely
// WASP 58										(1987)	France		1 Rounds	- Green and black color, Unlikely
// M79 Osa (Wasp)								(1979)	Yugoslavia 	1 Rounds	- Green and black color, Unlikely
// M80 Zolja (Wasp)								(1980)	Yugoslavia 	1 Rounds	- Green color, Unlikely
// M90 Stršljen									(2002)	Serbia	 	1 Rounds	- Green color, To new
//All Kingpin weapons are so far USA.
	{
		"weapon_bazooka",
		Pickup_Weapon,
		Use_Weapon,
		Drop_Weapon,
		Weapon_RocketLauncher,
		"misc/w_pkup.wav",
		"models/weapons/g_rocket_launcher/tris.md2", EF_REFL,
		"models/weapons/v_rocket_launcher/rlaunch.mdx",
/* icon */		"/pics/h_bazooka.tga",
/* pickup */	"Bazooka",// Rocket Launcher
		0,
		1,
		"Rockets",
		IT_WEAPON|IT_STAY_COOP,
		NULL,
		0,
/* precache */ "models/props/glass/glass2.md2"
	},
// END JOSEPH

/*QUAKED weapon_flamethrower (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/pu_icon/flame_shell/tris.md2"    
*/
//https://en.wikipedia.org/wiki/List_of_flamethrowers
//https://www.militaryfactory.com/smallarms/flamethrowers.php
//http://flamethrowerexpert.com/identification/
//FREDZ Posible types of Flamethrower:
// Flamethrower Type 93 				(1933)Japan		3.2 US Gallon (12 Liters) Fuel Tank								- 3 Tanks, no handle bar
// Flamethrower Type 100 				(1940)USA		3.2 US Gallon (12 Liters) Fuel Tank								- 3 Tanks, no handle bar
// Kleinflammenwerfer					(1911)Germany																	- Not much info
// Grossflammenwerfer					(1914)Germany																	- Need 2 a 3 people
// Flammenwerfer M.16.					(1915)Germany																	- 1 Tank,  no handle bar
// Wechselapparat M1917					(1917)Germany	3.2 US Gallon (12 Liters) Fuel Tank								- Looks diffrent with wheel shape on back
// Flammenwerfer 35 (FmW 35)			(1935)Germany	1 x 3-gallon compound fuel tank; 1 x Nitrogen propellant tank	- 2 Tanks, no handle bar
// Flammenwerfer 41 (FmW 41)			(1941)Germany	1 x 3-gallon compound fuel tank; 1 x Nitrogen propellant tank	- 2 Tanks, no handle bar
// Einstossflammenwerfer 46				(1944)Germany	0.45 gallon (1.7 Liters) Fuel Tank								- Weird shape
// Hay flamethrower						(1917)UK																		- 1 Tank, no handle bar
// Harvey Flamethrower					(1940)UK		22 gallons (100 Liters) 										- Needs 2 people
// Flamethrower Portable. No. 2 Mk I	(1943)UK		18.2 Liters Fuel Tank											- Looks diffrent with wheel shape on back
// Flamethrower Portable. No. 2 Mk II	(1944)UK		18.2 Liters Fuel Tank											- Looks diffrent with wheel shape on back
// Flamethrower M1						(1941)USA		4.7-gallon (21.36 Liters) Nitrogen Fuel Canister - 5 Rounds		- 3 Tanks, no handle bar
// Flamethrower M1A1					(1943)USA		4.7-gallon (21.36 Liters) Nitrogen Fuel Canister - 5 Rounds		- 3 Tanks, no handle bar
// Flamethrower M2(M2-2)				(1941)USA		4.7-gallon (21.36 Liters) Nitrogen Fuel Canister - 7 Rounds		- 3 Tanks, 2 handle bars
// Flamethrower M2A1-2					(1950)USA		4.7-gallon (21.36 Liters) Nitrogen Fuel Canister - 7 Rounds		- 3 Tanks, 2 handle bars
// Flamethrower M2A1-7					(19?)USA		4.7-gallon (21.36 Liters) Nitrogen Fuel Canister - 7 Rounds		- 3 Tanks, 1 handle bars
// Flamethrower M9A1-7					(1960)USA		4.7-gallon (21.36 Liters) Nitrogen Fuel Canister - 7 Rounds		- Most looks and is usa
// Flamethrower ROKS					(1935)Russia	2.4 US gallon (9 Liters) Fuel Tank; 1 nitrogen tank 			- No image but probably 2 Tanks with a gun
// Flamethrower ROKS-2					(1941)Russia	2.4 US gallon (9 Liters) Fuel Tank; 1 nitrogen tank 			- 2 Tanks with a gun.
// Flamethrower ROKS-3					(1943)Russia	2.4 US gallon (9 Liters) Fuel Tank; 1 nitrogen tank 			- 2 Tanks with a gun.
// Flamethrower LPO-50					(1953)Russia	Three 0.73 gallon (3.3 Liters) fuel tanks						- 3 Tanks with a gun.
// K pattern flamethrower				(1944)Polish	16 Liters														- 1 or 2 Tanks?, no handle bar.
// Lanciafiamme Modello 35 (Model 35)	(1935)Italy		29 liters														- 2 Tanks possible looks allot the same only no handle
// Lanciafiamme Modello 40 (Model 40)	(1940)Italy		29 liters														- 2 Tanks possible looks allot the same only no handle
// Lanciafiamme Modello 41 (Model 41)	(1941)Italy																		- 2 Tanks. Looks more like a gun.
//All Kingpin weapons are so far USA.
	{
		"weapon_flamethrower", 
		Pickup_Weapon,
		Use_Weapon,
		Drop_Weapon,
		Weapon_FlameThrower,
		"misc/w_pkup.wav",
		//"models/weapons/g_shotg2/tris.md2", EF_ROTATE,
		"models/pu_icon/flame_shell/tris.md2", EF_REFL,
		"models/weapons/v_flamegun/flamegun.mdx",
/* icon */		"/pics/h_flamethrower.tga",
/* pickup */	"FlameThrower",
		0,
		2,
		"Gas",
		IT_WEAPON|IT_STAY_COOP,
		NULL,
		0,
/* precache */ ""
	},
// END JOSEPH

// NEW CRASH WEAPONS (MH: moved to after standard weapons)

/*QUAKED weapon_bomb (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/weapons/g_dynomite/tris.md2"
*/
	{
		"weapon_bomb", 
		Pickup_Weapon,
		Use_Weapon2,
		Drop_Weapon,
		Weapon_Bomb,
		"misc/w_pkup.wav",
		"models/weapons/g_dynomite/tris.md2", EF_REFL,//FREDZ
		"models/weapons/v_dynomite/bomb.mdx",//FREDZ
/* icon */		"/pics/h_bomb.tga",
/* pickup */	"bomb",
		0,
		1,
		NULL,
		IT_WEAPON|IT_STAY_COOP,
		NULL,
		0,
		/* precache */ ""
	},

/*QUAKED weapon_defuse (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/weapons/v_deactivator/pliers.mdx"
*/
	{
		"weapon_defuse", 
		NULL,
		Use_Weapon2,
		NULL,
		Weapon_Defuse,
		"misc/w_pkup.wav",
		"models/weapons/g_deactivator/tris.md2", EF_REFL,//FREDZ
		"models/weapons/v_deactivator/plier.mdx",//FREDZ
/* icon */		"/pics/h_defuse.tga",
/* pickup */	"defuse",
		0,
		1,
		NULL,
		IT_WEAPON|IT_STAY_COOP,
		NULL,
		0,
		/* precache */ ""
	},


// END NEW CRASH WEAPONS

	//
	// AMMO ITEMS
	//

/*QUAKED ammo_grenades (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/pu_icon/grenade/tris.md2"  
*/
	{
		"ammo_grenades",
		Pickup_Ammo,
		NULL,
		Drop_Ammo,
		NULL,
		"world/pickups/ammo.wav",
		"models/pu_icon/grenade/tris.md2", 0,
        NULL,
/* icon */		"/pics/h_grenade.tga",
/* pickup */	"Grenades",
/* width */		3,
		3,
		NULL,
		IT_AMMO,
		NULL,
		AMMO_GRENADES,
/* precache */ ""
	},

/*QUAKED ammo_shells (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/pu_icon/shotgun_shell/tris.md2"  
*/
	{
		"ammo_shells",
		Pickup_Ammo,
		NULL,
		Drop_Ammo,
		NULL,
		"world/pickups/ammo.wav",
		"models/pu_icon/shotgun_shell/tris.md2", 0,		
		NULL,
/* icon */		"/pics/h_shots.tga",
/* pickup */	"Shells",
/* width */		3,
		10,
		NULL,
		IT_AMMO,
		NULL,
		AMMO_SHELLS,
/* precache */ ""
	},

// JOSEPH 3-MAR-99
/*QUAKED ammo_bullets (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/pu_icon/pclip/tris.md2"  
*/
	{
		"ammo_bullets",
		Pickup_Ammo,
		NULL,
		Drop_Ammo,
		NULL,
		"world/pickups/ammo.wav",
		"models/pu_icon/pclip/tris.md2", 0,
		NULL,
/* icon */		"/pics/h_bullet.tga",
/* pickup */	"Bullets", //.45 caliber ACP (Automatic Colt Pistol)
/* width */		3,
		20,
		NULL,
		IT_AMMO,
		NULL,
		AMMO_BULLETS,
/* precache */ ""
	},
// END JOSEPH


// JOSEPH 1-APR-99
/*QUAKED ammo_rockets (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/pu_icon/rocket/tris.md2" 
*/
	{
		"ammo_rockets",
		Pickup_Ammo,
		NULL,
		Drop_Ammo,
		NULL,
		"world/pickups/ammo.wav",
		"models/pu_icon/rocket/tris.md2", 0,
		NULL,
/* icon */		"/pics/h_missle.tga",
/* pickup */	"Rockets",
/* width */		3,
		5,
		NULL,
		IT_AMMO,
		NULL,
		AMMO_ROCKETS,
/* precache */ ""
	},
// END JOSEPH

// JOSEPH 28-APR-99
/*QUAKED ammo_308 (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/pu_icon/hmgclip/tris.md2" 
*/
	{
		"ammo_308",
		Pickup_Ammo,
		NULL,
		Drop_Ammo,
		NULL,
		"misc/w_pkup.wav",
		"models/pu_icon/hmgclip/tris.md2", 0,
		NULL,
/* icon */		"/pics/h_hmg_clip.tga",
/* pickup */	"308cal",
/* width */		3,
		30,
		NULL,
		IT_AMMO,
		NULL,
		AMMO_308CAL,
/* precache */ ""
	},
// END JOSEPH

/*QUAKED ammo_cylinder (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/pu_icon/tgclip/tris.md2"  
*/
	{
		"ammo_cylinder",
		Pickup_Ammo_Cylinder,
		NULL,
		Drop_Ammo,
		NULL,
		"world/pickups/ammo.wav",
		"models/pu_icon/tgclip/tris.md2", 0,
		NULL,
/* icon */		"/pics/h_tclip.tga",
/* pickup */	"Cylinder",
/* width */		3,
		50,
		NULL,
		IT_AMMO|IT_NOCHEATS,
		NULL,
		AMMO_BULLETS,
/* precache */ ""
	},

/*QUAKED ammo_flametank (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/pu_icon/flametank/tris.md2"  
*/
	{
		"ammo_flametank",
		Pickup_Ammo,
		NULL,
		NULL,
		NULL,
		"world/pickups/ammo.wav",
		"models/pu_icon/flametank/tris.md2", 0,
		NULL,
		"/pics/h_ftank.tga",
		"Gas",
		2,
		50,
		NULL,
		IT_AMMO,
		NULL,
		AMMO_GAS,
/* precache */ ""
	},		
#if 0
	//FREDZ Realistic ammo
	/*QUAKED 45_ACP" (.3 .3 1) (-16 -16 -16) (16 16 16)
	model="models/pu_icon/pclip/tris.md2"
	*/
	{
		"45_ACP",//https://en.wikipedia.org/wiki/.45_ACP
		Pickup_Ammo,
		NULL,
		Drop_Ammo,
		NULL,
		"world/pickups/ammo.wav",
		"models/pu_icon/pclip/tris.md2", 0,
		NULL,
		/* icon */		"/pics/h_bullet.tga",
		/* pickup */	"45 ACP", //.45 caliber ACP (Automatic Colt Pistol)
		/* width */		3,
		14,//2 times 7 https://www.militaryfactory.com/smallarms/detail.php?smallarms_id=12
		NULL,
		IT_AMMO,
		NULL,
		AMMO_45CAL,
		/* precache */ ""
	},
	/*QUAKED 12_gauge (.3 .3 1) (-16 -16 -16) (16 16 16)
	model="models/pu_icon/shotgun_shell/tris.md2"
	*/
//https://en.wikipedia.org/wiki/Shotgun_shell
//Estate Cartridge Ammunition - Target Sports USA		- Missing on Wikipedia, red and white possible.
//J. C. Higgins(1908-1962)USA							- J.C. HIGGINS xtra range SHOTGUN SHELLS possible
//Federal Monark 38										- mostlikely
//https://en.wikipedia.org/wiki/Category:Ammunition_manufacturers
//Ammo brands:
//   Aguila Ammunition(1961)Mexico						- black and orange unlikely
//   Alliant Techsystems(1990)USA						- to new.
//   American Powder Mills(1883–1929)USA				- no box
//   Austin Cartridge Company(1895–1907)USA				- to old.
//   Barnaul Cartridge Plant(1920)Russia				- green/blur and red unlikely
//   Black Hills Ammunition(1981)USA					- black and red no shell	
//   Brenneke(1895)Germany								- diffrent boxes unlikely
//   CCI (Cascade Cartridge Inc.)(1963)USA				- unlikely
//   Companhia Brasileira de Cartuchos(1926)Brazil		- unlikely
//   Cor-Bon/Glaser(1982)USA							- red/blue and white unlikely
//   Federal Premium Ammunition(1916)USA				- red unlikely
//   Fiocchi Munizioni(1876)Italy						- black or green unlikely
//   GECO(1941)Canada									- red and black unlikely
//   Hazard Powder Company(1835)USA						- to old.
//   Hodgdon Powder Company(1966)USA					- no boxes
//   Hornady(1949)USA									- grey or red unlikely
//   Klimovsk Specialized Ammunition Plant(1936)Russia	- black and red unlikely
//   Kynoch(1862)UK										- Yellow and red unlikely
//   Lake City Army Ammunition Plant(1944)				- Grey almost no boxes
//   Lehigh Defense(2019)USA							- To new
//   NIOA(ELEY)(1973)Australia							- Colorfull unlikely
//   Norma Precision(1895)Swedish						- Wood and red unlikely
//   Nosler(1948)USA									- Black unlikely
//   Olin Corporation(1892)USA							- Grey unlikely
//   Peters Cartridge Company(1887)USA					- Colorfull unlikely
//   Prvi Partizan(PPU)(1998)Serbia						- Blue box unlikely
//   Red Army Standard Ammunition(2012)USA				- To new
//   Remington Arms(1816)USA							- Green, maybe HG0068 Vtg Remington
//   Rio Ammunition(1896)USA							- Blue unlikely
//   Sellier & Bellot(1825)Czech						- Green and gold unlikely
//   Sierra Bullets(1947)USA							- Green bullets only
//   Union Metallic Cartridge Company(1867)USA			- unlikely 
//   United States Cartridge Company(1869)USA			- unlikely
//   Western Cartridge Company(1898)USA					- Yellow unlikely
//   Winchester Repeating Arms Company(1866)USA			- Red and yellow unlikely
//   Wolf Ammunition(2005)USA							- To new.
	{
		"12_gauge",//12, 16, 20, or 28 gauge possible
		Pickup_Ammo,
		NULL,
		Drop_Ammo,
		NULL,
		"world/pickups/ammo.wav",
		"models/pu_icon/shotgun_shell/tris.md2", 0,
		NULL,
		/* icon */		"/pics/h_shots.tga",
		/* pickup */	"12 Gauge",
		/* width */		3,
		10,//Ammount in box depence on box
		NULL,
		IT_AMMO,
		NULL,
		AMMO_12GAUGE,
		/* precache */ ""
	},
	//FREDZ Realistic ammo
#endif

	//
	// KINGPIN items
	//

	
// JOSEPH 22-FEB-99	
/*QUAKED item_coil (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/pu_icon/coil/tris.md2"  
*/
	{
		"item_coil",
		Pickup_Key,
		NULL,
		NULL,
		NULL,
		"world/pickups/coil.wav",
		"models/pu_icon/coil/tris.md2", 0,
		NULL,
		"/pics/h_coil.tga",
		"Coil",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY|IT_NOCHEATS,
		NULL,
		0,
/* precache */ ""
	},
// END JOSEPH

// JOSEPH 5-JUN-99
/*QUAKED item_lizzyhead (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/pu_icon/head/tris.md2"  
*/
	{
		"item_lizzyhead",
		Pickup_Key,
		NULL,
		NULL,
		NULL,
		"world/pickups/lizzyhead.wav",
		"models/pu_icon/head/head.mdx", 0,
		NULL,
		"/pics/h_lizzyhead.tga",
		"Lizzy Head",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY|IT_NOCHEATS,
		NULL,
		0,
/* precache */ ""
	},
// END JOSEPH

/*QUAKED item_cashroll (.3 .3 1) (-16 -16 -16) (16 16 16)
currentcash - set amount of cash in roll  
model="models/pu_icon/cash/tris.md2"  
*/
	{
		"item_cashroll",
		Pickup_Cash,
		NULL,
		NULL,
		NULL,
		"world/pickups/cash.wav",
		"models/pu_icon/cash/tris.md2", 0,
		NULL,
		// JOSEPH 26-JAN-99-C
		"/pics/hh_money.tga",
		"Cash",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY|IT_NOCHEATS,
		NULL,
		0,
/* precache */ ""
	},	

// JOSEPH 2-MAR-99
/*QUAKED item_cashbaglarge (.3 .3 1) (-16 -16 -16) (16 16 16)
currentcash - set amount of cash in the bag  
model="models/pu_icon/money/money_lg.md2"  
*/
	{
		"item_cashbaglarge",
		Pickup_Cash,
		NULL,
		NULL,
		NULL,
		"world/pickups/cash.wav",
		"models/pu_icon/money/money_lg.md2", 0,
		NULL,
		// JOSEPH 26-JAN-99-C
		"/pics/hh_money.tga",
		"Large Cash Bag",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY|IT_NOCHEATS,
		NULL,
		0,
/* precache */ ""
	},	

/*QUAKED item_cashbagsmall (.3 .3 1) (-16 -16 -16) (16 16 16)
currentcash - set amount of cash in the bag  
model="models/pu_icon/money/money_sm.md2"  
*/
	{
		"item_cashbagsmall",
		Pickup_Cash,
		NULL,
		NULL,
		NULL,
		"world/pickups/cash.wav",
		"models/pu_icon/money/money_sm.md2", 0,
		NULL,
		// JOSEPH 26-JAN-99-C
		"/pics/hh_money.tga",
		"Small Cash Bag",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY|IT_NOCHEATS,
		NULL,
		0,
/* precache */ ""
	},	
// END JOSEPH
	

/*QUAKED item_battery (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/pu_icon/battery/tris.md2"  
*/
	{
		"item_battery",
		Pickup_Key,
		NULL,
		NULL,
		NULL,
		"world/pickups/generic.wav",
		"models/pu_icon/battery/tris.md2", 0,
		NULL,
		"/pics/h_bat.tga",
		"Battery",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY|IT_NOCHEATS,
		NULL,
		0,
/* precache */ ""
	},		


// JOSEPH 2-MAR-99
/*QUAKED item_jetpack (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/items/misc/jetpack/jetpack.mdx"
*/
	{
		"item_jetpack",
		Pickup_JetPack,
		Use_JetPack,
		NULL,
		NULL,
		"world/pickups/generic.wav",
		"models/items/misc/jetpack/jetpack.mdx", 0,
		NULL,
/* icon */		"/pics/h_jetpack.tga",
		"Jet Pack",
		0,
		0,
		NULL,
		IT_STAY_COOP|IT_NOCHEATS,
		NULL,
		0,
/* precache */ ""
	},			
// END JOSEPH

// JOSEPH 10-FEB-99
/*QUAKED item_health_sm (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/pu_icon/health_s/tris.md2"  
*/
	{
		"item_health_sm",
		Pickup_Health_Small,
		NULL,
		NULL,
		NULL,
		"world/pickups/health.wav",
		"models/pu_icon/health_s/tris.md2", 0,
		NULL,
		"/pics/h_smed.tga",
		"Small Health",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY|IT_NOCHEATS,
		NULL,
		0,
/* precache */ ""
	},			
	
/*QUAKED item_health_lg (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/pu_icon/health/tris.md2"  
*/
	{
		"item_health_lg",
		Pickup_Health_Large,
		NULL,
		NULL,
		NULL,
		"world/pickups/health.wav",
		"models/pu_icon/health/tris.md2", 0,
		NULL,
		"/pics/h_lmed.tga",
		"Large Health",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY|IT_NOCHEATS,
		NULL,
		0,
/* precache */ ""
	},		
// END JOSEPH


/*QUAKED item_flashlight (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/pu_icon/f_light/tris.md2"  
*/
	{
		"item_flashlight",
		Pickup_Key,
		NULL,
		NULL,
		NULL,
		"world/pickups/generic.wav",
		"models/pu_icon/f_light/tris.md2", 0,
		NULL,
		"/pics/h_flashl.tga",
		"Flashlight",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_FLASHLIGHT,
		NULL,
		0,
/* precache */ ""
	},		

// JOSEPH 12-MAR-99	
/*QUAKED item_watch (.3 .3 1) (-16 -16 -16) (16 16 16)

Watch for Lenny
  
model="models/pu_icon/watch/tris.md2"  
*/
	{
		"item_watch",
		Pickup_Key,
		NULL,
		NULL,
		NULL,
		"world/pickups/generic.wav",
		"models/pu_icon/watch/tris.md2", 0,
		NULL,
		"/pics/h_watch.tga",
		"Watch",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY|IT_NOCHEATS,
		NULL,
		0,
/* precache */ ""
	},
// END JOSEPH

// JOSEPH 24-MAR-99	
/*QUAKED item_whiskey (.3 .3 1) (-16 -16 -16) (16 16 16)

model="models/pu_icon/whiskey/tris.md2"  

Whiskey for the bum
  
*/
	{
		"item_whiskey",
		Pickup_Key,
		NULL,
		NULL,
		NULL,
		"world/pickups/generic.wav",
		"models/pu_icon/whiskey/tris.md2", 0,
		NULL,
		"/pics/h_bottle.tga",
		"Whiskey",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY|IT_NOCHEATS,
		NULL,
		0,
/* precache */ ""
	},
// END JOSEPH

// JOSEPH 30-MAY-99
/*QUAKED item_pack (.3 .3 1) (-16 -16 -16) (16 16 16)
model="models/pu_icon/backpack/tris.md2"
*/
	{
		"item_pack",
		Pickup_Pack,
		NULL,
		NULL,
		NULL,
		"world/pickups/generic.wav",
		"models/pu_icon/backpack/tris.md2", 0,
		NULL,
/* icon */		"/pics/h_backpack.tga",
/* pickup */	"Ammo Pack",
/* width */		2,
		180,
		NULL,
		IT_NOCHEATS|IT_FLASHLIGHT,
		NULL,
		0,
/* precache */ ""
	},
// END JOSEPH

// JOSEPH 29-MAY-99
/*QUAKED item_adrenaline (.3 .3 1) (-16 -16 -16) (16 16 16)
gives +1 to maximum health
model="models/pu_icon/adrenaline/tris.md2"
*/
	{
		"item_adrenaline",
		Pickup_Adrenaline,
		NULL,
		NULL,
		NULL,
		"world/pickups/health.wav",
		"models/pu_icon/adrenaline/tris.md2", 0,
		NULL,
		"/pics/h_smed.tga",
/* pickup */	"Adrenaline",
/* width */		2,
		60,
		NULL,
		IT_NOCHEATS,
		NULL,
		0,
/* precache */ ""
	},
// END JOSEPH

// JOSEPH 7-MAY-99
/*QUAKED key_fuse (0 .5 .8) (-8 -8 -16) (8 8 16) TRIGGER_SPAWN NO_TOUCH
*/
	{
		"key_fuse",
		Pickup_Key,
		NULL,
		NULL,
		NULL,
		"world/pickups/coil.wav",
		"models/pu_icon/fuse/tris.md2", 0,
		NULL,
		"/pics/h_fuse.tga",
		"Fuse",//MK12A1
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY|IT_NOCHEATS,
		NULL,
		0,
/* precache */ ""
	},
// END JOSEPH

// JOSEPH 4-MAY-99
/*QUAKED item_safedocs (.3 .3 1) (-16 -16 -16) (16 16 16)
Safe docs for the louie in PV
model="models/pu_icon/folder/tris.md2"  
*/
	{
		"item_safedocs",
		Pickup_Key,
		NULL,
		NULL,
		NULL,
		"world/pickups/generic.wav",
		"models/pu_icon/folder/tris.md2", 0,
		NULL,
		"/pics/h_safedocs.tga",
		"Safe docs",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY|IT_NOCHEATS,
		NULL,
		0,
/* precache */ ""
	},
// END JOSEPH

/*QUAKED item_valve (.3 .3 1) (-16 -16 -16) (16 16 16)
A valve dial turn key
model="models/pu_icon/valve/tris.md2" 
*/
	{
		"item_valve",
		Pickup_Key,
		NULL,
		NULL,
		NULL,
		"world/pickups/generic.wav",
		"models/pu_icon/valve/tris.md2", 0,
		NULL,
		"/pics/h_valve.tga",
		"Valve",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY|IT_NOCHEATS,
		NULL,
		0,
/* precache */ ""
	},
// END JOSEPH

// JOSEPH 25-MAY-99
/*QUAKED item_oilcan (.3 .3 1) (-16 -16 -16) (16 16 16)
An oil can
model="models/pu_icon/oilcan/tris.md2" 
*/
	{
		"item_oilcan",
		Pickup_Key,
		NULL,
		NULL,
		NULL,
		"world/pickups/generic.wav",
		"models/pu_icon/oilcan/tris.md2", 0,
		NULL,
		"/pics/h_oilcan.tga",
		"Oil Can",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY|IT_NOCHEATS,
		NULL,
		0,
/* precache */ ""
	},
// END JOSEPH

	// Kingpin keys


// JOSEPH 16-MAR-99

/*QUAKED key_key1 (0 .5 .8) (-16 -16 -16) (16 16 16)
key 1
model="models/pu_icon/key/key_a.md2"  
*/
	{
		"key_key1",
		Pickup_Key,
		NULL,
		NULL,
		NULL,
        "world/pickups/keys.wav",
		"models/pu_icon/key/key_a.md2", 0,
		NULL,
		"/pics/h_key.tga",
		"StoreRoomKey",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY|IT_NOCHEATS,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED key_key2 (0 .5 .8) (-16 -16 -16) (16 16 16)
key 2
model="models/pu_icon/key/key_b.md2" 
*/
	{
		"key_key2",
		Pickup_Key,
		NULL,
		NULL,
		NULL,
        "world/pickups/keys.wav",
		"models/pu_icon/key/key_b.md2", 0,
		NULL,
		"/pics/h_key.tga",
		"Electrical_Room",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY|IT_NOCHEATS,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED key_key3 (0 .5 .8) (-16 -16 -16) (16 16 16)
key 3
model="models/pu_icon/key/key_c.md2" 
*/
	{
		"key_key3",
		Pickup_Key,
		NULL,
		NULL,
		NULL,
        "world/pickups/keys.wav",
		"models/pu_icon/key/key_c.md2", 0,
		NULL,
		"/pics/h_key.tga",
		"Chem_Plant_Key",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY|IT_NOCHEATS,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED key_key4 (0 .5 .8) (-16 -16 -16) (16 16 16)
key 4
model="models/pu_icon/key/key_c.md2" 
*/
	{
		"key_key4",
		Pickup_Key,
		NULL,
		NULL,
		NULL,
        "world/pickups/keys.wav",
		"models/pu_icon/key/key_c.md2", 0,
		NULL,
		"/pics/h_key.tga",
		"Bridge_Key",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY|IT_NOCHEATS,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED key_key5 (0 .5 .8) (-16 -16 -16) (16 16 16)
key 5
model="models/pu_icon/key/key_c.md2" 
*/
	{
		"key_key5",
		Pickup_Key,
		NULL,
		NULL,
		NULL,
        "world/pickups/keys.wav",
		"models/pu_icon/key/key_c.md2", 0,
		NULL,
		"/pics/h_key.tga",
		"Shipyard_Key",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY|IT_NOCHEATS,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED key_key6 (0 .5 .8) (-16 -16 -16) (16 16 16)
key 6
model="models/pu_icon/key/key_c.md2" 
*/
	{
		"key_key6",
		Pickup_Key,
		NULL,
		NULL,
		NULL,
        "world/pickups/keys.wav",
		"models/pu_icon/key/key_c.md2", 0,
		NULL,
		"/pics/h_key.tga",
		"Warehouse_Key",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY|IT_NOCHEATS,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED key_key7 (0 .5 .8) (-16 -16 -16) (16 16 16)
key 7
model="models/pu_icon/key/key_c.md2" 
*/
	{
		"key_key7",
		Pickup_Key,
		NULL,
		NULL,
		NULL,
        "world/pickups/keys.wav",
		"models/pu_icon/key/key_c.md2", 0,
		NULL,
		"/pics/h_key.tga",
		"Shop_Key",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY|IT_NOCHEATS,
		NULL,
		0,
/* precache */ ""
	},

// JOSEPH 6-JUN-99
/*QUAKED key_key8 (0 .5 .8) (-16 -16 -16) (16 16 16)
key 8
model="models/pu_icon/key/key_c.md2" 
*/
	{
		"key_key8",
		Pickup_Key,
		NULL,
		NULL,
		NULL,
        "world/pickups/keys.wav",
		"models/pu_icon/key/key_c.md2", 0,
		NULL,
		"/pics/h_ticket.tga",
		"Ticket",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY|IT_NOCHEATS,
		NULL,
		0,
/* precache */ ""
	},
// END JOSEPH

/*QUAKED key_key9 (0 .5 .8) (-16 -16 -16) (16 16 16)
key 9
model="models/pu_icon/key/key_c.md2" 
*/
	{
		"key_key9",
		Pickup_Key,
		NULL,
		NULL,
		NULL,
        "world/pickups/keys.wav",
		"models/pu_icon/key/key_c.md2", 0,
		NULL,
		"/pics/h_key.tga",
		"Office_Key",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY|IT_NOCHEATS,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED key_key10 (0 .5 .8) (-16 -16 -16) (16 16 16)
key 10
model="models/pu_icon/key/key_c.md2" 
*/
	{
		"key_key10",
		Pickup_Key,
		NULL,
		NULL,
		NULL,
        "world/pickups/keys.wav",
		"models/pu_icon/key/key_c.md2", 0,
		NULL,
		"/pics/h_key.tga",
		"Key10",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY|IT_NOCHEATS,
		NULL,
		0,
/* precache */ ""
	},
// END JOSEPH


	//==========================================================================================
	// OLD QUAKE2 ITEMS

	//
	// POWERUP ITEMS
	//
#if 0
/*QUAKED item_quad (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"item_quad", 
		Pickup_Powerup,
		Use_Quad,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/items/quaddama/tris.md2", EF_ROTATE,
		NULL,
/* icon */		"p_quad",
/* pickup */	"Quad Damage",
/* width */		2,
		60,
		NULL,
		IT_POWERUP,
		NULL,
		0,
/* precache */ "items/damage.wav items/damage2.wav items/damage3.wav"
	},

/*QUAKED item_quadfire (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"item_quadfire", 
		Pickup_Powerup,
		Use_QuadFire,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/items/quadfire/tris.md2", EF_ROTATE,
		NULL,
/* icon */		"p_quadfire",
/* pickup */	"QuadFire Damage",
/* width */		2,
		60,
		NULL,
		IT_POWERUP,
		NULL,
		0,
/* precache */ "items/damage.wav items/damage2.wav items/damage3.wav"
	},


/*QUAKED item_invulnerability (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"item_invulnerability",
		Pickup_Powerup,
		Use_Invulnerability,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/items/invulner/tris.md2", EF_ROTATE,
		NULL,
/* icon */		"p_invulnerability",
/* pickup */	"Invulnerability",
/* width */		2,
		300,
		NULL,
		IT_POWERUP,
		NULL,
		0,
/* precache */ "items/protect.wav items/protect2.wav items/protect4.wav"
	},

/*QUAKED item_silencer (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"item_silencer",
		Pickup_Powerup,
		Use_Silencer,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/pu_icon/silencer/tris.md2", 0,
		NULL,
/* icon */		"p_silencer",
/* pickup */	"Silencer",
/* width */		2,
		60,
		NULL,
		IT_POWERUP,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED item_breather (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"item_breather",
		Pickup_Powerup,
		Use_Breather,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/items/breather/tris.md2", EF_ROTATE,
		NULL,
/* icon */		"p_rebreather",
/* pickup */	"Rebreather",
/* width */		2,
		60,
		NULL,
		IT_STAY_COOP|IT_POWERUP,
		NULL,
		0,
/* precache */ "items/airout.wav"
	},

/*QUAKED item_enviro (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"item_enviro",
		Pickup_Powerup,
		Use_Envirosuit,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/items/enviro/tris.md2", EF_ROTATE,
		NULL,
/* icon */		"p_envirosuit",
/* pickup */	"Environment Suit",
/* width */		2,
		60,
		NULL,
		IT_STAY_COOP|IT_POWERUP,
		NULL,
		0,
/* precache */ "items/airout.wav"
	},

/*QUAKED item_ancient_head (.3 .3 1) (-16 -16 -16) (16 16 16)
Special item that gives +2 to maximum health
*/
	{
		"item_ancient_head",
		Pickup_AncientHead,
		NULL,
		NULL,
		NULL,
		"items/pkup.wav",
		"models/items/c_head/tris.md2", EF_ROTATE,
		NULL,
/* icon */		"i_fixme",
/* pickup */	"Ancient Head",
/* width */		2,
		60,
		NULL,
		0,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED item_bandolier (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"item_bandolier",
		Pickup_Bandolier,
		NULL,
		NULL,
		NULL,
		"items/pkup.wav",
		"models/items/band/tris.md2", EF_ROTATE,
		NULL,
/* icon */		"p_bandolier",
/* pickup */	"Bandolier",
/* width */		2,
		60,
		NULL,
		0,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED item_pack (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"item_pack",
		Pickup_Pack,
		NULL,
		NULL,
		NULL,
		"items/pkup.wav",
		"models/items/pack/tris.md2", EF_ROTATE,
		NULL,
/* icon */		"i_pack",
/* pickup */	"Ammo Pack",
/* width */		2,
		180,
		NULL,
		0,
		NULL,
		0,
/* precache */ ""
	},

	//
	// KEYS
	//
/*QUAKED key_data_cd (0 .5 .8) (-16 -16 -16) (16 16 16)
key for computer centers
*/
	{
		"key_data_cd",
		Pickup_Key,
		NULL,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/items/keys/data_cd/tris.md2", EF_ROTATE,
		NULL,
		"k_datacd",
		"Data CD",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY,
		NULL,
		0,
/* precache */ ""
	},

// JOSEPH 30-APR-99
/*QUAKED key_fuse (0 .5 .8) (-16 -16 -16) (16 16 16) TRIGGER_SPAWN NO_TOUCH
warehouse circuits
*/
// END JOSEPH
	{
		"key_fuse",
		Pickup_Key,
		NULL,
		Drop_General,
		NULL,
		"world/pickups/coil.wav",
		"models/pu_icon/coil/tris.md2", EF_ROTATE,
		NULL,
		"/pics/h_coil.tga",
		"Fuse",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED key_pyramid (0 .5 .8) (-16 -16 -16) (16 16 16)
key for the entrance of jail3
*/
	{
		"key_pyramid",
		Pickup_Key,
		NULL,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/items/keys/pyramid/tris.md2", EF_ROTATE,
		NULL,
		"k_pyramid",
		"Pyramid Key",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED key_data_spinner (0 .5 .8) (-16 -16 -16) (16 16 16)
key for the city computer
*/
	{
		"key_data_spinner",
		Pickup_Key,
		NULL,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/items/keys/spinner/tris.md2", EF_ROTATE,
		NULL,
		"k_dataspin",
		"Data Spinner",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED key_pass (0 .5 .8) (-16 -16 -16) (16 16 16)
security pass for the security level
*/
	{
		"key_pass",
		Pickup_Key,
		NULL,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/items/keys/pass/tris.md2", EF_ROTATE,
		NULL,
		"k_security",
		"Security Pass",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED key_blue_key (0 .5 .8) (-16 -16 -16) (16 16 16)
normal door key - blue
*/
	{
		"key_blue_key",
		Pickup_Key,
		NULL,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/items/keys/key/tris.md2", EF_ROTATE,
		NULL,
		"k_bluekey",
		"Blue Key",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY,
		NULL,
		0,
/* precache */ ""
	},


/*QUAKED key_red_key (0 .5 .8) (-16 -16 -16) (16 16 16)
normal door key - red
*/
	{
		"key_red_key",
		Pickup_Key,
		NULL,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/items/keys/red_key/tris.md2", EF_ROTATE,
		NULL,
		"k_redkey",
		"Red Key",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY,
		NULL,
		0,
/* precache */ ""
	},


// RAFAEL
/*QUAKED key_green_key (0 .5 .8) (-16 -16 -16) (16 16 16)
normal door key - blue
*/
	{
		"key_green_key",
		Pickup_Key,
		NULL,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/items/keys/green_key/tris.md2", EF_ROTATE,
		NULL,
		"k_green",
		"Green Key",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED key_commander_head (0 .5 .8) (-16 -16 -16) (16 16 16)
tank commander's head
*/
	{
		"key_commander_head",
		Pickup_Key,
		NULL,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/monsters/commandr/head/tris.md2", EF_GIB,
		NULL,
/* icon */		"k_comhead",
/* pickup */	"Commander's Head",
/* width */		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED key_airstrike_target (0 .5 .8) (-16 -16 -16) (16 16 16)
tank commander's head
*/
	{
		"key_airstrike_target",
		Pickup_Key,
		NULL,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/items/keys/target/tris.md2", EF_ROTATE,
		NULL,
/* icon */		"i_airstrike",
/* pickup */	"Airstrike Marker",
/* width */		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY,
		NULL,
		0,
/* precache */ ""
	},

	{
		NULL,
		Pickup_Health,
		NULL,
		NULL,
		NULL,
		"items/pkup.wav",
		NULL, 0,
		NULL,
/* icon */		"i_health",
/* pickup */	"Health",
/* width */		3,
		0,
		NULL,
		0,
		NULL,
		0,
/* precache */ ""
	},

	{
		NULL,
		Pickup_Pistol_Mods,
		NULL,
		NULL,
		NULL,
		"misc/w_pkup.wav",
		NULL, 0,
		NULL,
/* icon */		NULL,//"i_pistol_mods",
/* pickup */	"Pistol_Mods",
/* width */		3,
		0,
		NULL,
		IT_NOCHEATS,
		NULL,
		0,
/* precache */ ""
	},
#endif
	// end of list marker
	{NULL}
};
// END JOSEPH

#if 0
// JOSEPH 13-JUN-99
/*QUAKED hmg_mod_cooling (.7 .3 .4) (-16 -16 -16) (16 16 16)
model="models/pu_icon/modcool/tris.md2" 
*/
void SP_hmg_mod_cooling (edict_t *self)
{
	self->model = "models/pu_icon/coolmod/tris.md2";
	self->count = 4;
	SpawnItem (self, FindItem ("Pistol_Mods"));
//	self->item->icon = "/pics/h_heavymachinegun_cooling.tga";
// snap, self->item->icon was causing crash, disabled this
	//gi.soundindex ("items/pistol_mods.wav");
}
// END JOSEPH

// JOSEPH 1-APR-99
/*QUAKED pistol_mod_rof (.7 .3 .4) (-16 -16 -16) (16 16 16)
model="models/pu_icon/ro_fire_mod/tris.md2" 
*/
void SP_pistol_mod_rof (edict_t *self)
{
	self->model = "models/pu_icon/ro_fire_mod/tris.md2";
	self->count = 1;
	SpawnItem (self, FindItem ("Pistol_Mods"));
	//gi.soundindex ("items/pistol_mods.wav");
}

/*QUAKED pistol_mod_reload (.7 .3 .4) (-16 -16 -16) (16 16 16)
model="models/pu_icon/reload_mod/tris.md2" 
model="models/pu_icon/reload_mod/tris.md2" 
*/
void SP_pistol_mod_reload (edict_t *self)
{
	self->model = "models/pu_icon/reload_mod/tris.md2";
	self->count = 2;
	SpawnItem (self, FindItem ("Pistol_Mods"));
	//gi.soundindex ("items/pistol_mods.wav");
}

/*QUAKED pistol_mod_damage (.7 .3 .4) (-16 -16 -16) (16 16 16)
model="models/pu_icon/magmod/tris.md2" 
*/
void SP_pistol_mod_damage (edict_t *self)
{
	self->model = "models/pu_icon/magmod/tris.md2";
	self->count = 3;
	SpawnItem (self, FindItem ("Pistol_Mods"));
	//gi.soundindex ("items/pistol_mods.wav");
}
// END JOSEPH

/*UAKED item_health (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
void SP_item_health (edict_t *self)
{
	if ( deathmatch->value && ((int)dmflags->value & DF_NO_HEALTH) )
	{
		G_FreeEdict (self);
		return;
	}

	self->model = "models/items/healing/medium/tris.md2";
	self->count = 10;
	SpawnItem (self, FindItem ("Health"));
//	gi.soundindex ("items/n_health.wav")//FREDZ only in q2
}

/*QUAKED item_health_small (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
void SP_item_health_small (edict_t *self)
{
	if ( deathmatch->value && ((int)dmflags->value & DF_NO_HEALTH) )
	{
		G_FreeEdict (self);
		return;
	}

	self->model = "models/items/healing/stimpack/tris.md2";
	self->count = 2;
	SpawnItem (self, FindItem ("Health"));
	self->style = HEALTH_IGNORE_MAX;
//	gi.soundindex ("items/s_health.wav");//FREDZ only in q2
}

/*UAKED item_health_large (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
void SP_item_health_large (edict_t *self)
{
	if ( deathmatch->value && ((int)dmflags->value & DF_NO_HEALTH) )
	{
		G_FreeEdict (self);
		return;
	}

	self->model = "models/items/healing/large/tris.md2";
	self->count = 25;
	SpawnItem (self, FindItem ("Health"));
//	gi.soundindex ("items/l_health.wav");//FREDZ only in q2
}

/*QUAKED item_health_mega (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
void SP_item_health_mega (edict_t *self)//FREDZ only in q2
{
	if ( deathmatch->value && ((int)dmflags->value & DF_NO_HEALTH) )
	{
		G_FreeEdict (self);
		return;
	}

	self->model = "models/items/mega_h/tris.md2";
	self->count = 100;
	SpawnItem (self, FindItem ("Health"));
//	gi.soundindex ("items/m_health.wav");//FREDZ only in q2
	self->style = HEALTH_IGNORE_MAX|HEALTH_TIMED;
}

// RAFAEL
void SP_item_foodcube (edict_t *self)
{
	if ( deathmatch->value && ((int)dmflags->value & DF_NO_HEALTH) )
	{
		G_FreeEdict (self);
		return;
	}

	self->model = "models/objects/trapfx/tris.md2";//FREDZ model does not exist
	SpawnItem (self, FindItem ("Health"));
	self->spawnflags |= DROPPED_ITEM;
	self->style = HEALTH_IGNORE_MAX;
//	gi.soundindex ("items/s_health.wav");//FREDZ only in q2
	self->classname = "foodcube";
}
#endif
void InitItems (void)
{
	game.num_items = sizeof(itemlist)/sizeof(itemlist[0]) - 1;
}



/*
===============
SetItemNames

Called by worldspawn
===============
*/
void SetItemNames (void)
{
	int		i;
	gitem_t	*it;

	for (i=0 ; i<game.num_items ; i++)
	{
		it = &itemlist[i];
		gi.configstring (CS_ITEMS+i, it->pickup_name);
	}
/*//Q2
	jacket_armor_index = ITEM_INDEX(FindItem("Jacket Armor"));
	combat_armor_index = ITEM_INDEX(FindItem("Combat Armor"));
	body_armor_index   = ITEM_INDEX(FindItem("Body Armor"));
	power_screen_index = ITEM_INDEX(FindItem("Power Screen"));
	power_shield_index = ITEM_INDEX(FindItem("Power Shield"));
*/
}
