#include "g_local.h"
#include "file.h"
#include <stdio.h>

#define		ADD_MOTD_LINE			3 // MH: added

void fgetline (FILE* infile, char* buffer)
{
	int		i=0;
	char	ch;

	ch = fgetc(infile);

	while ( (ch != EOF) && (ch != '\n') && (i < (MAX_STRING_LENGTH-1)) )
	{
		buffer[i++] = ch;
		ch = fgetc(infile);
	}

	if ( (ch != '\n') && (ch != EOF) )	// Keep going to the eof
		ch = fgetc(infile);

	buffer[i] = '\0';
	
	return;

}


int proccess_line(char*	buffer)
{
	// Make sure the line's not empty
	if (strlen(buffer) == 0 || buffer[0] == '\n') return COMMENT_LINE;

	// Check to see if this is a comment line
	if (buffer[0] == '/' && buffer[1] == '/')	return COMMENT_LINE;

	// Check if this is the custom map keyword
	if (strstr(buffer, ADMIN_CODE_STRING)) return ADMIN_CODE_KEYWORD;

	// Check if this is the custom map keyword
	if (strstr(buffer, CUSTOM_MAP_STRING))
		return CUSTOM_MAP_KEYWORD;

	// Check if this is the default rotation keyword
	if (strstr(buffer, DEFAULT_MAP_STRING))
		return DEFAULT_MAP_KEYWORD;

	if (strstr(buffer, DEFAULT_PASSWORD_STRING))
		return DEFAULT_PASSWORD_KEYWORD;

	if (strstr(buffer, DEFAULT_TIME_STRING))
		return DEFAULT_TIME_KEYWORD;

	if (strstr(buffer, BAN_NAME_STRING))
		return BAN_NAME_KEYWORD;

	if (strstr(buffer, BAN_IP_STRING))
		return BAN_IP_KEYWORD;

	if (strstr(buffer, DISABLE_ADMIN_STRING))
		return DISABLE_ADMIN_KEYWORD;

	if (strstr(buffer, ENABLE_PASSWORD_STRING))
		return ENABLE_PASSWORD_KEYWORD;

	if (strstr(buffer, RCONX_FILE_STRING))
		return RCONX_FILE_KEYWORD;

	if (strstr(buffer, KEEP_ADMIN_STRING))
		return KEEP_ADMIN_KEYWORD;

	if (strstr(buffer, DEFAULT_MAP_TIME_STRING))
		return DEFAULT_MAP_TIME_KEYWORD;

	// MH: map voting
	if (strstr(buffer, "allow_map_voting"))
		return ALLOW_MAP_VOTING;

	//FREDZ
	if (strstr(buffer, "realistic_weapons"))
		return REALISTIC_WEAPONS;

	return FOUND_STRING;

}

int proccess_ini_file()
{
	FILE*	infile;		// Config file to be opened
	int	status = OK;
	int	mode = -1;
	char	buffer[MAX_STRING_LENGTH];
	char	map[32], dummy[32];
	char	filename[32],dir[32];
	cvar_t	*game_dir;


	default_map[0]=0;
	default_password[0]=0;
	admincode[0]=0;
	custom_map_filename[0]=0;
	ban_name_filename[0]=0;
	ban_ip_filename[0]=0;
	rconx_file[0]=0;

	// Set number of custom/rotation maps to 0
//	game.num_rmaps = 0;
	game.num_cmaps = 0;
	disable_admin_voting = false;
	num_maps = 0;
	num_netnames = 0;
	num_ips = 0;
	enable_password = false;
	keep_admin_status = false;
	num_MOTD_lines = 0; // MH: added
	allow_map_voting = false; // MH; added

	realistic_weapons = false;//FREDZ added

	// Open config file
	game_dir = gi.cvar("game", "", 0);
	if (game_dir->string[0]==0)
		strcpy(dir, "main");
	else
		strcpy(dir, game_dir->string);

	Com_sprintf (filename, sizeof(filename), "%s"DIR_SLASH"crash.ini",dir);
	infile = fopen(filename, "r");
	if (infile == NULL)	return FILE_OPEN_ERROR;
	
	// Read first line of the file
	fgetline(infile, buffer);

	while (!feof(infile))	// while there's still stuff
	{
		// MH: read MOTD
		if (mode == ADD_MOTD_LINE)
		{
			if (buffer[0] == '/' && buffer[1] == '/')
				mode = -1;
			else
			{
				if (num_MOTD_lines < 20)
				{
					strncpy(MOTD[num_MOTD_lines], buffer, sizeof(MOTD[num_MOTD_lines]) - 1);
					num_MOTD_lines++;
				}
			}
		}
		else switch (proccess_line(buffer))	// Determine what to do with the line, based offa what's in it
		{
		case ADMIN_CODE_KEYWORD:
			sscanf(buffer, "%s %s", dummy, map);	// Quick ugly hack :)
			strncpy(admincode, map, 16);
			break;
		case COMMENT_LINE:	// do nothing
			break;
		case FOUND_STRING:	// Found a string
			// MH: check MOTD start
			if (!strncmp(buffer, "MOTD", 4))
				mode = ADD_MOTD_LINE;
//			if (mode == ADD_CUSTOM)
//				add_to_custom_maps(buffer);
			break;
		case DEFAULT_MAP_KEYWORD:
			sscanf(buffer, "%s %s", dummy, map);	// Quick ugly hack :)
			strncpy(default_map, map, 32);
			gi.dprintf("Default map:                  %s\n", default_map);
			break;
		case DEFAULT_PASSWORD_KEYWORD:
			sscanf(buffer, "%s %s", dummy, map);	// Quick ugly hack :)
			strncpy(default_password, map, 16);
			break;
		case DEFAULT_TIME_KEYWORD:
			sscanf(buffer, "%s %s", dummy, map);	// Quick ugly hack :)
			strncpy(default_timelimit, map, 16);
			gi.dprintf("Default round timelimit:      %s\n", default_timelimit);
			break;
		case DEFAULT_MAP_TIME_KEYWORD:
			sscanf(buffer, "%s %s", dummy, map);	// Quick ugly hack :)
			strncpy(default_map_timelimit, map, 16);
			gi.dprintf("Default map timelimit:        %s\n", default_map_timelimit);
			break;
		case CUSTOM_MAP_KEYWORD: // add maps to custom map list
			sscanf(buffer, "%s %s", dummy, map);	// Quick ugly hack :)
			strncpy(custom_map_filename, map, 32);
			break;
		case BAN_NAME_KEYWORD: 
			sscanf(buffer, "%s %s", dummy, map);	// Quick ugly hack :)
			strncpy(ban_name_filename, map, 32);
			break;
		case BAN_IP_KEYWORD: 
			sscanf(buffer, "%s %s", dummy, map);	// Quick ugly hack :)
			strncpy(ban_ip_filename, map, 32);
			break;
		case DISABLE_ADMIN_KEYWORD:
			disable_admin_voting = true;
			break;
		case ENABLE_PASSWORD_KEYWORD:
			enable_password = true;
			break;
		case RCONX_FILE_KEYWORD:
			sscanf(buffer, "%s %s", dummy, map);	// Quick ugly hack :)
			strncpy(rconx_file, map, 32);
			break;
		case KEEP_ADMIN_KEYWORD:
			keep_admin_status = true;
			break;
		// MH: map voting
		case ALLOW_MAP_VOTING:
			allow_map_voting = true;
			break;
		// FREDZ: realistic weapons
		case REALISTIC_WEAPONS:
			realistic_weapons = true;
			break;
		default:
			gi.dprintf("Unhandled line!\n");
		}
		fgetline(infile, buffer);		// Retrieve next line from the input file
	}

	// close the ini file
	fclose(infile);

	if (ban_name_filename[0]) {
	Com_sprintf (filename, sizeof(filename), "%s"DIR_SLASH"%s",dir, ban_name_filename);
	infile = fopen(filename, "r");
	if (infile != NULL)	
	{
	// Read first line of the file
		fgetline(infile, buffer);
		num_netnames = 0;
		while (!feof(infile))	// while there's still stuff
		{
			if (strlen(buffer) == 0 || buffer[0] == '\n')
			{
				fgetline(infile, buffer);
				continue;
			}
		// Check to see if this is a comment line
			if (buffer[0] == '/' && buffer[1] == '/')
			{
				fgetline(infile, buffer);
				continue;
			}
			strncpy(netname[num_netnames].value,buffer,16);
			fgetline(infile, buffer);
			num_netnames++;
			if (num_netnames==100) break;
		}
		fclose(infile);
	}
	}

	if (ban_ip_filename[0]) {
	Com_sprintf (filename, sizeof(filename), "%s"DIR_SLASH"%s",dir, ban_ip_filename);
	infile = fopen(filename, "r");
	if (infile != NULL)	
	{
	// Read first line of the file
		fgetline(infile, buffer);
		num_ips = 0;
		while (!feof(infile))	// while there's still stuff
		{
			if (strlen(buffer) == 0 || buffer[0] == '\n')
			{
				fgetline(infile, buffer);
				continue;
			}
		// Check to see if this is a comment line
			if (buffer[0] == '/' && buffer[1] == '/')
			{
				fgetline(infile, buffer);
				continue;
			}
			strncpy(ip[num_ips].value,buffer,16);
			fgetline(infile, buffer);
			num_ips++;
			if (num_ips==100) break;
		}
		fclose(infile);
	}
	}

	if (rconx_file[0]) {
	Com_sprintf (filename, sizeof(filename), "%s"DIR_SLASH"%s",dir, rconx_file);
	infile = fopen(filename, "r");
	if (infile != NULL)	
	{
	// Read first line of the file
		fgetline(infile, buffer);
		num_rconx_pass = 0;
		while (!feof(infile))	// while there's still stuff
		{
			if (strlen(buffer) == 0 || buffer[0] == '\n')
			{
				fgetline(infile, buffer);
				continue;
			}
		// Check to see if this is a comment line
			if (buffer[0] == '/' && buffer[1] == '/')
			{
				fgetline(infile, buffer);
				continue;
			}
			strncpy(rconx_pass[num_rconx_pass].value,buffer,32);
			fgetline(infile, buffer);
			num_rconx_pass++;
			if (num_rconx_pass==100) break;
		}
		fclose(infile);
	}
	}

	return OK;
}

int read_map_file()
{

	FILE*	infile;		// Config file to be opened
	char	buffer[MAX_STRING_LENGTH];
	char	map[32], rank[32]; // MH:
	char	filename[32], dir[32];
	cvar_t	*game_dir;
	int		c; // MH:

	game_dir = gi.cvar("game", "", 0);
	if (game_dir->string[0]==0)
		strcpy(dir, "main");
	else
		strcpy(dir, game_dir->string);

	if (custom_map_filename[0]) {
	Com_sprintf (filename, sizeof(filename), "%s"DIR_SLASH"%s",dir, custom_map_filename);
	infile = fopen(filename, "r");
	if (infile == NULL)	return FILE_OPEN_ERROR;

	num_maps = 0;

	// Read first line of the file
	fgetline(infile, buffer);
	while (!feof(infile))	// while there's still stuff
	{
		if (strlen(buffer) == 0 || buffer[0] == '\n')
		{
			fgetline(infile, buffer);
			continue;
		}
	// Check to see if this is a comment line
		if (buffer[0] == '/' && buffer[1] == '/')
		{
			fgetline(infile, buffer);
			continue;
		}

		// MH: support lists with or without rank (which isn't used)
		c = sscanf(buffer, "%s %s", rank, map);
		if (c == 2 && rank[0]>='1' && rank[0]<='9')
		{
			strncpy(maplist[num_maps], map, sizeof(maplist[num_maps]) - 1);
			num_maps++;
		}
		else if (c)
		{
			strncpy(maplist[num_maps], rank, sizeof(maplist[num_maps]) - 1);
			num_maps++;
		}
		fgetline(infile, buffer);
	}

	fclose(infile); // MH: leak fix
	}

	return OK;
}
/*
void add_to_custom_maps(char*	buffer)
{
	strncpy(custom_list[game.num_cmaps].custom_map, buffer, 16);
	game.num_cmaps++;
}*/

// Test functions

/*
int write_map_file()
{

	FILE*	outfile;
	char	temp[32],dir[32];
	int		i;

	cvar_t	*game_dir;
	game_dir = gi.cvar("game", "", 0);
	if (game_dir->string[0]==0)
		strcpy(dir, "main");
	else
		strcpy(dir, game_dir->string);

	if (custom_map_filename[0]) {
	Com_sprintf (temp, sizeof(temp), "%s"DIR_SLASH"%s",dir,custom_map_filename);
	outfile = fopen(temp, "w+");
	if (outfile == NULL)	return FILE_OPEN_ERROR;

	for (i=0; i< num_custom_maps; i++)	
		fprintf(outfile, "%d %s\n",custom_list[i].rank, custom_list[i].custom_map);

	fprintf(outfile, "\n");

	fclose(outfile);
	}

	return OK;
}
*/
// MH: check file existence
#ifdef _WIN32
#include <io.h>
#define access(a,b) _access(a,b)
#else
#include <unistd.h>
#endif

int CheckFileExists(char *file)
{
	char	buf[MAX_QPATH];
	cvar_t	*game_dir = gi.cvar("game", "", 0);
	if (game_dir->string[0])
	{
		Com_sprintf(buf, sizeof(buf), "%s/%s", game_dir->string, file);
		if (!access(buf, 4))
			return true;
	}
	Com_sprintf(buf, sizeof(buf), "main/%s", file);
	if (!access(buf, 4))
		return true;
	// assume kpdm1-5 and team_pv/rc/sr are available if pak0.pak exists
	if (!Q_stricmp(file, "maps/kpdm1.bsp") || !Q_stricmp(file, "maps/kpdm2.bsp") || !Q_stricmp(file, "maps/kpdm3.bsp") || !Q_stricmp(file, "maps/kpdm4.bsp") || !Q_stricmp(file, "maps/kpdm5.bsp")
		|| !Q_stricmp(file, "maps/team_pv.bsp") || !Q_stricmp(file, "maps/teamp_rc.bsp") || !Q_stricmp(file, "maps/team_sr.bsp"))
		return !access("main/pak0.pak", 4);
	return false;
}
