#include "g_local.h"

int	 vote_set[9];        // stores votes for next map
char admincode[16];		 // the admincode
char default_map[32];    // default settings
char default_password[16];
char default_timelimit[16];
char default_map_timelimit[16];
char custom_map_filename[32];  // stores where various files can be found
char ban_name_filename[32];
char ban_ip_filename[32];
int disable_admin_voting;
int total_rank;          // used in calculating maps picks based on weight
int num_custom_maps;
int num_netnames;
int num_ips;
int enable_password;
char rconx_file[32];
int num_rconx_pass;
int keep_admin_status;

// MH: Message of the Day
char	MOTD[20][80];
int		num_MOTD_lines;

ban_t	netname[100];
ban_t	ip[100];
ban_t	rconx_pass[100];

//****************************************************
// Snap - this file contains changes to the code
//        teamplay is the only mode supported in this code. no FFA mode.
//****************************************************
//==============================================================
//
// Papa - This file contains all the functions that control the 
//        modes a server may be in.
//
//===============================================================

void RestartGame (){
	edict_t	*doot;
	int i;

	gi.bprintf (PRINT_HIGH, "Restarting Game.\n");
	for_each_player (doot,i){
		doot->client->pers.bagcash = 0;
		doot->client->pers.currentcash = 0;
		doot->client->resp.score = 0;
		doot->client->resp.deposited = 0;
	}
	level.roundnum = 1;
	team_cash[1] = 0;
	team_cash[2] = 0;
	UPDATESCORE
	MatchEnd();
}


void ResetServer () // completely resets the server including map
{
	char command[64];

	gi.bprintf (PRINT_HIGH, "Resetting server.\n\n");

	gi.cvar_set("password",default_password);
	gi.cvar_set("timelimit",default_timelimit);
	gi.cvar_set("map_timelimit",default_map_timelimit);
	gi.cvar_set("teamplay","4");
	gi.cvar_set("cheats","0");

	Com_sprintf (command, sizeof(command), "map \"%s\"\n", default_map);

	gi.AddCommandString (command);
}



void MatchStart()  // start the match
{

	// snap - pick according to map VIP/BOMB
	if(level.crash_gametype == VIP_MAP)
		Assign_VIP();
	else if(level.crash_gametype == BOMB_MAP)
		Assign_BOMBHOLDER();
	// remove any dropped weapons/items from the map
	if(level.num_ent_free > 0)
		free_dropped_ents();
		
	level.modeset = FINALCOUNT;
	level.startframe = level.framenum;


}


void SpawnPlayers ()  // Same idea but 1 player per team
{
	edict_t		*self;
	int			i;
	int			team1,team2;

	team1 = false;
	team2 = false;

	for_each_player (self,i)
	{
		if (self->inuse && (!team1 || !team2) )
		{

		if ((self->client->pers.team == 1) && (!team1) && (!self->client->resp.is_spawn))
		{

			self->playing_ingame = TRUE;
			ClientBeginDeathmatch( self );

			self->client->resp.is_spawn = true;
			team1 = true;

		}
		if ((self->client->pers.team == 2) && (!team2) && (!self->client->resp.is_spawn))
		{

			self->playing_ingame = TRUE;
			ClientBeginDeathmatch( self );	

			self->client->resp.is_spawn = true;
			team2 = true;

		}

		}
	}

	if ((!team1) && (!team2))
		level.is_spawn = true;
}

void Start_Match () // Starts the match
{
	edict_t		*self;
	int			i;

	level.startframe = level.framenum;
	level.modeset = STARTINGMATCH;
	level.is_spawn = false;
	for_each_player(self,i)
	{
		if(self->crashType == CRASH_NORMAL)
			gi.centerprintf(self,"round %d has started!", level.roundnum); // MH: removed newline
		self->client->resp.is_spawn = false;
		self->client->resp.enterframe = level.framenum;
		// MH: clear round result message from screen
		if (self->client->showscores >= SCORE_ROUNDEND)
			self->client->showscores = NO_SCOREBOARD;
	}
	gi.dprintf ("Round %d Has Started\n", level.roundnum); // MH: players already got the message, so changed bprintf to dprintf for server log only

}


void MatchEnd () // end of the match
{

	level.modeset = PUBLICROUNDSETUP;
	level.startframe = level.framenum;

}

void CheckAllPlayersSpawned () // when starting a match this function is called until all the players are in the game
{
	int		i;
	edict_t	*doot;
	int     team1=0;
	int		team2=0;

	SpawnPlayers ();

	if ((level.is_spawn) && (level.modeset == STARTINGMATCH)){
		// snap - moved these from matchstart(), was causing problem methinks
		level.roundover = FALSE;
		level.defused = FALSE;
		level.matchend_msg = FALSE;
		level.bomb_activated = FALSE;
		// snap, new breakable prop respawning code
		if(level.num_ent_respawn > 0){
			respawn_breakables();
		}

		for_each_player (doot,i)
		{
			if(doot->client->pers.team == 1 && doot->playing_ingame == TRUE)
				team1++;
			else if(doot->client->pers.team == 2 && doot->playing_ingame == TRUE)
				team2++;
		}

		if(team1 > 0 && team2 > 0)
			level.modeset = MATCH;
		else{
			level.modeset = PRE_MATCH;
			gi.bprintf (PRINT_HIGH, "PREMATCH mode, game will start when each team has at least 1 player.\n");
		}
	}
		
}

void CheckIdlePublicSetup () // snap, changed this function
{
	// HACK - FIXME
	if(level.roundnum == 0)
		level.roundnum++;

	MatchStart();

}


void CheckStartMatch () 
{
	Start_Match ();
}

// snap, new function, called when server is in PRE_MATCH state
void CheckRestartRound ()
{
	int			k;
	edict_t		*doot;
	int			team1ready = FALSE;
	int			team2ready = FALSE;
	int         dragons_numplayers_alive = 0;
	int         nikkis_numplayers_alive = 0;
	int         dragons_numplayers_dead = 0;
	int         nikkis_numplayers_dead = 0;
	int			clients=0;

	// if server settings are not defaults and empty after 50secs, reset it.
	if ( (strcmp(password->string, default_password) != 0) ||
		(strcmp(map_timelimit->string, default_map_timelimit) != 0) ||
		(strcmp(timelimit->string, default_timelimit) != 0)
		|| level.framenum > 0x100000) // MH: reset if map started a long time ago, before counters overflow
	{
		if(level.framenum > level.startframe + 500){
			for_each_player (doot,k){
				clients++;
			}
			if(clients == 0){
				ResetServer();
				return;
			}
		}
	}	

	// if client triggers a win or loss, then start round over, don't give them a win though
	// 1 second delay before next round start on ROUND_RESTART
	// OR 7 sec delay on any other round start type
	if(level.roundover){
		if(!level.matchend_msg){
			gi.bprintf (PRINT_HIGH, "Restarting Round.\n");
			for_each_player (doot,k){
				doot->client->showscores = SCORE_R_RESTART;
				DeathmatchScoreboard (doot);
			}
			level.matchend_msg = TRUE;
		}
		if(level.framenum > level.round_end_frame + 60)
			MatchEnd();	
		return;
	}

	for_each_player (doot,k)
	{
		if(doot->client->pers.team == 1){
			team1ready = TRUE;
			if(doot->playing_ingame == TRUE)
				dragons_numplayers_alive++;
			else
				dragons_numplayers_dead++;
		}
		else if(doot->client->pers.team == 2){
			team2ready = TRUE;
			if(doot->playing_ingame == TRUE)
				nikkis_numplayers_alive++;
			else
				nikkis_numplayers_dead++;
		}

	}
	// check for at least 1 player on each team, if so, then restart round
	// or, a team has all dead players
	if( (team1ready && team2ready) || (!dragons_numplayers_alive && dragons_numplayers_dead)
		|| (!nikkis_numplayers_alive && nikkis_numplayers_dead) ){
		level.round_end_frame = level.framenum;
		level.roundover = TRUE;
		level.roundover_type = ROUND_RESTART;
		return;
	}

}


void matchend_msg ()
{
	int			i;
	edict_t		*doot;

	switch(level.roundover_type)
	{
		case BOMB_DEFUSED:
			gi.bprintf (PRINT_HIGH, "Bomb Successfully Defused!\nCrash Squad Wins Round %d!\n", level.roundnum);
			team_cash[1]++;
			UPDATESCORE
			break;
		case VIP_ESCAPED:
			gi.bprintf (PRINT_HIGH, "VIP Escaped!\nCrash Squad Wins Round %d!\n", level.roundnum);
			team_cash[1]++;
			UPDATESCORE
			break;
		case VIP_LEFT:
			gi.bprintf (PRINT_HIGH, "VIP Left The Game!\nRound %d is a Tie!\n", level.roundnum);
			break;
		case TARGET_BOMBED:
			gi.bprintf (PRINT_HIGH, "Target Successfully Bombed!\nCrenshaw Mafia Wins Round %d!\n", level.roundnum);
			team_cash[2]++;
			UPDATESCORE
			break;
		case VIP_KILLED:
			gi.bprintf (PRINT_HIGH, "VIP Was Killed!\nCrenshaw Mafia Wins Round %d!\n", level.roundnum);
			team_cash[2]++;
			UPDATESCORE
			break;
		case TIMELIMIT_HIT:
			gi.bprintf (PRINT_HIGH, "Timelimit hit.\n");
			if(level.crash_gametype == VIP_MAP){
				gi.bprintf (PRINT_HIGH, "VIP Did Not Escape!\nCrenshaw Mafia Wins Round %d!\n", level.roundnum);
				team_cash[2]++;
				UPDATESCORE
			}
			else if(level.crash_gametype == BOMB_MAP){
				gi.bprintf (PRINT_HIGH, "Target Not Successfully Bombed!\nCrash Squad Wins Round %d!\n", level.roundnum);
				team_cash[1]++;
				UPDATESCORE
			}
			break;
		case TEAM_1_DEAD:
			gi.bprintf (PRINT_HIGH, "Crenshaw Mafia Destroyed The Squad!\nCrenshaw Mafia Wins Round %d!\n", level.roundnum);
			team_cash[2]++;
			UPDATESCORE
			break;
		case TEAM_2_DEAD:
			gi.bprintf (PRINT_HIGH, "Crash Squad Eliminated The Mafia!\nCrash Squad Wins Round %d!\n", level.roundnum);
			team_cash[1]++;
			UPDATESCORE
			break;
		case BOTH_TEAMS_DEAD:
			gi.bprintf (PRINT_HIGH, "The Last Player On Both Teams Died!\nThere is a Tie!\n");
			break;
		default:
			break;
	}

	for_each_player (doot,i){
		doot->client->showscores = SCORE_ROUNDEND;
		DeathmatchScoreboard (doot);
	}

}
//snap, changed this function
void CheckEndMatch () // check if time,frag,cash limits have been reached in a match
{
	int			k,l;
	int			total_players_inserver = 0;
	edict_t		*doot;
	int         dragons_numplayers_alive = 0;
	int         nikkis_numplayers_alive = 0;

	// MH: start map timer
	if (!level.map_startframe)
		level.map_startframe = level.framenum;

	if(level.roundover){
		if(!level.matchend_msg){
			matchend_msg();
			level.matchend_msg = TRUE;
		}
		if(level.framenum > level.round_end_frame + 60){
			level.roundnum++;
			MatchEnd();
		}
		return;
	}

	if(level.framenum == level.startframe+20){
		for_each_player (doot,l)
		{
			if(doot->playing_ingame == TRUE){
				gi.cprintf(doot, PRINT_CHAT, "RADIO: Let's go\n");
				gi.WriteByte( svc_stufftext );
				if (doot->client->pers.team == 1)				
					gi.WriteString( va("play radio_crash/letsgo.wav") );
				else
					gi.WriteString( va("play radio_gang/letsgo.wav") );
				gi.unicast (doot, true);	
			}
		}
	}

	for_each_player (doot,k)
	{
		if(doot->playing_ingame == TRUE)
		{
			switch(doot->client->pers.team)
			{
				case 1:
					dragons_numplayers_alive++;
					break;
				case 2:
					nikkis_numplayers_alive++;
					break;
				default:
					break;
			}
		}
		total_players_inserver++;
	}

	if(!dragons_numplayers_alive && nikkis_numplayers_alive)
	{
		level.round_end_frame = level.framenum;
		level.roundover = TRUE;
		level.roundover_type = TEAM_1_DEAD;
		return;
	}
	else if(!dragons_numplayers_alive && !nikkis_numplayers_alive)
	{
		level.round_end_frame = level.framenum;
		level.roundover = TRUE;
		level.roundover_type = BOTH_TEAMS_DEAD;
		return;
	}
	else if(level.bomb_activated){
		return;
	}
	else if(dragons_numplayers_alive && !nikkis_numplayers_alive)
	{
		level.round_end_frame = level.framenum;
		level.roundover = TRUE;
		level.roundover_type = TEAM_2_DEAD;
		return;
	}
	else if(level.framenum > (level.startframe + ((int)timelimit->value) * 600 - 1))
	{
		level.round_end_frame = level.framenum;
		level.roundover = TRUE;
		level.roundover_type = TIMELIMIT_HIT;
		return;
	}

}

void CheckVote() // check the timelimit for an admin or map vote
{
	
	if (level.framenum >= (level.voteframe + 900)) // MH: reduced from 1200
	{
		switch (level.voteset)
		{
			case VOTE_ON_ADMIN:
				gi.bprintf(PRINT_HIGH, "The request for admin has failed\n");
				break;
			// MH: map vote
			case VOTE_ON_MAP:
				gi.bprintf(PRINT_HIGH, "The request for a map change has failed\n");
				break;
		}
		level.voteset = NO_VOTES;
	}
}

int	CheckNameBan (char *name)
{
	char n[64];
	int i;

	strcpy(n,name);
	for (i=0;i<strlen(n);i++) n[i]=tolower(n[i]);
	for (i=0;i<num_netnames;i++) {
		if (strstr(n,netname[i].value))
			return true;
	}
	return false;
}

int	CheckPlayerBan (char *userinfo)
{
	char	*value;
	int		i,j;
	int		isSame;

	value = Info_ValueForKey (userinfo, "name");
	if (CheckNameBan(value))
		return true;

	value = Info_ValueForKey (userinfo, "ip");
	for (i=0;i<num_ips;i++) {
		isSame = true;
		j = 0;
		while ((isSame) && (value[j] != '\0') && (value[j] != ':'))
		{		
			if (ip[i].value[j] != value[j])
				isSame = false;
			j++;
		}
		if (isSame)
			return true;
	}

	return false;
}

