

#include "g_local.h"


/**************************************************************************

  EXTREME KINGPIN STARTED - 25/06/00

	25/06/00	Added standard MOTD and scoreboard enhancements. Pistol
				upgraded and added a tracer (bugged)

	26/06/00	Tracer now debugged and working. Shotgun upgraded as well
				as Tommy gun.

***************************************************************************/

void ex_LoadMOTD( void );

#define MOTD_lines		3

typedef struct   // Message of the Day
	{
	char textline[100];
	} MOTD_t;

	MOTD_t	MOTD[20];

//***********************************************************************
//	Check to see if this player is a cheating bastard and it they are
//	then let everyone know.

void CheckForCheating(edict_t* ent)
	{
	if (!ent->client)
		return;		// not fully in game yet

  	if (!ent->inuse)
    	return;

	// After 15 seconds recheck cheat, this is so we don't overflow.
	if (ent->client->Ex_timescaletimer < level.time)
		{
		// Retrieve the timescale
		gi.WriteByte(13);
		gi.WriteString("clienttimescale $timescale\n");
		gi.unicast(ent,true);

		// Reset time to next check for cheating.
		ent->client->Ex_timescaletimer = level.time + (1.0 * 15);
		}
	}

//***************************************************************************
//
//	Load the server changeable part of the MOTD into an array for use later.
//	

void ex_LoadMOTD( void )
	{

	FILE	*motd_file;
	char	line[80];
	int		i;

	// Open the motd file
	if (motd_file = fopen("extreme/motd.txt", "r"))
		{
		i = 0;

		// Read the lines now
		while ( fgets(line, 80, motd_file) )
			{
			// Once we've read a line copy it to the MOTD array.
			strcpy(MOTD[i].textline, line);
			i++;

			// We don't want more than 3 lines so lets piss off.
			if (i>3)
				break;
			}

		// be good now ! ... close the file
		fclose(motd_file);
		}
	}


//**********************************************************************
//
//	Function:	Displays a superb message of the day 
//
void MOTDScoreboardMessage (edict_t *ent)
	{
	char	entry[1024];
	char	string[1400];
	int		stringlength;
	int		i, j;
	int		yofs;
	char	*seperator = "++++++++++++++++++++++++++++++++";

	char	*selectheader[] =
			{
			"Atrophy Presents",
			"EXTREME Kingpin v1.1",
			"by Rat Instinct",
			"www.Atrophy.co.uk",
			NULL
			};


	string[0] = 0;
	stringlength = 0;

	yofs = 80 - MOTD_lines * 10;
	if (yofs < 0 )
		yofs = 0;

	for (i=0; selectheader[i]; i++)
		{
		Com_sprintf (entry, sizeof(entry),
			"xm %i yv %i dmstr 752 \"%s\" ",
			-5*strlen(selectheader[i]), yofs + (int)(-60.0+-3.5*14), selectheader[i] );

		j = strlen(entry);
		strcpy (string + stringlength, entry);
		stringlength += j;

		yofs += 20;
		}

	yofs += 10;
	Com_sprintf (entry, sizeof(entry),
		"xm %i yv %i dmstr 772 \"%s\" ",
		-5*strlen(seperator), yofs + (int)(-60.0+-3.5*14), seperator );

	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;

	yofs += 30;

	for (i=0; i< MOTD_lines; i++)
		{
		Com_sprintf (entry, sizeof(entry),
			"xm %i yv %i dmstr 842 \"%s\" ",
			-5*strlen(MOTD[i].textline), yofs + (int)(-60.0+-3.5*14), MOTD[i].textline );

		j = strlen(entry);
		if (stringlength + j < 1024)
			{
			strcpy (string + stringlength, entry);
			stringlength += j;
			}

		yofs += 20;
		}

	Com_sprintf (entry, sizeof(entry),
		"xm %i yv %i dmstr 772 \"%s\" ",
		-5*strlen(seperator), yofs + (int)(-60.0+-3.5*14), seperator );

	j = strlen(entry);

	if (stringlength + j < 1024)
		{
		strcpy (string + stringlength, entry);
		stringlength += j;
		}

	gi.WriteByte (svc_layout);
	gi.WriteString (string);

	}


/////////////////////////////////////////////////////////////////////////////////


