#include "g_local.h"
#if compileJACKBOT



	/****************************************************************

		Best type of node to use according to self's environment

	****************************************************************/
	nodeType_t *edit_BestNodeType(edict_t *self, qboolean allowAirfall)
		{
		vec3_t	v;

		// WATER //
		if (self->waterlevel > 1)
			return getNodeTypeByValue(nWater);

		// LADDER //
		if (onLadder(self))
			return getNodeTypeByValue(nLadder);

		// AIRFALL //
		if (!self->groundentity)
			{
			if (allowAirfall == true)
				return getNodeTypeByValue(nAirFall);
			return NULL;
			}

		// MOVING PLATFORM //
		if (self->groundentity->use == Use_Plat)
			return NULL;

		// LAVA/ACID //
		v[0]  = self->s.origin[0];
		v[1]  = self->s.origin[1];
		v[2]  = self->s.origin[2] - 18;
		if (gi.pointcontents(v) & (CONTENTS_LAVA | CONTENTS_SLIME))
			return NULL;

		// ANYTHING ELSE //
		return getNodeTypeByValue(nMove);
		}



	/****************************************************************

		Create a trail of nodes

	****************************************************************/
	void edit_AutoNodeTrail(edict_t *self)
		{
		static float		last_update = 0;
		short int				closest_node;
		nodeType_t			*nt;

		// Wait between updates
		if (level.time < last_update)
			return;
		last_update = level.time + 0.15;
	
		// Get best node type
		nt = edit_BestNodeType(self, false);
		if (!nt)
			return;

		// Spawn node
		closest_node = botMisc_FindClosestNode(self->s.origin, BOTNODE_DIST_MIN, nt->value); // Approximation is good enough
		if (closest_node == BOTNODE_INVALID)
			{
			closest_node = edit_RegisterNode(self, nt, NULL);
			if (bot_nodesound->value)
				gi.sound(self, CHAN_AUTO, gi.soundindex("world/switches/pushbutton.wav"), 1, ATTN_NORM, 0);
			}
		}



	/****************************************************************

		Remove node index from Roadbook

	****************************************************************/
	void removeFromRoadbook(int nodeIndex)
		{
		int i, j;

		// CRUSH //
		if (nodeIndex < (jb_NumNodes - 1))
			{
			for (i = nodeIndex; i < jb_NumNodes - 1; i++)
				{
				for (j = 0; j < jb_NumNodes; j++)
					jb_PathTable[i][j] = jb_PathTable[i + 1][j];
				}
			for (i = 0; i < jb_NumNodes; i++)
				{
				for (j = nodeIndex; j < jb_NumNodes - 1; j++)
					jb_PathTable[i][j] = jb_PathTable[i][j + 1];
				}
			}

		// SHIFT INDICES //
		for (i = 0; i < jb_NumNodes; i++)
			{
			for (j = 0; j < jb_NumNodes; j++)
				{
				if (jb_PathTable[i][j] == nodeIndex)
					jb_PathTable[i][j] = BOTNODE_INVALID;
				else if (jb_PathTable[i][j] > nodeIndex)
					jb_PathTable[i][j]--;
				}
			}
		}



	/****************************************************************

		Remove node index from Item List

	****************************************************************/
	void removeFromItemList(int nodeIndex)
		{
		int i, j;

		// CRUSH //
		if (jb_Node[nodeIndex].type->linksEntity)
			{
			for (i = 0; i < jb_NumItems; i++)
				{
				if (jb_ItemTable[i].node != nodeIndex)
					continue;
				if (i < (jb_NumItems - 1))
					{
					for (j = i; j < jb_NumItems; j++)
						jb_ItemTable[j] = jb_ItemTable[j + 1];
					}
				jb_NumItems--;
				break;
				}
			}

		// SHIFT INDICES //
		for (i = 0; i < jb_NumItems; i++)
			{
			if (jb_ItemTable[i].node > nodeIndex)
				jb_ItemTable[i].node--;
			}
		}


	
	/****************************************************************

		Remove node index from duck or jump

	****************************************************************/
	void removeFromMoveList(int nodeIndex, nodePair_t *list, int *count)
		{
		int i, j, k;

		if (!(*count))
			return;

		// CRUSH //
		for (i = 0; i < (*count); i++)
			{
			k = (*count) - 1 - i;
			if ((list[k].from != nodeIndex) && (list[k].to != nodeIndex))
				continue;
			if (k != ((*count) - 1))
				{
				for (j = k; j < (*count); j++)
					{
					list[j].from = list[j + 1].from;
					list[j].to   = list[j + 1].to;
					}
				}
				(*count)--;
			}
			
		// SHIFT INDICES //
		if (*count)
			{
			for (i = 0; i < (*count); i++)
				{
				if (list[i].from > nodeIndex)
					list[i].from--;
				if (list[i].to > nodeIndex)
					list[i].to--;
				}
			}
		}
		


	/****************************************************************

		Remove node index from user links

	****************************************************************/
	void removeFromUserLink(int nodeIndex)
		{
		int i, j, k;

		if (!jb_NumLinks)
			return;

		// CRUSH //
		for (i = 0; i < jb_NumLinks; i++)
			{
			k = jb_NumLinks - 1 - i;
			if ((jb_LinkTable[k].from != nodeIndex) && (jb_LinkTable[k].to != nodeIndex))
				continue;
			if (k != (jb_NumLinks - 1))
				{
				for (j = k; j < jb_NumLinks; j++)
					{
					jb_LinkTable[j].from    = jb_LinkTable[j + 1].from;
					jb_LinkTable[j].to		  = jb_LinkTable[j + 1].to;
					jb_LinkTable[j].vehicle = jb_LinkTable[j + 1].vehicle;
					}
				}
				jb_NumLinks--;
			}
			
		// SHIFT INDICES //
		if (jb_NumLinks)
			{
			for (i = 0; i < (jb_NumLinks); i++)
				{
				if (jb_LinkTable[i].from > nodeIndex)
					jb_LinkTable[i].from--;
				if (jb_LinkTable[i].to > nodeIndex)
					jb_LinkTable[i].to--;
				}
			}
		}


	/****************************************************************
	
		Remove nodes and associted dummies

	****************************************************************/
	void edit_NodeRemove(int nodeIndex)
		{
		int			i;
		edict_t	*entity, *entDelete = NULL;

		if ((nodeIndex < 0) || (nodeIndex >= jb_NumNodes))
			{
			gi.dprintf("Couldn't remove node[%i]: out of boundaries\n", nodeIndex);
			return;
			}

		// REMOVE FROM VARIOUS LISTS //
		removeFromRoadbook(nodeIndex);
		removeFromItemList(nodeIndex);
		removeFromMoveList(nodeIndex, jb_JumpTable, &jb_NumJumps);
		removeFromMoveList(nodeIndex, jb_DuckTable, &jb_NumDucks);
		removeFromUserLink(nodeIndex);
		
		// CRUSH NODE LIST //
		if (nodeIndex < (jb_NumNodes - 1))
			{
			for (i = nodeIndex; i < jb_NumNodes - 1; i++)
					jb_Node[i] = jb_Node[i + 1];
			}
		jb_NumNodes--;

		// UPDATE DUMMY NODES //
		for (entity = g_edicts; entity < &g_edicts[globals.num_edicts]; entity++)
			{
			if (!entity)
				continue;
			if ((!entity->inuse) || (Q_stricmp(entity->classname, "info_node_display")))
				continue;
			if (entity->count == nodeIndex)
				entDelete = entity;
			else if (entity->count > nodeIndex)
				entity->count --;
			}
		if (!entDelete)
			return;
		gi.unlinkentity(entDelete);
		G_FreeEdict(entDelete);
		}



	/*******************************************************************

		ROUTE EDIT MODE -- Shows first-degree connections of the closest
		node, how those links must be traveled and provide the index of
		the connected nodes.

	*******************************************************************/
	void edit_ShowNearbyLinks(edict_t *ent)
		{
		int						src, lnk, j, mode;
		vec3_t				halfway, tail;
		static int		lastSrc = BOTNODE_INVALID;
		static float	last_update = 0;

		// Not enough nodes
		if (jb_NumNodes < 2)
			return;

		// Wait a little longer
		if (level.time < last_update)
			return;
		last_update = level.time + 0.10;

		// Find closest node
		src = botMisc_FindClosestNode(ent->s.origin, BOTNODE_DIST_MIN, nAll); // Approximation is good enough
		if (src == BOTNODE_INVALID)
			return;

		// Show links
		for (lnk = 0; lnk < jb_NumNodes; lnk++)
			{
			if (jb_PathTable[src][lnk] != lnk)
				continue;
			mode = VEHICLE_NONE;
			#if 0
			trace_Climb(ent, jb_Node[src].origin, jb_Node[lnk].origin, true);
			#else
			for (j = 0; j < jb_NumJumps; j++)
				{
				if ((jb_JumpTable[j].from != src) || (jb_JumpTable[j].to != lnk))
					continue;
				VectorMiddle(jb_Node[src].origin, jb_Node[lnk].origin, halfway);
				VectorSet(tail, halfway[0], halfway[1], halfway[2] + 12);
				showTrace(halfway, tail);
				break;
				}
			for (j = 0; j < jb_NumDucks; j++)
				{
				if ((jb_DuckTable[j].from != src) || (jb_DuckTable[j].to != lnk))
					continue;
				VectorMiddle(jb_Node[src].origin, jb_Node[lnk].origin, halfway);
				VectorSet(tail, halfway[0], halfway[1], halfway[2] - 12);
				showTrace(halfway, tail);
				break;
				}
			showTrace(jb_Node[src].origin, jb_Node[lnk].origin);
			#endif
			}

		// Output connections
		if (lastSrc == src)
			return;
		
		gi.dprintf("Node[%i] %s at %s", src, jb_Node[src].type->name, vtos(jb_Node[src].origin));
		if (jb_Node[src].type->linksEntity)
			{
			qboolean f = false;
			for (j = 0; j < jb_NumItems; j++)
				{
				if (jb_ItemTable[j].node != src)
					continue;
				f = true;
				if (!jb_ItemTable[j].ent)
					gi.dprintf(" ** UNLIKED **");
				else
					gi.dprintf(" linked to %s", jb_ItemTable[j].ent->classname);
				break;
				}
			if (f == false)
				gi.dprintf(" ** UNREGISTERED **");
			}
		gi.dprintf("\n");

		lastSrc = src;
		}

	int edit_LinkGetIndex(int start, int stop)
		{
		int i;

		// Return link index
		if (jb_NumLinks)
			{
			for (i = 0; i < jb_NumLinks; i++)
				{
				if ((jb_LinkTable[i].from == start) && (jb_LinkTable[i].to == stop))
					return i;
				}
			}

		// No link found
		return -1;
		}

	void edit_LinkForce(int start, int stop, char *vehicle)
		{
		int way = VEHICLE_WALK;
		int ind;

		// Get proper moving way
		if (!Q_stricmp(vehicle, "jump"))
			way = VEHICLE_JUMP;
		else if (!Q_stricmp(vehicle, "crouch"))
			way = VEHICLE_CROUCH;

		// Cannot be the same
		if (stop == start)
			{ gi.dprintf("Node cannot be linked to itself\n"); return; }

		// Check start node
		if (!ValidNode(start))
			{ gi.dprintf("Invalid starting node\n"); return; }

		// Check end node
		if (!ValidNode(stop))
			{ gi.dprintf("Invalid ending node\n"); return; }

		// Create/update link
		ind = edit_LinkGetIndex(start, stop);
		if (ind == -1)
			{
			jb_LinkTable[jb_NumLinks].from		= start;
			jb_LinkTable[jb_NumLinks].to			= stop;
			jb_LinkTable[jb_NumLinks].vehicle = way;
			gi.dprintf("Created custom link[%i]\n", jb_NumLinks);
			jb_NumLinks ++;
			}
		else
			{
			jb_LinkTable[ind].vehicle = way;
			gi.dprintf("Updated custom link[%i]\n", ind);
			}
		}

	/****************************************************************

		Add a point to the area (either start the node area, or fill
		it with nodes)

	****************************************************************/
	void edit_AreaPoint(edict_t *self)
		{
		vec3_t	delta, s, v;
		double	countX, countY;
		double	frac, inte;
		int			i, j;

		// BEGIN DRAWING //
		if (!(jb_Debug & BOTDEBUG_NODEAREA))
			{
			jb_Debug |= BOTDEBUG_NODEAREA;
			VectorCopy(self->s.origin, jb_NodeArea1);
			return;
			}

		// START POINT //
		jb_Debug &= ~BOTDEBUG_NODEAREA;
		VectorCopy(self->s.origin, jb_NodeArea2);
		if (jb_NodeArea1[0] < jb_NodeArea2[0])
			s[0] = jb_NodeArea1[0];
		else
			s[0] = jb_NodeArea2[0];
		if (jb_NodeArea1[1] < jb_NodeArea2[1])
			s[1] = jb_NodeArea1[1];
		else
			s[1] = jb_NodeArea2[1];
		if (jb_NodeArea1[2] > jb_NodeArea2[2]) // pick highest, we'll drop nodes to floor level
			s[2] = jb_NodeArea1[2];
		else
			s[2] = jb_NodeArea2[2];
		
		// AREA SIZE //
		delta[0] = abs(jb_NodeArea1[0] - jb_NodeArea2[0]);
		delta[1] = abs(jb_NodeArea1[1] - jb_NodeArea2[1]);
		delta[2] = abs(jb_NodeArea1[2] - jb_NodeArea2[2]);

		// ROWS //
		countX = (delta[0] / (float)BOTNODE_DIST_MIN);
		frac = modf(countX, &inte);
		countX = inte;
		if (frac >= 0.4)
			countX ++;
		if (!countX)
			return;

		// COLUMNS //
		countY = (delta[1] / (float)BOTNODE_DIST_MIN);
		frac = modf(countY, &inte);
		countY = inte;
		if (frac >= 0.4)
			countY ++;
		if (!countY)
			return;

		// FILL //
		for (i = 0; i <= (int)countX; i++)
			{
			for (j = 0; j <= (int)countY; j++)
				{
				v[0] = s[0] + ((delta[0] / countX) * i);
				v[1] = s[1] + ((delta[1] / countY) * j);
				v[2] = s[2];
				if (gi.pointcontents(v) & CONTENTS_SOLID)
					continue;
				v[2] = getFloor(v, NULL, NULL, self) + 24;
				edit_RegisterNode(self, getNodeTypeByValue(nMove), v);
				}
			}
		}



	/****************************************************************

		Show current node area

	****************************************************************/
	void edit_AreaShow(edict_t *self)
		{
		static float	last_update = 0;
		vec3_t v1, v2;

		// Wait a little longer
		if (level.time < last_update)
				return;
			last_update = level.time + 0.15;

		// Go on...
		v1[0] = jb_NodeArea1[0];
		v1[1] = jb_NodeArea1[1];
		v1[2] = jb_NodeArea1[2];

		v2[0] = jb_NodeArea1[0];
		v2[1] = self->s.origin[1];
		v2[2] = jb_NodeArea1[2];
		showTrace(v1, v2);
		VectorCopy(v2, v1);

		v2[0] = self->s.origin[0];
		v2[1] = self->s.origin[1];
		v2[2] = jb_NodeArea1[2];
		showTrace(v1, v2);
		VectorCopy(v2, v1);

		v2[0] = self->s.origin[0];
		v2[1] = jb_NodeArea1[1];
		v2[2] = jb_NodeArea1[2];
		showTrace(v1, v2);
		VectorCopy(v2, v1);

		v2[0] = jb_NodeArea1[0];
		v2[1] = jb_NodeArea1[1];
		v2[2] = jb_NodeArea1[2];
		showTrace(v1, v2);
		VectorCopy(v2, v1);
		}



	/****************************************************************

		Show path (relies on jb_ShowPathFrom and jb_ShowPathTo)

	****************************************************************/
	void edit_ShowPath()
		{
		int nodeCurrent;
		int nodeGoal;
		int nodeNext;
		static float	last_update = 0;

		// Wait a little longer
		if (level.time < last_update)
				return;
			last_update = level.time + 0.15;

		// Nope.
		if ((jb_ShowPathFrom == BOTNODE_INVALID) || (jb_ShowPathTo == BOTNODE_INVALID) || (jb_ShowPathFrom >= jb_NumNodes) || (jb_ShowPathTo >= jb_NumNodes) || (jb_ShowPathFrom == jb_ShowPathTo))
			return;

		nodeCurrent = jb_ShowPathFrom;
		nodeGoal = jb_ShowPathTo;
		nodeNext = jb_PathTable[nodeCurrent][nodeGoal];

		// Bigger nope.
		if (nodeNext == BOTNODE_INVALID)
			{
			gi.dprintf("No path from node[%i] %s to node[%i] %s\n", jb_ShowPathFrom, vtos(jb_Node[jb_ShowPathFrom].origin), jb_ShowPathTo, vtos(jb_Node[jb_ShowPathTo].origin));
			jb_ShowPathFrom = BOTNODE_INVALID;
			jb_ShowPathTo = BOTNODE_INVALID;
			return;
			}

		// Now set up and display the path
		while ((nodeCurrent != nodeGoal) && (nodeCurrent != BOTNODE_INVALID))
			{
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_BFG_LASER);
			gi.WritePosition (jb_Node[nodeCurrent].origin);
			gi.WritePosition (jb_Node[nodeNext].origin);
			gi.multicast (jb_Node[nodeCurrent].origin, MULTICAST_PVS);
			nodeCurrent = nodeNext;
			nodeNext = jb_PathTable[nodeCurrent][nodeGoal];
			}
		}



	/****************************************************************

		Add a node of the specified type to jb_Nodes[]

	****************************************************************/
	short int edit_RegisterNode(edict_t *self, nodeType_t *type, vec3_t forceOrg)
		{
		int				nodeInit = jb_NumNodes;
		int				i;

		// Bail if we exceed maximum
		if ((jb_NumNodes + 1) >= BOTNODE_MAX)
			{
			gi.dprintf("Unable to create Node[%i], maxed out!\n", jb_NumNodes);
			return BOTNODE_INVALID;
			}

		// Set type
		if (!type)
			{
			type = edit_BestNodeType(self, true);
			if (!type)
				return BOTNODE_INVALID;
			}
		jb_Node[jb_NumNodes].type = type;

		// Set origin
		if (!forceOrg)
			VectorCopy(self->s.origin, jb_Node[jb_NumNodes].origin);
		else
			VectorCopy(forceOrg, jb_Node[jb_NumNodes].origin);

		// Reset roadbook for this node
		for (i = 0; i < jb_NumNodes; i++)
			{
			jb_PathTable[jb_NumNodes][i] = BOTNODE_INVALID;
			jb_PathTable[i][jb_NumNodes] = BOTNODE_INVALID;
			}

		// Go to next node
		jb_NumNodes++;

		if (jb_Debug & BOTDEBUG_ROUTE)
			{
			for (i = nodeInit; i < jb_NumNodes; i++)
				DummyNode_Spawn(i);
			}

		return jb_NumNodes - 1; // return last node added
		}


	/****************************************************************

		Move jb_Node[<nodeIndex>] to specified <org>, also move the
		associated dummy if any.

	****************************************************************/
	void edit_NodeMove(int nodeIndex, vec3_t org, qboolean keepheight)
		{
		int				j;
		float			deltaz;
		short int	nodeIndex2 = BOTNODE_INVALID;
		edict_t		*ent = NULL;

		// Invalid node
		if (!ValidNode(nodeIndex))
			return;

		// For platforms, also move twin node
		if (jb_Node[nodeIndex].type->value == nElevator)
			{
			// Get linked entity
			for (j = 0; j < jb_NumItems; j++)
				{
				if (jb_ItemTable[j].node != nodeIndex)
					continue;
				ent = jb_ItemTable[j].ent;
				break;
				}
			if (ent)
				{
				// Get twin node
				for (j = 0; j < jb_NumItems; j++)
					{
					if ((jb_ItemTable[j].node == nodeIndex) || (jb_ItemTable[j].ent != ent))
						continue;
					nodeIndex2 = jb_ItemTable[j].node;
					break;
					}
				}
			}

		// Move
		if (nodeIndex2 != BOTNODE_INVALID)
			{
			// Node 1
			deltaz = jb_Node[nodeIndex].origin[2] - jb_Node[nodeIndex2].origin[2];
			VectorCopy(org, jb_Node[nodeIndex].origin);
			DummyNode_Move(nodeIndex, jb_Node[nodeIndex].origin);
			// Node 2
			jb_Node[nodeIndex2].origin[0] = org[0];
			jb_Node[nodeIndex2].origin[1] = org[1];
			if (keepheight)
				jb_Node[nodeIndex2].origin[2] = org[2] - deltaz;
			DummyNode_Move(nodeIndex2, jb_Node[nodeIndex2].origin);
			gi.dprintf("Moved two nodes\n");
			}
		else
			{
			VectorCopy(org, jb_Node[nodeIndex].origin);
			DummyNode_Move(nodeIndex, jb_Node[nodeIndex].origin);
			gi.dprintf("Moved one node\n");
			}
		}



	/****************************************************************

		Create a node for each unlinked item

	****************************************************************/
	void edit_BuildItemNodeTable()
		{
		nodeType_t			*nType;
		edict_t					*entity;
		int							itemIndex;
		int							j;
		int							cnt = 0;
		qboolean				skipMe;
		short int				nodeIndex;
		vec3_t					v;

		// Parse each entity on the map
		for (entity = g_edicts; entity < &g_edicts[globals.num_edicts]; entity++)
			{
			if ((!entity->classname) || ((entity->solid == SOLID_NOT) && (entity->think != DoRespawn))) // Pickup valid entities
				continue;

			// Check if we got a link to this one already
			skipMe = false;
			for (j = 0; j < jb_NumItems; j ++)
				{
				if (jb_ItemTable[j].ent == entity)
					{
					skipMe = true;
					break;
					}
				}
			if (skipMe)
				continue;

			itemIndex = botMisc_FindItemIndexByClassname(entity->classname);
			if (itemIndex != -1)
				{
				nType = getNodeTypeByValue(nItem);
				v[0] = entity->s.origin[0];
				v[1] = entity->s.origin[1];
				v[2] = entity->s.origin[2] + 8;
				nodeIndex = edit_RegisterNode(entity, nType, v);
				if (nodeIndex != BOTNODE_INVALID)
					{
					jb_ItemTable[jb_NumItems].ent		= entity;
					jb_ItemTable[jb_NumItems].item	= itemIndex;
					jb_ItemTable[jb_NumItems].node	= nodeIndex;
					jb_ItemTable[jb_NumItems].turf	= getEntityTerritory(entity);
					jb_NumItems++;
					cnt++;
					}
				}
			else
				{
				if (!Q_stricmp(entity->classname, "dm_safebag"))
					{
					nType = getNodeTypeByValue(nItem);
					v[0] = entity->s.origin[0];
					v[1] = entity->s.origin[1];
					v[2] = entity->s.origin[2] + 8;
					nodeIndex = edit_RegisterNode(entity, nType, v);
					if (nodeIndex != BOTNODE_INVALID)
						{
						jb_ItemTable[jb_NumItems].ent		= entity;
						jb_ItemTable[jb_NumItems].item	= itemIndex; // -1
						jb_ItemTable[jb_NumItems].node	= nodeIndex;
						jb_ItemTable[jb_NumItems].turf	= getEntityTerritory(entity);
						jb_NumItems++;
						cnt++;
						}
					}
				else if (!Q_stricmp(entity->classname, "func_plat"))
					{
					nType = getNodeTypeByValue(nElevator);
					// Raised
					v[0] = (entity->maxs[0] - entity->mins[0]) / 2 + entity->mins[0];
					v[1] = (entity->maxs[1] - entity->mins[1]) / 2 + entity->mins[1];
					v[2] = (entity->maxs[2] + 24);
					nodeIndex = edit_RegisterNode(entity, nType, v);
					if (nodeIndex != BOTNODE_INVALID)
						{
						jb_ItemTable[jb_NumItems].ent		= entity;
						jb_ItemTable[jb_NumItems].item	= itemIndex;
						jb_ItemTable[jb_NumItems].node	= nodeIndex;
						jb_NumItems++;
						cnt++;
						}
					// Lowered
					v[2] += (entity->moveinfo.end_origin[2] - entity->moveinfo.start_origin[2]);
					nodeIndex = edit_RegisterNode(entity, nType, v);
					if (nodeIndex != BOTNODE_INVALID)
						{
						jb_ItemTable[jb_NumItems].ent		= entity;
						jb_ItemTable[jb_NumItems].item	= itemIndex;
						jb_ItemTable[jb_NumItems].node	= nodeIndex;
						jb_NumItems++;
						cnt++;
						}
					}
				else if (!Q_stricmp(entity->classname, "misc_teleporter_dest") || !Q_stricmp(entity->classname, "misc_teleporter"))
					{
					nType = getNodeTypeByValue(nTeleporter);
					v[0] = entity->s.origin[0];
					v[1] = entity->s.origin[1];
					if (!Q_stricmp(entity->classname, "misc_teleporter_dest"))
						v[2] = entity->s.origin[2] + (entity->maxs[2] - entity->mins[2]);
					else
						v[2] = entity->s.origin[2] + 8;
					nodeIndex = edit_RegisterNode(entity, nType, v);
					if (nodeIndex != BOTNODE_INVALID)
						{
						jb_ItemTable[jb_NumItems].ent		= entity;
						jb_ItemTable[jb_NumItems].item	= itemIndex;
						jb_ItemTable[jb_NumItems].node	= nodeIndex;
						jb_NumItems++;
						cnt++;
						}
					}
				}
			}
		gi.dprintf("Created %i node items\n", cnt);
		}
#endif