#include "g_local.h"
#if compileJACKBOT


	/***************************************************************************
	
		<self> can SEE point <target>. Beware, being able to SEE a point doesn't
		necessarily mean we can reach it (also, transparent surfaces are breaking
		line of sight in this case).

	***************************************************************************/
	qboolean sight_CanSee(edict_t *self, vec3_t target)
		{
		vec3_t	selfEyes;

		selfEyes[0] = self->s.origin[0];
		selfEyes[1] = self->s.origin[1];
		selfEyes[2] = self->s.origin[2] + self->viewheight;

		return (gi.trace(target, NULL, NULL, selfEyes, self, CONTENTS_SOLID|CONTENTS_WINDOW).fraction == 1.00);
		}



	/***************************************************************************

		Could <other> be able to SEE point <target>?
		BEWARE: we are wondering if maybe, <other> can see <target>, it doesn't
		mean it can actually see it, nor does it mean it can reach it; this
		function is used to estimate if the specified entity could be able to
		see a node.

	***************************************************************************/
	qboolean sight_CouldSee(edict_t *other, vec3_t target)
		{
		// Ignore
		if (other == NULL)
			return false;

		// Not in PVS
		if (!gi.inPVS(target, other->s.origin))
			return false;

		// There's something in the way
		if (!sight_CanSee(other, target))
			return false;

		// Estimate cone of vision: maybe it can see 2048 units away, probably within a 90 field...
		return sight_InCone(other->s.origin, 2048, 90, other->s.angles[YAW], target);
		}



	/***************************************************************************

		See if target is located in view cone (doesn't mean there's nothing in
		the way, this function should always be preceeded by sight_SelfCanSee)

	***************************************************************************/
	qboolean sight_InCone(vec3_t origin, float dist, float field, float angle, vec3_t target)
		{
		float	halfField = field / 2;
		float degView;

		// In range?
		if (VectorDistance(origin, target) > dist)
			return false;

		// In cone?
		degView = (angleRange(atan2(target[1] - origin[1], target[0] - origin[0]) * (180 / M_PI)) + halfField);
		return (!(angleRange(degView - angle) > field));
		}



	/***************************************************************************

		Do you think that Other entity could see Self?

	***************************************************************************/
	qboolean sight_EnemyAimingAtMe(edict_t *self, edict_t *other)
		{
		// Invalid
		if ((other == NULL) || (other == self))
			return false;

		// Non-solid, dead or invisible, complete dummy
		if ((other->solid == SOLID_NOT) || (other->deadflag) || (other->flags & FL_NOTARGET))
			return false;

		// Not in PVS
		if (!gi.inPVS(self->s.origin, other->s.origin))
			return false;

		// A solid brush is standing between the two entities
		if (!visible(self, other))
			return false;

		// Is it aiming in my general direction?
		return (sight_InCone(other->s.origin, 2048, 120 * self->botInfo->def.dodge, other->s.angles[YAW], self->s.origin));
		}

	/***************************************************************************

		 Return true if <self> can see <target> (doesn't take luminosity into
		 account... not sure it will ever, who knows?)

	***************************************************************************/
	qboolean sight_VisibleClient(edict_t *self, edict_t *target)
		{
		int				sightDist = self->botInfo->def.viewdistance;
		int				sightCone = self->botInfo->def.viewangle / 2;
		#if 1
		vec3_t		selfEyes;
		#endif

		// Invalid
		if ((target == NULL) || (target == self))
			return false;

		// Non-solid, dead or invisible
		if ((target->solid == SOLID_NOT) || (target->deadflag) || (target->flags & FL_NOTARGET))
			return false;

		// Not in PVS
		if (!gi.inPVS(self->s.origin, target->s.origin))
			return false;

		// A solid brush is standing between the two entities (yes, we also discard windows)
		#if 1
		selfEyes[0] = self->s.origin[0];
		selfEyes[1] = self->s.origin[1];
		selfEyes[2] = self->s.origin[2] + self->viewheight;
		if (gi.trace(target->s.origin, NULL, NULL, selfEyes, self, CONTENTS_SOLID|CONTENTS_WINDOW).fraction < 1.00)
			return false;
		#else
		if (!visible(self, target))
			return false;
		#endif

		// Final test, in view cone
		if (self->onfiretime)
			{
			sightDist = self->botInfo->def.viewdistance / 8;
			sightCone = self->botInfo->def.viewangle / 2;
			}
		return(sight_InCone(self->s.origin, sightDist, sightCone, self->s.angles[YAW], target->s.origin));
		}



	/***************************************************************************

	   Check who's visible amongst all players, <distance> will contain the
		 distance between <self> and the visible client.

	***************************************************************************/
	edict_t *sight_ClosestVisibleClient(edict_t *self, float *distance)
		{
		int				i;
		float			dist = self->botInfo->def.viewdistance + self->botInfo->def.viewdistance;
		float			dist2;
		edict_t		*closest = NULL;

		for (i = 0; i < jb_NumPlayers; i++)
			{
			// Cannot see yourself
			if (jb_Player[i] == self || !jb_Player[i]->client)
				continue;

			// Not a friend
			if (self->client->pers.team != jb_Player[i]->client->pers.team)
				continue;

			// Not visible
			if (!sight_VisibleClient(self, jb_Player[i]))
				continue;

			dist2 = VectorDistanceTaxicab(self->s.origin, jb_Player[i]->s.origin);
			if (dist2 > dist)
				continue;
			dist = dist2;
			closest = jb_Player[i];
			}

		// Make sure this client is in range
		if (closest)
			{
			*distance = VectorDistance(self->s.origin, closest->s.origin);
			if ((*distance) > self->botInfo->def.viewdistance)
				closest = NULL;
			}

		return closest;
		}

	edict_t *sight_ClosestVisibleFriend(edict_t *self, float *distance)
		{
		int				i;
		float			dist = self->botInfo->def.viewdistance + self->botInfo->def.viewdistance;
		float			dist2;
		edict_t		*closest = NULL;

		for (i = 0; i < jb_NumPlayers; i++)
			{
			// Cannot see yourself
			if (jb_Player[i] == self || !jb_Player[i]->client)
				continue;

			// Not a friend
			if (self->client->pers.team != jb_Player[i]->client->pers.team)
				continue;

			// Not visible
			if (!sight_VisibleClient(self, jb_Player[i]))
				continue;

			dist2 = VectorDistanceTaxicab(self->s.origin, jb_Player[i]->s.origin);
			if (dist2 > dist)
				continue;
			dist = dist2;
			closest = jb_Player[i];
			}

		// Make sure this client is in range
		if (closest)
			{
			*distance = VectorDistance(self->s.origin, closest->s.origin);
			if ((*distance) > self->botInfo->def.viewdistance)
				closest = NULL;
			}

		return closest;
		}

	edict_t *sight_ClosestVisibleEnemy(edict_t *self, float *distance)
		{
		int				i;
		float			dist = self->botInfo->def.viewdistance + self->botInfo->def.viewdistance;
		float			dist2;
		edict_t		*skipEnt = NULL;
		edict_t		*ignore = NULL;
		edict_t		*closest = NULL;

		// Ignore enemies
		if (self->botInfo->def.flags & BOTFLAG_NOREACTION)
			return NULL;

		if (self->botInfo->state & BOTSTATE_INVESTIGATE)
			ignore = self->enemy;

		// Check if current target is still visible.
		if ((self->enemy) && (self->enemy != ignore))
			{
			if (sight_VisibleClient(self, self->enemy))
				{
				dist = VectorDistanceTaxicab(self->s.origin, self->enemy->s.origin);
				skipEnt = self->enemy;
				closest = self->enemy;
				}
			}

		// Check anyone else, only pick closest target.
		for (i = 0; i < jb_NumPlayers; i++)
			{
			if ((jb_Player[i] == skipEnt) || (jb_Player[i] == ignore))
				continue;
			if ((self->client->pers.team == jb_Player[i]->client->pers.team) && (self->client->pers.team))
				continue;
			if (!sight_VisibleClient(self, jb_Player[i]))
				continue;
			dist2 = VectorDistanceTaxicab(self->s.origin, jb_Player[i]->s.origin);
			if (dist2 > dist)
				continue;
			dist = dist2;
			closest = jb_Player[i];
			}

		// Make sure this client is in range
		if (closest)
			{
			*distance = VectorDistance(self->s.origin, closest->s.origin);
			if ((*distance) > self->botInfo->def.viewdistance)
				closest = NULL;
			}

		return closest;
		}



	/***************************************************************************

	   We think the goal is still available (true). If we can see its position,
		 and notice the goal is no longer there, return false.

	***************************************************************************/
	qboolean sight_GoalIsStillThere(edict_t *self)
		{
		// Invalid goal
		if (self->botInfo->nodeGoal == BOTNODE_INVALID)
			return false;

		// Not looking for an entity
		if (!self->botInfo->goalEntity)
			return true;

		// eyes
		if (!sight_CanSee(self, jb_Node[self->botInfo->nodeGoal].origin))
			return true;

		// Is the entity there?
		if (self->botInfo->goalEntity->solid != SOLID_NOT)
			return true;

		botprint(self, "Fuck, \"%s\" got away!\n", self->botInfo->goalEntity->classname);
		return false;
		}

#endif