#include "g_local.h"

void	Killerz_SetFullInventory(edict_t *attacker);
void	Check_Extra_Frags(edict_t *defender, edict_t *attacker);
int		Killerz_TakeDamage(edict_t *self, edict_t *attacker);
int		Killerz_TakeArmour(edict_t *self, edict_t *attacker);
void	ReportNewKiller(edict_t *killer);
void	ReportKiller(void);
void	ResetKillstogo(void);

/**************************************************************************

	13/10/00	Started because Warren was taking too long.


**************************************************************************/


//****************************************************************************
//	Depending on what options are set we want to set the KILLERZ armour and
//	health to full and maybe weapons.
//***************************************************************************/
void Killerz_SetFullInventory(edict_t *attacker)
	{
	gitem_t *itemh = FindItem("Helmet Armor");
	gitem_t *itemj = FindItem("Jacket Armor");
	gitem_t *iteml = FindItem("Legs Armor");	

	gitem_t *itemhh = FindItem("Helmet Armor Heavy");
	gitem_t *itemjh = FindItem("Jacket Armor Heavy");
	gitem_t *itemlh = FindItem("Legs Armor Heavy");	

	if (attacker->client->pers.inventory[ITEM_INDEX(itemh)])
		attacker->client->pers.inventory[ITEM_INDEX(itemh)] = 0;

	if (attacker->client->pers.inventory[ITEM_INDEX(itemj)])
		attacker->client->pers.inventory[ITEM_INDEX(itemj)] = 0;

	if (attacker->client->pers.inventory[ITEM_INDEX(iteml)])
		attacker->client->pers.inventory[ITEM_INDEX(iteml)] = 0;			

	attacker->client->pers.inventory[ITEM_INDEX(itemhh)] = 100;
	attacker->client->pers.inventory[ITEM_INDEX(itemjh)] = 100;
	attacker->client->pers.inventory[ITEM_INDEX(itemlh)] = 100;

	attacker->health = 100;


	}

//****************************************************************************
//	Check to see if any extra frags need awarding to the attacker.
//***************************************************************************/
void Check_Extra_Frags(edict_t *defender, edict_t *attacker)
	{

	// If a KILLER killed a VICTIM then give him extra points
	if ((defender->client->pers.plstatus == VICTIM) &&
		(attacker->client->pers.plstatus == KILLER))
		{
		attacker->client->resp.score += killerbonus->value;
		return;
		}

	// If a VICTIM killed the KILLER then give him extra points
	if ((defender->client->pers.plstatus == KILLER) &&
		(attacker->client->pers.plstatus == VICTIM))
		{
		attacker->client->resp.score += victimbonus->value;
		return;
		}

	}


/***************************************************************************
/*	Checks to see if a player can take damage.
/*	If true is returned kingpin will do its normal stuff otherwise no effect
//*************************************************************************/
int Killerz_TakeDamage(edict_t *self, edict_t *attacker)
	{
	vec3_t	vieworg;

	// If player was attacked by the world. Let quake handle it
	if (attacker == world || (attacker && !attacker->client))
		return true;

	// Allow pain to dead player corpses
	if (self->client == NULL)
		return true;

	// If the attacker's a KILLER anyone is fair game
	if (attacker->client->pers.plstatus == KILLER)
		return true;

	// If two VICTIMS's are scrapping they are both fair game if there's 
	// no killer
	if ((attacker->client->pers.plstatus == VICTIM) &&
		(self->client->pers.plstatus == VICTIM) && (!game.killeractive))
		return true;

	// A VICTIM can certainly kill a TARGET
	if ((attacker->client->pers.plstatus == VICTIM) &&
		(self->client->pers.plstatus == KILLER))
		return true;

	if (self && self->client)
		{
		VectorAdd (self->s.origin, self->client->ps.viewoffset, vieworg);

		// If in crap. Too bad you die
		if (gi.pointcontents (vieworg) & (CONTENTS_LAVA|CONTENTS_SLIME))
			return true;
		}

	// Players safe.. I think
	return false;
	}

/***************************************************************************
/*	Checks to see if a player can take damage.
/*	If true is returned kingpin will do its normal stuff otherwise no effect
//*************************************************************************/
int Killerz_TakeArmour(edict_t *self, edict_t *attacker)
	{
	vec3_t	vieworg;

	// If player was attacked by the world. Let quake handle it
	if (attacker == world || (attacker && !attacker->client))
		return true;

	// Allow pain to dead player corpses
	if (self->client == NULL)
		return true;

	// If the attacker's a KILLER anyone is fair game
	if (attacker->client->pers.plstatus == KILLER)
		return true;

	// If two VICTIMS's are scrapping they are both fair game if there's 
	// no killer
	if ((attacker->client->pers.plstatus == VICTIM) &&
		(self->client->pers.plstatus == VICTIM) && (!game.killeractive))
		return true;

	// A VICTIM can certainly kill a TARGET
	if ((attacker->client->pers.plstatus == VICTIM) &&
		(self->client->pers.plstatus == KILLER))
		return true;

	if (self && self->client)
		{
		VectorAdd (self->s.origin, self->client->ps.viewoffset, vieworg);

		// If in crap. Too bad you die
		if (gi.pointcontents (vieworg) & (CONTENTS_LAVA|CONTENTS_SLIME))
			return true;
		}

	// Players safe.. I think
	return false;
	}


/***************************************************************************
/*	Make sure everyone knows who the killer is when created
//*************************************************************************/
void ReportNewKiller(edict_t *killer)
	{
	edict_t *nextplayer = NULL;

	while ((nextplayer = G_Find (nextplayer, FOFS(classname), "player")) != NULL)
		{
		if (nextplayer == killer)
			gi.centerprintf(nextplayer, "%s, you're the Killer!\n", killer->client->pers.netname);
		else
			gi.centerprintf(nextplayer, "%s has become the Killer!\n", killer->client->pers.netname);
		}
	}

/***************************************************************************
/*	Make sure everyone still knows who the killer is
//*************************************************************************/
void ReportKiller(void)
	{
	edict_t	*nextplayer = NULL;
	edict_t *killer = NULL;

	// Inform everyone including the killer of who's who
	while ((nextplayer = G_Find (nextplayer, FOFS(classname), "player")) != NULL)
		{
		if (nextplayer->client->pers.plstatus == KILLER)
			{
			killer = nextplayer;
			break;
			}
		}


	// Inform everyone including the killer of who's who
	while ((nextplayer = G_Find (nextplayer, FOFS(classname), "player")) != NULL)
		{
		if (nextplayer->client->pers.plstatus == KILLER)
			gi.centerprintf(nextplayer, "You're still the Killer,\n%s!\n", killer->client->pers.netname);
		else
			gi.centerprintf(nextplayer, "%s is still the Killer.\n", killer->client->pers.netname);
		}

	}

/***************************************************************************
/*	Check if we want to reset the kills after a killer is born
//*************************************************************************/
void ResetKillstogo(void)
	{
	edict_t *player = NULL;

	while ((player = G_Find (player, FOFS(classname), "player")) != NULL)
		{
		if ((player->client->pers.plstatus == VICTIM) && (resetkills->value))
			player->client->resp.killstogo = killstoget->value;
		}
	}
