#include "g_local.h"

#define NON_MOVEABLE   2
#define TYPE_WOOD      4
#define TYPE_WOOD2     8
#define TYPE_METAL     16
#define TYPE_CARDBOARD 32

void rat_die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point, int mdx_part, int mdx_subobject)
{
	vec3_t realorigin;

	VectorCopy(self->s.origin, realorigin);
	realorigin[2] += 8;

	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_GIBS);
	gi.WritePosition (realorigin);
	gi.WriteDir (vec3_origin);
	gi.WriteByte ( 1 );	// number of gibs
	gi.WriteByte ( 0 );	// scale of direction to add to velocity
	gi.WriteByte ( 0 );	// random offset scale
	gi.WriteByte ( 10 );	// random velocity scale
	gi.multicast (realorigin, MULTICAST_PVS);

	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_SPLASH);
	gi.WriteByte (50);
	gi.WritePosition (realorigin);
	gi.WriteDir (self->movedir);
	gi.WriteByte (6);
	gi.multicast (realorigin, MULTICAST_PVS);

	// If this rat was spawned - tell spawner to make a new one
	if (self->targetname)
	{
		int i;
		edict_t	*e = NULL;

		for (i=1, e=g_edicts+i ; i < globals.num_edicts ; i++,e++)
		{
			if ((e->classname) && (!strcmp(e->classname, "props_rat_spawner")) &&
			    (e->target) && (!strcmp(e->target, self->targetname)))
			{
				e->fxdensity++;	
				break;	
			}
		}	
	}

	G_FreeEdict (self);
}

void trashcanA_check_sound (edict_t *ent)
{
	if (((ent->s.origin[1] == ent->save_avel[1]) && (ent->s.origin[0] == ent->save_avel[0])) ||
		(ent->groundentity == NULL)) 
	{
		ent->s.sound = 0;
	}
}

void light_fire_think( edict_t *ent)
{
	ent->nextthink = level.time + 0.1;

	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_SFXFIRE);
	gi.WritePosition (ent->s.origin);
//	gi.WriteDir (ent->s.angles);
	gi.WriteByte (ent->firetype);
	if (ent->alphalevel)
	{
		gi.WriteByte (ent->alphalevel);
	}
	else
	{
		gi.WriteByte (0);
	}
	gi.multicast (ent->s.origin, MULTICAST_PVS);
}

void smoke_think( edict_t *ent)
{
	ent->nextthink = level.time + 0.5;

	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_SFXSMOKE);
	gi.WritePosition (ent->s.origin);
//	gi.WriteDir (ent->s.angles);
	gi.WriteByte (ent->firetype);
	if (ent->alphalevel)
	{
		gi.WriteByte (ent->alphalevel);
	}
	else
	{
		gi.WriteByte (0);
	}
	gi.multicast (ent->s.origin, MULTICAST_PVS);
}

void steam_think( edict_t *ent)
{
	ent->nextthink = level.time + 0.5;
	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_SFXSTEAM);
	gi.WritePosition (ent->s.origin);
	gi.WriteDir (ent->s.angles);
	gi.WriteByte (ent->firetype); // length
	gi.WriteByte (ent->deadticks); // puffs
	gi.WriteByte (ent->thudsurf); // start size
	gi.WriteByte (ent->thudsnd); // end size
	if (ent->alphalevel)
		gi.WriteByte (ent->alphalevel);
	else
		gi.WriteByte (0);
	gi.multicast (ent->s.origin, MULTICAST_PVS);
}

void crate_stuff (edict_t *self)
{
	vec3_t	org;
	float	spd;
	vec3_t	save;

	VectorCopy (self->s.origin, save);
	VectorMA (self->absmin, 0.5, self->size, self->s.origin);

	// a few big chunks
	spd = 7.0 * (float)self->dmg / 200.0;
	org[0] = self->s.origin[0] + crandom() * self->size[0];
	org[1] = self->s.origin[1] + crandom() * self->size[1];
	org[2] = self->s.origin[2] + crandom() * self->size[2];
	ThrowDebris_stuff (self, "models/props/stuff/piece1.md2", spd, org);
	org[0] = self->s.origin[0] + crandom() * self->size[0];
	org[1] = self->s.origin[1] + crandom() * self->size[1];
	org[2] = self->s.origin[2] + crandom() * self->size[2];
	ThrowDebris_stuff (self, "models/props/stuff/piece1.md2", spd, org);

	// bottom corners
	spd = 6.0 * (float)self->dmg / 200.0;
	VectorCopy (self->absmin, org);
	ThrowDebris_stuff (self, "models/props/stuff/piece3.md2", spd, org);
	VectorCopy (self->absmin, org);
	org[0] += self->size[0];
	ThrowDebris_stuff (self, "models/props/stuff/piece3.md2", spd, org);
	VectorCopy (self->absmin, org);
	org[1] += self->size[1];
	ThrowDebris_stuff (self, "models/props/stuff/piece1.md2", spd, org);
	VectorCopy (self->absmin, org);
	org[0] += self->size[0];
	org[1] += self->size[1];
	ThrowDebris_stuff (self, "models/props/stuff/piece2.md2", spd, org);

	// a bunch of little chunks
	spd = 10 * self->dmg / 200;
	org[0] = self->s.origin[0] + crandom() * self->size[0];
	org[1] = self->s.origin[1] + crandom() * self->size[1];
	org[2] = self->s.origin[2] + crandom() * self->size[2];
	ThrowDebris_stuff (self, "models/props/stuff/piece1.md2", spd, org);
	org[0] = self->s.origin[0] + crandom() * self->size[0];
	org[1] = self->s.origin[1] + crandom() * self->size[1];
	org[2] = self->s.origin[2] + crandom() * self->size[2];
	ThrowDebris_stuff (self, "models/props/stuff/piece3.md2", spd, org);
	org[0] = self->s.origin[0] + crandom() * self->size[0];
	org[1] = self->s.origin[1] + crandom() * self->size[1];
	org[2] = self->s.origin[2] + crandom() * self->size[2];
	ThrowDebris_stuff (self, "models/props/stuff/piece3.md2", spd, org);
	org[0] = self->s.origin[0] + crandom() * self->size[0];
	org[1] = self->s.origin[1] + crandom() * self->size[1];
	org[2] = self->s.origin[2] + crandom() * self->size[2];
	ThrowDebris_stuff (self, "models/props/stuff/piece1.md2", spd, org);
	org[0] = self->s.origin[0] + crandom() * self->size[0];
	org[1] = self->s.origin[1] + crandom() * self->size[1];
	org[2] = self->s.origin[2] + crandom() * self->size[2];
	ThrowDebris_stuff (self, "models/props/stuff/piece3.md2", spd, org);
	org[0] = self->s.origin[0] + crandom() * self->size[0];
	org[1] = self->s.origin[1] + crandom() * self->size[1];
	org[2] = self->s.origin[2] + crandom() * self->size[2];
	ThrowDebris_stuff (self, "models/props/stuff/piece3.md2", spd, org);
	org[0] = self->s.origin[0] + crandom() * self->size[0];
	org[1] = self->s.origin[1] + crandom() * self->size[1];
	org[2] = self->s.origin[2] + crandom() * self->size[2];
	ThrowDebris_stuff (self, "models/props/stuff/piece1.md2", spd, org);
	org[0] = self->s.origin[0] + crandom() * self->size[0];
	org[1] = self->s.origin[1] + crandom() * self->size[1];
	org[2] = self->s.origin[2] + crandom() * self->size[2];
	ThrowDebris_stuff (self, "models/props/stuff/piece2.md2", spd, org);
	org[0] = self->s.origin[0] + crandom() * self->size[0];
	org[1] = self->s.origin[1] + crandom() * self->size[1];
	org[2] = self->s.origin[2] + crandom() * self->size[2];
	ThrowDebris_stuff (self, "models/props/stuff/piece1.md2", spd, org);
	org[0] = self->s.origin[0] + crandom() * self->size[0];
	org[1] = self->s.origin[1] + crandom() * self->size[1];
	org[2] = self->s.origin[2] + crandom() * self->size[2];
	ThrowDebris_stuff (self, "models/props/stuff/piece3.md2", spd, org);
	org[0] = self->s.origin[0] + crandom() * self->size[0];
	org[1] = self->s.origin[1] + crandom() * self->size[1];
	org[2] = self->s.origin[2] + crandom() * self->size[2];
	ThrowDebris_stuff (self, "models/props/stuff/piece3.md2", spd, org);
	org[0] = self->s.origin[0] + crandom() * self->size[0];
	org[1] = self->s.origin[1] + crandom() * self->size[1];
	org[2] = self->s.origin[2] + crandom() * self->size[2];
	ThrowDebris_stuff (self, "models/props/stuff/piece1.md2", spd, org);
	org[0] = self->s.origin[0] + crandom() * self->size[0];
	org[1] = self->s.origin[1] + crandom() * self->size[1];
	org[2] = self->s.origin[2] + crandom() * self->size[2];
	ThrowDebris_stuff (self, "models/props/stuff/piece3.md2", spd, org);
	org[0] = self->s.origin[0] + crandom() * self->size[0];
	org[1] = self->s.origin[1] + crandom() * self->size[1];
	org[2] = self->s.origin[2] + crandom() * self->size[2];
	ThrowDebris_stuff (self, "models/props/stuff/piece3.md2", spd, org);
	org[0] = self->s.origin[0] + crandom() * self->size[0];
	org[1] = self->s.origin[1] + crandom() * self->size[1];
	org[2] = self->s.origin[2] + crandom() * self->size[2];
	ThrowDebris_stuff (self, "models/props/stuff/piece1.md2", spd, org);
	org[0] = self->s.origin[0] + crandom() * self->size[0];
	org[1] = self->s.origin[1] + crandom() * self->size[1];
	org[2] = self->s.origin[2] + crandom() * self->size[2];
	ThrowDebris_stuff (self, "models/props/stuff/piece2.md2", spd, org);
}

/*QUAKED props_crate_bust_32 (0 .5 .8) (-16 -16 -16) (16 16 16) ? NON_MOVEABLE TYPE_WOOD TYPE_WOOD2 TYPE_METAL TYPE_CARDBOARD
Crate can bust and you can push
health (10).

"item" - Item to spawn on destruction 

model="models\props\crate\stillcrate32_1.mdx"
*/

/*QUAKED props_crate_bust_48 (0 .5 .8) (-24 -24 -24) (24 24 24) ? NON_MOVEABLE TYPE_WOOD TYPE_WOOD2 X TYPE_CARDBOARD
Crate can bust and you can push
health (10).

"item" - Item to spawn on destruction 

model="models\props\crate\stillcrate48_1.mdx"
*/

/*QUAKED props_crate_bust_64 (0 .5 .8) (-32 -32 -32) (32 32 32) ? X TYPE_WOOD TYPE_WOOD2 X TYPE_CARDBOARD 
Crate you can bust
health (10).

"item" - Item to spawn on destruction 

model="models\props\crate\stillcrate64_1.mdx"
*/

void crate_check_sound (edict_t *ent)
{
	if (((ent->s.origin[1] == ent->save_avel[1]) && (ent->s.origin[0] == ent->save_avel[0])) ||
		(ent->groundentity == NULL)) 
	{
		ent->s.sound = 0;
	}
}

void crate_explode (edict_t *self);

void breakit_sound (edict_t *self)
{
	gi.sound (self, CHAN_VOICE, gi.soundindex("world/boardbreak.wav"), 1, ATTN_NORM, 0);
	self->think = G_FreeEdict;
	self->nextthink = level.time + 2.0;
}

void crate_bust_final_32 (edict_t *self)
{
    if (self->s.frame < 19)
	{
		if (self->item)
		{
			Drop_Item (self, self->item);
			self->item = NULL;
		}
		else
		{
			if (self->s.frame == 0)
				crate_stuff (self);
		}
		
		self->s.frame++;
		
		self->nextthink = level.time + 0.1;
	}
	else if (self->misstime-- > 0)
	{
		if (self->misstime <= 20)
		{
			if (self->misstime == 20)
			{
				self->s.renderfx2 |= RF2_PASSALPHA;
				self->s.effects = 1;		// this is full alpha now
			}
			
			self->s.effects += (255/20);
		
			if (self->s.effects > 255)
				self->s.effects = 255;
		}
		
		self->nextthink = level.time + 0.1;
	}
	else
	{
		G_FreeEdict (self);
	}
}	

void crate_bust_die_32 (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point, int mdx_part, int mdx_subobject)
{
	int i;
	
	if (self->takedamage == DAMAGE_NO)
		return;
	
	self->s.sound = 0;

	self->think = crate_bust_final_32;
	self->nextthink = level.time + FRAMETIME;

 	memset(&(self->s.model_parts[0]), 0, sizeof(model_part_t) * MAX_MODEL_PARTS);
	self->s.num_parts++;
	
	if (self->spawnflags & TYPE_CARDBOARD)
	{
		self->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/props/crate/cardboard32.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_HEAD].skinnum[i] = self->s.skinnum;
		gi.GetObjectBounds("models/props/crate/cardboard32.mdx", &self->s.model_parts[PART_HEAD]);

		self->takedamage = DAMAGE_NO;
		self->think = NULL;
		self->nextthink = 0;
		gi.sound (self, CHAN_AUTO, gi.soundindex ("weapons/melee/pipehitcboard.wav"), 1, ATTN_NORM, 0);
		return;
	}
	
	if (self->spawnflags & TYPE_WOOD2)
	{
		self->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/props/crate/crate32_2.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_HEAD].skinnum[i] = self->s.skinnum;
		gi.GetObjectBounds("models/props/crate/crate32_2.mdx", &self->s.model_parts[PART_HEAD]);
	}		
	else
	{
		self->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/props/crate/crate32_1.mdx");
	for (i=0; i<MAX_MODELPART_OBJECTS; i++)
		self->s.model_parts[PART_HEAD].skinnum[i] = self->s.skinnum;
		gi.GetObjectBounds("models/props/crate/crate32_1.mdx", &self->s.model_parts[PART_HEAD]);	
	}

	self->s.renderfx2 |= RF2_NOSHADOW;
	self->solid = 0;
	self->touch = NULL;
	gi.sound (self, CHAN_AUTO, gi.soundindex ("world/crate2.wav"), 1, ATTN_NORM, 0);
}	

void crate_touch_32 (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	float	ratio;
	vec3_t	v;

	if ((!other->groundentity) || (other->groundentity == self))
		return;

	self->pullingflag = 0;

	// If activate key is pressed
	if ((plane) && (plane->type == 123))
	{
		if ((other->s.origin[0] != other->s.old_origin[0]) || (other->s.origin[1] != other->s.old_origin[1]))
		{
			self->pullingflag = 1;
			
			ratio = (float)other->mass / (float)self->mass;
			VectorSubtract (self->s.origin, other->s.origin, v);
			M_walkmove (self, 180+vectoyaw(v), 20 * ratio * FRAMETIME);
		
			if (!self->s.sound)
				self->s.sound = gi.soundindex ("world/crate1.wav");
			VectorCopy(self->s.origin, self->save_avel);
			self->think = trashcanA_check_sound;
			self->nextthink = level.time + (FRAMETIME * 1.1);
		}
	}
	else
	{	
		ratio = (float)other->mass / (float)self->mass;
		VectorSubtract (self->s.origin, other->s.origin, v);
		M_walkmove (self, vectoyaw(v), 20 * ratio * FRAMETIME);

		if (((self->s.origin[0] != self->s.old_origin[0]) || (self->s.origin[1] != self->s.old_origin[1])))
		{
			if (!self->s.sound)
				self->s.sound = gi.soundindex ("world/crate1.wav");	
			VectorCopy(self->s.origin, self->save_avel);
			self->think = trashcanA_check_sound;
			self->nextthink = level.time + (FRAMETIME * 1.1);
		}
	}

	if (!(self->spawnflags & TYPE_METAL))
	{	
	if (self->health <= 0)
			crate_bust_die_32(self, 0, 0, 0, vec3_origin, 0, 0);
	}
}

void SP_props_crate_bust_32 (edict_t *self)
{
	int i;

	/*
	if (deathmatch->value)
	{	// auto-remove for deathmatch
		G_FreeEdict (self);
		return;
	}
	*/

	self->solid = SOLID_BBOX;

	if (self->spawnflags & NON_MOVEABLE)
		self->movetype = MOVETYPE_NONE;
	else
	self->movetype = MOVETYPE_STEP;
	
	self->svflags |= SVF_PROP;	

	VectorSet (self->mins, -16, -16, -16);
	VectorSet (self->maxs, 16, 16, 16);
	
	self->s.skinnum = self->skin;
 	memset(&(self->s.model_parts[0]), 0, sizeof(model_part_t) * MAX_MODEL_PARTS);
	self->s.num_parts++;

	if (self->spawnflags & TYPE_METAL)
	{
		self->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/props/crate/stillcrate32.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_HEAD].skinnum[i] = self->s.skinnum;
		gi.GetObjectBounds("models/props/crate/stillcrate32.mdx", &self->s.model_parts[PART_HEAD]);
		self->surfacetype = SURF_WOOD;
	}
	else if (self->spawnflags & TYPE_CARDBOARD)
	{
		self->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/props/crate/stillcard32.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_HEAD].skinnum[i] = self->s.skinnum;
		gi.GetObjectBounds("models/props/crate/stillcard32.mdx", &self->s.model_parts[PART_HEAD]);
		self->surfacetype = SURF_FABRIC;
	}
	else if (self->spawnflags & TYPE_WOOD2)
	{
		self->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/props/crate/stillcrate32_2.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_HEAD].skinnum[i] = self->s.skinnum;
		gi.GetObjectBounds("models/props/crate/stillcrate32_2.mdx", &self->s.model_parts[PART_HEAD]);
		self->surfacetype = SURF_WOOD;
	}		
	else
	{
		self->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/props/crate/stillcrate32_1.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_HEAD].skinnum[i] = self->s.skinnum;
		gi.GetObjectBounds("models/props/crate/stillcrate32_1.mdx", &self->s.model_parts[PART_HEAD]);	
		self->surfacetype = SURF_WOOD;
	}
	
	if (!(self->spawnflags & NON_MOVEABLE))
	{
		self->pullable = 1;
		self->nokickbackflag = 1;
		self->fallerflag = 1;
	}

	if (!self->mass)
		self->mass = 400;
	if (!self->health)
		self->health = 10;
	if (!self->dmg)
		self->dmg = 0;

	if (self->spawnflags & TYPE_METAL)
	{
		if (self->pullable)
			self->touch = crate_touch_32;	
	}
	else 
	{
		self->die = crate_bust_die_32;
		self->takedamage = DAMAGE_YES;
		if (self->pullable)
			self->touch = crate_touch_32;	
	}

	self->cast_info.aiflags = AI_NOSTEP;	

	self->think = M_droptofloor;
	self->nextthink = level.time + 2 * FRAMETIME;

	self->s.renderfx2 |= RF2_DIR_LIGHTS;
	self->misstime = 21;

	if (st.item)
	{
		self->item = FindItemByClassname (st.item);
		if (!self->item)
			gi.dprintf("%s at %s has bad item: %s\n", self->classname, vtos(self->s.origin), st.item);
	}

	gi.linkentity (self);
}


void crate_bust_final_48 (edict_t *self)
{
    if (self->s.frame < 28)
	{
		if (self->item)
		{
			Drop_Item (self, self->item);
			self->item = NULL;
		}
		else
		{
			if (self->s.frame == 0)
				crate_stuff (self);
		}
			
		self->s.frame++;
		
		self->nextthink = level.time + 0.1;
	}
	else if (self->misstime-- > 0)
	{
		if (self->misstime <= 20)
		{
			if (self->misstime == 20)
			{
				self->s.renderfx2 |= RF2_PASSALPHA;
				self->s.effects = 1;		// this is full alpha now
			}
			
			self->s.effects += (255/20);
		
			if (self->s.effects > 255)
				self->s.effects = 255;
		}
		
		self->nextthink = level.time + 0.1;
	}
	else
	{
		G_FreeEdict (self);
	}
}	

void crate_bust_die_48 (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point, int mdx_part, int mdx_subobject)
{
	int i;
	
	if (self->takedamage == DAMAGE_NO)
		return;
	
	self->s.sound = 0;

	self->think = crate_bust_final_48;
	self->nextthink = level.time + FRAMETIME;

 	memset(&(self->s.model_parts[0]), 0, sizeof(model_part_t) * MAX_MODEL_PARTS);
	self->s.num_parts++;
	
	if (self->spawnflags & TYPE_CARDBOARD)
	{
		self->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/props/crate/cardboard48.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_HEAD].skinnum[i] = self->s.skinnum;
		gi.GetObjectBounds("models/props/crate/cardboard48.mdx", &self->s.model_parts[PART_HEAD]);

		self->takedamage = DAMAGE_NO;
		self->think = NULL;
		self->nextthink = 0;

		gi.sound (self, CHAN_AUTO, gi.soundindex ("weapons/melee/pipehitcboard.wav"), 1, ATTN_NORM, 0);		
		return;
	}
	
	if (self->spawnflags & TYPE_WOOD2)
	{
		self->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/props/crate/crate48_2.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_HEAD].skinnum[i] = self->s.skinnum;
		gi.GetObjectBounds("models/props/crate/crate48_2.mdx", &self->s.model_parts[PART_HEAD]);
	}		
	else
	{
		self->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/props/crate/crate48_1.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_HEAD].skinnum[i] = self->s.skinnum;
		gi.GetObjectBounds("models/props/crate/crate48_1.mdx", &self->s.model_parts[PART_HEAD]);	
	}

	self->s.renderfx2 |= RF2_NOSHADOW;
	self->solid = 0;
	self->touch = NULL;
	gi.sound (self, CHAN_AUTO, gi.soundindex ("world/crate2.wav"), 1, ATTN_NORM, 0);
}	

void crate_touch_48 (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	float	ratio;
	vec3_t	v;

	if ((!other->groundentity) || (other->groundentity == self))
		return;

	self->pullingflag = 0;

	// If activate key is pressed
	if ((plane) && (plane->type == 123))
	{
		if ((other->s.origin[0] != other->s.old_origin[0]) || (other->s.origin[1] != other->s.old_origin[1]))
		{
			self->pullingflag = 1;
			
			ratio = (float)other->mass / (float)self->mass;
			VectorSubtract (self->s.origin, other->s.origin, v);
			M_walkmove (self, 180+vectoyaw(v), 20 * ratio * FRAMETIME);
		
			if (!self->s.sound)
				self->s.sound = gi.soundindex ("world/crate1.wav");
			VectorCopy(self->s.origin, self->save_avel);
			self->think = trashcanA_check_sound;
			self->nextthink = level.time + (FRAMETIME * 1.1);
		}
	}
	else
	{	
		ratio = (float)other->mass / (float)self->mass;
		VectorSubtract (self->s.origin, other->s.origin, v);
		M_walkmove (self, vectoyaw(v), 20 * ratio * FRAMETIME);

		if (((self->s.origin[0] != self->s.old_origin[0]) || (self->s.origin[1] != self->s.old_origin[1])))
		{
			if (!self->s.sound)
				self->s.sound = gi.soundindex ("world/crate1.wav");	
			VectorCopy(self->s.origin, self->save_avel);
			self->think = trashcanA_check_sound;
			self->nextthink = level.time + (FRAMETIME * 1.1);
		}
	}

	if (!(self->spawnflags & TYPE_METAL))
	{	
		if (self->health <= 0)
			crate_bust_die_48(self, 0, 0, 0, vec3_origin, 0, 0);
	}
}

void SP_props_crate_bust_48 (edict_t *self)
{
	int i;

	/*
	if (deathmatch->value)
	{	// auto-remove for deathmatch
		G_FreeEdict (self);
		return;
	}
	*/

	self->solid = SOLID_BBOX;
	
	if (self->spawnflags & NON_MOVEABLE)
		self->movetype = MOVETYPE_NONE;
	else
		self->movetype = MOVETYPE_STEP;
	
	self->svflags |= SVF_PROP;	

	VectorSet (self->mins, -24.1, -24.1, -24.1);
	VectorSet (self->maxs, 24.1, 24.1, 24.1);
	
	self->s.skinnum = self->skin;
 	memset(&(self->s.model_parts[0]), 0, sizeof(model_part_t) * MAX_MODEL_PARTS);
	self->s.num_parts++;

	if (self->spawnflags & TYPE_METAL)
	{
		self->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/props/crate/stillcrate48.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_HEAD].skinnum[i] = self->s.skinnum;
		gi.GetObjectBounds("models/props/crate/stillcrate48.mdx", &self->s.model_parts[PART_HEAD]);
		self->surfacetype = SURF_WOOD;
	}
	else if (self->spawnflags & TYPE_CARDBOARD)
	{
		self->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/props/crate/stillcard48.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_HEAD].skinnum[i] = self->s.skinnum;
		gi.GetObjectBounds("models/props/crate/stillcard48.mdx", &self->s.model_parts[PART_HEAD]);
		self->surfacetype = SURF_FABRIC;
	}
	else if (self->spawnflags & TYPE_WOOD2)
	{
		self->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/props/crate/stillcrate48_2.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_HEAD].skinnum[i] = self->s.skinnum;
		gi.GetObjectBounds("models/props/crate/stillcrate48_2.mdx", &self->s.model_parts[PART_HEAD]);
		self->surfacetype = SURF_WOOD;
	}		
	else
	{
		self->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/props/crate/stillcrate48_1.mdx");
	for (i=0; i<MAX_MODELPART_OBJECTS; i++)
		self->s.model_parts[PART_HEAD].skinnum[i] = self->s.skinnum;
		gi.GetObjectBounds("models/props/crate/stillcrate48_1.mdx", &self->s.model_parts[PART_HEAD]);	
		self->surfacetype = SURF_WOOD;
	}

	if (!(self->spawnflags & NON_MOVEABLE))
	{
		self->pullable = 1;
		self->nokickbackflag = 1;
	  self->fallerflag = 1;
	}
	
	if (!self->mass)
		self->mass = 400;
	if (!self->health)
		self->health = 10;
	if (!self->dmg)
		self->dmg = 0;

	if (self->spawnflags & TYPE_METAL)
	{
		if (self->pullable)
			self->touch = crate_touch_48;	
	}
	else 
	{
		self->die = crate_bust_die_48;
	self->takedamage = DAMAGE_YES;
		if (self->pullable)
			self->touch = crate_touch_48;	
	}

	self->cast_info.aiflags = AI_NOSTEP;

	self->think = M_droptofloor;
	self->nextthink = level.time + 2 * FRAMETIME;

	self->s.renderfx2 |= RF2_DIR_LIGHTS;
	self->misstime = 21;

	if (st.item)
	{
		self->item = FindItemByClassname (st.item);
		if (!self->item)
			gi.dprintf("%s at %s has bad item: %s\n", self->classname, vtos(self->s.origin), st.item);
	}

	gi.linkentity (self);
}

void crate_bust_final_64 (edict_t *self)
{
    if (self->s.frame < 39)
	{
		if (self->item)
		{
			Drop_Item (self, self->item);
			self->item = NULL;
		}
		else
		{
			if (self->s.frame == 0)
				crate_stuff (self);
		}
			
		self->s.frame++;
		
		self->nextthink = level.time + 0.1;
	}
	else if (self->misstime-- > 0)
	{
		if (self->misstime <= 20)
		{
			if (self->misstime == 20)
			{
				self->s.renderfx2 |= RF2_PASSALPHA;
				self->s.effects = 1;		// this is full alpha now
			}
			
			self->s.effects += (255/20);
		
			if (self->s.effects > 255)
				self->s.effects = 255;
		}
		
		self->nextthink = level.time + 0.1;
	}
	else
	{
		G_FreeEdict (self);
	}
}	

void crate_bust_die_64 (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point, int mdx_part, int mdx_subobject)
{
	int i;
	
	if (self->takedamage == DAMAGE_NO)
		return;
	
	self->s.sound = 0;

	self->think = crate_bust_final_64;
	self->nextthink = level.time + FRAMETIME;

 	memset(&(self->s.model_parts[0]), 0, sizeof(model_part_t) * MAX_MODEL_PARTS);
	self->s.num_parts++;
	
	if (self->spawnflags & TYPE_CARDBOARD)
	{
		self->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/props/crate/cardboard64.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_HEAD].skinnum[i] = self->s.skinnum;
		gi.GetObjectBounds("models/props/crate/cardboard64.mdx", &self->s.model_parts[PART_HEAD]);

		self->takedamage = DAMAGE_NO;
		self->think = NULL;
		self->nextthink = 0;

		gi.sound (self, CHAN_AUTO, gi.soundindex ("weapons/melee/pipehitcboard.wav"), 1, ATTN_NORM, 0);		
		return;
	}
	
	if (self->spawnflags & TYPE_WOOD2)
	{
		self->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/props/crate/crate64_2.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_HEAD].skinnum[i] = self->s.skinnum;
		gi.GetObjectBounds("models/props/crate/crate64_2.mdx", &self->s.model_parts[PART_HEAD]);
	}		
	else
	{
		self->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/props/crate/crate64_1.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_HEAD].skinnum[i] = self->s.skinnum;
		gi.GetObjectBounds("models/props/crate/crate64_1.mdx", &self->s.model_parts[PART_HEAD]);	
	}

	self->s.renderfx2 |= RF2_NOSHADOW;
	self->solid = 0;
	self->touch = NULL;
	gi.sound (self, CHAN_AUTO, gi.soundindex ("world/crate2.wav"), 1, ATTN_NORM, 0);
}	

void SP_props_crate_bust_64 (edict_t *self)
{
	int i;

	/*
	if (deathmatch->value)
	{	// auto-remove for deathmatch
		G_FreeEdict (self);
		return;
	}
	*/

	self->solid = SOLID_BBOX;
	self->movetype = MOVETYPE_NONE;
	self->svflags |= SVF_PROP;	

	VectorSet (self->mins, -32, -32, -32);
	VectorSet (self->maxs, 32, 32, 32);
	
	self->s.skinnum = self->skin;
 	memset(&(self->s.model_parts[0]), 0, sizeof(model_part_t) * MAX_MODEL_PARTS);
	self->s.num_parts++;

	if (self->spawnflags & TYPE_METAL)
	{
		self->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/props/crate/stillcrate64.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_HEAD].skinnum[i] = self->s.skinnum;
		gi.GetObjectBounds("models/props/crate/stillcrate64.mdx", &self->s.model_parts[PART_HEAD]);
		self->surfacetype = SURF_WOOD;
	}
	else if (self->spawnflags & TYPE_CARDBOARD)
	{
		self->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/props/crate/stillcard64.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_HEAD].skinnum[i] = self->s.skinnum;
		gi.GetObjectBounds("models/props/crate/stillcard64.mdx", &self->s.model_parts[PART_HEAD]);
		self->surfacetype = SURF_FABRIC;
	}
	else if (self->spawnflags & TYPE_WOOD2)
	{
		self->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/props/crate/stillcrate64_2.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_HEAD].skinnum[i] = self->s.skinnum;
		gi.GetObjectBounds("models/props/crate/stillcrate64_2.mdx", &self->s.model_parts[PART_HEAD]);
		self->surfacetype = SURF_WOOD;
	}		
	else
	{
		self->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/props/crate/stillcrate64_1.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_HEAD].skinnum[i] = self->s.skinnum;
		gi.GetObjectBounds("models/props/crate/stillcrate64_1.mdx", &self->s.model_parts[PART_HEAD]);	
		self->surfacetype = SURF_WOOD;
	}
	
	if (!self->mass)
		self->mass = 400;
	if (!self->health)
		self->health = 10;
	if (!self->dmg)
		self->dmg = 0;

	if (!(self->spawnflags & TYPE_METAL))
	{
		self->die = crate_bust_die_64;
		self->takedamage = DAMAGE_YES;
	}

	self->think = M_droptofloor;
	self->nextthink = level.time + 2 * FRAMETIME;

	self->s.renderfx2 |= RF2_DIR_LIGHTS;
	self->misstime = 21;

	if (st.item)
	{
		self->item = FindItemByClassname (st.item);
		if (!self->item)
			gi.dprintf("%s at %s has bad item: %s\n", self->classname, vtos(self->s.origin), st.item);
	}

	gi.linkentity (self);
}

/*QUAKED props_ammocrate_bust (0 .5 .8) (-32 -16 -8) (32 16 8)
Crate you may bust.
health (10).

"item" - Item to spawn on destruction if hit by pipe or crowbar 

The bounding box can be rotated in angles of 90 deg and block properly

model="models\props\crate\crate_32_64.mdx"
skin="models\props\crate\crate_exp.tga"
*/

void ammocrate_bust_finalA (edict_t *self)
{
    if (self->s.frame < 15)
	{
		self->s.frame++;
		
		self->nextthink = level.time + 0.1;
	}
	else if (self->misstime-- > 0)
	{
		if (self->misstime <= 20)
		{
			if (self->misstime == 20)
			{
				self->s.renderfx2 |= RF2_PASSALPHA;
				self->s.effects = 1;		// this is full alpha now
			}
			
			self->s.effects += (255/20);
		
			if (self->s.effects > 255)
				self->s.effects = 255;
		}
		
		self->nextthink = level.time + 0.1;
	}
	else
	{
		G_FreeEdict (self);
	}
}	

void ammocrate_bust_finalB (edict_t *self)
{
    if (self->s.frame < 7)
	{
			if (self->item)
			{
				Drop_Item (self, self->item);
				self->item = NULL;
			}
		
		self->s.frame++;
		
		self->nextthink = level.time + 0.1;
	}
	else if (self->misstime-- > 0)
	{
		if (self->misstime <= 20)
		{
			if (self->misstime == 20)
			{
				self->s.renderfx2 |= RF2_PASSALPHA;
				self->s.effects = 1;		// this is full alpha now
			}
			
			self->s.effects += (255/20);
		
			if (self->s.effects > 255)
				self->s.effects = 255;
		}
		
		self->nextthink = level.time + 0.1;
	}
	else
	{
		G_FreeEdict (self);
	}
}	

void ammocrate_bust_die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point, int mdx_part, int mdx_subobject)
{
	if ((attacker->client) && (attacker->client->pers.weapon) &&
		((!strcmp(attacker->client->pers.weapon->pickup_name, "Crowbar")) ||	// Ridah, 12-may-99, added brackets to fix crash if Dog busts open crate while attacking player
		 (!strcmp(attacker->client->pers.weapon->pickup_name, "Pipe"))))
	{
		self->think = ammocrate_bust_finalB;
		self->nextthink = level.time + FRAMETIME;
	}
	else
	{
		vec3_t	vec;
		
		self->model = "models/props/crate/exp.md2";
		self->s.modelindex = gi.modelindex (self->model);
		self->think = ammocrate_bust_finalA;
		self->nextthink = level.time + FRAMETIME;

		{
			edict_t *breakit;
			
			breakit = G_Spawn();
			
			if (breakit)
			{
				VectorCopy (self->s.origin, breakit->s.origin);
				gi.linkentity(breakit);
				gi.sound (breakit, CHAN_VOICE, gi.soundindex("world/explosion1.wav"), 1, ATTN_NORM, 0);
				breakit->think = G_FreeEdict;
				breakit->nextthink = level.time + 5.0;
			}
		}

		{
			vec3_t neworigin;

			VectorCopy(self->s.origin, neworigin);
			neworigin[1] -= 48;
			neworigin[0] -= 32;
			neworigin[2] += 16;

			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_EXPLOSION1);
			gi.WritePosition (neworigin);
			gi.WriteDir( vec );
			gi.WriteByte( (int)(self->dmg / 2) );
			gi.WriteByte (self->fxdensity);
			gi.multicast (neworigin, MULTICAST_PVS);	
		}
	}
	
	self->s.renderfx2 |= RF2_NOSHADOW;
	self->solid = 0;
	self->touch = NULL;
	gi.sound (self, CHAN_AUTO, gi.soundindex ("world/crate2.wav"), 1, ATTN_NORM, 0);
}	

void SP_props_ammocrate_bust (edict_t *self)
{
	/*
	if (deathmatch->value)
	{	// auto-remove for deathmatch
		G_FreeEdict (self);
		return;
	}
	*/

	self->solid = SOLID_BBOX;
	self->movetype = MOVETYPE_NONE;
	self->svflags |= SVF_PROP;
	self->model = "models/props/crate/tris.md2";
	self->s.modelindex = gi.modelindex (self->model);

	if ((self->s.angles[1] == 90) || self->s.angles[1] == 270)
	{
		VectorSet (self->mins, -16, -32, -8);
		VectorSet (self->maxs, 16, 32, 8);	
	}
	else
	{
		VectorSet (self->mins, -32, -16, -8);
		VectorSet (self->maxs, 32, 16, 8);		
	}		
	
	if (!self->mass)
		self->mass = 400;
	if (!self->health)
		self->health = 10;
	if (!self->dmg)
		self->dmg = 0;

	self->die = ammocrate_bust_die;
	self->takedamage = DAMAGE_YES;

	self->think = M_droptofloor;
	self->nextthink = level.time + 2 * FRAMETIME;

	self->misstime = 26;

	if (st.item)
	{
		self->item = FindItemByClassname (st.item);
		if (!self->item)
			gi.dprintf("%s at %s has bad item: %s\n", self->classname, vtos(self->s.origin), st.item);
	}	
	
	self->surfacetype = SURF_WOOD;	
	gi.linkentity (self);
}

void SP_light_fire_esm (edict_t *ent)
{
    if (ent->alphalevel > 10) ent->alphalevel = 10;
	VectorSet (ent->movedir, 0.0, 1, 0.0);
	ent->think = light_fire_think;
	ent->nextthink = level.time + 0.1;
	ent->firetype = 8;
	gi.linkentity (ent);

	AddLightSource(ent);
}

void SP_light_fire_sm (edict_t *ent)
{
    if (ent->alphalevel > 10) ent->alphalevel = 10;
	VectorSet (ent->movedir, 0.0, 1, 0.0);
	ent->think = light_fire_think;
	ent->nextthink = level.time + 0.1;
	ent->firetype = 16;
	gi.linkentity (ent);

	AddLightSource(ent);
}

void SP_light_fire_med (edict_t *ent)
{
    if (ent->alphalevel > 10) ent->alphalevel = 10;
	VectorSet (ent->movedir, 0.0, 1, 0.0);
	ent->think = light_fire_think;
	ent->nextthink = level.time + 0.1;
	ent->firetype = 24;
	gi.linkentity (ent);

	AddLightSource(ent);
}

void SP_light_fire_lg (edict_t *ent)
{
    if (ent->alphalevel > 10) ent->alphalevel = 10;
	VectorSet (ent->movedir, 0.0, 1, 0.0);
	ent->think = light_fire_think;
	ent->nextthink = level.time + 0.1;
	ent->firetype = 32;
	gi.linkentity (ent);

	AddLightSource(ent);
}

void SP_smoke_esm (edict_t *ent)
{
    if (ent->alphalevel > 10) ent->alphalevel = 10;
	VectorSet (ent->movedir, 0.0, 1, 0.0);
	ent->think = smoke_think;
	ent->nextthink = level.time + 0.1;
	ent->firetype = 5;
	gi.linkentity (ent);
}

void SP_smoke_sm (edict_t *ent)
{
    if (ent->alphalevel > 10) ent->alphalevel = 10;
	VectorSet (ent->movedir, 0.0, 1, 0.0);
	ent->think = smoke_think;
	ent->nextthink = level.time + 0.1;
	ent->firetype = 10;
	gi.linkentity (ent);
}

void SP_smoke_med (edict_t *ent)
{
    if (ent->alphalevel > 10) ent->alphalevel = 10;
	VectorSet (ent->movedir, 0.0, 1, 0.0);
	ent->think = smoke_think;
	ent->nextthink = level.time + 0.1;
	ent->firetype = 20;
	gi.linkentity (ent);
}

void SP_smoke_lg (edict_t *ent)
{
    if (ent->alphalevel > 10) ent->alphalevel = 10;
	VectorSet (ent->movedir, 0.0, 1, 0.0);
	ent->think = smoke_think;
	ent->nextthink = level.time + 0.1;
	ent->firetype = 30;
	gi.linkentity (ent);
}

void SP_props_steam_machine (edict_t *ent)
{
    if (ent->alphalevel > 10) ent->alphalevel = 10;
	if ((!ent->thudsurf) || (ent->thudsurf > 10))
		ent->thudsurf = 5;
	if ((!ent->thudsnd) || (ent->thudsnd > 10))
		ent->thudsnd = 5;
	if ((!ent->firetype) || (ent->firetype > 100))
		ent->firetype = 15;
	if ((!ent->deadticks) || (ent->deadticks > 10))
		ent->deadticks = 2;
	ent->think = steam_think;
	ent->nextthink = level.time + 0.1;
	gi.linkentity (ent);
}
