#include "g_local.h"


void MonsterSpawn (edict_t *ent, vec3_t origin, vec3_t angles);
edict_t *SelectRandomDeathmatchSpawnPointMonster (void);
float	PlayersRangeFromSpot (edict_t *spot);
void Cmd_Monster_f (void);


void SP_cast_punkz(edict_t *self);
void SP_cast_punkrl(edict_t *self);
void SP_cast_punkfg(edict_t *self);
void SP_cast_punkgl(edict_t *self);
void SP_cast_punkhmg(edict_t *self);
void SP_cast_punktg(edict_t *self);
void SP_cast_thug(edict_t *self);
void SP_cast_runt (edict_t *self);
//void SP_cast_thug2(edict_t *self);
void SP_cast_bitch (edict_t *ent);
void SP_cast_dog (edict_t *ent);
void SP_cast_spider (edict_t *self);
//void SP_eatshit(edict_t *ent);
void SP_cast_shorty (edict_t *ent);
void SP_cast_shortyz (edict_t *ent);

//void SP_cast_whore (edict_t *ent);
void SP_cast_bum_sit (edict_t *self);
void SP_cast_bum_sitz (edict_t *self);


/*
===========
MONSTER SPAWNING

Add monsters in DM
============
*/
/*
================
SelectRandomDeathmatchSpawnPoint

go to a random point, but NOT the two points closest
to other players
================
*/


edict_t *SelectRandomDeathmatchSpawnPointMonster (void)
{
	edict_t	*spot, *spot1, *spot2;
	int		count = 0;
	int		selection;
	float	range, range1, range2;

	spot = NULL;
	range1 = range2 = 99999;
	spot1 = spot2 = NULL;

	while ((spot = G_Find (spot, FOFS(classname), "info_player_deathmatch")) != NULL)
	{
		count++;
		range = PlayersRangeFromSpot(spot);
		if (range < range1)
		{
			range1 = range;
			spot1 = spot;
		}
		else if (range < range2)
		{
			range2 = range;
			spot2 = spot;
		}
	}

	if (!count)
		return NULL;

	if (count <= 2)
	{
		spot1 = spot2 = NULL;
	}
	else
		count -= 2;

	selection = rand() % count;

	spot = NULL;
	do
	{
		spot = G_Find (spot, FOFS(classname), "info_player_deathmatch");
		if (spot == spot1 || spot == spot2)
			selection++;
	} while(selection--);

	return spot;
}





void MonsterSpawn (edict_t *ent, vec3_t origin, vec3_t angles)
{
	edict_t	*spot = NULL;

	spot = SelectRandomDeathmatchSpawnPointMonster ();

	// find a single player start spot
	if (!spot)
	{
		while ((spot = G_Find (spot, FOFS(classname), "info_player_start")) != NULL)
		{
			if (!game.spawnpoint[0] && !spot->targetname)
				break;

			if (!game.spawnpoint[0] || !spot->targetname)
				continue;

			if (Q_stricmp(game.spawnpoint, spot->targetname) == 0)
				break;
		}

		if (!spot)
		{
			if (!game.spawnpoint[0])
			{	// there wasn't a spawnpoint without a target, so use any
				spot = G_Find (spot, FOFS(classname), "info_player_start");
			}
			if (!spot)
				gi.error ("Couldn't find spawn point %s\n", game.spawnpoint);
		}
	}

	VectorCopy (spot->s.origin, origin);
	origin[2] += 9;
	VectorCopy (spot->s.angles, angles);

	//add standard spawn shizt
	//KillBox(ent);
	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (spot-g_edicts);
	gi.WriteByte (MZ_LOGIN);
	gi.multicast (spot->s.origin, MULTICAST_PVS);

}



void Cmd_Monster_f (void)
{
	edict_t	*ent;
	char	*monster;
//	int j;

	monster = gi.argv(2);

//	if (!(deathmatch->value))
//	{
//		safe_cprintf (NULL, PRINT_HIGH, "Cannot spawn monsters in Coop or SP\n");
//		return;
//	}
	
//	deathmatch->value=0;

//	safe_cprintf (NULL, PRINT_HIGH, "\"%s\"\n", monster);

	//START MONSTER SPAWN CODE...
	if (Q_strcasecmp(monster, "cast_punkz")==0)
	{
		ent = G_Spawn();
		ent->classname="cast_punkz";
		MonsterSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		SP_cast_punkz(ent);
		monster="cast_punkz";
		safe_cprintf (NULL, PRINT_HIGH, "Spawning %s\n", monster);
	}
	else if (Q_strcasecmp(monster, "cast_punkrl")==0)
	{
		ent = G_Spawn();
		ent->classname="cast_punkrl";
		MonsterSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		SP_cast_punkrl(ent);
		monster="cast_punkrl";
		safe_cprintf (NULL, PRINT_HIGH, "Spawning %s\n", monster);
	}
	else if (Q_strcasecmp(monster, "cast_punkfg")==0)
	{
		ent = G_Spawn();
		ent->classname="cast_punkfg";
		MonsterSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		SP_cast_punkfg(ent);
		monster="cast_punkfg";
		safe_cprintf (NULL, PRINT_HIGH, "Spawning %s\n", monster);
	}

	else if (Q_strcasecmp(monster, "cast_spider")==0)
	{
		ent = G_Spawn();
		ent->classname="cast_spider";
		MonsterSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		SP_cast_spider(ent);
		monster="cast_spider";
		safe_cprintf (NULL, PRINT_HIGH, "Spawning %s\n", monster);
	}
	
	else if (Q_strcasecmp(monster, "cast_punkgl")==0)
	{
		ent = G_Spawn();
		ent->classname="cast_punkgl";
		MonsterSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		SP_cast_punkgl(ent);
		monster="cast_punkgl";
		safe_cprintf (NULL, PRINT_HIGH, "Spawning %s\n", monster);
	}
	else if (Q_strcasecmp(monster, "cast_punkhmg")==0)
	{
		ent = G_Spawn();
		ent->classname="cast_punkhmg";
		MonsterSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		SP_cast_punkhmg(ent);
		monster="cast_punkhmg";
		safe_cprintf (NULL, PRINT_HIGH, "Spawning %s\n", monster);
	}
	else if (Q_strcasecmp(monster, "cast_punktg")==0)
	{
		ent = G_Spawn();
		ent->classname="cast_punktg";
		MonsterSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		SP_cast_punktg(ent);
		monster="cast_punktg";
		safe_cprintf (NULL, PRINT_HIGH, "Spawning %s\n", monster);
	}
	else if (Q_strcasecmp(monster, "cast_thug")==0)
	{
		ent = G_Spawn();
		ent->classname="cast_thug";
		MonsterSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		SP_cast_thug(ent);
		monster="cast_thug";
		safe_cprintf (NULL, PRINT_HIGH, "Spawning %s\n", monster);
	}
	else if (Q_strcasecmp(monster, "cast_bitch")==0)
	{
		ent = G_Spawn();
		ent->classname="cast_bitch";
		MonsterSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		SP_cast_bitch(ent);
		monster="cast_bitch";
		safe_cprintf (NULL, PRINT_HIGH, "Spawning %s\n", monster);
	}
	else if (Q_strcasecmp(monster, "cast_dog")==0)
	{
		ent = G_Spawn();
		ent->classname="cast_dog";
		MonsterSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		SP_cast_dog(ent);
		monster="cast_dog";
		safe_cprintf (NULL, PRINT_HIGH, "Spawning %s\n", monster);
	}
	else if (Q_strcasecmp(monster, "cast_runt")==0)
	{
		ent = G_Spawn();
		ent->classname="cast_runt";
		MonsterSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		SP_cast_runt(ent);
		monster="cast_runt";
		safe_cprintf (NULL, PRINT_HIGH, "Spawning %s\n", monster);
	}
	
	else if (Q_strcasecmp(monster, "cast_bum_sitz")==0)
	{
		ent = G_Spawn();
		ent->classname="cast_bum_sitz";
		MonsterSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		SP_cast_bum_sitz(ent);
		monster="cast_bum_sitz";
		safe_cprintf (NULL, PRINT_HIGH, "Spawning %s\n", monster);
	}
	
	else if (Q_strcasecmp(monster, "cast_shortyz")==0)
	{
		ent = G_Spawn();
		ent->classname="cast_shortyz";
		MonsterSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		SP_cast_shortyz(ent);
		monster="cast_shortyz";
		safe_cprintf (NULL, PRINT_HIGH, "Spawning %s\n", monster);
	}
/*	
	else if (Q_strcasecmp(monster, "cast_whore")==0)
	{
		ent = G_Spawn();
		ent->classname="cast_whore";
		MonsterSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		SP_cast_whore(ent);
		monster="cast_whore";
		safe_cprintf (NULL, PRINT_HIGH, "Spawning %s\n", monster);
	}
	
*/	
	
	
	
	
	else if ((Q_strcasecmp(monster, "rand")==0)||
			 (Q_strcasecmp(monster, "random")==0)||
			 (Q_strcasecmp(monster, "")==0))
	{
		ent = G_Spawn();
		MonsterSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		if (random()>.8)
		{
			ent->classname="";
			monster="Hover";
//			SP_monster_hover(ent);
		}
		else if (random()>.85)
		{
			ent->classname="monster_floater";
			monster="Floater";
//			SP_monster_floater(ent);
		}
		else if (random()>.85)
		{
			ent->classname="monster_mutant";
			monster="Mutant";
//			SP_monster_mutant(ent);
		}
		else if (random()>.85)
		{
			ent->classname="monster_chick";
			monster="Chick";
//			SP_monster_chick(ent);
		}
		else if (random()>.85)
		{
			ent->classname="monster_soldier_ss";
			monster="SMG Soldier";
//			SP_monster_soldier_ss(ent);
		}
		else if (random()>.85)
		{
			ent->classname="monster_soldier";
			monster="Shotgun Soldier";
//			SP_monster_soldier(ent);
		}
		else if (random()>.85)
		{
			ent->classname="monster_soldier_light";
			monster="Blaster Soldier";
//			SP_monster_soldier_light(ent);
		}
		else if (random()>.85)
		{
			ent->classname="monster_infantry";
			monster="Infantry";
//			SP_monster_infantry(ent);
		}
		else if (random()>.85)
		{
			ent->classname="monster_gunner";
			monster="Gunner";
//			SP_monster_gunner(ent);
		}
		else
		{
			ent->classname="monster_berserk";
			monster="Berserk";
//			SP_monster_berserk(ent);
		}
		safe_cprintf (NULL, PRINT_HIGH, "Spawning %s\n", monster);
	}
	else
	{
		safe_cprintf (NULL, PRINT_HIGH, "Invalid Monster\n");
//		deathmatch->value=1;
		return;
	}
	//END MONSTER SPAWN CODE
	//clear spawn point

//	ent->target_ent = ent;
//	ent->MonsterFind = ent;
//	ent->enemy = ent;
//	ent->goalentity = ent;
//	ent->movetarget = ent;

//	deathmatch->value=1;
}
