
#include "g_local.h"
#include "m_player.h"

#include "voice_punk.h"
#include "voice_bitch.h"

#define CHECKFIXED(a)\
if (fixed_gametype) cprintf(ent,PRINT_HIGH,"This server's game type may not be changed\n");\
else {gi.cvar_set(a,value);cprintf(ent,PRINT_HIGH,"This setting will take effect with a map change\n");}

// BEGIN:	Xatrix/Ridah/Navigator/23-mar-1998
int		showpath_on=false;
edict_t	*showpath_ent;

void Cmd_NavDebugDest_f (edict_t *ent)
{
	if (deathmatch->value)
	{
		cprintf(ent, PRINT_HIGH, "This command only available when deathmatch = 0\n");
		return;
	}

	if (!showpath_ent)
	{	// spawn it
		showpath_ent = G_Spawn();
		showpath_ent->s.modelindex = 255;
	}

	VectorCopy( ent->s.origin, showpath_ent->s.origin );
	gi.linkentity(showpath_ent);
}

void Cmd_NavDebugShowPath_f (edict_t *ent)
{
	if (deathmatch->value)
	{
		cprintf(ent, PRINT_HIGH, "This command only available when deathmatch = 0\n");
		return;
	}

	if (!(showpath_on))
	{		// enable path
		Cmd_NavDebugDest_f (ent);
		showpath_on = true;
	}
	else	// disable path
	{
		showpath_on = false;
//		ent->nav_build_data->flags &= ~NBD_SHOWPATH;

		// kill the destination entity
		G_FreeEdict(showpath_ent);
		showpath_ent = NULL;
	}
}

// Clears the nav_data for the current level
void Cmd_NavClear_f ( edict_t *self )
{
	if (deathmatch->value)
	{
		cprintf(self, PRINT_HIGH, "This command only available when deathmatch = 0\n");
		return;
	}

	// clear the current nodes
	level.node_data->modified = false;
	NAV_PurgeActiveNodes ( level.node_data );

	// create the node data structure
	level.node_data = gi.TagMalloc (sizeof (active_node_data_t), TAG_GAME);
	NAV_InitActiveNodes	( level.node_data );
	NAV_WriteActiveNodes ( level.node_data, level.mapname );

	gi.AddCommandString( "echo \necho Cleared Navigational Data, closing down server.\necho \ndisconnect\n" );
}

// END:		Xatrix/Ridah/Navigator/23-mar-1998

//--------------------------------------------------------
// TEAMPLAY commands
extern void ClientBeginDeathmatch (edict_t *ent);

// Papa - add player to specator
void Cmd_Spec_f (edict_t *self)
{
	
	if (self->client->pers.spectator == SPECTATING && !self->client->pers.team)
		return;

	if (teamplay->value && self->client->pers.team) {
		gi.bprintf (PRINT_MEDIUM, "%s left %s\n", self->client->pers.netname, team_names[self->client->pers.team]);
		meansOfDeath = MOD_RESTART;
	} else
		meansOfDeath = MOD_SUICIDE;

	self->client->pers.team = 0;
	self->client->pers.spectator = SPECTATING;
	
	self->flags &= ~FL_GODMODE;
	self->health = 0;
//	meansOfDeath = MOD_SUICIDE;
	player_die (self, self, self, 1, vec3_origin, 0, 0);

	ClientBeginDeathmatch( self );

	if (level.modeset==TEAMPLAY || level.modeset==MATCH
		|| level.modeset==STARTINGPUB || level.modeset==STARTINGMATCH)
		UPDATERATE(self)
}


// Papa - add plater to a team
void Cmd_Join_f (edict_t *self, char *teamcmd)
{
	int	i;
	char str1[MAX_QPATH], varteam[MAX_QPATH];

	//curse adds a limiting timer to prevent overflows
	if (self->client->last_wave > (level.time - 1) && (self->client->last_wave <= level.time)) return;
	self->client->last_wave = level.time;

	if ((!teamplay->value) && (self->client->pers.spectator == SPECTATING))
	{
		self->client->pers.spectator = PLAYING;
		self->flags &= ~FL_GODMODE;
		self->health = 0;
		meansOfDeath = MOD_RESTART;
		self->solid = SOLID_NOT;
		player_die (self, self, self, 1, vec3_origin, 0, 0);
		ClientBeginDeathmatch( self );	
		if (level.modeset==TEAMPLAY || level.modeset==STARTINGPUB)
			UPDATERATE(self)
		return;
	}

	strcpy( varteam, teamcmd );

	// search for the team-name

	if (varteam && varteam[0])
	{
		for (i=1; team_names[i]; i++)
		{
			strcpy(str1, team_names[i]);
			kp_strlwr(str1);
			kp_strlwr(varteam);

			if (strstr( str1, varteam ) == str1)
			{	// found a match

				if (self->client->pers.team == i)
				{
					cprintf( self, PRINT_HIGH, "Already a member of %s\n", team_names[i] );
				}
				else
				{
					if (self->client->pers.spectator!=SPECTATING
						&& level.framenum < (self->switch_teams_frame + 20)) {
						cprintf(self,PRINT_HIGH,"Overflow protection: Unable to change team yet\n");
						return;
					}
					self->switch_teams_frame = level.framenum;

					// kill us if currently in game
					if ((self->client->pers.team) && (!(level.modeset == MATCHSETUP) || (level.modeset == FINALCOUNT) || (level.modeset == FREEFORALL)))
					{
Cmd_Spec_f (self);
/*						self->flags &= ~FL_GODMODE;
						self->health = 0;
						meansOfDeath = MOD_RESTART;
						self->solid = SOLID_NOT;
						player_die (self, self, self, 1, vec3_origin, 0, 0);
						ClientBeginDeathmatch( self );	
*/					}

					if (!Teamplay_ValidateJoinTeam( self, i ))
					{
						cprintf( self, PRINT_HIGH, "Unable to join %s\n", team_names[i] );
					}
				}

				if (level.modeset==TEAMPLAY || level.modeset==MATCH
					|| level.modeset==STARTINGPUB || level.modeset==STARTINGMATCH)
				UPDATERATE(self)
				return;
			}
		}

		cprintf( self, PRINT_HIGH, "Un-matched team: %s\n", varteam );
	}
}


void Cmd_GearUp_f (edict_t *self)
{
	vehicle_t *vehicle;

	if (!self->vehicle_index)
	{
		cprintf( self, PRINT_HIGH, "You aren't in a vehicle, can't change gears.\n");
		return;
	}

	vehicle = &global_vehicles[self->vehicle_index - 1];

	vehicle->gear++;
	if (vehicle->gear == vehicle->def->gearbox->num_gears)
		vehicle->gear--;

}

void Cmd_GearDown_f (edict_t *self)
{
	vehicle_t *vehicle;

	if (!self->vehicle_index)
	{
		cprintf( self, PRINT_HIGH, "You aren't in a vehicle, can't change gears.\n");
		return;
	}

	vehicle = &global_vehicles[self->vehicle_index - 1];

	vehicle->gear--;
	if (vehicle->gear < 0)
		vehicle->gear = vehicle->def->gearbox->num_gears - 1;
}

// Saves the current LightPaint data
void Cmd_BurnSave_f (edict_t *self)
{
	cvar_t	*game_dir, *base_dir;
	char	filename[MAX_QPATH], dir[MAX_QPATH];
	int		i;
	FILE	*f;

	if (deathmatch->value)
	{
		cprintf(self, PRINT_HIGH, "This command only available when deathmatch = 0\n");
		return;
	}

	game_dir = gi.cvar("game", "", 0);
	base_dir = gi.cvar("basedir", "", 0);

	// dir, eg: .\main\maps
	strcpy( dir, base_dir->string);
	strcat( dir, DIR_SLASH);

	if (strlen(game_dir->string) == 0)
		strcat( dir, "main");
	else
		strcat( dir, game_dir->string);

	strcat( dir, DIR_SLASH);
	strcat( dir, "maps");

	// filename, eg: .\main\maps\skidrow.pnt
	strcpy( filename, dir);
	strcat( filename, DIR_SLASH);
	strcat( filename, level.mapname);
	strcat( filename, ".pnt");

	// try and open the file for writing
	f = fopen ( filename, "a+b");
	if (!f)
	{
		cprintf ( self, PRINT_HIGH, "Couldn't open %s for writing.\n", filename);
		return;
	}

	for (i=0; i<num_lpbuf; i++)
	{
		fwrite( lpbuf[i], LP_SIZE, 1, f );

		free( lpbuf[i] );
	}

	num_lpbuf = 0;

	fclose( f );

	cprintf ( self, PRINT_HIGH, "Saved LightPaint to %s.\n", filename);
}

#if 0	// turn this off once we have the tables (not used by actual game code)

//-------------------------------------------------------------
// Ridah, only used to calculate the new x_anorms.h
void Cmd_Anorms_f (void)
{
	#define	NUM_PITCH_STEPS	8

	vec3_t	angles;
	int		step, yawstep;
	int		step_sections[9] = {32,28,24,20,16,12,8,4};

	vec3_t	out_normals[256];
	int		count=0;

	if (maxclients->value > 1)
		return;

	VectorClear( angles );

	// do the positive pitch step
	for (step=0; step < NUM_PITCH_STEPS; step++)
	{

		angles[PITCH] = ((90.0 / NUM_PITCH_STEPS) * (float)step);

		// go around the Z axis

		for (yawstep=0; yawstep < step_sections[step]; yawstep++)
		{

			angles[YAW] = ((360.0 / step_sections[step]) * (float)yawstep);

			AngleVectors( angles, out_normals[count++], NULL, NULL );

		}

	}

	// do the negative pitch step
	for (step=1; step < NUM_PITCH_STEPS; step++)
	{

		angles[PITCH] = ((90.0 / NUM_PITCH_STEPS) * (float)(-step));

		// go around the Z axis

		for (yawstep=0; yawstep < step_sections[step]; yawstep++)
		{

			angles[YAW] = ((360.0 / step_sections[step]) * (float)yawstep);

			AngleVectors( angles, out_normals[count++], NULL, NULL );

		}

	}

	gi.dprintf( "Anorm calculation completed, %i normals produced\n", count );

	{
		char	filename[MAX_QPATH];
		int		i;
		char	str[256];
		FILE	*f;

		// filename, eg: .\gamedir\routes\map01.nav
		strcpy( filename, "\\kingpin\\source\\ref_gl\\x_anorms.h");

		// try and open the file for writing
		f = fopen ( filename, "wb");
		if (!f) gi.error ("Couldn't open %s for writing.", filename);

		for (i=0; i<count; i++)
		{
			sprintf( str, "{%f, %f, %f},\n", out_normals[i][0], out_normals[i][1], out_normals[i][2] );

			fwrite( str, strlen(str), 1, f );
		}

		fclose(f);

		gi.dprintf( "%s saved\n", filename );

	}

}

#define	NUM_ANORMS	162		// old table only has 162

vec3_t	anorms[NUM_ANORMS] = {
#include "../client/anorms.h"
};

void Cmd_Adots_f (void)
{
	int	i, j;
	float	adots[NUM_ANORMS][NUM_ANORMS];

	for (i=0; i<NUM_ANORMS; i++)
	{
		for (j=0; j<NUM_ANORMS; j++)
		{
			adots[i][j] = DotProduct( anorms[i], anorms[j] );
		}
	}

	gi.dprintf( "Adot calculation completed.\n" );

	{
		char	filename[MAX_QPATH];
		int		i;
		char	str[256];
		FILE	*f;

		// filename, eg: .\gamedir\routes\map01.nav
		strcpy( filename, "\\kingpin\\source\\ref_gl\\x_adots.h");

		// try and open the file for writing
		f = fopen ( filename, "wb");
		if (!f) gi.error ("Couldn't open %s for writing.", filename);

		sprintf( str, "{\n" );
		fwrite( str, strlen(str), 1, f );

		for (i=0; i<NUM_ANORMS; i++)
		{

			sprintf( str, "{" );
			fwrite( str, strlen(str), 1, f );

			for (j=0; j<NUM_ANORMS; j++)
			{
				if (j > 0)
				{
					sprintf( str, ", " );
					fwrite( str, strlen(str), 1, f );
				}

				sprintf( str, "%f", adots[i][j] );
				fwrite( str, strlen(str), 1, f );
			}

			sprintf( str, "},\n" );
			fwrite( str, strlen(str), 1, f );

		}

		sprintf( str, "}\n" );
		fwrite( str, strlen(str), 1, f );

		fclose(f);

		gi.dprintf( "%s saved\n", filename );

	}

}

//-------------------------------------------------------------
#endif


// Caution: if using this to spawn an entity that hasn't been precached, this will cause problems
void Cmd_Spawn_f (edict_t *ent)
{
	edict_t *spawn;
	char *name;
	vec3_t	forward;
	if(deathmatch->value) return; // curse

	spawn = G_Spawn();

	name = gi.args ();
	spawn->classname = gi.TagMalloc(sizeof(name)+1, TAG_LEVEL);
	strcpy( spawn->classname, name );

	AngleVectors( ent->s.angles, forward, NULL, NULL);
	VectorScale( forward, 64, forward );
	forward[2] += 16;

	VectorAdd( ent->s.origin, forward, spawn->s.origin );
	VectorCopy( ent->s.angles, spawn->s.angles );

	ED_CallSpawn (spawn);
}

//-------------------------------------------------------------

void P_ClearProfanity ( edict_t *ent )
{
	ent->owner->profanity_level = 0;

	G_FreeEdict( ent );
}

void Cmd_Speech_f (edict_t *ent, edict_t *other, char *cmd)
{
	static		float speechtime=0;
	edict_t		*best=NULL;
	cast_memory_t	*mem;

	if (deathmatch->value)
	{
		cprintf (ent, PRINT_HIGH, "No speech in deathmatch\n");
		return;
	}

	if (speechtime > (level.time - TALK_OTHER_DELAY) && speechtime < level.time)
		return;

	if (Q_stricmp (cmd, "key1") == 0)		// NEUTRAL
	{
		// JOSEPH 4-FEB-99 
		ent->client->ps.stats[STAT_HUD_SELF_TALK] = TT_POSITIVE;
		ent->client->hud_self_talk_time = level.time + 2.0;
		// END JOSEPH	
		
		if ((other->svflags & SVF_MONSTER) && (other->cast_info.talk))
			best = other;

		if (best)
		{
			mem = level.global_cast_memory[best->character_index][ent->character_index];

			if (!mem)
			{
				AI_RecordSighting( best, ent, VectorDistance( best->s.origin, ent->s.origin ) );
			}

//			if (strcmp (best->classname, "cast_bitch") == 0)
//				Voice_Random( ent, best, f_neutral_talk_player, F_NUM_NEUTRAL_TALK_PLAYER );
//			else
				// Voice_Random( ent, best, neutral_talk_player, NUM_NEUTRAL_TALK_PLAYER );
			Voice_Random( ent, best, neutral_talk_player, 5 );


			// character should turn to us
			best->cast_info.last_talk_turn = level.time;
			best->cast_info.talk_ent = ent;

			AI_CheckTalk( best );
		}
		else
		{
			cprintf(ent, PRINT_HIGH, "No-one to talk to.\n");
		}
	}
	else if (Q_stricmp (cmd, "key3") == 0)		// AGGRESSIVE
	{
		// JOSEPH 4-FEB-99 
		ent->client->ps.stats[STAT_HUD_SELF_TALK] = TT_NEGATIVE;
		ent->client->hud_self_talk_time = level.time + 2.0;
		// END JOSEPH
		
		if (	(other->svflags & SVF_MONSTER) 
			&&	(other->cast_info.talk)
			&&	(other->cast_group != ent->cast_group))
		{
			best = other;
		}

		if (best)
		{

			mem = level.global_cast_memory[best->character_index][ent->character_index];

			if (!mem)
			{
				AI_RecordSighting( best, ent, VectorDistance( best->s.origin, ent->s.origin ) );
			}

			mem->flags |= MEMORY_ASSHOLE;

			// Ridah, hack so Momo knows if we swear at him twice
			if (best->name_index == NAME_MOMO)
			{
				if (mem->inc < 3)
				{
					mem->flags &= ~MEMORY_UPSET;	// clear it so we charge them 30 bucks
				}

				// if (ent->episode_flags & EP_SKIDROW_MOMO_ASKED_MONEY)
				// 	mem->inc++;
				EP_CheckMomo (ent, mem);

			}

			if (best->cast_group)
			{
				if (ent->profanity_level == 0)
					Voice_Random( ent, best, player_profanity_level1, NUM_PLAYER_PROFANITY_LEVEL1 );
				else if (ent->profanity_level == 1)
					Voice_Random( ent, best, player_profanity_level2, NUM_PLAYER_PROFANITY_LEVEL2 );
				else
					Voice_Random( ent, best, player_profanity_level3, NUM_PLAYER_PROFANITY_LEVEL3 );

				if (ent->profanity_level < 3)
					ent->profanity_level++;

				if (ent->profanity_level == 3)
				{	// spawn an entity, that will return us to normal profanity in a second
					edict_t *thinkent;

					thinkent = G_Spawn();
					thinkent->think = P_ClearProfanity;
					thinkent->nextthink = level.time + 4.0;
					thinkent->owner = ent;
				}
			}
			else
			{
				Voice_Random( ent, best, player_profanity_level1, NUM_PLAYER_PROFANITY_LEVEL1 );
			}

			// character should turn to us
			best->cast_info.last_talk_turn = level.time;	// so they don't look for AI characters
			best->cast_info.talk_ent = ent;

			AI_CheckTalk( best );
		}
		else
		{
			cprintf(ent, PRINT_HIGH, "No-one to abuse.\n");
		}
	}
	else
	{
//		cprintf( ent, PRINT_HIGH, "Unknown Speech command\n" );
		return;
	}

	speechtime = level.time;

}

/*
==================
Cmd_Order_f

1. hold = Hold Position
2. move = Move Out
3. converge = Converge on my position
===================
*/
edict_t *Order_MoveOut (edict_t *ent);

qboolean FullGang (edict_t *player)
{
	edict_t	*ent;
	cast_memory_t *mem;
	int		i;
	int		cnt = 0;
	
	for (i=1, ent=g_edicts+i ; i < globals.num_edicts ; i++,ent++)
	{
		if (ent->client)
			continue;
		if (!(ent->inuse))
			continue;
		if (ent->deadflag == DEAD_DEAD)
			continue;
		if (ent->cast_group != 1)
			continue;
		
		mem = level.global_cast_memory [ent->character_index][player->character_index];
		
		if (mem && mem->flags & MEMORY_HIRED)
			cnt++;

		if (cnt == 2)
			return true;

	}

	return false;
}


void Cmd_Order_f (edict_t *ent, edict_t *other, char *cmd)
{
	int			flags = 0;
	static		float ordertime=0;
	static		int last_voice;
	qboolean	firstime = false;
	
	if (deathmatch->value)
	{
		cprintf (ent, PRINT_HIGH, "No orders in deathmatch\n");
		return;
	}

	if (Q_stricmp (cmd, "key1") == 0)		// Stay Here
		flags = ORDER_FOLLOWME;
	else if (Q_stricmp (cmd, "key2") == 0)	// Attack
		flags = ORDER_MOVE;
	else if (Q_stricmp (cmd, "key3") == 0)	// Follow
		flags = ORDER_HOLD;

	ent->order = flags;
	ent->order_timestamp = level.time;

//	if (other->cast_info.aiflags & AI_TAKE_COVER)
//		return;	// can't order a hiding dude

	if (ent->client)
	{
		cast_memory_t *cast_memory;

		cast_memory = level.global_cast_memory[other->character_index][ent->character_index];

		if (!EP_HiredGuys (ent, other))
		{
			// Ridah, 21-may-99, so they make a talking jesture if they just said something
			if (other->last_talk_time == level.time)
				other->cast_info.talk( other );

			return;
		}

		if (other->gender == GENDER_MALE)
		{

		// RAFAEL 02-18-99	
		if (!(cast_memory->flags & MEMORY_HIRED)) // if the dude is not hired
		{
			if (flags == ORDER_MOVE)	// not a valid command
				return;

			// if (FullGang (ent)) // if the gang is full
			if (ent->client->pers.friends >= 2)
			{
				if (other->last_talk_time < (level.time - 2) || last_voice != 6)
					Voice_Random (other, ent, &hiredguy_specific[6], 2);

				other->cast_info.talk( other );
				last_voice = 6;
				return;
			}
		}


		if (!(cast_memory->flags & MEMORY_HIRE_FIRST_TIME))
		{
			cast_memory->flags |= MEMORY_HIRE_FIRST_TIME;
			{
				int rval;
				rval = abs (other->currentcash);

				// JOSEPH 19-FEB-99
				if (flags == ORDER_FOLLOWME)
				{
					ent->client->ps.stats[STAT_HUD_SELF_TALK] = TT_YES;
					ent->client->hud_self_talk_time = level.time + 2.0;
				}
				else if (flags == ORDER_HOLD)
				{
					ent->client->ps.stats[STAT_HUD_SELF_TALK] = TT_NO;
					ent->client->hud_self_talk_time = level.time + 2.0;
				}
				// END JOSEPH
				
				// gi.dprintf ("yo man I'll follow ya fer %d bucks\n", rval);

				if (other->last_talk_time < (level.time - 2) || last_voice != 1)
					// this line chooses the correct sound to play.. (even switches between the first and second for consecutive calls)
					Voice_Specific( other, ent, hiredguy_ask, ((rval / 25) * 2) + (hiredguy_ask[((rval / 25) * 2)].last_played > hiredguy_ask[((rval / 25) * 2) + 1].last_played) );


				other->cast_info.talk( other );

				last_voice = 1;

				return;
			}
		}
		
		else if (!(cast_memory->flags & MEMORY_HIRE_ASK))
		{
			// JOSEPH 19-FEB-99
			if (flags == ORDER_FOLLOWME)
			{
				ent->client->ps.stats[STAT_HUD_SELF_TALK] = TT_YES;
				ent->client->hud_self_talk_time = level.time + 2.0;
			}
			else if (flags == ORDER_HOLD)
			{
				ent->client->ps.stats[STAT_HUD_SELF_TALK] = TT_NO;
				ent->client->hud_self_talk_time = level.time + 2.0;
			}
			// END JOSEPH
			
			if (ent->client->pers.currentcash >= abs (other->currentcash))
			{
				if (flags == ORDER_FOLLOWME)
				{
					cast_memory->flags |= MEMORY_HIRE_ASK;

	//					gi.dprintf ("so ya got the money?\n", abs (other->currentcash));

					if (other->last_talk_time < (level.time - 2) || last_voice != 2)
						// Voice_Specific( other, ent, hiredguy_specific, 0 + (hiredguy_specific[0].last_played > hiredguy_specific[1].last_played) );
						Voice_Random (other, ent, hiredguy_specific, 2);


					other->cast_info.talk( other );
					last_voice = 2;

					return;
				}
				else if (flags == ORDER_HOLD)
				{
	//					gi.dprintf ("yo man I'll be waiting for ya\n");
					if (other->last_talk_time < (level.time - 2) || last_voice != 3)
						// Voice_Specific( other, ent, hiredguy_specific, 4 + (hiredguy_specific[4].last_played > hiredguy_specific[5].last_played) );
						Voice_Random (other, ent, &hiredguy_specific[4], 2);

					other->cast_info.talk( other );
					last_voice = 3;
					return;
				}
				else	// invalid response
				{
					gi.dprintf( "\nInvalid response.\nkey1 = YES\nkey3 = NO\n" );
					return;
				}
			}
			else
			{
	//				gi.dprintf ("yo man come to me when you got %d bucks\n", abs (other->currentcash));
				if (other->last_talk_time < (level.time - 2) || last_voice != 4)
					Voice_Random( other, ent, &hiredguy_specific[11], 3 );

				other->cast_info.talk( other );
				last_voice = 4;
				return;
			}
		}
		
		else if (!(cast_memory->flags & MEMORY_HIRED))
		{
			// JOSEPH 19-FEB-99
			if (flags == ORDER_HOLD)
			{
				ent->client->ps.stats[STAT_HUD_SELF_TALK] = TT_NO;
				ent->client->hud_self_talk_time = level.time + 2.0;
			}
			else if (flags == ORDER_FOLLOWME)
			{
				ent->client->ps.stats[STAT_HUD_SELF_TALK] = TT_YES;
				ent->client->hud_self_talk_time = level.time + 2.0;
			}
			// END JOSEPH
			
			// JOSEPH 3-FEB-99 
			if (ent->client->pers.currentcash >= abs (other->currentcash))
			{
				if (flags == ORDER_FOLLOWME)
				{	// give them the money
					extern mmove_t	thug_move_crch_grab;

					cast_memory->flags |= MEMORY_HIRED;
					ent->client->pers.currentcash -= abs (other->currentcash);
					
					// other->currentcash = abs(other->currentcash);
					other->currentcash = 0;

					ent->client->pers.friends++;

					if (!strcmp(other->classname, "cast_thug"))
					{
						other->cast_info.currentmove = &thug_move_crch_grab;
					}

					other->cast_info.aiflags |= AI_NOWALK_FACE;

					// we just hired them, by default they should follow us
					flags = ORDER_FOLLOWME;
					firstime = true;

					EP_HiredGuysRegisterFlags (ent, other);
				}
				else if (flags == ORDER_HOLD)
				{
	//					gi.dprintf ("yo man I'll be here if you change your mind\n");
					
					cast_memory->flags &= ~MEMORY_HIRE_ASK;

					if (other->last_talk_time < (level.time - 2) || last_voice != 5)
						Voice_Specific( other, ent, hiredguy_specific, 2 );
					other->cast_info.talk( other );
					last_voice = 5;
					return;
				}
			}
			// END JOSEPH
			else
			{
	//				gi.dprintf ("yo man come to me when you got %d bucks\n", abs (other->currentcash));
				if (other->last_talk_time < (level.time - 2) || last_voice != 6)
					Voice_Specific( other, ent, hiredguy_specific, 3 );
				other->cast_info.talk( other );
				last_voice = 6;
				return;
			}
		}
	}
		else // GENDER_FEMALE
		{
					// RAFAEL 02-18-99	
			if (!(cast_memory->flags & MEMORY_HIRED)) // if the dude is not hired
			{
				if (flags == ORDER_MOVE)	// not a valid command
					return;

				// if (FullGang (ent)) // if the gang is full
				if (ent->client->pers.friends >= 2)
				{
					if (other->last_talk_time < (level.time - 2) || last_voice != 6)
						Voice_Random (other, ent, &hiredgal_specific[6], 2);

					other->cast_info.talk( other );
					last_voice = 6;
					return;
				}
			}


			if (!(cast_memory->flags & MEMORY_HIRE_FIRST_TIME))
			{
				cast_memory->flags |= MEMORY_HIRE_FIRST_TIME;
				{
					int rval;
					rval = abs (other->currentcash);

					// JOSEPH 19-FEB-99
					if (flags == ORDER_FOLLOWME)
					{
						ent->client->ps.stats[STAT_HUD_SELF_TALK] = TT_YES;
						ent->client->hud_self_talk_time = level.time + 2.0;
					}
					else if (flags == ORDER_HOLD)
					{
						ent->client->ps.stats[STAT_HUD_SELF_TALK] = TT_NO;
						ent->client->hud_self_talk_time = level.time + 2.0;
					}
					// END JOSEPH
					
					// gi.dprintf ("yo man I'll follow ya fer %d bucks\n", rval);

					if (other->last_talk_time < (level.time - 2) || last_voice != 1)
						// this line chooses the correct sound to play.. (even switches between the first and second for consecutive calls)
						Voice_Specific( other, ent, hiredgal_ask, ((rval / 25) * 2) + (hiredgal_ask[((rval / 25) * 2)].last_played > hiredgal_ask[((rval / 25) * 2) + 1].last_played) );


					other->cast_info.talk( other );

					last_voice = 1;

					return;
				}
			}
			
			else if (!(cast_memory->flags & MEMORY_HIRE_ASK))
			{
				// JOSEPH 19-FEB-99
				if (flags == ORDER_FOLLOWME)
				{
					ent->client->ps.stats[STAT_HUD_SELF_TALK] = TT_YES;
					ent->client->hud_self_talk_time = level.time + 2.0;
				}
				else if (flags == ORDER_HOLD)
				{
					ent->client->ps.stats[STAT_HUD_SELF_TALK] = TT_NO;
					ent->client->hud_self_talk_time = level.time + 2.0;
				}
				// END JOSEPH
				
				if (ent->client->pers.currentcash >= abs (other->currentcash))
				{
					if (flags == ORDER_FOLLOWME)
					{
						cast_memory->flags |= MEMORY_HIRE_ASK;

	//					gi.dprintf ("so ya got the money?\n", abs (other->currentcash));

						if (other->last_talk_time < (level.time - 2) || last_voice != 2)
							// Voice_Specific( other, ent, hiredguy_specific, 0 + (hiredguy_specific[0].last_played > hiredguy_specific[1].last_played) );
							Voice_Random (other, ent, hiredgal_specific, 2);


						other->cast_info.talk( other );
						last_voice = 2;

						return;
					}
					else if (flags == ORDER_HOLD)
					{
	//					gi.dprintf ("yo man I'll be waiting for ya\n");
						if (other->last_talk_time < (level.time - 2) || last_voice != 3)
							// Voice_Specific( other, ent, hiredguy_specific, 4 + (hiredguy_specific[4].last_played > hiredguy_specific[5].last_played) );
							Voice_Random (other, ent, &hiredgal_specific[4], 2);

						other->cast_info.talk( other );
						last_voice = 3;
						return;
					}
					else	// invalid response
					{
						gi.dprintf( "\nInvalid response.\nkey1 = YES\nkey3 = NO\n" );
						return;
					}
				}
				else
				{
	//				gi.dprintf ("yo man come to me when you got %d bucks\n", abs (other->currentcash));
					if (other->last_talk_time < (level.time - 2) || last_voice != 4)
						Voice_Specific( other, ent, hiredgal_specific, 3 );

					other->cast_info.talk( other );
					last_voice = 4;
					return;
				}
			}
			
			else if (!(cast_memory->flags & MEMORY_HIRED))
			{
				// JOSEPH 19-FEB-99
				if (flags == ORDER_HOLD)
				{
					ent->client->ps.stats[STAT_HUD_SELF_TALK] = TT_NO;
					ent->client->hud_self_talk_time = level.time + 2.0;
				}
				else if (flags == ORDER_FOLLOWME)
				{
					ent->client->ps.stats[STAT_HUD_SELF_TALK] = TT_YES;
					ent->client->hud_self_talk_time = level.time + 2.0;
				}
				// END JOSEPH
				
				// JOSEPH 3-FEB-99 
				if (ent->client->pers.currentcash >= abs (other->currentcash))
				{
					if (flags == ORDER_FOLLOWME)
					{	// give them the money
						extern mmove_t	thug_move_crch_grab;

						cast_memory->flags |= MEMORY_HIRED;
						ent->client->pers.currentcash -= abs (other->currentcash);
						
						// other->currentcash = abs(other->currentcash);
						other->currentcash = 0;

						ent->client->pers.friends++;

						/*
						if (!strcmp(other->classname, "cast_thug"))
						{
							other->cast_info.currentmove = &thug_move_crch_grab;
						}
						*/

						other->cast_info.aiflags |= AI_NOWALK_FACE;

						// we just hired them, by default they should follow us
						flags = ORDER_FOLLOWME;
						firstime = true;


						EP_HiredGuysRegisterFlags (ent, other);
					}
					else if (flags == ORDER_HOLD)
					{
	//					gi.dprintf ("yo man I'll be here if you change your mind\n");
						
						cast_memory->flags &= ~MEMORY_HIRE_ASK;

						if (other->last_talk_time < (level.time - 2) || last_voice != 5)
							Voice_Specific( other, ent, hiredgal_specific, 2 );
						other->cast_info.talk( other );
						last_voice = 5;
						return;
					}
				}
				// END JOSEPH
				else
				{
	//				gi.dprintf ("yo man come to me when you got %d bucks\n", abs (other->currentcash));
					if (other->last_talk_time < (level.time - 2) || last_voice != 6)
						Voice_Specific( other, ent, hiredgal_specific, 3 );
					other->cast_info.talk( other );
					last_voice = 6;
					return;
				}
			}
		}
	}

	// if in bar, don't allow killing
	if (flags == ORDER_MOVE && level.bar_lvl)
	{
		// gi.dprintf("SOUND TODO: No killing in the bar\n");
		return;
	}

	// this should help with the friendly guys not showing up when you change level
	other->spawnflags &= ~2; 
	other->currentcash = 0;
	other->leader = ent;

	other->cast_info.aiflags &= ~(AI_MOVEOUT | AI_HOLD_POSITION);
	other->cast_info.aiflags &= ~AI_NOWALK_FACE;

	if (other->holdpos_ent)
	{
		G_FreeEdict( other->holdpos_ent );
		other->holdpos_ent = NULL;
	}

	if (flags == ORDER_MOVE)
	{
		if (EP_DoKey (ent, other))
		{
			ent->cast_info.aiflags |= AI_DOKEY;
			other->cast_info.aiflags |= AI_DOKEY;
		}
		else
		{
		ent->cast_info.aiflags |= AI_MOVEOUT;
		other->cast_info.aiflags |= AI_MOVEOUT;

		if (ent->moveout_ent)
		{	// in case it was set before, kill it
			ent->moveout_ent = NULL;
		}
	}
	}

	if (ordertime > level.time)		// changed levels
		ordertime = 0;

	switch (flags)
	{
	case ORDER_MOVE :
		{
			if (ordertime < (level.time - 0.5))
			{
				Voice_Random( ent, other, m_response, NUM_MOVEOUT );
			}
			break;
		}
	case ORDER_HOLD :
		{
			if (ordertime < (level.time - 0.5))
				Voice_Random( ent, other, holdposition, NUM_HOLDPOSITION );
			other->cast_info.aiflags |= AI_HOLD_POSITION;
			other->cast_info.aiflags |= AI_NOWALK_FACE;

			// remember this position
			if (!other->holdpos_ent)
				other->holdpos_ent = G_Spawn();

			VectorCopy( other->s.origin, other->holdpos_ent->s.origin );

			break;
		}
	case ORDER_FOLLOWME :
		{
			if (firstime)
			{
				if (other->gender == GENDER_FEMALE)
					Voice_Random( other, ent, &hiredgal_specific[8], 3);
				else
					Voice_Specific( other, ent, hiredguy_specific, (rand()%3) + 8 );
//				gi.dprintf ("ok I'll go with ya\n");
			}
			else if (ordertime < (level.time - 0.5))
				Voice_Random( ent, other, followme, NUM_FOLLOWME );

			if (other->cast_info.aiflags & AI_TAKE_COVER)
			{
				other->cast_info.aiflags &= ~(AI_TAKE_COVER|AI_TAKECOVER_IGNOREHEALTH);
			}

			break;
		}
		
		// JOSEPH 19-FEB-99 
		if ((flags) && (!ent->client->hud_self_talk_time == (level.time + 2.0)) &&
			(!((ent->client->ps.stats[STAT_HUD_SELF_TALK] == TT_YES) || 
			(ent->client->ps.stats[STAT_HUD_SELF_TALK] == TT_NO))))
		{
		ent->client->ps.stats[STAT_HUD_SELF_TALK] = TT_COMMAND;
		ent->client->hud_self_talk_time = level.time + 2.0;
		}
		// END JOSEPH	
	}

	if (ordertime < (level.time - 0.5))
		ordertime = level.time;
}

//-------------------------------------------------------------------------
// Generic "3-key" system

edict_t *key_ent;

// JOSEPH 8-FEB-99
edict_t	*GetKeyEnt( edict_t *ent )
{
	vec3_t	dir;
	vec3_t	start, end;
	trace_t	tr;

	AngleVectors( ent->client->ps.viewangles, dir, NULL, NULL );

	VectorCopy( ent->s.origin, start );
	start[2] += ent->viewheight;

	if (deathmatch->value)
		VectorMA( start, 4000, dir, end );
	else
		VectorMA( start, 384, dir, end );

	tr = gi.trace( start, NULL, NULL, end, ent, CONTENTS_MONSTER );

	if ((tr.fraction < 1) && ((deathmatch->value && tr.ent->client) || (tr.ent->svflags & SVF_MONSTER)) && (tr.ent->name_index == NAME_MOMO))
	{
		return tr.ent;
	}

	tr = gi.trace( start, NULL, NULL, end, ent, MASK_SHOT );

	if ((tr.fraction < 1) && ((deathmatch->value && tr.ent->client) || (tr.ent->svflags & SVF_MONSTER)))
	{
		return tr.ent;
	}

	return NULL;
}
// END JOSEPH

void Cmd_Key_f (edict_t *ent)
{
	char		*cmd;

	
	if (level.speaktime > level.time)
		return;
	
	cmd = gi.argv (0);

	if (key_ent = GetKeyEnt( ent ))
	{
		void Cmd_Wave_f (edict_t *ent, edict_t *other);
		cast_memory_t *mem;

		if (deathmatch->value)
		{
			Cmd_Wave_f( ent, key_ent );
			return;
		}

		// JOSEPH 18-FEB-99 
		ent->client->ps.stats[STAT_HUD_SELF_TALK] = TT_COMMAND;
		ent->client->hud_self_talk_time = level.time + 2.0;
		// END JOSEPH	

		mem = level.global_cast_memory[key_ent->character_index][ent->character_index];

		if (!mem)
			return;

		if (mem->memory_type == MEMORY_TYPE_FRIEND)
		{	// issuing an order

			Cmd_Order_f( ent, key_ent, cmd );

			if (key_ent->targetname)
				key_ent->targetname = 0;
			if (key_ent->spawnflags & 2)
				key_ent->spawnflags &=~ 2;
			
		}
		else if (mem->response)		// we're responding to a question
		{
			response_t resp;

			if (Q_stricmp (cmd, "key1") == 0)
				resp = resp_yes;
			else if (Q_stricmp (cmd, "key3") == 0)
				resp = resp_no;

			mem->response( ent, key_ent, resp );

		}
		else	// normal discussion
		{
	
			Cmd_Speech_f ( ent, key_ent, cmd );

		}

	}
	else	// noone to talk to, so make it an order in case anyone's listening
	{
		int flags;

		if (Q_stricmp (cmd, "key1") == 0)		// Stay Here
			flags = ORDER_FOLLOWME;
		else if (Q_stricmp (cmd, "key2") == 0)	// Attack
			flags = ORDER_MOVE;
		else if (Q_stricmp (cmd, "key3") == 0)	// Follow
			flags = ORDER_HOLD;
			

		ent->order = flags;
		ent->order_timestamp = level.time;
	}


	level.speaktime = level.time + 1.0;

}

//-------------------------------------------------------------------------

// Ridah, Chasecam
void Cmd_ToggleCam_f ( edict_t *ent )
{
	if (ent->flags & FL_CHASECAM)
	{
		ent->flags += FL_CHASECAM;
	}
	else
	{
		ent->flags -= FL_CHASECAM;

		//gi.centerprintf( ent, "Chasecam is incomplete, and therefore\nunsupported at this stage\n" );
	}
}
// done.

// JOSEPH 13-APR-99
void Cmd_SetProps_f (int status)
{
	edict_t	*e;
	int		i;
					
	for (i=1, e=g_edicts+i ; i < globals.num_edicts ; i++,e++)
	{
		if ((e->svflags & SVF_PROP) && (e->option))
		{
			if (status)
			{
				e->svflags |= SVF_NOCLIENT;
				e->solid = SOLID_NOT;
			}
			else
			{
				e->svflags &= ~SVF_NOCLIENT;	
				e->solid = e->savesolid;
			}
		}
	}
}
// END JOSEPH

// JOSEPH 23-MAR-99
void Cmd_FryAll_f (edict_t *ent)
{
	edict_t	*e = NULL;

	if (deathmatch->value)	return;

	while (e = findradius(e, ent->s.origin, 512))
	{
		if (e->svflags & SVF_MONSTER)
		{
			e->onfiretime = 100;
			e->onfireent = e;

			if (e->gender == GENDER_FEMALE)
			{
				Voice_Random (e, e, &female_specific[6], 2); 
			}
			else if (e->gender == GENDER_MALE)
			{
				Voice_Random (e, e, &male_specific[10], 2); 
			}

			e->pain_debounce_time = level.time + 5;

			if (e->cast_info.catch_fire)
			{
				e->cast_info.catch_fire(e, e);
			}

			e->s.renderfx2 &= ~RF2_DIR_LIGHTS;		
		}
	}
}
// END JOSEPH

// ==============================================================================
// Quake2 code follows:

char *ClientTeam (edict_t *ent)
{
	char		*p;
	static char	value[512];
	
	value[0] = 0;

	if (!ent->client)
		return value;

	strcpy(value, Info_ValueForKey (ent->client->pers.userinfo, "skin"));
	p = strchr(value, '/');
	if (!p)
		return value;

	if ((int)(dmflags->value) & DF_MODELTEAMS)
	{
// Ridah, disabled this, teams are determined by model and skin (since that's the only way to make sure they appear the same
//		*p = 0;
		return value;
	}

	// if ((int)(dmflags->value) & DF_SKINTEAMS)
	return ++p;
}

qboolean OnSameTeam (edict_t *ent1, edict_t *ent2)
{
	char	ent1Team [512];
	char	ent2Team [512];

	if (teamplay->value)
	{
		if (ent1 && ent2 && ent1->client && ent2->client && ent1->client->pers.team && (ent1->client->pers.team == ent2->client->pers.team))
			return true;
		else
			return false;
	}

	if (!((int)(dmflags->value) & (DF_MODELTEAMS /*| DF_SKINTEAMS*/)))
		return false;

	strcpy (ent1Team, ClientTeam (ent1));
	strcpy (ent2Team, ClientTeam (ent2));

	if (strcmp(ent1Team, ent2Team) == 0)
		return true;
	return false;

}

void Cmd_Huds_tgl (edict_t *ent, int direction)
{
	//curse adds a limiting timer to prevent overflows
	if (ent->client->last_wave > (level.time - 1) && (ent->client->last_wave <= level.time)) return;
	ent->client->last_wave = level.time;

	switch(direction)
	{
		default: 
		case 1:  ent->client->showscores += 1;	break;
		case 2:  ent->client->showscores -= 1;	break;
	}

tryagain:

	if(ent->client->showscores < NO_SCOREBOARD)		ent->client->showscores = SCORE_MAP_VOTE;
	if(ent->client->showscores > SCORE_MAP_VOTE)	ent->client->showscores = NO_SCOREBOARD;

	if(		(ent->client->showscores == SCORE_REJOIN) 
		||	(ent->client->showscores == SCORE_MAP_VOTE)
		||	(ent->client->showscores == SPECTATORS)
		||	(ent->client->showscores == SCORE_MOTD)
	  )
	{
		switch(direction)
		{
		default: 
		case 1:  ent->client->showscores += 1;	break;
		case 2:  ent->client->showscores -= 1;	break;
		}	
		goto tryagain;
	}

	DeathmatchScoreboard(ent);
}

void SelectNextItem (edict_t *ent, int itflags)
{
	gclient_t	*cl;
//	int			i, index;
//	gitem_t		*it;
	int			num_vote_set;

// Papa - this is used to move down the vote map menu

	num_vote_set = num_custom_maps;
	if (num_vote_set > 8) num_vote_set = 8;
	if (ent->client->showscores == SCORE_MAP_VOTE)
	{
		if (level.framenum > (ent->switch_teams_frame + 4))
		{
			ent->vote++;
			if (ent->vote == num_vote_set+1)
				ent->vote = 1;
			ent->switch_teams_frame = level.framenum;
			DeathmatchScoreboard (ent);
		}
		return;
	}

	if (ent->client->showscores == SCORE_REJOIN)
	{
		if (level.framenum > (ent->switch_teams_frame + 4))
		{
			if (ent->vote == 0)
				ent->vote = 1;
			else
				ent->vote = 0;
			ent->switch_teams_frame = level.framenum;
			DeathmatchScoreboard (ent);
		}
		return;
	}


	cl = ent->client;
	
	if (cl->chase_target)
	{
		ChaseNext(ent);
		return;
	} else
		Cmd_Huds_tgl (ent, 1);

}

void SelectPrevItem (edict_t *ent, int itflags)
{
	gclient_t	*cl;
//	int			i, index;
//	gitem_t		*it;
	int			num_vote_set;


// Papa - this is used to move up the vote map menu

	num_vote_set = num_custom_maps;
	if (num_vote_set > 8)
		num_vote_set = 8;
	if (ent->client->showscores == SCORE_MAP_VOTE)
	{
		if (level.framenum > (ent->switch_teams_frame + 4))
		{
			ent->vote--;
			if (ent->vote < 1)
				ent->vote = num_vote_set;
			ent->switch_teams_frame = level.framenum;
			DeathmatchScoreboard (ent);
		}
		return;
	}

	if (ent->client->showscores == SCORE_REJOIN)
	{
		if (level.framenum > (ent->switch_teams_frame + 4))
		{
			if (ent->vote == 0)
				ent->vote = 1;
			else
				ent->vote = 0;
			ent->switch_teams_frame = level.framenum;
			DeathmatchScoreboard (ent);
		}
		return;
	}
	

	cl = ent->client;

	if (cl->chase_target)
	{
		ChasePrev(ent);
		return;
	} else
		Cmd_Huds_tgl (ent, 2);
}

void ValidateSelectedItem (edict_t *ent)
{
	gclient_t	*cl;

	cl = ent->client;

	if (cl->pers.inventory[cl->pers.selected_item])
		return;		// valid

	SelectNextItem (ent, -1);
}

/*
==================
Cmd_Give_f

Give items to a client
==================
*/
void Cmd_Give_f (edict_t *ent)
{
	char		*name;
	gitem_t		*it;
	int			index;
	int			i;
	qboolean	give_all;
	edict_t		*it_ent;

	if (!developer->value)
		return;

	if (deathmatch->value && !sv_cheats->value)
	{
		cprintf (ent, PRINT_HIGH, "You must run the server with '+set cheats 1' to enable this command.\n");
		return;
	}

	name = gi.args();

	if (Q_stricmp(name, "all") == 0)
		give_all = true;
	else
		give_all = false;

	// JOSEPH 15-FEB-99
	if (Q_stricmp(gi.argv(1), "cash") == 0)
	{
		if (gi.argc() == 3)
			ent->client->pers.currentcash += atoi(gi.argv(2));
		else
			ent->client->pers.currentcash += 100;

		gi.sound (ent, CHAN_AUTO, gi.soundindex("world/pickups/cash.wav"), 1, ATTN_NORM, 0);
		
		if (!give_all)
			return;
	}
	// END JOSEPH
	
	if (give_all || Q_stricmp(gi.argv(1), "health") == 0)
	{
		if (gi.argc() == 3)
			ent->health = atoi(gi.argv(2));
		else
			ent->health = ent->max_health;
		if (!give_all)
			return;
	}

	if (give_all || Q_stricmp (gi.argv(1), "mods") == 0)
	{
		ent->client->pers.pistol_mods |= WEAPON_MOD_ROF;
		
		ent->client->pers.pistol_mods |= WEAPON_MOD_RELOAD;
		
		ent->client->pers.pistol_mods |= WEAPON_MOD_DAMAGE;
		
		ent->client->pers.pistol_mods |= WEAPON_MOD_COOLING_JACKET;

		ent->client->pers.hmg_shots = 30;

		if (!give_all)
			return;
	}

	if (give_all || Q_stricmp(name, "weapons") == 0)
	{
		for (i=0 ; i<game.num_items ; i++)
		{
			it = itemlist + i;
			if (!it->pickup)
				continue;
			if (!(it->flags & IT_WEAPON))
				continue;
			
			// ent->client->pers.inventory[i] += 1;
			ent->client->pers.inventory[i] = 1;
			if (it->flags & IT_SILENCER)
			{
				ent->client->pers.silencer_shots = 20;
			}
		}
		if (!give_all)
			return;
	}

	if (give_all || Q_stricmp(name, "ammo") == 0)
	{
		for (i=0 ; i<game.num_items ; i++)
		{
			it = itemlist + i;
			if (!it->pickup)
				continue;
			if (!(it->flags & IT_AMMO))
				continue;
			if (it->flags & IT_NOCHEATS)
				continue;
			Add_Ammo (ent, it, 1000);
		}
		if (!give_all)
			return;
	}

	// JOSEPH 30-APR-99
	if (Q_stricmp(name, "armor") == 0)
	{
		gitem_t	*it;

		it = FindItem("Jacket Armor Heavy");
		ent->client->pers.inventory[ITEM_INDEX(it)] = 100;

		it = FindItem("Legs Armor Heavy");
		ent->client->pers.inventory[ITEM_INDEX(it)] = 100;

		it = FindItem("Helmet Armor Heavy");
		ent->client->pers.inventory[ITEM_INDEX(it)] = 100;

			return;
	}


	// END JOSEPH

	if (give_all)
	{
		for (i=0 ; i<game.num_items ; i++)
		{
			it = itemlist + i;
			if (!it->pickup)
				continue;
			if (it->flags & (IT_ARMOR|IT_WEAPON|IT_AMMO))
				continue;
			if (it->flags & IT_NOCHEATS)
				continue;
			ent->client->pers.inventory[i] = 1;
		}
		return;
	}

	it = FindItem (name);
	if (!it)
	{
		name = gi.argv(1);
		it = FindItem (name);
		if (!it)
		{
			cprintf (ent, PRINT_HIGH, "not a valid item\n");
			return;
		}
	}

	if (!it->pickup)
	{
		cprintf (ent, PRINT_HIGH, "non-pickup item\n");
		return;
	}

	index = ITEM_INDEX(it);

	if (it->flags & IT_AMMO)
	{
		if (gi.argc() == 3)
			ent->client->pers.inventory[index] = atoi(gi.argv(2));
		else
			ent->client->pers.inventory[index] += it->quantity;
	}
	else
	{
		it_ent = G_Spawn();
		it_ent->classname = it->classname;
		SpawnItem (it_ent, it);
		Touch_Item (it_ent, ent, NULL, NULL);
		if (it->flags & IT_SILENCER)
			ent->client->pers.silencer_shots = 20;
		if (it_ent->inuse)
			G_FreeEdict(it_ent);
		
	}
}


/*
==================
Cmd_God_f

Sets client to godmode

argv(0) god
==================
*/
void Cmd_God_f (edict_t *ent)
{
	char	*msg;

	if (!developer->value)
		return;

	if (deathmatch->value && !sv_cheats->value)
	{
		cprintf (ent, PRINT_HIGH, "You must run the server with '+set cheats 1' to enable this command.\n");
		return;
	}

	ent->flags ^= FL_GODMODE;
	if (!(ent->flags & FL_GODMODE) )
		msg = "Immortal OFF\n";
	else
		msg = "Immortal ON\n";

	cprintf (ent, PRINT_HIGH, msg);
}


/*
==================
Cmd_Notarget_f

Sets client to notarget

argv(0) notarget
==================
*/
void Cmd_Notarget_f (edict_t *ent)
{
	char	*msg;

	if (!developer->value)
		return;

	if (deathmatch->value && !sv_cheats->value)
	{
		cprintf (ent, PRINT_HIGH, "You must run the server with '+set cheats 1' to enable this command.\n");
		return;
	}

	ent->flags ^= FL_NOTARGET;
	if (!(ent->flags & FL_NOTARGET) )
		msg = "notarget OFF\n";
	else
		msg = "notarget ON\n";

	cprintf (ent, PRINT_HIGH, msg);
}


/*
==================
Cmd_Noclip_f

argv(0) noclip
==================
*/
void Cmd_Noclip_f (edict_t *ent)
{
	char	*msg;

	if (!developer->value)
		return;

	if (deathmatch->value && !sv_cheats->value)
	{
		cprintf (ent, PRINT_HIGH, "You must run the server with '+set cheats 1' to enable this command.\n");
		return;
	}

	if (ent->movetype == MOVETYPE_NOCLIP)
	{
		ent->movetype = MOVETYPE_WALK;
		msg = "noclip OFF\n";
	}
	else
	{
		ent->movetype = MOVETYPE_NOCLIP;
		msg = "noclip ON\n";
	}

	cprintf (ent, PRINT_HIGH, msg);
}


/*
==================
Cmd_Use_f

Use an inventory item
==================
*/
void Cmd_Use_f (edict_t *ent)
{
	int			index = 0;
	gitem_t		*it;
	char		*s;	
	int			i;

	s = gi.args();
	// Teamplay

// Papa
// Kingpin uses whatever key your weapon is bound to, to work its menus
// So I kept with this format for the menus that I added


	if (ent->client->showscores == SCORE_MAP_VOTE)  // next map vote menu
	{
		if (level.framenum > (ent->switch_teams_frame + 4))
			if (s)
			{
				if (!strcmp(s, "pipe"))
					ent->vote = 1;
				if (!strcmp(s, "pistol"))
					ent->vote = 2;
				if (!strcmp(s, "shotgun"))
					ent->vote = 3;
				if (!strcmp(s, "tommygun"))
					ent->vote = 4;
				if (!strcmp(s, "heavy machinegun"))
					ent->vote = 5;
				if (!strcmp(s, "grenade launcher"))
					ent->vote = 6;
				if (!strcmp(s, "bazooka"))
					ent->vote = 7;
				if (!strcmp(s, "flamethrower"))
					ent->vote = 8;
				ent->switch_teams_frame = level.framenum;
				DeathmatchScoreboard (ent);
			}
		return;
	}
			

	if (ent->client->showscores == SCORE_REJOIN) // restores players frags, time, etc after they disconnect
	{
		if (s)
		{
			for (i=0;i<level.player_num;i++)
			{
				if (Q_stricmp (ent->client->pers.netname,playerlist[i].netname) == 0)
					index = i;
			}

			if (!strcmp(s, "pipe"))
			{
				ent->client->resp.score = playerlist[index].frags;
				ent->client->resp.deposited = playerlist[index].deposits;
				ent->client->pers.team = playerlist[index].team;
				ent->client->resp.enterframe -= playerlist[index].time;
				ent->client->pers.spectator = PLAYING;
				ent->flags &= ~FL_GODMODE;
				ent->health = 0;
				meansOfDeath = MOD_RESTART;
				ent->solid = SOLID_NOT;
				player_die (ent, ent, ent, 1, vec3_origin, 0, 0);
				PutClientInServer( ent );	
				UPDATERATE(ent)
			}
			else 
				if (teamplay->value)
					ent->client->showscores = SCOREBOARD;
				else
				{
					ent->client->pers.spectator = PLAYING;
					ent->flags &= ~FL_GODMODE;
					ent->health = 0;
					meansOfDeath = MOD_RESTART;
					ent->solid = SOLID_NOT;
					player_die (ent, ent, ent, 1, vec3_origin, 0, 0);
					PutClientInServer( ent );	
				}

			for (i=level.player_num; i>index; i--)
				playerlist[i-1] = playerlist[i];
			level.player_num--;
		}
		return;
	}	
	else if ((teamplay->value) && ((!ent->client->pers.team) || (level.modeset == MATCHSETUP) || (level.modeset == FREEFORALL)))
	{
//		if (level.framenum > (ent->switch_teams_frame + 20)) // Kingpin's join team menu
			if (s)
			{
				if (!strcmp(s, "pipe"))
				{	// Kings
					Cmd_Join_f( ent, team_names[1] );
//					ent->switch_teams_frame = level.framenum;
				}
				else if (!strcmp(s, "pistol"))
				{	// Pins
					Cmd_Join_f( ent, team_names[2] );
//					ent->switch_teams_frame = level.framenum;
				}
			}
		return;
	}

	if (ent->client->pers.spectator == SPECTATING) {
		if (!teamplay->value) Cmd_Join_f( ent, "" );
		return;
	}

	it = FindItem (s);
	if (!it)
	{
		cprintf (ent, PRINT_HIGH, "not a valid item: %s\n", s);
		return;
	}
	if (!it->use)
	{
		cprintf (ent, PRINT_HIGH, "Item is not usable.\n");
		return;
	}

	index = ITEM_INDEX(it);

	if ( (!Q_stricmp (it->pickup_name, "FlameThrower")) && deathmatch->value ) // speedway v1.4
	{
		it = FindItem ("Pistol");
		index = ITEM_INDEX(it);
	}

	if (!ent->client->pers.inventory[index])
	{
		
		if (strcmp (it->pickup_name, "Pistol") == 0)
		{
			gi.dprintf ("silencer_shots: %d\n", ent->client->pers.silencer_shots);
			if (!ent->client->pers.silencer_shots)
			{
				cprintf (ent, PRINT_HIGH, "Out of item: %s\n", s);
				return;
			}
			it = FindItem ("SPistol");
			index = ITEM_INDEX (it);
			if (!ent->client->pers.inventory[index])
			{
				cprintf (ent, PRINT_HIGH, "Out of item: %s\n", s);
				return;
			}
		}

		else if ( (strcmp (it->pickup_name, "Pipe") == 0) && deathmatch->value ) // curse
		{
			it = FindItem ("Crowbar");
			index = ITEM_INDEX(it);
		}

		else 
		{
			cprintf (ent, PRINT_HIGH, "Out of item: %s\n", s);
			return;
		}
	}

	if (ent->client->pers.holsteredweapon)
	{
		if (level.bar_lvl)
			return;
		
		if (ent->client->pers.holsteredweapon == it)
		{
			ent->client->newweapon = ent->client->pers.holsteredweapon;
			ChangeWeapon (ent);
			ent->client->pers.holsteredweapon = 0;
			return;	
		}
		else
		{
			ent->client->pers.weapon = ent->client->pers.holsteredweapon; 
			ent->client->pers.holsteredweapon = NULL;
		}
	}

	it->use (ent, it);

	if (!ent->client->pers.holsteredweapon && !ent->client->pers.weapon && ent->client->newweapon)
	{
		ChangeWeapon (ent);
	}
}


/*
==================
Cmd_Drop_f

Drop an inventory item
==================
*/
void Cmd_Drop_f (edict_t *ent)
{
	int			index;
	gitem_t		*it;
	char		*s;

	s = gi.args();

	it = FindItem (s);
	if (!it)
	{
		cprintf (ent, PRINT_HIGH, "not a valid item: %s\n", s);
		return;
	}
	if (!it->drop || (Q_stricmp (s, "cash") == 0) )
	{
		cprintf (ent, PRINT_HIGH, "Item is not dropable.\n");
		return;
	}

	index = ITEM_INDEX(it);
	if (!ent->client->pers.inventory[index])
	{
		if (strcmp (it->pickup_name, "Pistol") == 0)
		{
			gi.dprintf ("silencer_shots: %d\n", ent->client->pers.silencer_shots);

			if (!ent->client->pers.silencer_shots)
			{
				cprintf (ent, PRINT_HIGH, "Out of item: %s\n", s);
				return;
			}
			
			it = FindItem ("SPistol");
			index = ITEM_INDEX (it);
			if (!ent->client->pers.inventory[index])
			{
				cprintf (ent, PRINT_HIGH, "Out of item: %s\n", s);
				return;
			}
		}
		else 
		{
			cprintf (ent, PRINT_HIGH, "Out of item: %s\n", s);
			return;
		}
	}

	it->drop (ent, it);
}


/*
=================
Cmd_Inven_f
=================
*/
void Cmd_Inven_f (edict_t *ent)
{
	int			i;
	gclient_t	*cl;

	cl = ent->client;

	cl->showscores = NO_SCOREBOARD;
	cl->showhelp = false;

	if (cl->showinventory)
	{
		cl->showinventory = false;
		return;
	}

	cl->showinventory = true;

	gi.WriteByte (svc_inventory);
	for (i=0 ; i<MAX_ITEMS ; i++)
	{
		gi.WriteShort (cl->pers.inventory[i]);
	}
	gi.unicast (ent, true);
}

/*
=================
Cmd_InvUse_f
=================
*/
void Cmd_InvUse_f (edict_t *ent)
{
	gitem_t		*it;
	int			i, index;


	if (ent->client->showscores == SCORE_REJOIN) 
	{
		for (i=0;i<level.player_num;i++)
		{
			if (Q_stricmp (ent->client->pers.netname,playerlist[i].netname) == 0)
				index = i;
		}

		if (ent->vote == 0)
		{
			ent->client->resp.score = playerlist[index].frags;
			ent->client->resp.deposited = playerlist[index].deposits;
			ent->client->pers.team = playerlist[index].team;
			ent->client->resp.enterframe -= playerlist[index].time;
			ent->client->pers.spectator = PLAYING;
			ent->flags &= ~FL_GODMODE;
			ent->health = 0;
			meansOfDeath = MOD_RESTART;
			ent->solid = SOLID_NOT;
			player_die (ent, ent, ent, 1, vec3_origin, 0, 0);
			PutClientInServer( ent );	
		}
		else 
			if (teamplay->value)
				ent->client->showscores = SCOREBOARD;
			else
			{
				ent->client->pers.spectator = PLAYING;
				ent->flags &= ~FL_GODMODE;
				ent->health = 0;
				meansOfDeath = MOD_RESTART;
				ent->solid = SOLID_NOT;
				player_die (ent, ent, ent, 1, vec3_origin, 0, 0);
				PutClientInServer( ent );	
			}

		for (i=level.player_num; i>index; i--)
			playerlist[i-1] = playerlist[i];
		level.player_num--;
		return;
	}	
	
	
	ValidateSelectedItem (ent);

	if (ent->client->pers.selected_item == -1)
	{
		cprintf (ent, PRINT_HIGH, "No item to use.\n");
		return;
	}

	it = &itemlist[ent->client->pers.selected_item];
	if (!it->use)
	{
		cprintf (ent, PRINT_HIGH, "Item is not usable.\n");
		return;
	}
	it->use (ent, it);
}

/*
=================
Cmd_WeapPrev_f
=================
*/
void Cmd_WeapPrev_f (edict_t *ent)
{
	gclient_t	*cl;
	int			i, index;
	gitem_t		*it;
	int			selected_weapon;

	cl = ent->client;

	// JOSEPH 10-FEB-99
	if (cl->pers.holsteredweapon)
	{
		if (level.bar_lvl)
			return;

		cl->newweapon = cl->pers.holsteredweapon;
		ChangeWeapon (ent);
		cl->pers.holsteredweapon = 0;
		return;
	}
	// END JOSEPH

	if (!cl->pers.weapon)
		return;

	// Ridah, if already changing weapons, start from the next weapon, for faster cycling
	if (ent->client->weaponstate == WEAPON_DROPPING)
		selected_weapon = ITEM_INDEX(cl->newweapon);
	else
		selected_weapon = ITEM_INDEX(cl->pers.weapon);

	// scan  for the next valid one
	for (i=1 ; i<=MAX_ITEMS ; i++)
	{
		index = (selected_weapon + i)%MAX_ITEMS;
		if (!cl->pers.inventory[index])
			continue;
		it = &itemlist[index];
		if (!it->use)
			continue;
		if (! (it->flags & IT_WEAPON) )
			continue;
		if (selected_weapon == ITEM_INDEX(it) && cl->newweapon)
		{
			// Ridah, show the current weapon on the hud, for easy scrolling
			if (deathmatch->value && !strstr(cl->newweapon->icon, "pipe"))
			{
				it = cl->newweapon;
				ent->client->ps.stats[STAT_PICKUP_ICON] = gi.imageindex(it->icon);
				ent->client->ps.stats[STAT_PICKUP_STRING] = CS_ITEMS+ITEM_INDEX(it);
				ent->client->pickup_msg_time = level.time + 5.5;
			}

			return;	// successful
		}
		else
		{
			it->use (ent, it);
		}
	}
}

#define DREWACTIVATEDISTANCE	96

// JOSEPH 11-MAY-99
qboolean infront_angle_activate (vec3_t selfang, vec3_t selforg, vec3_t otherorg)
{
	vec3_t	vec;
	float	dot;
	vec3_t	forward;

	AngleVectors (selfang, forward, NULL, NULL);
	VectorSubtract (otherorg, selforg, vec);
	VectorNormalize (vec);
	dot = DotProduct (vec, forward);
	
	if (dot > 0.95)
		return true;
	return false;
}
// END JOSEPH

// JOSEPH 21-SEP-98
void Cmd_Activate_f (edict_t *ent)
{
	edict_t		*trav, *best;
	float		best_dist=9999, this_dist;

	if (ent->movetype == MOVETYPE_NOCLIP) {
		if (ent->client->pers.spectator == SPECTATING)
		{
			if (maxclients->value > 1)
			{
				if (!ent->client->chase_target)
					ChaseNext(ent);
				else	// disable it
				{
					ent->client->chase_target = NULL;
					ent->client->ps.pmove.pm_flags &= ~PMF_NO_PREDICTION;
				}
			}
		}
		return;
	}

	// if we are ducking
	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
	{
		// find the near enemy 
		trav = best = NULL;
		// JOSEPH 13-MAY-99
		while (trav = findradius( trav, ent->s.origin, 80 ))
		// END JOSEPH
		{
			// JOSEPH 14-MAY-99
			if (!(trav->svflags & SVF_MONSTER))
				continue;
			// END JOSEPH
			// JOSEPH 6-JAN-99
			if (trav == ent)
				continue;
			// END JOSEPH
			//if (!infront(ent, trav))
			//	continue;
			//if (!visible(ent, trav))
			//	continue;
			if (((this_dist = VectorDistance(ent->s.origin, trav->s.origin)) > best_dist) && (this_dist > 32))
				continue;
			
			best = trav;
			best_dist = this_dist;
		}

		// if the enemy has cash - then take it
		// Joseph 14-MAY-99
		if ((best) && (best->currentcash > 0) && best->health <= 0)
		// END JOSEPH
		{
			int     index;
			gitem_t *item;
			
			ent->client->pers.currentcash += best->currentcash;
			//cprintf (ent, PRINT_HIGH, "%i dollars found\n", best->currentcash);
			ent->client->ps.stats[STAT_CASH_PICKUP] = best->currentcash;
			best->currentcash = 0;
			// flash the screen green
			ent->client->bonus_alpha = 0.25;	
			ent->client->bonus_alpha_color = 2;	
			gi.sound (ent, CHAN_AUTO, gi.soundindex("world/pickups/cash.wav"), 1, ATTN_NORM, 0);		

			item = FindItem ("Cash");
			index = ITEM_INDEX (item);
			// show icon and name on status bar
			ent->client->ps.stats[STAT_PICKUP_ICON] = gi.imageindex(item->icon);
			ent->client->ps.stats[STAT_PICKUP_STRING] = CS_ITEMS+index;
			ent->client->pickup_msg_time = level.time + 5.5;		
		}
	}


	// JOSEPH 11-MAY-99
	// find a usable brush entity and tag it as such
	{
		edict_t		*target, *toptarget;
		vec3_t		dest;
		trace_t		trace, tr;
		vec3_t		dir, neworigin, endorg;	
		float       topdistance;
		int			directtarget;

		target = NULL;
		toptarget = NULL;
		topdistance = 10000;
		directtarget = 0;

		while (((target = findradius(target, ent->s.origin, DREWACTIVATEDISTANCE * (1 + (deathmatch->value != 0)))) || toptarget) && !directtarget)
		{
			if (!target)
				goto startyourtriggers;
			if (!(target->activate_flags & ACTIVATE_GENERAL))
				continue;
			if (target->targetname && target->key != -1)
				continue;
			
			VectorCopy(ent->s.origin, neworigin);
			neworigin[2] += ent->viewheight;
			
			AngleVectors( ent->client->ps.viewangles, dir, NULL, NULL );
			VectorMA (neworigin, DREWACTIVATEDISTANCE * (1 + (deathmatch->value != 0)), dir, dest);

			trace = gi.trace (neworigin, vec3_origin, vec3_origin, dest, ent, MASK_SOLID);
			
			// JOSEPH 19-MAY-99
			if (trace.ent && trace.ent->classname && (!strcmp(trace.ent->classname, "func_lift")))
			{
				edict_t		*targetL;

				targetL = NULL;

				while (((targetL = findradius(targetL, trace.endpos, 16))))
				{
					if (!(targetL->activate_flags & ACTIVATE_GENERAL))
						continue;			
					if (targetL->targetname && targetL->key != -1)
						continue;
					if (targetL->classname && (!strcmp(targetL->classname, "func_button")))
					{
						toptarget = targetL;
						goto startyourtriggers;
					}
				}
			}
			// END JOSEPH
			
			// JOSEPH 14-MAY-99
			if (trace.ent == target)
			{
				directtarget = 1;	
				
				if ((strcmp (target->classname, "func_door") == 0) ||
					(strcmp (target->classname, "func_door_rotating") == 0))
				{
					if ((target->team) && (target->teammaster))
					{
						toptarget = target->teammaster;
						goto startyourtriggers;
					}
				}

				toptarget = target;
				goto startyourtriggers;
			}
			// END JOSEPH

			VectorAdd (target->absmin, target->absmax, endorg);				
			VectorScale (endorg, 0.5, endorg);

			if (!(infront_angle_activate(ent->client->v_angle, neworigin, endorg)))
				continue;

			if (VectorDistance(trace.endpos, dest ) > topdistance)
				continue;
			
			tr = gi.trace(neworigin, NULL, NULL, endorg, ent, MASK_SOLID);

			// Ridah, added this since it's frustrating hitting the switches in deathmatch
			if (!deathmatch->value || (!Q_stricmp(target->classname, "func_button") && !Q_stricmp(target->target, "safe2")))
			if (tr.ent != target)
				continue;

			topdistance = VectorDistance(trace.endpos, dest);
			toptarget = target;
			continue;

startyourtriggers:			

			target = toptarget;	
			toptarget = NULL;
	
	// END JOSEPH
			// JOSEPH 12-MAR-99-B
			// If it must be trigger unlocked
			if (target->key < 0)
			{
				gi.sound (ent, CHAN_AUTO, gi.soundindex("world/doors/dr_locked.wav"), 1, ATTN_NORM, 0);
				continue;
			}
			// END JOSEPH

			// JOSEPH 19-MAR-99-B
			// Kingpin keys must be placed here to open doors
			if (target->key > 0)
			{
				switch(target->key)
				{
					case 1:
					{
						if (!ent->client->pers.inventory[ITEM_INDEX(FindItem("StoreRoomKey"))])
						{
							gi.sound (ent, CHAN_AUTO, gi.soundindex("world/doors/dr_locked.wav"), 1, ATTN_NORM, 0);
							continue;
						}
					}
					break;			

					case 2:
					{
						if (!ent->client->pers.inventory[ITEM_INDEX(FindItem("Electrical_Room"))])
						{
							gi.sound (ent, CHAN_AUTO, gi.soundindex("world/doors/dr_locked.wav"), 1, ATTN_NORM, 0);
							continue;
						}
					}
					break;	
					
					case 3:
					{
						if (!ent->client->pers.inventory[ITEM_INDEX(FindItem("Chem_Plant_Key"))])
						{
							gi.sound (ent, CHAN_AUTO, gi.soundindex("world/doors/dr_locked.wav"), 1, ATTN_NORM, 0);			
							continue;
						}
					}
					break;	

					case 4:
					{
						if (!ent->client->pers.inventory[ITEM_INDEX(FindItem("Bridge_Key"))])
						{
							gi.sound (ent, CHAN_AUTO, gi.soundindex("world/doors/dr_locked.wav"), 1, ATTN_NORM, 0);					
							continue;
						}
					}
					break;	

					case 5:
					{
						if (!ent->client->pers.inventory[ITEM_INDEX(FindItem("Shipyard_Key"))])
						{
							gi.sound (ent, CHAN_AUTO, gi.soundindex("world/doors/dr_locked.wav"), 1, ATTN_NORM, 0);					
							continue;
						}
					}
					break;	

					case 6:
					{
						if (!ent->client->pers.inventory[ITEM_INDEX(FindItem("Warehouse_Key"))])
						{
							gi.sound (ent, CHAN_AUTO, gi.soundindex("world/doors/dr_locked.wav"), 1, ATTN_NORM, 0);					
							continue;
						}
					}
					break;	

					case 7:
					{
						if (!ent->client->pers.inventory[ITEM_INDEX(FindItem("Shop_Key"))])
						{
							gi.sound (ent, CHAN_AUTO, gi.soundindex("world/doors/dr_locked.wav"), 1, ATTN_NORM, 0);					
							continue;
						}
					}
					break;
					
					case 8:
					{
						if (!ent->client->pers.inventory[ITEM_INDEX(FindItem("Ticket"))])
						{
							gi.sound (ent, CHAN_AUTO, gi.soundindex("world/doors/dr_locked.wav"), 1, ATTN_NORM, 0);					
							continue;
						}
						else
							ent->client->pers.inventory[ITEM_INDEX(FindItem("Ticket"))] = 0;
					}
					break;	

					case 9:
					{
						if (!ent->client->pers.inventory[ITEM_INDEX(FindItem("Office_Key"))])
						{
							gi.sound (ent, CHAN_AUTO, gi.soundindex("world/doors/dr_locked.wav"), 1, ATTN_NORM, 0);					
							continue;
						}
					}
					break;	

					case 10:
					{
						if (!ent->client->pers.inventory[ITEM_INDEX(FindItem("key10"))])
						{
							gi.sound (ent, CHAN_AUTO, gi.soundindex("world/doors/dr_locked.wav"), 1, ATTN_NORM, 0);					
							continue;
						}
					}
					break;					

					case 11:
					{
						if (!(EP_UnlockDoorFlag (ent)))
						{
							gi.sound (ent, CHAN_AUTO, gi.soundindex("world/doors/dr_locked.wav"), 1, ATTN_NORM, 0);					
							continue;
						}
					}
				}

				// Ridah, once unlocked, stay unlocked
				target->key = 0;
			}
			// END JOSEPH			

			// we have a valid one so lets flag it
			target->activate_flags |= ACTIVATE_AND_OPEN;
			break;
		}
		
		if (target)
			if (target->activate_flags & ACTIVATE_AND_OPEN)
				if (target->use)
				{
//					gi.dprintf( "%s, %s\n", target->classname, target->target );
					target->use (target, ent, ent);
				}
	}

	// Ridah, moveout command
 	if ((ent->cast_info.aiflags & AI_DOKEY || ent->cast_info.aiflags & AI_MOVEOUT) && ent->client->pers.friends > 0)
	{
		vec3_t	start, end, dir;
		trace_t tr;

		AngleVectors( ent->client->ps.viewangles, dir, NULL, NULL );

		VectorCopy( ent->s.origin, start );
		start[2] += ent->viewheight;

		VectorMA( start, 2048, dir, end );

		tr = gi.trace( start, NULL, NULL, end, ent, MASK_SHOT );

		if (	(tr.fraction < 1)
			&&	(tr.ent->svflags & SVF_MONSTER)
			&&	(tr.ent->health > 0)
			&&	(tr.ent->cast_group != ent->cast_group))
		{
			int i;

			ent->moveout_ent = tr.ent;

			// look for a friend to say this to
			for (i=0; i<level.num_characters; i++)
			{
				if (!level.characters[i])
					continue;
				if (level.characters[i]->health <= 0)
					continue;
				if (level.characters[i]->leader != ent)
					continue;

				if (!(level.characters[i]->cast_info.aiflags & AI_MOVEOUT))
					continue;
				
				Voice_Random( ent, level.characters[i], hiredguy_combat_moveout, NUM_HIREDGUY_COMBAT_MOVEOUT );
				break;
			}
		}

		else if (ent->cast_info.aiflags & AI_DOKEY)
		{
			EP_Check_DoKey (ent, tr.ent);
			// gi.dprintf ("gave a go do key order\n");
		}
	}

}
// END JOSEPH

// RAFAEL 01-11-99
void Cmd_Reload_f (edict_t *ent)
{
	gclient_t	*cl;

	cl = ent->client;
	
	if (!cl->pers.weapon)
		return;

	// Ridah, fixes Tommygun reloading twice, if hit "reload" as it starts to auto-reload when out of ammo
	if (ent->client->weaponstate == WEAPON_RELOADING)
		return;

	if (ent->client->weaponstate != WEAPON_READY)
		return;

	ent->client->reload_weapon = true;
}
// END 01-11-99


// JOSEPH 6-FEB-99
void Cmd_Holster_f (edict_t *ent)
{
	gclient_t *cl;

	if (deathmatch->value)
		return;

	if (level.bar_lvl)
	{
		gi.dprintf ("no weapons on this level\n");
		return;
	}

	cl = ent->client;

	if (!cl->pers.holsteredweapon)
	{
		if (!cl->pers.weapon)
			return;

		cl->pers.holsteredweapon = cl->pers.weapon;
		cl->newweapon = NULL;
		cl->weaponstate = WEAPON_DROPPING;

		if (ent->s.renderfx2 & RF2_FLAMETHROWER)
			ent->s.renderfx2 &= ~RF2_FLAMETHROWER;
	}
	else
	{
		if (cl->ps.gunindex != 0)
			return;
  
		cl->newweapon = cl->pers.holsteredweapon;
		ChangeWeapon (ent);
		cl->pers.holsteredweapon = 0;  
	}
}

void Cmd_HolsterBar_f (edict_t *ent)
{
	gclient_t *cl;

	cl = ent->client;

	if (deathmatch->value)
		return;

	if (level.bar_lvl)
	{
		if (!cl->pers.holsteredweapon)
		{
			if (!cl->pers.weapon)
				return;

			cl->pers.holsteredweapon = cl->pers.weapon;
			//cl->newweapon = NULL;
			//cl->weaponstate = WEAPON_DROPPING;
			cl->ps.gunindex = 0;
		}
	}
	
	else
	{
		if (cl->ps.gunindex != 0)
			return;
  
		cl->newweapon = cl->pers.holsteredweapon;
		ChangeWeapon (ent);
		cl->pers.holsteredweapon = 0;  
	}
	
	
}
// END JOSEPH

// JOSEPH 29-DEC-98
void Cmd_Hud_f (edict_t *ent)
{
	gi.WriteByte (svc_hud);
	gi.unicast (ent, true);
}
// END JOSEPH

void Cmd_Flashlight_f (edict_t *ent)
{
	if (!ent->client->flashlight && ent->client->pers.inventory[ITEM_INDEX(FindItem("Flashlight"))])
		ent->client->flashlight = true;
	else
		ent->client->flashlight = false;
}


/*
=================
Cmd_WeapNext_f
=================
*/
void Cmd_WeapNext_f (edict_t *ent)
{
	gclient_t	*cl;
	int			i, index;
	gitem_t		*it;
	int			selected_weapon;

	cl = ent->client;

	// JOSEPH 10-FEB-99
	if (cl->pers.holsteredweapon)
	{
		if (level.bar_lvl)
			return;
		
		cl->newweapon = cl->pers.holsteredweapon;
		ChangeWeapon (ent);
		cl->pers.holsteredweapon = 0;
		return;
	}
	// END JOSEPH

	if (!cl->pers.weapon)
		return;

	// Ridah, if already changing weapons, start from the next weapon, for faster cycling
	if (ent->client->weaponstate == WEAPON_DROPPING)
	{
		selected_weapon = ITEM_INDEX(cl->newweapon);
	}
	else
	{
		selected_weapon = ITEM_INDEX(cl->pers.weapon);
	}

	// scan  for the next valid one
	for (i=1 ; i<=MAX_ITEMS ; i++)
	{
		index = (selected_weapon + MAX_ITEMS - i)%MAX_ITEMS;
		
		if (!cl->pers.inventory[index])
			continue;
		it = &itemlist[index];
		if (!it->use)
			continue;
		if (! (it->flags & IT_WEAPON) )
			continue;
		if (selected_weapon == ITEM_INDEX(it) && cl->newweapon)
		{
			// Ridah, show the current weapon on the hud, for easy scrolling
			if (deathmatch->value && !strstr(cl->newweapon->icon, "pipe"))
			{
				it = cl->newweapon;
				ent->client->ps.stats[STAT_PICKUP_ICON] = gi.imageindex(it->icon);
				ent->client->ps.stats[STAT_PICKUP_STRING] = CS_ITEMS+ITEM_INDEX(it);
				ent->client->pickup_msg_time = level.time + 5.5;
			}

			return;	// successful
		}
		else
		{
			it->use (ent, it);
		}
	}
}

/*
=================
Cmd_WeapLast_f
=================
*/
void Cmd_WeapLast_f (edict_t *ent)
{
	gclient_t	*cl;
	int			index;
	gitem_t		*it;

	cl = ent->client;

	if (!cl->pers.weapon || !cl->pers.lastweapon)
		return;

	index = ITEM_INDEX(cl->pers.lastweapon);
	if (!cl->pers.inventory[index])
		return;
	it = &itemlist[index];
	if (!it->use)
		return;
	if (! (it->flags & IT_WEAPON) )
		return;
	it->use (ent, it);

	// Ridah, show the current weapon on the hud, for easy scrolling
	if (deathmatch && !strstr(it->icon, "pipe"))
	{
		ent->client->ps.stats[STAT_PICKUP_ICON] = gi.imageindex(it->icon);
		ent->client->ps.stats[STAT_PICKUP_STRING] = CS_ITEMS+ITEM_INDEX(it);
		ent->client->pickup_msg_time = level.time + 5.5;
	}
}

/*
=================
Cmd_InvDrop_f
=================
*/
void Cmd_InvDrop_f (edict_t *ent)
{
	gitem_t		*it;
	int		index;
	char		*s;

	s = gi.args();

	ValidateSelectedItem (ent);

	if (ent->client->pers.selected_item == -1)
	{
		cprintf (ent, PRINT_HIGH, "No item to drop.\n");
		return;
	}

	it = &itemlist[ent->client->pers.selected_item];
	if (!it->drop)
	{
		cprintf (ent, PRINT_HIGH, "Item is not dropable.\n");
		return;
	}

	index = ITEM_INDEX(it);
	if (!ent->client->pers.inventory[index])
	{
		cprintf (ent, PRINT_HIGH, "Out of item: %s\n", s);
		return;
	}

	it->drop (ent, it);
}

/*
=================
Cmd_Kill_f
=================
*/
void Cmd_Kill_f (edict_t *ent)
{
	if(teamplay->value) { cprintf (ent, PRINT_HIGH, "no suiciding!\n"); return; }

	// don't let spectators kill themselves
	if (ent->solid == SOLID_NOT)
		return;

	if((level.time - ent->client->respawn_time) < 5)
		return;
//	ent->flags &= ~FL_GODMODE;//Hexed commented out , was getting stuck in spectator mode when player died.
	ent->health = 0;
	meansOfDeath = MOD_SUICIDE;
	player_die (ent, ent, ent, 1, vec3_origin, 0, 0);
}

/*
=================
Cmd_PutAway_f
=================
*/
void Cmd_PutAway_f (edict_t *ent)
{
	ent->client->showscores = NO_SCOREBOARD;
	ent->client->showhelp = false;
	ent->client->showinventory = false;
}

int PlayerSort (void const *a, void const *b)
{
	int		anum, bnum;

	anum = *(int *)a;
	bnum = *(int *)b;

	anum = game.clients[anum].ps.stats[STAT_FRAGS];
	bnum = game.clients[bnum].ps.stats[STAT_FRAGS];

	if (anum < bnum)
		return -1;
	if (anum > bnum)
		return 1;
	return 0;
}

/*
=================
Cmd_Players_f
=================
*/
void Cmd_Players_f (edict_t *ent)
{
	int		i;
	int		count;
	char	small[80];
//	char	large[1280];
	char	large[2000];
	int		index[256];

	count = 0;
	for (i = 0 ; i < maxclients->value ; i++)
		if (game.clients[i].pers.connected)
		{
			index[count] = i;
			count++;
		}

	// sort by frags
// Ridah, disabled, so we can use this to list players we might want to "vote ban"
//	qsort (index, count, sizeof(index[0]), PlayerSort);

	// print information
	large[0] = 0;

	for (i = 0 ; i < count ; i++)
	{
		Com_sprintf (small, sizeof(small), "%2i - %s (%i frags)",
			index[i] + 1,
			game.clients[index[i]].pers.netname,
			game.clients[index[i]].ps.stats[STAT_FRAGS]);
		strcat(small,"\n");
		if (strlen (small) + strlen(large) > sizeof(large) - 100 )
		{	// can't print all of them in one packet
			strcat (large, "...\n");
			break;
		}
		strcat (large, small);
	}

	cprintf (ent, PRINT_HIGH, "%s\n%i players\n", large, count);
}

/*
=================
Cmd_Wave_f
=================
*/
void Cmd_Wave_f (edict_t *ent, edict_t *other)
{
	char *cmd;
	int	rnd;

	cmd = gi.argv(0);

	if (!other->client)
		return;

	if (!ent->solid)
		return;

	// can't wave when ducked
	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
		return;

	if (ent->client->last_wave > (level.time - 2) && (ent->client->last_wave <= level.time))
		return;

	ent->client->last_wave = level.time;

	// say something
	{

		if (!teamplay->value || (ent->client->pers.team != other->client->pers.team))
		{
			if (strstr(cmd, "key1"))
			{
				if (ent->gender == GENDER_MALE)
					Voice_Random(ent, other, player_profanity_level2, NUM_PLAYER_PROFANITY_LEVEL2);
				else if (ent->gender == GENDER_FEMALE)
					Voice_Random(ent, other, f_profanity_level2, F_NUM_PROFANITY_LEVEL2);
			}
			else	// profanity 3
			{
				if (ent->gender == GENDER_MALE)
					Voice_Random(ent, other, player_profanity_level3, NUM_PLAYER_PROFANITY_LEVEL3);
				else if (ent->gender == GENDER_FEMALE)
					Voice_Random(ent, other, f_profanity_level3, F_NUM_PROFANITY_LEVEL3);
			}
		}
		else	// stay here/moving out
		{
			if (strstr(cmd, "key3"))
			{		// hold
				if (ent->gender == GENDER_MALE)
					Voice_Random(ent, other, holdposition, NUM_HOLDPOSITION);
				else if (ent->gender == GENDER_FEMALE)
//					Voice_Random(ent, other, f_holdposition, F_NUM_HOLDPOSITION);
					Voice_Random(ent, other, rc_f_profanity_level1, 5);
			}
			else if (strstr(cmd, "key2"))	// lets go
			{
				if (ent->gender == GENDER_MALE)
					Voice_Random(ent, other, followme, NUM_FOLLOWME);
				else if (ent->gender == GENDER_FEMALE)
//					Voice_Random(ent, other, f_followme, F_NUM_FOLLOWME);
					Voice_Random(ent, other, rc_lola, 7);
			}
			else // converse
			{
				if (ent->gender == GENDER_MALE)
				{
					if (other->gender == GENDER_FEMALE)
						Voice_Random(ent, other, f_neutral_talk_player, F_NUM_NEUTRAL_TALK_PLAYER);
					else
						Voice_Random(ent, other, neutral_talk_player, NUM_NEUTRAL_TALK_PLAYER);
				}
				else if (ent->gender == GENDER_FEMALE)
				{
					Voice_Random(ent, other, f_neutral_talk, F_NUM_NEUTRAL_TALK);
				}
			}
		}
	}

	if (ent->client->anim_priority > ANIM_WAVE)
		return;

	ent->client->anim_priority = ANIM_WAVE;

	rnd = rand() % 3;

	switch (rnd)
	{
	case 0:
//		cprintf (ent, PRINT_HIGH, "flipoff\n");
		ent->s.frame = FRAME_tg_bird_01-1;
		ent->client->anim_end = FRAME_tg_bird_10;
		break;
	case 1:
//		cprintf (ent, PRINT_HIGH, "salute\n");
		ent->s.frame = FRAME_tg_crch_grab_01-1;
		ent->client->anim_end = FRAME_tg_crch_grab_16;
		break;
	case 2:
//		cprintf (ent, PRINT_HIGH, "taunt\n");
		ent->s.frame = FRAME_tg_chin_flip_01-1;
		ent->client->anim_end = FRAME_tg_chin_flip_15;
		break;
	}

}


/*
==================
Cmd_Say_f
==================
*/
void Cmd_Say_f (edict_t *ent, qboolean team, qboolean arg0)
{
	int		i, j;
	edict_t	*other;
	char	*p;
	char	text[2048];
	gclient_t *cl;

////// curse adds a limiting timer to prevent macro chats ////////////////////////////////////////////////////////
	if (ent->client->last_wave > (level.time - 0.5) && (ent->client->last_wave <= level.time)) return;
	ent->client->last_wave = level.time;
	if((strstr(gi.argv(0),">"))||(strstr(gi.argv(1),">"))) return;
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	if (gi.argc () < 2 && !arg0) return;


	if (!teamplay->value && !((int)(dmflags->value) & (DF_MODELTEAMS)))
		team = false;

	if (team)
		Com_sprintf (text, sizeof(text), ":<<%s>>: ", ent->client->pers.netname);
	else
		Com_sprintf (text, sizeof(text), ":%s: ", ent->client->pers.netname);

	if (arg0)
	{
		strcat (text, gi.argv(0));
		strcat (text, " ");
		strcat (text, gi.args());
	}
	else
	{
		p = gi.args();

		if (*p == '"')
		{
			p++;
			p[strlen(p)-1] = 0;
		}
		strcat(text, p);
	}

	if (disable_anon_text && strchr(text,13)) {
		if (!ent->anonwarn) {
			gi.cprintf(ent, PRINT_CHAT, "anonymous text is not allowed on this server!\n");
			ent->anonwarn++;
		}
		return;
	}

	// don't let text be too long for malicious reasons
	if (strlen(text) > 150)
		text[150] = 0;

	strcat(text, "\n");

	if (flood_msgs->value) {
		cl = ent->client;

      if (level.time < cl->flood_locktill) {
			cprintf(ent, PRINT_HIGH, "You can't talk for %d more seconds\n",
				(int)(cl->flood_locktill - level.time));
            return;
      }
      i = cl->flood_whenhead - flood_msgs->value + 1;
      if (i < 0)
          i = (sizeof(cl->flood_when)/sizeof(cl->flood_when[0])) + i;
		if (cl->flood_when[i] && 
			level.time - cl->flood_when[i] < flood_persecond->value) {
			cl->flood_locktill = level.time + flood_waitdelay->value;
			gi.cprintf(ent, PRINT_CHAT, "Flood protection:  You can't talk for %d seconds.\n",
				(int)flood_waitdelay->value);
         return;
      }

      // if they repeat themselves really quickly, bitch-slap time
		if (cl->flood_when[cl->flood_whenhead] && (cl->flood_when[cl->flood_whenhead] > level.time - 1) &&
			!strcmp( ent->client->flood_lastmsg, text ))
		{
			cl->flood_locktill = level.time + flood_waitdelay->value;
			gi.cprintf(ent, PRINT_CHAT, "Flood protection:  You can't talk for %d seconds.\n",
				(int)flood_waitdelay->value);
         return;
		}

		cl->flood_whenhead = (cl->flood_whenhead + 1) %
			(sizeof(cl->flood_when)/sizeof(cl->flood_when[0]));
		cl->flood_when[cl->flood_whenhead] = level.time;
	}

	strcpy( ent->client->flood_lastmsg, text );
	
	if (dedicated->value)
		gi.cprintf(NULL, PRINT_CHAT, "%s", text);

	for (j = 1; j <= game.maxclients; j++) {
		other = &g_edicts[j];
		if (!(other->inuse))
			continue;
		if (!(other->client))
			continue;
		if (team) {
			if (!teamplay->value || ent->client->pers.team!=other->client->pers.team)
				if (!OnSameTeam(ent, other))
					continue;
		}
		gi.cprintf(other, PRINT_CHAT, "%s", text);
	}
}


//===================================================================================
// Papa 10.6.99 - added the ability to drop your current cash - still buggy
//===================================================================================


void Cmd_DropCash_f (edict_t *self)
{
	edict_t		*cash;

	if(deathmatch->value) return; //curse dont like this

	if ((int)(dmflags->value) & DF_DROP_CASH)
	{
		if (self->client->pers.currentcash)
		{
			cash = SpawnTheWeapon( self, "item_cashroll" );
			cash->currentcash = self->client->pers.currentcash;
			self->client->pers.currentcash = 0;
		}
	}
}

//===================================================================================
// Papa 10.6.99
//===================================================================================

//===================================================================================
// This is the start for all the commands that players can enter to run the mod.

//===================================================================================

void Cmd_PrintSettings_f (edict_t *ent)
{
	cprintf(ent, PRINT_HIGH,"\nCurrent Game Settings.\n");
	cprintf(ent, PRINT_HIGH,"======================\n\n");
	switch (level.modeset)
	{
		case FREEFORALL :
		case TEAMPLAY :
			cprintf(ent, PRINT_HIGH,"Server State    : Public\n");
			break;
		case MATCHSETUP :
			cprintf(ent, PRINT_HIGH,"Server State    : Match Setup\n");
			break;
		case FINALCOUNT :
			cprintf(ent, PRINT_HIGH,"Server State    : Final Countdown\n");
			break;
		case MATCH :
			cprintf(ent, PRINT_HIGH,"Server State    : Match\n");
			break;
	}

	cprintf(ent, PRINT_HIGH,"Time limit      : %d\n", (int)timelimit->value);
	cprintf(ent, PRINT_HIGH,"Frag limit      : %d\n", (int)fraglimit->value);
	cprintf(ent, PRINT_HIGH,"Lap  limit      : %d\n", (int)laplimit->value);
	cprintf(ent, PRINT_HIGH,"dmflags         : %d\n", (int)dmflags->value);
	cprintf(ent, PRINT_HIGH,"dm_realmode     : %d\n", (int)dm_realmode->value);
	cprintf(ent, PRINT_HIGH,"Server password : %s\n", password->string);
	cprintf(ent, PRINT_HIGH,"Teamplay mode   : %d\n",(int)teamplay->value);
	if (admincode[0] || !disable_admin_voting) {
		int			i,found;
		edict_t		*player;

		i=0;
		found = false;
		while ((!found) && (i<maxclients->value)) {
			player = g_edicts + 1 + i;
			i++;
			if (!player->inuse)
				continue;
			if (player->client->pers.admin > NOT_ADMIN)
				found = true;
		}

		if (found )
			cprintf(ent, PRINT_HIGH,"Current admin   : %s\n\n",player->client->pers.netname);
		else 
			cprintf(ent, PRINT_HIGH,"Current admin   : none\n\n");
	}
}


void Cmd_CommandList_f (edict_t *ent)
{
//gladiator_commands:
	gi.cprintf(ent, PRINT_HIGH,"\n============================\n");
	gi.cprintf(ent, PRINT_HIGH,"Additional Console Commands.\n");
	gi.cprintf(ent, PRINT_HIGH,"============================\n\n");

	gi.cprintf(ent, PRINT_HIGH,"HUDS <<  Cycles Hud Screens  >>\n");
	gi.cprintf(ent, PRINT_HIGH,"COMMANDS << print  this  list >>\n\n");

	gi.cprintf(ent, PRINT_HIGH,"==== CURSING TAUNT BINDS ====\n");
	gi.cprintf(ent, PRINT_HIGH,"CURSE   << 100 New  taunts>>\n");/*FRANK*/
	gi.cprintf(ent, PRINT_HIGH,"CYPRESSHILL << Music >>\n");
	gi.cprintf(ent, PRINT_HIGH,"HEILMAN << Various  taunts>>\n");
	gi.cprintf(ent, PRINT_HIGH,"HONEY   << 1 taunt only   >>\n");
	gi.cprintf(ent, PRINT_HIGH,"JESUS   <<Jesus's   taunts>>\n");
	gi.cprintf(ent, PRINT_HIGH,"KINGPIN <<Kingpin's taunts>>\n");
	gi.cprintf(ent, PRINT_HIGH,"LAMONT  <<Lamont's  taunts>>\n");
	gi.cprintf(ent, PRINT_HIGH,"LEROY   <<Leroy's   taunts>>\n");
	gi.cprintf(ent, PRINT_HIGH,"MOKER   <<Moker's   taunts>>\n");
	gi.cprintf(ent, PRINT_HIGH,"MOMO    <<Momo's    taunts>>\n");
	gi.cprintf(ent, PRINT_HIGH,"NIKKI   <<Nikki's   taunts>>\n");
	gi.cprintf(ent, PRINT_HIGH,"RUMMY   <<Drunk's   taunts>>\n");
	gi.cprintf(ent, PRINT_HIGH,"TYRONE  <<Tyrone's  taunts>>\n");
	gi.cprintf(ent, PRINT_HIGH,"WILLY   <<Willy's   taunts>>\n");
	gi.cprintf(ent, PRINT_HIGH,"FEM     <<Female    taunts>>\n");
	gi.cprintf(ent, PRINT_HIGH,"BLUNT   <<Female    taunts>>\n");
	gi.cprintf(ent, PRINT_HIGH,"=========================\n");

	ent->client->showscores = COMMANDS;
	DeathmatchScoreboard(ent);

	if (!admincode[0] && disable_admin_voting) {
		cprintf(ent, PRINT_HIGH,"There are no admin commands enabled on this server.\n");
		return;
	}
	cprintf(ent, PRINT_HIGH,"\nCurrent Console Commands.\n");
	cprintf(ent, PRINT_HIGH,"=========================\n");
	if (admincode[0]) cprintf(ent, PRINT_HIGH,"admin, ");
	if (!disable_admin_voting) cprintf(ent, PRINT_HIGH,"elect, ");
	cprintf(ent, PRINT_HIGH,"resign, commands, settings\n");
	if (teamplay->value)
		cprintf(ent, PRINT_HIGH,"matchsetup, matchstart, matchend, publicsetup\n");
	cprintf(ent, PRINT_HIGH,"resetserver, changemap, maplist\n");
	cprintf(ent, PRINT_HIGH,"settimelimit, setfraglimit, setlaplimit\n");
	if (enable_password) cprintf(ent, PRINT_HIGH,"setpassword removepassword\n");
	if (!fixed_gametype) {
		cprintf(ent, PRINT_HIGH,"setdmflags, setdm_realmode, setteamplay\n");
		cprintf(ent, PRINT_HIGH,"   The teamplay settings are:\n");
		cprintf(ent, PRINT_HIGH,"       0 : Free for all DM\n");
		cprintf(ent, PRINT_HIGH,"       1 : Bagman\n");
		cprintf(ent, PRINT_HIGH,"       4 : Team DM\n");
	}
}


//===================================================================================
//===================================================================================


void Cmd_Yes_f (edict_t *ent)
{
	edict_t		*dude;
	int			i,nop,novy;

	if ((level.voteset != NO_VOTES) && (ent->vote == HASNT_VOTED))
	{
		ent->vote = YES;
		nop=0;
		novy=0;
		for_each_player(dude,i)
		{
			if ((dude->vote == YES) || (dude->vote == CALLED_VOTE))
				novy ++;
			nop++;
		}
		gi.bprintf (PRINT_HIGH,"\n%d out of %d, have voted YES.\n\n",novy,nop);
		if ((novy *2) > nop)
		{
			switch (level.voteset) // Papa - if you wanted to add different types of votes, you could do it here
			{
				case VOTE_ON_ADMIN :
					for_each_player (dude,i)
					{
						if (dude->vote == CALLED_VOTE)
						{
							dude->client->pers.admin = ELECTED;
							gi.bprintf (PRINT_HIGH,"%s has been elected Admin.\n",dude->client->pers.netname);
							Cmd_CommandList_f(dude);
						}
					}
					break;
			}
			for_each_player (dude,i)
			{
				if (dude->vote == CALLED_VOTE)
					dude->vote = HASNT_VOTED;
			}
			level.voteset = NO_VOTES;
		}
	}
	else
		cprintf(ent,PRINT_HIGH,"There is nothing to vote on at this time!\n");
}


void Cmd_No_f (edict_t *ent)
{
	edict_t		*dude;
	int			i,nop,novn;

	if ((level.voteset != NO_VOTES) && (ent->vote == HASNT_VOTED))
	{
		ent->vote = NO;
		nop=0;
		novn=0;
		for_each_player(dude,i)
		{
			if (dude->vote == NO)
				novn ++;
			nop++;
		}
		if ((novn *2) >= nop)
		{
			switch (level.voteset) // Papa - if you wanted to add different types of votes, you could do it here
			{
				case VOTE_ON_ADMIN:
					gi.bprintf(PRINT_HIGH,"The request for admin has been voted down!\n");
					break;
			}
			for_each_player (dude,i)
			{
				if (dude->vote == CALLED_VOTE)
					dude->vote = HASNT_VOTED;
			}

			level.voteset = NO_VOTES;
		}
	}
	else
		cprintf(ent,PRINT_HIGH,"There is nothing to vote on at this time.\n");

}

void Cmd_Vote_f (edict_t *ent, char *vote)
{
	if (Q_stricmp (vote, "yes") == 0)
		Cmd_Yes_f (ent);
	else if (Q_stricmp (vote, "no") == 0)
		Cmd_No_f (ent);
	else
		cprintf(ent,PRINT_HIGH,"Vote YES or NO.  F00l.\n");
}


void Cmd_Elect_f (edict_t *ent)
{
	edict_t		*dude;
	int			count=0;
	int			i,j,found;
	edict_t		*player;


	if (disable_admin_voting) {
		cprintf(ent,PRINT_HIGH,"Electable Admins has been disabled on this server.\n");
		return;
	}
		
	j = atoi (gi.argv(1));
	found = FALSE;

	for (i=0 ; i<maxclients->value ; i++)
	{
		player = g_edicts + 1 + i;
		if (!player->inuse)
			continue;
		if (player->client->pers.admin > NOT_ADMIN)
			found = TRUE;
	}

	if (found)
	{
		cprintf(ent,PRINT_HIGH,"Someone already has admin\n");
		return;
	}

	if (level.voteset == NO_VOTES)  
	{
		for_each_player(dude,i)
		{
			dude->vote = 0;
			count++;
		}
		if (count == 1)
		{
			ent->client->pers.admin = ELECTED;
			gi.bprintf (PRINT_HIGH,"%s has been elected Admin.\n",ent->client->pers.netname);
			Cmd_CommandList_f(ent);
			return;
		}
		gi.bprintf(PRINT_HIGH,"%s has requested admin privilages.\n\nPLEASE VOTE\n\n",ent->client->pers.netname);
		ent->vote = CALLED_VOTE;
		level.voteframe = level.framenum;
		level.voteset= VOTE_ON_ADMIN;
	}
	else if (level.voteset != NO_VOTES)
		cprintf(ent,PRINT_HIGH,"Someone else has requested admin.\n");

}


//===================================================================================
//===================================================================================



void Cmd_MapList_f (edict_t *ent)
{
	int		i;

	if (!num_custom_maps) {
		cprintf(ent,PRINT_HIGH,"any map on this server may be loaded\n");
		return;
	}

	cprintf(ent,PRINT_HIGH,"Valid Maps for this server:\n");
	for (i=0;i<num_custom_maps;i++)
		cprintf(ent,PRINT_HIGH,"   %s\n",custom_list[i].custom_map);
}


qboolean ValidMap (char *mapname)
{
	int		i;

	for (i=0;i<num_custom_maps;i++)
		if  (!Q_stricmp(custom_list[i].custom_map,mapname))
			return true;
	if (!i) return true;

	return false;
}


void Cmd_ChangeMap_f (edict_t *ent)
{

	char		*s;
	char	command [256];

	if (ent->client->pers.admin > NOT_ADMIN )
	{
		s = gi.args();

		if (strchr(s,'.') ||
			!ValidMap (s)) // Always make sure the map is on the server before switching
		{
			cprintf(ent,PRINT_HIGH,"%s is not a valid map\n",s);
			return;
		}
		Com_sprintf (command, sizeof(command), "map \"%s\"\n", s);
		gi.AddCommandString (command);
	}
	else
		cprintf(ent,PRINT_HIGH,"You do not have admin\n");

}

//===================================================================================
//===================================================================================


void Cmd_MatchSetup_f (edict_t *ent)
{
	if (ent->client->pers.admin > NOT_ADMIN )
	{
		MatchSetup ();
		Cmd_PrintSettings_f (ent);
	}
	else
		cprintf(ent,PRINT_HIGH,"You do not have admin.\n");

}

void Cmd_PublicSetup_f (edict_t *ent)
{
	if (ent->client->pers.admin > NOT_ADMIN )
		PublicSetup ();
	else
		cprintf(ent,PRINT_HIGH,"You do not have admin.\n");

}


void Cmd_MatchStart_f (edict_t *ent)
{
	if (ent->client->pers.admin > NOT_ADMIN )
		MatchStart ();
	else
		cprintf(ent,PRINT_HIGH,"You do not have admin.\n");

}

void Cmd_MatchEnd_f (edict_t *ent)
{
	if (ent->client->pers.admin > NOT_ADMIN )
		MatchEnd ();
	else
		cprintf(ent,PRINT_HIGH,"You do not have admin.\n");

}
//===================================================================================
//===================================================================================


void Cmd_SetTimeLimit_f (edict_t *ent, char *value)
{
	int		i = atoi (value);

	if (ent->client->pers.admin > NOT_ADMIN )
		if ((i < 0 ) || (i > 60 )) {
			cprintf(ent,PRINT_HIGH,"Please choose a timelimit between 0 and 60\n");
			return;
		} else {
			gi.cvar_set("timelimit",value);
			gi.bprintf(PRINT_HIGH,"The Timelimit has been changed to %d.\n",i);
			gi.cvar_set(TIMENAME,"");
		}

	else
		cprintf(ent,PRINT_HIGH,"You do not have admin\n");
}

void Cmd_SetFragLimit_f (edict_t *ent, char *value)
{
	int		i = atoi (value);

	if (ent->client->pers.admin > NOT_ADMIN )
		if (i < 0 ) 
		{
			cprintf(ent,PRINT_HIGH,"Please choose a Positive Fraglimit\n");
			return;
		}
		else
		{
			gi.bprintf(PRINT_HIGH,"The Fraglimit has been changed to %d.\n",i);
			gi.cvar_set("fraglimit",value);
		}
	else
		cprintf(ent,PRINT_HIGH,"You do not have admin\n");
}

void Cmd_SetLapLimit_f (edict_t *ent, char *value)
{
	int		i = atoi (value);

	if (ent->client->pers.admin > NOT_ADMIN )
		if (i < 0 ) 
		{
			cprintf(ent,PRINT_HIGH,"Please choose a Positive Laplimit\n");
			return;
		}
		else
		{
			gi.bprintf(PRINT_HIGH,"The Laplimit has been changed to %d.\n",i);
			gi.cvar_set("laplimit",value);
		}
	else
		cprintf(ent,PRINT_HIGH,"You do not have admin\n");
}

void Cmd_SetDmFlags_f (edict_t *ent, char *value)
{
	if (ent->client->pers.admin > NOT_ADMIN ) {
		if (fixed_gametype)
			cprintf(ent,PRINT_HIGH,"This server's game type may not be changed\n");
		else {
			gi.bprintf(PRINT_HIGH,"dmflags has been changed to %s.\n",value);
			gi.cvar_set("dmflags",value);
		}
	} else
		cprintf(ent,PRINT_HIGH,"You do not have admin\n");
}

void Cmd_SetRealMode_f (edict_t *ent, char *value)
{
	if (ent->client->pers.admin > NOT_ADMIN ) {
		CHECKFIXED("dm_realmode");
	} else
		cprintf(ent,PRINT_HIGH,"You do not have admin\n");
}


void Cmd_SetPassword_f (edict_t *ent, char *value)
{
	if (ent->client->pers.admin > NOT_ADMIN ) {
		if (enable_password)
			gi.cvar_set("password",value);
		else
			cprintf(ent,PRINT_HIGH,"The password option is disabled\n");
	} else
		cprintf(ent,PRINT_HIGH,"You do not have admin\n");
}

void Cmd_SetTeamplay_f (edict_t *ent, char *value)
{
	int		i;

	i = atoi (value);
	if ((i == 0) || (i == 1) || (i== 4))
		if (ent->client->pers.admin > NOT_ADMIN ) {
			CHECKFIXED("teamplay");
		} else
			cprintf(ent,PRINT_HIGH,"You do not have admin\n");
	else
		cprintf(ent,PRINT_HIGH,"Teamplay settings are as follows:\n 0: Free for all DM\n 1: Bagman\n 4: Team DM\n");
}

void Cmd_ResetServer_f (edict_t *ent)
{
	if (ent->client->pers.admin > NOT_ADMIN ) 
		ResetServer();
	else
		cprintf(ent,PRINT_HIGH,"You do not have admin\n");
}


//===================================================================================
//===================================================================================

void Cmd_Admin_f (edict_t *ent, char *value)
{
	int			i,found;
	edict_t		*player;

	if (!admincode[0]) {
		cprintf(ent,PRINT_HIGH,"The admin option is disabled\n");
		return;
	}

	if (!Q_stricmp(admincode, value))
	{
		found = FALSE;

		for (i=0 ; i<maxclients->value ; i++)
		{
			player = g_edicts + 1 + i;
			if (!player->inuse)
				continue;
			if (player->client->pers.admin == ADMIN)
				found = ADMIN;
			else if (player->client->pers.admin == ELECTED)
			{	
				player->client->pers.admin = NOT_ADMIN;
				gi.bprintf(PRINT_HIGH,"%s has been removed from admin\n", player->client->pers.netname);
				found = ELECTED;
			}
		}

		if (found == ADMIN)
		{
			cprintf(ent,PRINT_HIGH,"Someone already has admin\n");
			return;
		}

		ent->client->pers.admin = ADMIN;
		gi.bprintf(PRINT_HIGH,"%s is now admin.\n",ent->client->pers.netname);
		Cmd_CommandList_f(ent);
	}
	else
		cprintf(ent,PRINT_HIGH,"** COMMAND FAILED ** Wrong admin code\n");
}

void Cmd_Resign_f (edict_t *ent)
{
	if (ent->client->pers.admin > NOT_ADMIN ) 
	{
		ent->client->pers.admin = NOT_ADMIN;
//		admin_name[0] = 0;
		cprintf(ent,PRINT_HIGH,"You are no longer admin.\n");

	}
}

//===================================================================================
//===================================================================================

void checkkick(edict_t *ent,char *cmd, char *action)
{
	int a;
	char *name;
	if (gi.argc()!=3) {
		cprintf(ent,PRINT_HIGH,"Usage: %s <userid>\n",cmd);
		return;
	}
	name=gi.argv(2);
	a=atoi(name);
	if (!strcmp(name,"0") || (a>0 && a<maxclients->value)) {
		a++;
		if (g_edicts[a].inuse && g_edicts[a].client)
			gi.bprintf(PRINT_HIGH,"%s is being %s by %s\n",g_edicts[a].client->pers.netname,action,ent->client->pers.netname);
		else
			cprintf(ent,PRINT_HIGH,"Client %s is not active\n",name);
	} else {
		for (a=1;a<=maxclients->value;a++)
			if (g_edicts[a].inuse && g_edicts[a].client
				&& !Q_strcasecmp(g_edicts[a].client->pers.netname,name)) break;
		if (a>maxclients->value)
			cprintf(ent,PRINT_HIGH,"Userid %s is not on the server\n",name);
		else
			gi.bprintf(PRINT_HIGH,"%s is being %s by %s\n",g_edicts[a].client->pers.netname,action,ent->client->pers.netname);
	}
}

void dumpuser(edict_t *ent, edict_t *target)
{
	char *info=target->client->pers.userinfo,*s,buf[64];

	cprintf(ent,PRINT_HIGH,"userinfo\n--------\n");
	while (*info) {
		if (*info=='\\') info++;
		s=info;
		while (*s && *s!='\\') s++;
		if (!*s) return;
		memcpy(buf,info,(int)s-(int)info);
		buf[(int)s-(int)info]=0;
		info=++s;
		cprintf(ent,PRINT_HIGH,"%-20s",buf);
		while (*s && *s!='\\') s++;
		memcpy(buf,info,(int)s-(int)info);
		buf[(int)s-(int)info]=0;
		info=++s;
		cprintf(ent,PRINT_HIGH,"%s\n",buf);
	}

	cprintf(ent,PRINT_HIGH,"%s\n",s);

}

void Cmd_Rcon_f (edict_t *ent)
{
	char *cmd,cmdline[256];
	int a;

	if (!num_rconx_pass) {
		cprintf(ent,PRINT_HIGH,"The rconx options are disabled\n");
		return;
	}

	if (!ent->client->pers.rconx[0]) {
		cprintf(ent,PRINT_HIGH,"You must login with \"rconx_login\" before using \"rconx\"\n");
		return;
	}

	if (gi.argc()<2) return;
	cmd=gi.argv(1);
	if (!Q_strncasecmp(cmd,"rcon",4)) return;

	strcpy(cmdline,cmd);
	for (a=2;a<gi.argc();a++) {
		strcat(cmdline," \"");
		strcat(cmdline,gi.argv(a));
		strcat(cmdline,"\"");
	}
	gi.dprintf("rconx (%s:%s) %s\n",ent->client->pers.netname,ent->client->pers.rconx,cmdline);

	if (!Q_stricmp(cmd,"status")) {
		cprintf(ent,PRINT_HIGH,"map              : %s\n",level.mapname);
		cprintf(ent,PRINT_HIGH,"num score ping name            address               ver  rconx\n");
		cprintf(ent,PRINT_HIGH,"--- ----- ---- --------------- --------------------- ---- -----\n");
		for (a=1;a<=maxclients->value;a++) {
			if (g_edicts[a].inuse && g_edicts[a].client) {
				gclient_t *c=g_edicts[a].client;
				cprintf(ent,PRINT_HIGH,"%3d",a-1);
				cprintf(ent,PRINT_HIGH," %5d",c->resp.score);
				cprintf(ent,PRINT_HIGH," %4d",c->ping);
				cprintf(ent,PRINT_HIGH," %-15s",c->pers.netname);
				cprintf(ent,PRINT_HIGH," %-21s",c->pers.ip);
				cprintf(ent,PRINT_HIGH," %.2f",(float)c->pers.version/100.0);
				cprintf(ent,PRINT_HIGH,"  %s\n",c->pers.rconx[0]?"yes":"");
			}
		}
		return;
	} else if (!Q_stricmp(cmd,"serverinfo")) {
		cvar_t *v=dm_realmode;
		cprintf(ent,PRINT_HIGH,"Server info settings:\n");
		cprintf(ent,PRINT_HIGH,"mapname              %s\n",level.mapname);
		while (v) {
			if (v->flags&CVAR_SERVERINFO)
				cprintf(ent,PRINT_HIGH,"%-21s%s\n",v->name,v->string);
			v=v->next;
		}
		return;
	} else if (!Q_stricmp(cmd,"dumpuser")) {
		char *name;
		if (gi.argc()!=3) {
			cprintf(ent,PRINT_HIGH,"Usage: %s <userid>\n",cmd);
			return;
		}
		name=gi.argv(2);
		a=atoi(name);
		if (!strcmp(name,"0") || (a>0 && a<maxclients->value)) {
			a++;
			if (g_edicts[a].inuse && g_edicts[a].client)
				dumpuser(ent,g_edicts+a);
			else
				cprintf(ent,PRINT_HIGH,"Client %s is not active\n",name);
		} else {
			for (a=1;a<=maxclients->value;a++)
				if (g_edicts[a].inuse && g_edicts[a].client
					&& !Q_strcasecmp(g_edicts[a].client->pers.netname,name)) break;
			if (a>maxclients->value)
				cprintf(ent,PRINT_HIGH,"Userid %s is not on the server\n",name);
			else
				dumpuser(ent,g_edicts+a);
		}
		return;
	}
	else if (!Q_stricmp(cmd,"kick")) checkkick(ent,cmd,"kicked");
	else if (!Q_stricmp(cmd,"kickban")) checkkick(ent,cmd,"kicked & banned");
	else if (gi.argc()==2) {
		char *val=gi.cvar(cmd,"",0)->string;
		if (val[0]) {
			cprintf(ent,PRINT_HIGH,"\"%s\" is \"%s\"\n",cmd,val);
			return;
		}
	}

	gi.AddCommandString(cmdline);
}

void Cmd_Rcon_login_f (edict_t *ent, char *pass)
{
	int a;
	time_t t;

	if (!num_rconx_pass) {
		cprintf(ent,PRINT_HIGH,"The rconx options are disabled\n");
		return;
	}

	pass[31]=0;
	for (a=0;a<num_rconx_pass;a++)
		if (!Q_stricmp(pass,rconx_pass[a].value)) break;
	if (a==num_rconx_pass) {
		ent->client->pers.rconx[0]=0;
		cprintf(ent,PRINT_HIGH,"Invalid rconx login\n");
		return;
	}
	strcpy(ent->client->pers.rconx,pass);
	time(&t);
	gi.dprintf("rconx_login (%s:%s) ip: %s time: %s\n",ent->client->pers.netname,ent->client->pers.rconx,ent->client->pers.ip,ctime(&t));
	cprintf(ent,PRINT_HIGH,"Successfully logged in\n");
}

/////begin Curse Commands

qboolean Hogie_Filter(edict_t *ent)
{
	int		i;
	gclient_t *cl;
//boop
	//can't talk if you just talked or tried to talk less than 3 seconds ago.
	if (ent->client->last_wave > (level.time - 3) && (ent->client->last_wave <= level.time))
    return false;
	
	if(!deathmatch->value) ent->gender = GENDER_MALE;
	//cant talk if your dying.
	if (ent->health <= 10)
	{
//		gi.cprintf(ent, PRINT_CHAT, "%s is too ill to speak!\n" , ent->client->pers.netname );
		//mark the last time that you talked.
	    ent->client->last_wave = level.time;
		return false; 
	}

	//cant cuss if underwater
	if (ent->waterlevel >= 2)
	{	//mark the last time that you talked.
	    ent->client->last_wave = level.time;
//		gi.cprintf(ent, PRINT_CHAT, "%s is trying to curse underwater!\n" , ent->client->pers.netname );
		return false; 
	}

	// can't wave when ducked.
	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
		return false;

	if (flood_msgs->value) 
	{
	  cl = ent->client;

      if (level.time < cl->flood_locktill) 
	  {
			gi.cprintf(ent, PRINT_HIGH, "You can't talk for %d more seconds\n",
				(int)(cl->flood_locktill - level.time));
            return false;
      }

      i = cl->flood_whenhead - flood_msgs->value + 1;

      if (i < 0)
          i = (sizeof(cl->flood_when)/sizeof(cl->flood_when[0])) + i;
		if (cl->flood_when[i] && 
			level.time - cl->flood_when[i] < flood_persecond->value) {
			cl->flood_locktill = level.time + flood_waitdelay->value;
//			gi.cprintf(ent, PRINT_CHAT, "Flood protection:  You can't talk for %d seconds.\n",
//				(int)flood_waitdelay->value);
         return false;
      }

      // if they repeat themselves really quickly, bitch-slap time
		if (cl->flood_when[cl->flood_whenhead] && (cl->flood_when[cl->flood_whenhead] > level.time - 1) )
		{
			cl->flood_locktill = level.time + flood_waitdelay->value;
//			gi.cprintf(ent, PRINT_CHAT, "Flood protection:  You can't talk for %d seconds.\n",
//				(int)flood_waitdelay->value);
         return false;
		}

		cl->flood_whenhead = (cl->flood_whenhead + 1) %
			(sizeof(cl->flood_when)/sizeof(cl->flood_when[0]));
		cl->flood_when[cl->flood_whenhead] = level.time;
	}



	if (ent->client->anim_priority > ANIM_WAVE)
	return false;

    ent->client->anim_priority = ANIM_WAVE;
	//mark the last time that you talked.
	ent->client->last_wave = level.time;
	return true;
}

//FRANK Feb21,00
/*
==================
Cmd_Barcode_f //private fucntion for server admin: Barcode
==================
*/
void Cmd_Hexed_f (edict_t *ent)
{
	int		i;
	static int	rnd;

	if(!Hogie_Filter(ent))
		return;

    rnd = (rnd + 1) % 13;
	switch (rnd)
	{
	case 0:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/eatlead2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		//ent->s.frame = FRAME_tg_bird_01-1;
		//ent->client->anim_end = FRAME_tg_bird_10;
		break;

	case 1:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/eatlead1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		//ent->s.frame = FRAME_tg_crch_grab_01-1;
		//ent->client->anim_end = FRAME_tg_crch_grab_16;
		break;

	case 2:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/fucker.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
   		//ent->s.frame = FRAME_tg_chin_flip_01-1;
		//ent->client->anim_end = FRAME_tg_chin_flip_15;
		break;

	case 3:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/fuckyou2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	case 4:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/pieceshit.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 5:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/takesome.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;

	case 6:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/ratfuck.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	case 7:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/player/male/profanity/level1/cuss1-10.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0);
		break;

	case 8:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/player/male/profanity/level2/cuss2-15.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 9:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/player/male/peekaboo.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		//ent->s.frame = FRAME_tg_bird_01-1;
		//ent->client->anim_end = FRAME_tg_bird_10;
		break;

	case 10:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/player/male/profanity/level3/cuss3-1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		//ent->s.frame = FRAME_tg_crch_grab_01-1;
		//ent->client->anim_end = FRAME_tg_crch_grab_16;
		break;

	case 11:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/player/male/profanity/level3/cuss3-2.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
   		//ent->s.frame = FRAME_tg_chin_flip_01-1;
		//ent->client->anim_end = FRAME_tg_chin_flip_15;
		break;

	case 12:
	default:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/ratfuck.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-1.wav"), 1, ATTN_NORM, 0);
		break;
	}

	//pick a taunt wave.
	i = rand() % 3;
	switch(i)
	{
	case 0: ent->s.frame = FRAME_tg_bird_01-1;
			ent->client->anim_end = FRAME_tg_bird_10;
			break;
	case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
		    ent->client->anim_end = FRAME_tg_crch_grab_16;
		    break;
	case 2:
	default: ent->s.frame = FRAME_tg_chin_flip_01-1;
		     ent->client->anim_end = FRAME_tg_chin_flip_15;
	}

}

/*
==================
Cmd_Corleone_f       Frank 10/4/02 for $20
==================
*/
void Cmd_Corleone_f (edict_t *ent)
{
	int i;
	static int	rnd;
	if(!Hogie_Filter(ent))
		return;
    rnd = (rnd + 1) % 19;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/luke/hostile1.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/luke/hostile2.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/luke/hostile3.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/joseph/motard.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/joseph/ripass.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/lizzy1.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kroker/opensafe.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/neutral/talk7.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level1/cuss1-2.wav"), 1, ATTN_NORM, 0); break;

	default:
	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/postfind3.wav"), 1, ATTN_NORM, 0); break;

	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lenny/stole1.wav"), 1, ATTN_NORM, 0); break;

	case 11: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lenny/idle1.wav"), 1, ATTN_NORM, 0); break;

	case 12: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lenny/killme.wav"), 1, ATTN_NORM, 0); break;

	case 13: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lenny/stole2.wav"), 1, ATTN_NORM, 0); break;

	case 14: gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/skidrow/leroy/mybitch2.wav"), 1, ATTN_NORM, 0); break;

	case 15: gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/skidrow/magicj/gimmedollar.wav"), 1, ATTN_NORM, 0); break;

	case 16: gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/skidrow/magicj/fuckup.wav"), 1, ATTN_NORM, 0); break;

	case 17: gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/fighting/infacemf.wav"), 1, ATTN_NORM, 0); break;

	case 18: gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/fighting/f_die3.wav"), 1, ATTN_NORM, 0); break;

	}

	if((rand()%2)==0)
	{
		//pick a taunt wave only once out of 10 waves
		 i = rand() % 3;
		 switch(i)
		 {
			case 0: ent->s.frame = FRAME_tg_bird_01-1;
					ent->client->anim_end = FRAME_tg_bird_10;
					break;
			case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
					ent->client->anim_end = FRAME_tg_crch_grab_16;
					break;
			case 2:
					default: ent->s.frame = FRAME_tg_chin_flip_01-1;
					ent->client->anim_end = FRAME_tg_chin_flip_15;
		 }
	}
}//end Cmd_Corleone_f

//FRANK June26,00
/*
==================
Cmd_Jaxon_f
==================
*/
void Cmd_Jaxon_f (edict_t *ent)
{
	int		i;
	static int	rnd;

	if(!Hogie_Filter(ent))
		return;

    rnd = (rnd + 1) % 16;
	switch (rnd)
	{
	case 0:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/ambient/conv14.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		//ent->s.frame = FRAME_tg_bird_01-1;
		//ent->client->anim_end = FRAME_tg_bird_10;
		break;

	case 1:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/dogg/dogg3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		//ent->s.frame = FRAME_tg_crch_grab_01-1;
		//ent->client->anim_end = FRAME_tg_crch_grab_16;
		break;

	case 2:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hann/hostile2.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
   		//ent->s.frame = FRAME_tg_chin_flip_01-1;
		//ent->client->anim_end = FRAME_tg_chin_flip_15;
		break;

	case 3:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hann/hostile3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	case 4:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/larry.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 5:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/hostile1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;

	case 6:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/funny7.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	case 7:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/funny4.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0);
		break;

	case 8:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/funny2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 9:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/fight4.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		//ent->s.frame = FRAME_tg_bird_01-1;
		//ent->client->anim_end = FRAME_tg_bird_10;
		break;

	case 10:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/fight3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		//ent->s.frame = FRAME_tg_crch_grab_01-1;
		//ent->client->anim_end = FRAME_tg_crch_grab_16;
		break;

	case 11:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/fight2.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
   		//ent->s.frame = FRAME_tg_chin_flip_01-1;
		//ent->client->anim_end = FRAME_tg_chin_flip_15;
		break;

	case 12:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/fight1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;


	case 13:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("world/pawnomatic/funny1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;

	case 14:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("world/pawnomatic/armor_head2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	default:
	case 15:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/magicj/fuckshit.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0);
		break;

	}

	//pick a taunt wave.
	i = rand() % 3;
	switch(i)
	{
	case 0: ent->s.frame = FRAME_tg_bird_01-1;
			ent->client->anim_end = FRAME_tg_bird_10;
			break;
	case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
		    ent->client->anim_end = FRAME_tg_crch_grab_16;
		    break;
	case 2:
	default: ent->s.frame = FRAME_tg_chin_flip_01-1;
		     ent->client->anim_end = FRAME_tg_chin_flip_15;
	}

} // end Jaxon_Curse


//FRANK 9/12/00
/*
==================
Cmd_Sephi_f
==================
*/
void Cmd_Sephi_f (edict_t *ent)
{
	int		i;
	static int	rnd;

	if(!Hogie_Filter(ent))
		return;

    rnd = (rnd + 1) % 15;
	switch (rnd)
	{
	case 0:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/dogg/dogg5.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		//ent->s.frame = FRAME_tg_bird_01-1;
		//ent->client->anim_end = FRAME_tg_bird_10;
		break;

	case 1:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/david/david3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		//ent->s.frame = FRAME_tg_crch_grab_01-1;
		//ent->client->anim_end = FRAME_tg_crch_grab_16;
		break;

	case 2:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lenny/killme2.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
   		//ent->s.frame = FRAME_tg_chin_flip_01-1;
		//ent->client->anim_end = FRAME_tg_chin_flip_15;
		break;

	case 3:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lenny/leave.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	case 4:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/louie/getout3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 5:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/louie/morgue.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;

	case 6:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/neutral/talk13.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	case 7:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/neutral/talk8.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0);
		break;

	case 8:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/cowar2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 9:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/moe1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		//ent->s.frame = FRAME_tg_bird_01-1;
		//ent->client->anim_end = FRAME_tg_bird_10;
		break;

	case 10:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/killhim.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		//ent->s.frame = FRAME_tg_crch_grab_01-1;
		//ent->client->anim_end = FRAME_tg_crch_grab_16;
		break;

	case 11:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/cowar3.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
   		//ent->s.frame = FRAME_tg_chin_flip_01-1;
		//ent->client->anim_end = FRAME_tg_chin_flip_15;
		break;

	case 12:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/scalper/curse1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;


	case 13:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/scalper/curse2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;
	default:
	case 14:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/scalper/curse3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	}

	//pick a taunt wave.
	i = rand() % 3;
	switch(i)
	{
	case 0: ent->s.frame = FRAME_tg_bird_01-1;
			ent->client->anim_end = FRAME_tg_bird_10;
			break;
	case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
		    ent->client->anim_end = FRAME_tg_crch_grab_16;
		    break;
	case 2:
	default: ent->s.frame = FRAME_tg_chin_flip_01-1;
		     ent->client->anim_end = FRAME_tg_chin_flip_15;
	}

} // end Sephi_Curse



//FRANK June26,00
/*
==================
Cmd_Whoop_f
==================
*/
void Cmd_Whoop_f (edict_t *ent)
{
	int i;
	static int rnd;

    if(!Hogie_Filter(ent))
		return;

    rnd = (rnd + 1) % 13;
	switch (rnd)
	{
	case 0:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/scalper/amb1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		//ent->s.frame = FRAME_tg_bird_01-1;
		//ent->client->anim_end = FRAME_tg_bird_10;
		break;

	case 1:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/scalper/buyticket1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		//ent->s.frame = FRAME_tg_crch_grab_01-1;
		//ent->client->anim_end = FRAME_tg_crch_grab_16;
		break;

	case 2:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/scalper/yes2.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
   		//ent->s.frame = FRAME_tg_chin_flip_01-1;
		//ent->client->anim_end = FRAME_tg_chin_flip_15;
		break;

	case 3:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/hostile1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	case 4:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kroker/getout.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 5:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/funny6.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;

	case 6:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/funny7.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	case 7:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/wounded/friendlyfire2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0);
		break;

	case 8:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/ambient/conv14.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 9:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/player/male/peekaboo.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		//ent->s.frame = FRAME_tg_bird_01-1;
		//ent->client->anim_end = FRAME_tg_bird_10;
		break;

	case 10:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("world/pawnomatic/funny3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		//ent->s.frame = FRAME_tg_crch_grab_01-1;
		//ent->client->anim_end = FRAME_tg_crch_grab_16;
		break;

	case 11:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/skidrow/leroy/stepoff.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
   		//ent->s.frame = FRAME_tg_chin_flip_01-1;
		//ent->client->anim_end = FRAME_tg_chin_flip_15;
		break;

	case 12:
	default:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/skidrow/leroy/warned.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	}

	//pick a taunt wave.
	i = rand() % 3;
	switch(i)
	{
	case 0: ent->s.frame = FRAME_tg_bird_01-1;
			ent->client->anim_end = FRAME_tg_bird_10;
			break;
	case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
		    ent->client->anim_end = FRAME_tg_crch_grab_16;
		    break;
	case 2:
	default: ent->s.frame = FRAME_tg_chin_flip_01-1;
		     ent->client->anim_end = FRAME_tg_chin_flip_15;
	}

} // end Whoop_Curse


//FRANK June26,00
/*
==================
Cmd_Cuts_f
==================
*/
void Cmd_Cuts_f (edict_t *ent)
{

	int		i;
	static int	rnd;
	gclient_t *cl;

	//can't talk if you just talked or tried to talk less than 30 seconds ago.
	if (ent->client->last_wave > (level.time - 30) && (ent->client->last_wave <= level.time))
    return;

	//cant talk if your dying.
	if (ent->health <= 10)
	{
//		gi.cprintf(ent, PRINT_CHAT, "%s is too ill to speak!\n" , ent->client->pers.netname );
		//mark the last time that you talked.
	    ent->client->last_wave = level.time;
		return; 
	}

	// can't wave when ducked.
	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
		return;

	if (flood_msgs->value) 
	{
	  cl = ent->client;

      if (level.time < cl->flood_locktill) 
	  {
			gi.cprintf(ent, PRINT_HIGH, "You can't talk for %d more seconds\n",
				(int)(cl->flood_locktill - level.time));
            return;
      }

      i = cl->flood_whenhead - flood_msgs->value + 1;

      if (i < 0)
          i = (sizeof(cl->flood_when)/sizeof(cl->flood_when[0])) + i;
		if (cl->flood_when[i] && 
			level.time - cl->flood_when[i] < flood_persecond->value) {
			cl->flood_locktill = level.time + flood_waitdelay->value;
//			gi.cprintf(ent, PRINT_CHAT, "Flood protection:  You can't talk for %d seconds.\n",
//			(int)flood_waitdelay->value);
	      return;
      }

      // if they repeat themselves really quickly, bitch-slap time
		if (cl->flood_when[cl->flood_whenhead] && (cl->flood_when[cl->flood_whenhead] > level.time - 1) )
		{
			cl->flood_locktill = level.time + flood_waitdelay->value;
//			gi.cprintf(ent, PRINT_CHAT, "Flood protection:  You can't talk for %d seconds.\n",
//				(int)flood_waitdelay->value);
         return;
		}

		cl->flood_whenhead = (cl->flood_whenhead + 1) %
			(sizeof(cl->flood_when)/sizeof(cl->flood_when[0]));
		cl->flood_when[cl->flood_whenhead] = level.time;
	}

	if (ent->client->anim_priority > ANIM_WAVE)
	return;

    ent->client->anim_priority = ANIM_WAVE;
	//mark the last time that you talked.
	ent->client->last_wave = level.time;

    rnd = (rnd + 1) % 12;
	switch (rnd)
	{
	case 0:	gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/cut_pv1.wav"), 1, ATTN_NORM, 0);		break;

	case 1:	gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/cut_pv2.wav"), 1, ATTN_NORM, 0);     break;

	case 2:	gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/cut1.wav"), 1, ATTN_NORM, 0);		break;

	case 3:	gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/cut2.wav"), 1, ATTN_NORM, 0);		break;

	case 4:	gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/cut2_1.wav"), 1, ATTN_NORM, 0);		break;

	case 5:	gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/cut3_2.wav"), 1, ATTN_NORM, 0);		break;

	case 6:	gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/kpcut2.wav"), 1, ATTN_NORM, 0);		break;

	case 7:	gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/kpcut3.wav"), 1, ATTN_NORM, 0);		break;

	case 8:	gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/kpcut4.wav"), 1, ATTN_NORM, 0);		break;

	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/kpcut5.wav"), 1, ATTN_NORM, 0);		break;

	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/kpcut7.wav"), 1, ATTN_NORM, 0);     break;

	case 11:
	default: gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/sycut.wav"), 1, ATTN_NORM, 0);
	}

	//pick a taunt wave.
	i = rand() % 3;
	switch(i)
	{
	case 0: ent->s.frame = FRAME_tg_bird_01-1;
			ent->client->anim_end = FRAME_tg_bird_10;
			break;
	case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
		    ent->client->anim_end = FRAME_tg_crch_grab_16;
		    break;
	case 2:
	default: ent->s.frame = FRAME_tg_chin_flip_01-1;
		     ent->client->anim_end = FRAME_tg_chin_flip_15;
	}

} // end CutScenes


//FRANK June26,00
/*
==================
Cmd_Cypress_f
==================
*/
void Cmd_Cypress_f (edict_t *ent)
{

	int		i;
	static int	rnd;
	gclient_t *cl;

	//can't talk if you just talked or tried to talk less than 15 seconds ago.
	if (ent->client->last_wave > (level.time - 15) && (ent->client->last_wave <= level.time))
    return;
	
	//cant talk if your dying.
	if (ent->health <= 10)
	{
//		gi.cprintf(ent, PRINT_CHAT, "%s is too ill to speak!\n" , ent->client->pers.netname );
		//mark the last time that you talked.
	    ent->client->last_wave = level.time;
		return; 
	}

	// can't wave when ducked.
	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
		return;

	if (flood_msgs->value) 
	{
	  cl = ent->client;

      if (level.time < cl->flood_locktill) 
	  {
			gi.cprintf(ent, PRINT_HIGH, "You can't talk for %d more seconds\n",
				(int)(cl->flood_locktill - level.time));
            return;
      }

      i = cl->flood_whenhead - flood_msgs->value + 1;

      if (i < 0)
          i = (sizeof(cl->flood_when)/sizeof(cl->flood_when[0])) + i;
		if (cl->flood_when[i] && 
			level.time - cl->flood_when[i] < flood_persecond->value) {
			cl->flood_locktill = level.time + flood_waitdelay->value;
	//		gi.cprintf(ent, PRINT_CHAT, "Flood protection:  You can't talk for %d seconds.\n",
	//			(int)flood_waitdelay->value);
         return;
      }

      // if they repeat themselves really quickly, bitch-slap time
		if (cl->flood_when[cl->flood_whenhead] && (cl->flood_when[cl->flood_whenhead] > level.time - 1) )
		{
			cl->flood_locktill = level.time + flood_waitdelay->value;
//			gi.cprintf(ent, PRINT_CHAT, "Flood protection:  You can't talk for %d seconds.\n",
	//			(int)flood_waitdelay->value);
         return;
		}

		cl->flood_whenhead = (cl->flood_whenhead + 1) %
			(sizeof(cl->flood_when)/sizeof(cl->flood_when[0]));
		cl->flood_when[cl->flood_whenhead] = level.time;
	}



	if (ent->client->anim_priority > ANIM_WAVE)
	return;

    ent->client->anim_priority = ANIM_WAVE;
	//mark the last time that you talked.
	ent->client->last_wave = level.time;

    rnd = (rnd + 1) % 4;
	switch (rnd)
	{
	case 0:	gi.sound(ent, CHAN_AUTO, gi.soundindex("world/cypress.wav"), 1, ATTN_NORM, 0);		break;

	case 1:	gi.sound(ent, CHAN_AUTO, gi.soundindex("world/cypress2.wav"), 1, ATTN_NORM, 0);		break;

	case 2:	gi.sound(ent, CHAN_AUTO, gi.soundindex("world/cypress3.wav"), 1, ATTN_NORM, 0);		break;

	default:
	case 3:	gi.sound(ent, CHAN_AUTO, gi.soundindex("world/cypress4.wav"), 1, ATTN_NORM, 0);		break;
	}

	//pick a taunt wave.
	i = rand() % 3;
	switch(i)
	{
	case 0: ent->s.frame = FRAME_tg_bird_01-1;
			ent->client->anim_end = FRAME_tg_bird_10;
			break;
	case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
		    ent->client->anim_end = FRAME_tg_crch_grab_16;
		    break;
	case 2:
	default: ent->s.frame = FRAME_tg_chin_flip_01-1;
		     ent->client->anim_end = FRAME_tg_chin_flip_15;
	}

} // end CypressHill

//FRANK Jan25,00
/*
==================
Cmd_Hogie_f
==================
*/
void Cmd_Hogie_f (edict_t *ent)
{
	int		i;
	static int	rnd;

	if(!Hogie_Filter(ent))
		return;

    rnd = (rnd + 1) % 23;
	switch (rnd)
	{
	case 0:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/rand3.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		//ent->s.frame = FRAME_tg_bird_01-1;
		//ent->client->anim_end = FRAME_tg_bird_10;
		break;

	case 1:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/bum/swat.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		//ent->s.frame = FRAME_tg_crch_grab_01-1;
		//ent->client->anim_end = FRAME_tg_crch_grab_16;
		break;

	case 2:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/fuckthem1.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
   		//ent->s.frame = FRAME_tg_chin_flip_01-1;
		//ent->client->anim_end = FRAME_tg_chin_flip_15;
		break;

	case 3:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/getme2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	case 4:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/nogot1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 5:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/nogot2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;

	case 6:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/yesgot2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	case 7:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/curse1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0);
		break;

	case 8:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/curse2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 9:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/bum/bum.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		//ent->s.frame = FRAME_tg_bird_01-1;
		//ent->client->anim_end = FRAME_tg_bird_10;
		break;

	case 10:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/bum/pain.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		//ent->s.frame = FRAME_tg_crch_grab_01-1;
		//ent->client->anim_end = FRAME_tg_crch_grab_16;
		break;

	case 11:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/bum/swat.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
   		//ent->s.frame = FRAME_tg_chin_flip_01-1;
		//ent->client->anim_end = FRAME_tg_chin_flip_15;
		break;

	case 12:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/bum/death.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	case 13:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/bum/sit.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 14:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/bum/shuffle.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;

	case 15:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/worked2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	case 16:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/fuckthem2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0);
		break;

	case 17:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/magicj/holdbuck.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 22:
	default:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/rand4.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-1.wav"), 1, ATTN_NORM, 0);
		break;

	case 19:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/curse3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 20:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/rand1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 21:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/rand2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	case 18:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/yesgot1.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;
	}

	if(rand()%2==0)
	{
		//pick a taunt wave.
		i = rand() % 3;
		switch(i)
		{
		case 0: ent->s.frame = FRAME_tg_bird_01-1;
				ent->client->anim_end = FRAME_tg_bird_10;
				break;
		case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
				ent->client->anim_end = FRAME_tg_crch_grab_16;
				break;
		case 2:
		default: ent->s.frame = FRAME_tg_chin_flip_01-1;
				 ent->client->anim_end = FRAME_tg_chin_flip_15;
		}
	}

}

qboolean Curse_Filter(edict_t *ent , qboolean gender)
{
	int i;
	gclient_t *cl;
	char *cmd;
	cmd = gi.argv(0);
	//can't talk if you just talked or tried to talk less than 3 seconds ago.
	if (ent->client->last_wave > (level.time - 3) && (ent->client->last_wave <= level.time))
    return false;
	
	if (!deathmatch->value) // Curse2 this is a fix for single player
		ent->gender = GENDER_MALE;

	//kingpin has to be male.
	if ((!(ent->gender == GENDER_MALE)) && (gender))
	{
		gi.cprintf(ent, PRINT_CHAT, ">> %s is a MALE taunt!\n>> %s is female.\n" , cmd, ent->client->pers.netname );
		ent->client->last_wave = level.time;
		return false;
	}	

	else if ((!(ent->gender == GENDER_FEMALE)) && (!gender) )
	{
		gi.cprintf(ent, PRINT_CHAT, ">> %s is a FEMALE taunt!\n>> %s is male.\n" , cmd, ent->client->pers.netname );
		ent->client->last_wave = level.time;
		return false;
	}

	//cant talk if your dying.
	if (ent->health <= 10)
	{
		gi.cprintf(ent, PRINT_CHAT, "%s is too ill to speak!\n" , ent->client->pers.netname );
		//mark the last time that you talked.
	    ent->client->last_wave = level.time;
		return false; 
	}

	//cant cuss if underwater
	if (ent->waterlevel >= 2)
	{	//mark the last time that you talked.
	    ent->client->last_wave = level.time;
		gi.cprintf(ent, PRINT_CHAT, "%s is trying to curse underwater!\n" , ent->client->pers.netname );
		return false; 
	}

	// can't wave when ducked.
	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED) return false;
	if (ent->client->anim_priority > ANIM_WAVE)	return false;

    ent->client->anim_priority = ANIM_WAVE;

	//mark the last time that you talked.
	ent->client->last_wave = level.time;

	if (flood_msgs->value) 
	{
	  cl = ent->client;

      if (level.time < cl->flood_locktill) 
	  {
			gi.cprintf(ent, PRINT_HIGH, "You can't talk for %d more seconds\n",
				(int)(cl->flood_locktill - level.time));
            return false;
      }

      i = cl->flood_whenhead - flood_msgs->value + 1;

      if (i < 0) i = (sizeof(cl->flood_when)/sizeof(cl->flood_when[0])) + i;

	  if (cl->flood_when[i] && level.time - cl->flood_when[i] < flood_persecond->value) 
	  {
		cl->flood_locktill = level.time + flood_waitdelay->value;
		gi.cprintf(ent, PRINT_CHAT, "Flood protection:  You can't talk for %d seconds.\n",(int)flood_waitdelay->value);
        return false;
      }

      // if they repeat themselves really quickly, bitch-slap time
	  if (cl->flood_when[cl->flood_whenhead] && (cl->flood_when[cl->flood_whenhead] > level.time - 1) )
	  {
		cl->flood_locktill = level.time + flood_waitdelay->value;
		gi.cprintf(ent, PRINT_CHAT, "Flood protection:  You can't talk for %d seconds.\n",(int)flood_waitdelay->value);
        return false;
	  }

	  cl->flood_whenhead = (cl->flood_whenhead + 1) %	(sizeof(cl->flood_when)/sizeof(cl->flood_when[0]));
	  cl->flood_when[cl->flood_whenhead] = level.time;
	}

	return true;
}

//FRANK Jan28,00
/*
==================
Cmd_Kingpin_f
==================
*/
void Cmd_Kingpin_f (edict_t *ent)
{	int i;
	static int	rnd;

	if(!Curse_Filter(ent,true))
		return;

    rnd = (rnd + 1) % 13;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny8.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny4.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny3.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny1.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight4.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight3.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight2.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight1.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny6.wav"), 1, ATTN_NORM, 0); break;

	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/death1.wav"), 1, ATTN_NORM, 0); break;

	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny2.wav"), 1, ATTN_NORM, 0); break;

	case 11: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny7.wav"), 1, ATTN_NORM, 0); break;

	default:
    case 12: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/warned.wav"), 1, ATTN_NORM, 0);
			//pick a taunt wave only once out of 13 waves
	         i = rand() % 3;
	         switch(i)
			 {
				case 0: ent->s.frame = FRAME_tg_bird_01-1;
						ent->client->anim_end = FRAME_tg_bird_10;
						break;
				case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
						ent->client->anim_end = FRAME_tg_crch_grab_16;
						break;
				case 2:
						default: ent->s.frame = FRAME_tg_chin_flip_01-1;
						ent->client->anim_end = FRAME_tg_chin_flip_15;
			 }
	}

}



//FRANK Jan28,00
/*
==================
Cmd_Leroy_f
==================
*/
void Cmd_Leroy_f (edict_t *ent)
{
	int i;
	static int	rnd;

	if(!Curse_Filter(ent,true))
		return;

    rnd = (rnd + 1) % 10;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/stepoff.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/conv10.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/warned.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/fuckyou.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/die.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/conv11.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/conv8.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/conv9.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/mybitch1.wav"), 1, ATTN_NORM, 0); break;

	case 9: 
	default: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/whatsup.wav"), 1, ATTN_NORM, 0); break;
			//pick a taunt wave only once out of 10 waves
	         i = rand() % 3;
	         switch(i)
			 {
				case 0: ent->s.frame = FRAME_tg_bird_01-1;
						ent->client->anim_end = FRAME_tg_bird_10;
						break;
				case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
						ent->client->anim_end = FRAME_tg_crch_grab_16;
						break;
				case 2:
						default: ent->s.frame = FRAME_tg_chin_flip_01-1;
						ent->client->anim_end = FRAME_tg_chin_flip_15;
			 }
	}

}


//FRANK Jan28,00
/*
==================
Cmd_Lamont_f
==================
*/
void Cmd_Lamont_f (edict_t *ent)
{
	int i;
	static int	rnd;

	if(!Curse_Filter(ent,true))
		return;

    rnd = (rnd + 1) % 14;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/babble1.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/babble2.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/fuckinprob.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/fuckyou.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/getsome.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/killem.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/lenny1.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/lookinat1.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/lenny2.wav"), 1, ATTN_NORM, 0); break;

	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/lookinat2.wav"), 1, ATTN_NORM, 0); break;

	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/lenny3.wav"), 1, ATTN_NORM, 0); break;

	case 11: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/mfcomeout.wav"), 1, ATTN_NORM, 0); break;


	case 12: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/offstreet2.wav"), 1, ATTN_NORM, 0); break;

	default:
    case 13: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/outofface.wav"), 1, ATTN_NORM, 0); 
			//pick a taunt wave only once out of 14 waves
	         i = rand() % 3;
	         switch(i)
			 {
				case 0: ent->s.frame = FRAME_tg_bird_01-1;
						ent->client->anim_end = FRAME_tg_bird_10;
						break;
				case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
						ent->client->anim_end = FRAME_tg_crch_grab_16;
						break;
				case 2:
						default: ent->s.frame = FRAME_tg_chin_flip_01-1;
						ent->client->anim_end = FRAME_tg_chin_flip_15;
			 }
	}
}//end Cmd_Lamont_f



//FRANK Mar19,00
/*
==================
Cmd_Nikki_f
==================
*/
void Cmd_Nikki_f (edict_t *ent)
{
	int i;
	static int	rnd;
	if(!Curse_Filter(ent,true))
		return;
    rnd = (rnd + 1) % 10;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny6.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/fight1.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/fight2.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/fight3.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/fight4.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny1.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny2.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny3.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny4.wav"), 1, ATTN_NORM, 0); break;

	default:
	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny5.wav"), 1, ATTN_NORM, 0);
			//pick a taunt wave only once out of 10 waves
	         i = rand() % 3;
	         switch(i)
			 {
				case 0: ent->s.frame = FRAME_tg_bird_01-1;
						ent->client->anim_end = FRAME_tg_bird_10;
						break;
				case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
						ent->client->anim_end = FRAME_tg_crch_grab_16;
						break;
				case 2:
						default: ent->s.frame = FRAME_tg_chin_flip_01-1;
						ent->client->anim_end = FRAME_tg_chin_flip_15;
			 }
	}
}//end Cmd_Nikki_f

//FRANK Jan28,00
/*
==================
Cmd_Momo_f
==================
*/
void Cmd_Momo_f (edict_t *ent)
{
	int i;
	static int	rnd;
	if(!Curse_Filter(ent,true))
		return;
    rnd = (rnd + 1) % 21;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-12.wav"), 1, ATTN_NORM, 0); break;
	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-10.wav"), 1, ATTN_NORM, 0); break;
	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-13.wav"), 1, ATTN_NORM, 0); break;
	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-15.wav"), 1, ATTN_NORM, 0); break;
	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-16.wav"), 1, ATTN_NORM, 0); break;
	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-17.wav"), 1, ATTN_NORM, 0); break;
	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level1/cuss1-10.wav"), 1, ATTN_NORM, 0); break;
	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-5.wav"), 1, ATTN_NORM, 0); break;
	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-6.wav"), 1, ATTN_NORM, 0); break;
	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-7.wav"), 1, ATTN_NORM, 0); break;
	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/hostile1.wav"), 1, ATTN_NORM, 0); break;
	case 11: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/idle4.wav"), 1, ATTN_NORM, 0); break;
	case 12: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/welcome_typhoon.wav"), 1, ATTN_NORM, 0); break;
	case 13: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/hostile2.wav"), 1, ATTN_NORM, 0); break;
	case 14: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/scram.wav"), 1, ATTN_NORM, 0); break;
	case 15: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/comeback2.wav"), 1, ATTN_NORM, 0); break;
	case 16: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/idle3.wav"), 1, ATTN_NORM, 0); break;
	case 17: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/welcome_saltydog.wav"), 1, ATTN_NORM, 0); break;
	default:
    case 18: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/ladiesroom.wav"), 1, ATTN_NORM, 0); break;
	case 19: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/idle2.wav"), 1, ATTN_NORM, 0); break;
	case 20: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/welcome_boilerroom.wav"), 1, ATTN_NORM, 0); break;
	}
	if((rand()%2)==0)
	{
		//pick a taunt wave only once out of 15 waves
	     i = rand() % 3;
	     switch(i)
		 {
			case 0: ent->s.frame = FRAME_tg_bird_01-1;
					ent->client->anim_end = FRAME_tg_bird_10;
					break;
			case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
					ent->client->anim_end = FRAME_tg_crch_grab_16;
					break;
			case 2:
					default: ent->s.frame = FRAME_tg_chin_flip_01-1;
					ent->client->anim_end = FRAME_tg_chin_flip_15;
		 }
	}
}//end Cmd_Momo_f




//FRANK Jan28,00
/*
==================
Cmd_Jesus_f
==================
*/
void Cmd_Jesus_f (edict_t *ent)
{
	int i;
	static int	rnd;
	if(!Curse_Filter(ent,true))
		return;
    rnd = (rnd + 1) % 14;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/battery.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight1.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight2.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/funny2.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight4.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/funny1.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight3.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/funny3.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/funny4.wav"), 1, ATTN_NORM, 0); break;

	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/funny5.wav"), 1, ATTN_NORM, 0); break;

	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/pain3.wav"), 1, ATTN_NORM, 0); break;

	case 11: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/funny6.wav"), 1, ATTN_NORM, 0); break;


	case 12: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/pain1.wav"), 1, ATTN_NORM, 0); break;

	default:
    case 13: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight3.wav"), 1, ATTN_NORM, 0); 
			//pick a taunt wave only once out of 14 waves
	         i = rand() % 3;
	         switch(i)
			 {
				case 0: ent->s.frame = FRAME_tg_bird_01-1;
						ent->client->anim_end = FRAME_tg_bird_10;
						break;
				case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
						ent->client->anim_end = FRAME_tg_crch_grab_16;
						break;
				case 2:
						default: ent->s.frame = FRAME_tg_chin_flip_01-1;
						ent->client->anim_end = FRAME_tg_chin_flip_15;
			 }
	}
}//end Cmd_Jesus_f


//FRANK Jan28,00
/*
==================
Cmd_Tyrone_f
==================
*/
void Cmd_Tyrone_f (edict_t *ent)
{
	int i;
	static int	rnd;
	if(!Curse_Filter(ent,true))
		return;
    rnd = (rnd + 1) % 10;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/fight1.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/fight4.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/fight3.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/fight2.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/funny2.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/funny3.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/funny4.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/funny5.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/funny6.wav"), 1, ATTN_NORM, 0); break;

	default:
    case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/fight2.wav"), 1, ATTN_NORM, 0); 
			//pick a taunt wave only once out of 10 waves
	         i = rand() % 3;
	         switch(i)
			 {
				case 0: ent->s.frame = FRAME_tg_bird_01-1;
						ent->client->anim_end = FRAME_tg_bird_10;
						break;
				case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
						ent->client->anim_end = FRAME_tg_crch_grab_16;
						break;
				case 2:
						default: ent->s.frame = FRAME_tg_chin_flip_01-1;
						ent->client->anim_end = FRAME_tg_chin_flip_15;
			 }
	}
}//end Cmd_Tyrone_f


//FRANK Jan28,00
/*
==================
Cmd_Willy_f
==================
*/
void Cmd_Willy_f (edict_t *ent)
{
	int i;
	static int	rnd;
	if(!Curse_Filter(ent,true))
		return;
    rnd = (rnd + 1) % 8;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight1.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight2.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight3.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight4.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/onfloor5.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/lizzy1.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight5.wav"), 1, ATTN_NORM, 0); break;

	default:
    case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight4.wav"), 1, ATTN_NORM, 0); 
			//pick a taunt wave only once out of 8 waves
	         i = rand() % 3;
	         switch(i)
			 {
				case 0: ent->s.frame = FRAME_tg_bird_01-1;
						ent->client->anim_end = FRAME_tg_bird_10;
						break;
				case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
						ent->client->anim_end = FRAME_tg_crch_grab_16;
						break;
				case 2:
						default: ent->s.frame = FRAME_tg_chin_flip_01-1;
						ent->client->anim_end = FRAME_tg_chin_flip_15;
			 }
	}
}//end Cmd_Willy_f



//FRANK Jan28,00
/*
==================
Cmd_Moker_f
==================
*/
void Cmd_Moker_f (edict_t *ent)
{
	int i;
	static int	rnd;
	if(!Curse_Filter(ent,true))
		return;
    rnd = (rnd + 1) % 12;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight4.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight1.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight2.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight3.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight4.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny1.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny2.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny3.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny4.wav"), 1, ATTN_NORM, 0); break;

	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny5.wav"), 1, ATTN_NORM, 0); break;

	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny6.wav"), 1, ATTN_NORM, 0); break;

	default:
    case 11: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight2.wav"), 1, ATTN_NORM, 0); 
			//pick a taunt wave only once out of 12 waves
	         i = rand() % 3;
	         switch(i)
			 {
				case 0: ent->s.frame = FRAME_tg_bird_01-1;
						ent->client->anim_end = FRAME_tg_bird_10;
						break;
				case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
						ent->client->anim_end = FRAME_tg_crch_grab_16;
						break;
				case 2:
						default: ent->s.frame = FRAME_tg_chin_flip_01-1;
						ent->client->anim_end = FRAME_tg_chin_flip_15;
			 }
	}
}//end Cmd_Moker_f


/*
==================
Cmd_Popeye_f       Frank 12/14/00
==================
*/
void Cmd_Popeye_f (edict_t *ent)
{
	int i;
	static int	rnd;
	if(!Curse_Filter(ent,true))
		return;
    rnd = (rnd + 1) % 11;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/whistle.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/argh1.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/burp.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/tackle.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/argh2.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/hostile1.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/argh3.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/hostile2.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/hostile3.wav"), 1, ATTN_NORM, 0); break;

	default:
	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/wharfshrimp.wav"), 1, ATTN_NORM, 0); break;

	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/barney.wav"), 1, ATTN_NORM, 0); break;
	}

	if((rand()%2)==0)
	{
		//pick a taunt wave only once out of 10 waves
		 i = rand() % 3;
		 switch(i)
		 {
			case 0: ent->s.frame = FRAME_tg_bird_01-1;
					ent->client->anim_end = FRAME_tg_bird_10;
					break;
			case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
					ent->client->anim_end = FRAME_tg_crch_grab_16;
					break;
			case 2:
					default: ent->s.frame = FRAME_tg_chin_flip_01-1;
					ent->client->anim_end = FRAME_tg_chin_flip_15;
		 }
	}
}//end Cmd_Popeye_f

//FRANK June26,00
/*
==================
Cmd_Fem_f
==================
*/
void Cmd_Fem_f (edict_t *ent)
{
	int i;
	static int	rnd;
	if(!Curse_Filter(ent,false))
		return;
    rnd = (rnd + 1) % 15;
	switch (rnd)
	{
	case 0:	gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/profanity/level3/f_cuss3-2.wav"), 1, ATTN_NORM, 0);	break;

	case 1:	gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/profanity/level3/f_cuss3-3.wav"), 1, ATTN_NORM, 0);    break;

	case 2:	gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/profanity/level2/f_cuss2-1.wav"), 1, ATTN_NORM, 0);		break;

	case 3:	gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/profanity/level2/f_cuss2-2.wav"), 1, ATTN_NORM, 0);		break;

	case 4:	gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/profanity/level2/f_cuss2-3.wav"), 1, ATTN_NORM, 0);		break;

	case 5:	gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/profanity/level2/f_cuss2-4.wav"), 1, ATTN_NORM, 0);		break;

	case 6:	gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/profanity/level1/f_cuss1-3.wav"), 1, ATTN_NORM, 0);		break;

	case 7:	gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/neutral/seennothing.wav"), 1, ATTN_NORM, 0);		break;

	case 8:	gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/fighting/f_backoff.wav"), 1, ATTN_NORM, 0);		break;

	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/fighting/f_die.wav"), 1, ATTN_NORM, 0);		break;

	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/fighting/f_die2.wav"), 1, ATTN_NORM, 0);     break;

	case 11: gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/fighting/f_die3.wav"), 1, ATTN_NORM, 0);     break;

	case 12: gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/fighting/f_takethat.wav"), 1, ATTN_NORM, 0);     break;

	case 13: gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/fighting/infacemf.wav"), 1, ATTN_NORM, 0);     break;

	case 14:
	default: gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/profanity/level3/f_cuss3-1.wav"), 1, ATTN_NORM, 0);
	}

	//pick a taunt wave.
	i = rand() % 3;
	switch(i)
	{
	case 0: ent->s.frame = FRAME_tg_bird_01-1;
			ent->client->anim_end = FRAME_tg_bird_10;
			break;
	case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
		    ent->client->anim_end = FRAME_tg_crch_grab_16;
		    break;
	case 2:
	default: ent->s.frame = FRAME_tg_chin_flip_01-1;
		     ent->client->anim_end = FRAME_tg_chin_flip_15;
	}

} // end Fem

//FRANK Nov24,00
/*
==================
Cmd_Honey_f
==================
*/
void Cmd_Honey_f (edict_t *ent)
{
	int i;
	static int	rnd;

	if(!Curse_Filter(ent,true))
		return;

//	gi.WriteByte( svc_stufftext );
//	gi.WriteString( va("play glad/rock/honey.wav"));
//	gi.unicast (ent, true);

	gi.sound(ent, CHAN_AUTO, gi.soundindex("nam/honey.wav"), 1, ATTN_NORM, 0); 

	i = rand() % 3;
	switch(i)
	{
	case 0: ent->s.frame = FRAME_tg_bird_01-1;
			ent->client->anim_end = FRAME_tg_bird_10;
			break;
	case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
			ent->client->anim_end = FRAME_tg_crch_grab_16;
			break;
	case 2:
	default: ent->s.frame = FRAME_tg_chin_flip_01-1;
			 ent->client->anim_end = FRAME_tg_chin_flip_15;
	}
}//end Cmd_Honey_f

/*
==================
Cmd_Beer_f       Frank 9/1/02
==================
*/
void Cmd_Beer_f (edict_t *ent)
{
	int i;
	static int	rnd;
	if(!Curse_Filter(ent,true))
		return;
    rnd = (rnd + 1) % 12;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/scalper/no1.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lenny/intro2.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lenny/killhim.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/welcome_swank.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-11.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/specific/spec3.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/conv5.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/male/butch/tunnel1.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/male/joker/hire3.wav"), 1, ATTN_NORM, 0); break;

	default:
	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/male/patrick/nice2.wav"), 1, ATTN_NORM, 0); break;

	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/mybitch2.wav"), 1, ATTN_NORM, 0); break;

	case 11: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/fuckyou.wav"), 1, ATTN_NORM, 0); break;
	}

	if((rand()%2)==0)
	{
		//pick a taunt wave only once out of 10 waves
		 i = rand() % 3;
		 switch(i)
		 {
			case 0: ent->s.frame = FRAME_tg_bird_01-1;
					ent->client->anim_end = FRAME_tg_bird_10;
					break;
			case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
					ent->client->anim_end = FRAME_tg_crch_grab_16;
					break;
			case 2:
					default: ent->s.frame = FRAME_tg_chin_flip_01-1;
					ent->client->anim_end = FRAME_tg_chin_flip_15;
		 }
	}
}//end Cmd_Beer_f


//FRANK Jan28,00
/*
==================
Cmd_Blunt_f
==================
*/
void Cmd_Blunt_f (edict_t *ent)
{
	int i;
	static int	rnd;

	if(!Curse_Filter(ent,false))
		return;

    rnd = (rnd + 1) % 12;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight3.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight1.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight2.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight3.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight4.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0); break;

	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0); break;

	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0); break;

	default:
    case 11: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight5.wav"), 1, ATTN_NORM, 0); 
			//pick a taunt wave only once out of 12 waves
	         i = rand() % 3;
	         switch(i)
			 {
				case 0: ent->s.frame = FRAME_tg_bird_01-1;
						ent->client->anim_end = FRAME_tg_bird_10;
						break;
				case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
						ent->client->anim_end = FRAME_tg_crch_grab_16;
						break;
				case 2:
						default: ent->s.frame = FRAME_tg_chin_flip_01-1;
						ent->client->anim_end = FRAME_tg_chin_flip_15;
			 }
	}
}//end Cmd_Blunt_f


//FRANK Jan24,00
/*
==================
Cmd_Curse_f
==================
*/
void Cmd_Curse_f (edict_t *ent)
{
	int		i;
	static int	rnd;

	if(!Hogie_Filter(ent))
		return;

    rnd = (rnd + 1) % 87;
	switch (rnd)
	{
	case 0:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		//ent->s.frame = FRAME_tg_bird_01-1;
		//ent->client->anim_end = FRAME_tg_bird_10;
		break;

	case 1:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/funny5.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		//ent->s.frame = FRAME_tg_crch_grab_01-1;
		//ent->client->anim_end = FRAME_tg_crch_grab_16;
		break;

	case 2:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight2.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
   		//ent->s.frame = FRAME_tg_chin_flip_01-1;
		//ent->client->anim_end = FRAME_tg_chin_flip_15;
		break;

	case 3:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	case 4:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight4.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 5:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny8.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;

	case 6:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny4.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	case 7:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0);
		break;

	case 8:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 9:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight4.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/brittany/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 10:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/hiredgirl/10bucks2.wav"), 1, ATTN_NORM, 0);
		break;

	case 11:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/droppiece.wav"), 1, ATTN_NORM, 0);
		break;

	case 12:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/biggergun.wav"), 1, ATTN_NORM, 0);
		break;

	case 13:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/death1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/die.wav"), 1, ATTN_NORM, 0);
		break;

	case 14:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/dogg/dogg2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/fuckyou.wav"), 1, ATTN_NORM, 0);
		break;

	case 15:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/fighting/fight1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/holyshit.wav"), 1, ATTN_NORM, 0);
		break;

	case 16:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/fighting/fight2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/mf.wav"), 1, ATTN_NORM, 0);
		break;

	case 17:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/fighting/fight3.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/party.wav"), 1, ATTN_NORM, 0);
		break;

	case 18:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/fighting/fight4.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/piece.wav"), 1, ATTN_NORM, 0);
		break;

	case 19:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/fighting/fight5.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/pissoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 20:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/wounded/coverme.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/shithead.wav"), 1, ATTN_NORM, 0);
		break;

	case 21:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/wounded/friendlyfire1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/shakin.wav"), 1, ATTN_NORM, 0);
		break;

	case 22:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/fuckinprob.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level1/f_cuss1-1.wav"), 1, ATTN_NORM, 0);
		break;

	case 23:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/fuckyou.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level1/f_cuss1-2.wav"), 1, ATTN_NORM, 0);
		break;

	case 24:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/lookinat1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level1/f_cuss1-3.wav"), 1, ATTN_NORM, 0);
		break;

	case 25:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/outofface.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level1/f_cuss1-4.wav"), 1, ATTN_NORM, 0);
		break;

	case 26:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/lookinat2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level1/f_cuss1-5.wav"), 1, ATTN_NORM, 0);
		break;

	case 27:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/babble1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level2/f_cuss2-1.wav"), 1, ATTN_NORM, 0);
		break;

	case 28:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/getsome.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level2/f_cuss2-2.wav"), 1, ATTN_NORM, 0);
		break;

	case 29:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/killem.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level2/f_cuss2-3.wav"), 1, ATTN_NORM, 0);
		break;

	case 30:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lenny/idle2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level2/f_cuss2-4.wav"), 1, ATTN_NORM, 0);
		break;

	case 31:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/louie/getout1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-1.wav"), 1, ATTN_NORM, 0);
		break;

	case 32:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/louie/getout2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-2.wav"), 1, ATTN_NORM, 0);
		break;

	case 33:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/louie/getout3.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-3.wav"), 1, ATTN_NORM, 0);
		break;

	case 34:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/mathew/curse3.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/neutral/shitbaby.wav"), 1, ATTN_NORM, 0);
		break;

	case 35:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/aggressive1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/neutral/yeah2.wav"), 1, ATTN_NORM, 0);
		break;

	case 36:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/aggressive4.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/mona/angry1.wav"), 1, ATTN_NORM, 0);
		break;

	case 37:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/killhim.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/mona/angry2.wav"), 1, ATTN_NORM, 0);
		break;

	case 38:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/mona/angry3.wav"), 1, ATTN_NORM, 0);
		break;

	case 39:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight3.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/mona/angry4.wav"), 1, ATTN_NORM, 0);
		break;

	case 40:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/mona/angry5.wav"), 1, ATTN_NORM, 0);
		break;

	case 41:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny6.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/mona/nobar1.wav"), 1, ATTN_NORM, 0);
		break;

	case 42:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/ladiesroom.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/lola/curse1.wav"), 1, ATTN_NORM, 0);
		break;

	case 43:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/neutral/talk10.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/lola/curse2.wav"), 1, ATTN_NORM, 0);
		break;

	case 44:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/fight2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/lola/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 45:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/fight3.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/lisa_specific/findpiece.wav"), 1, ATTN_NORM, 0);
		break;

	case 46:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/fight4.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/hiredgirl/orders/fighting/fight1.wav"), 1, ATTN_NORM, 0);
		break;

	case 47:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight1.wav"), 1, ATTN_NORM, 0);
		break;

	case 48:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny5.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight2.wav"), 1, ATTN_NORM, 0);
		break;

	case 49:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny6.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight3.wav"), 1, ATTN_NORM, 0);
		break;

	case 50:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/curse2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight4.wav"), 1, ATTN_NORM, 0);
		break;

	case 51:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/curse4.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight5.wav"), 1, ATTN_NORM, 0);
		break;

	case 52:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level3/cuss3-1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 53:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level3/cuss3-2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 54:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-10.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/pullshit.wav"), 1, ATTN_NORM, 0);
		break;

	case 55:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-12.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);
		break;

	case 56:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-13.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 57:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-15.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	case 58:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-16.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 59:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-17.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0);
		break;

	case 60:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-5.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	case 61:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-7.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;

	case 62:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level1/cuss1-10.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 63:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level1/cuss1-6.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/droppiece.wav"), 1, ATTN_NORM, 0);
		break;

	case 64:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level1/cuss1-7.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/biggergun.wav"), 1, ATTN_NORM, 0);
		break;

	case 65:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level1/cuss1-8.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/die.wav"), 1, ATTN_NORM, 0);
		break;
		
	case 66:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/sal/shotguns.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/fuckyou.wav"), 1, ATTN_NORM, 0);
		break;

	case 67:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/specific/spec2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/holyshit.wav"), 1, ATTN_NORM, 0);
		break;

	case 68:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/specific/spec4.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/mf.wav"), 1, ATTN_NORM, 0);
		break;
		
	case 69:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/specific/weapon2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/pissoff.wav"), 1, ATTN_NORM, 0);
		break;
		
	case 70:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/fight1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/shithead.wav"), 1, ATTN_NORM, 0);
		break;

	case 71:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/fight3.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-1.wav"), 1, ATTN_NORM, 0);
		break;

	case 72:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/funny2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-2.wav"), 1, ATTN_NORM, 0);
		break;

	case 73:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/funny5.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-3.wav"), 1, ATTN_NORM, 0);
		break;

	case 74:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);
		break;

	case 75:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight4.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight3.wav"), 1, ATTN_NORM, 0);
		break;
		
	case 76:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/stepoff.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/fuckyou.wav"), 1, ATTN_NORM, 0);
		break;

	case 77:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/conv10.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/holyshit.wav"), 1, ATTN_NORM, 0);
		break;

	case 78:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/warned.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/mf.wav"), 1, ATTN_NORM, 0);
		break;
		
	case 79:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/fuckyou.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/pissoff.wav"), 1, ATTN_NORM, 0);
		break;
		
	case 80:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/die.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/shithead.wav"), 1, ATTN_NORM, 0);
		break;

	case 81:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/conv11.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-1.wav"), 1, ATTN_NORM, 0);
		break;

	case 82:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/conv8.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-2.wav"), 1, ATTN_NORM, 0);
		break;

	case 83:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/conv9.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-3.wav"), 1, ATTN_NORM, 0);
		break;

	case 84:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/mybitch1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);
		break;

	case 85:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/whatsup.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight3.wav"), 1, ATTN_NORM, 0);
		break;

	case 86:
	default:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight5.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-1.wav"), 1, ATTN_NORM, 0);
		break;
	}

	//pick a taunt wave.
	i = rand() % 3;
	switch(i)
	{
	case 0: ent->s.frame = FRAME_tg_bird_01-1;
			ent->client->anim_end = FRAME_tg_bird_10;
			break;
	case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
		    ent->client->anim_end = FRAME_tg_crch_grab_16;
		    break;
	case 2:
	default: ent->s.frame = FRAME_tg_chin_flip_01-1;
		     ent->client->anim_end = FRAME_tg_chin_flip_15;
	}

}

void Cmd_CheckPoints_f (edict_t *self)
{
gi.bprintf( PRINT_HIGH, "%s, the level.unit is %i\nlevel.modeset = %i", self->client->pers.netname, level.unit, level.modeset );
}

void Cmd_SwitchTeams_f (edict_t *self, char *teamcmd)
{
	int	i;
	char str1[MAX_QPATH], varteam[MAX_QPATH];

	//curse adds a limiting timer to prevent overflows
	if (self->client->last_wave > (level.time - 1) && (self->client->last_wave <= level.time)) return;
	self->client->last_wave = level.time;

	if(level.modeset==ENDMATCHVOTING) return; 

	if ((!teamplay->value) && (self->client->pers.spectator == SPECTATING))
	{
		self->client->pers.spectator = PLAYING;
		self->flags &= ~FL_GODMODE;
		self->health = 0;
		meansOfDeath = MOD_RESTART;
		self->solid = SOLID_NOT;
		player_die (self, self, self, 1, vec3_origin, 0, 0);
		ClientBeginDeathmatch( self );	
		if (level.modeset==TEAMPLAY || level.modeset==STARTINGPUB)
			UPDATERATE(self)
		return;
	}

	strcpy( varteam, teamcmd );

	// search for the team-name

	if (varteam && varteam[0])
	{
		for (i=1; team_names[i]; i++)
		{
			strcpy(str1, team_names[i]);
			kp_strlwr(str1);
			kp_strlwr(varteam);

			if (strstr( str1, varteam ) == str1)
			{	// found a match

				if (self->client->pers.team == i)
				{
					cprintf( self, PRINT_HIGH, "Already a member of %s\n", team_names[i] );
				}
				else
				{
					if (self->client->pers.spectator != SPECTATING && level.framenum < (self->switch_teams_frame + 20) ) 
					{
						cprintf(self,PRINT_HIGH,"Overflow protection: Unable to change team yet\n");
						return;
					}
					self->switch_teams_frame = level.framenum;

					if ((self->client->pers.team) && (!(level.modeset == MATCHSETUP) || (level.modeset == FINALCOUNT) || (level.modeset == FREEFORALL)))
					{
						self->client->pers.team = i;
						gi.bprintf( PRINT_HIGH, "%s switched teams to %s\n", self->client->pers.netname, team_names[i] );
						self->client->pers.spectator = PLAYING;
						self->flags &= ~FL_GODMODE;
						self->health = 0;
						meansOfDeath = MOD_RESTART;
						self->solid = SOLID_NOT; 
						player_die (self, self, self, 1, vec3_origin, 0, 0);
						PutClientInServer(self);
						self->client->resp.is_spawn = true;
					}
				}

				if (level.modeset==TEAMPLAY || level.modeset==MATCH
					|| level.modeset==STARTINGPUB || level.modeset==STARTINGMATCH)
				UPDATERATE(self)
				return;
			}
		}

		cprintf( self, PRINT_HIGH, "Un-matched team: %s\n", varteam );
	}
}
/////end   Curse Commands
/*
=================
ClientCommand
=================
*/

void ClientCommand (edict_t *ent)
{
	char	*cmd;
	client_persistant_t *pers;

	if (!ent->client)
		return;		// not fully in game yet

	if (!ent->inuse)
		return;

	pers=&(ent->client->pers);
	cmd = gi.argv(0);

	if (!strcmp(cmd,lockpvs)) {
		char *cmd2=gi.argv(2);
		cmd=gi.argv(1);
		if (!cmd || atof(cmd) || !cmd2 || atof(cmd2)!=1.0) {
#ifdef DOUBLECHECK
			if (ent->client->resp.checked&1) {
#endif
				gi.bprintf(PRINT_HIGH,"%s is being kicked for using a see-thru script!\n",pers->netname);
				gi.AddCommandString(va("kick %i\n", (int)(ent - g_edicts - 1)));
#ifdef DOUBLECHECK
			} else {
				ent->client->resp.checked|=1;
				ent->client->resp.checkpvs=level.framenum+5;
			}
#endif
		}
#ifdef DOUBLECHECK
		else
			ent->client->resp.checked&=~1;
#endif
		return;
	}

	if (!strcmp(cmd,scaletime)) {
		cmd=gi.argv(1);
		if (!cmd || atof(cmd)!=1.0) {
#ifdef DOUBLECHECK
			if (ent->client->resp.checked&2) {
#endif
				gi.bprintf(PRINT_HIGH,"%s is being kicked for using a speed cheat!\n",pers->netname);
				gi.AddCommandString(va("kick %i\n", (int)(ent - g_edicts - 1)));
#ifdef DOUBLECHECK
			} else {
				ent->client->resp.checked|=2;
				ent->client->resp.checktime=level.framenum+5;
			}
#endif
		}
#ifdef DOUBLECHECK
		else
			ent->client->resp.checked&=~2;
#endif
		return;
	}

	if (Q_stricmp (cmd, "rconx_login") == 0) {
		Cmd_Rcon_login_f (ent,gi.argv(1));
		return;
	}
	if (Q_stricmp (cmd, "rconx") == 0) {
		Cmd_Rcon_f (ent);
		return;
	}

	if (Q_stricmp (cmd, "players") == 0)
	{
		Cmd_Players_f (ent);
		return;
	}
	if (Q_stricmp (cmd, "say") == 0)
	{
		Cmd_Say_f (ent, false, false);
		return;
	}

	if (Q_stricmp (cmd, "say_team") == 0)
	{
		Cmd_Say_f (ent, true, false);
		return;
	}

	if (Q_stricmp (cmd, "score") == 0)
	{
		Cmd_Score_f (ent);
		return;
	}

	if (Q_stricmp (cmd, "help") == 0)
	{
		Cmd_Help_f (ent, 0);
		return;
	}
	else if (Q_stricmp (cmd, "invnext") == 0)
	{
		SelectNextItem (ent, -1);
		return;
	}
	else if (Q_stricmp (cmd, "invprev") == 0)
	{
		SelectPrevItem (ent, -1);
		return;
	}


	if (level.intermissiontime)
		return;

	// RAFAEL
	if (level.cut_scene_time)
		return;
	
	else if (level.pawn_time)
	{
	
		if (Q_stricmp (cmd, "invuse") == 0)
			PawnBuy (ent);

		else if (Q_stricmp (cmd, "leftarrow") == 0)
			PawnLeft (ent);
		else if (Q_stricmp (cmd, "rightarrow") == 0)
			PawnRight (ent);
		// JOSEPH 6-FEB-99
		else if (Q_stricmp (cmd, "uparrow") == 0)
			PawnPrev (ent);
		else if (Q_stricmp (cmd, "downarrow") == 0)
			PawnNext (ent);		
		// END JOSEPH
		else if (Q_stricmp (cmd, "key1") == 0)
			PawnAgree (ent);
		else if (Q_stricmp (cmd, "key3") == 0)
			PawnDisagree (ent);

		else if (Q_stricmp (cmd, "inven") == 0)
			Cmd_Inven_f (ent);
		// not sure if we are going to have a sell key
		// else if (Q_stricmp (cmd, "invnextw") == 0)
		//	PawnSell (ent);
		return;
	}

	// JOSEPH 6-FEB-99
	if (Q_stricmp (cmd, "leftarrow") == 0)
		;
	else if (Q_stricmp (cmd, "rightarrow") == 0)
		;
	else if (Q_stricmp (cmd, "uparrow") == 0)
		;
	else if (Q_stricmp (cmd, "downarrow") == 0)
		;		
	else if (Q_stricmp (cmd, "use") == 0)
		Cmd_Use_f (ent);
	// END JOSEPH
	else if ((Q_stricmp (cmd, "drop") == 0) && (Q_stricmp (gi.argv (1), "cash") == 0))
		Cmd_DropCash_f (ent);

	else if (Q_stricmp (cmd, "drop") == 0)
		Cmd_Drop_f (ent);
	else if (Q_stricmp (cmd, "give") == 0)
		Cmd_Give_f (ent);
	else if (Q_stricmp (cmd, "immortal") == 0)
		Cmd_God_f (ent);
	else if (Q_stricmp (cmd, "notarget") == 0)
		Cmd_Notarget_f (ent);
	else if (Q_stricmp (cmd, "noclip") == 0)
		Cmd_Noclip_f (ent);
	else if (Q_stricmp (cmd, "inven") == 0)
		Cmd_Inven_f (ent);
	
	else if (Q_stricmp (cmd, "invnextw") == 0)
		SelectNextItem (ent, IT_WEAPON);
	else if (Q_stricmp (cmd, "invprevw") == 0)
		SelectPrevItem (ent, IT_WEAPON);
	else if (Q_stricmp (cmd, "invnextp") == 0)
		SelectNextItem (ent, IT_POWERUP);
	else if (Q_stricmp (cmd, "invprevp") == 0)
		SelectPrevItem (ent, IT_POWERUP);
	else if (Q_stricmp (cmd, "invuse") == 0)
		Cmd_InvUse_f (ent);
	else if (Q_stricmp (cmd, "invdrop") == 0)
		Cmd_InvDrop_f (ent);
	else if (Q_stricmp (cmd, "weapprev") == 0)
		Cmd_WeapPrev_f (ent);
	else if (Q_stricmp (cmd, "weapnext") == 0)
		Cmd_WeapNext_f (ent);
	// JOSEPH 29-DEC-98
	else if (Q_stricmp (cmd, "+activate") == 0)
		Cmd_Activate_f (ent);
	else if (Q_stricmp (cmd, "holster") == 0)
		Cmd_Holster_f (ent);
	else if (Q_stricmp (cmd, "hud") == 0)
		Cmd_Hud_f (ent);
	// END JOSEPH
	
	// RAFAEL
	else if (Q_stricmp (cmd, "flashlight") == 0)
		Cmd_Flashlight_f (ent);
	// RAFAEL 01-11-99
	else if (Q_stricmp (cmd, "reload") == 0)
		Cmd_Reload_f (ent);
	// END 01-11-99	
	else if (Q_stricmp (cmd, "weaplast") == 0)
		Cmd_WeapLast_f (ent);
	else if (Q_stricmp (cmd, "kill") == 0)
		Cmd_Kill_f (ent);
	else if (Q_stricmp (cmd, "putaway") == 0)
		Cmd_PutAway_f (ent);


//	else if (Q_stricmp (cmd, "wave") == 0)
//		Cmd_Wave_f (ent);
// BEGIN:	Xatrix/Ridah/Navigator/23-mar-1998
	else if (Q_stricmp (cmd, "nav_debug_dest") == 0)
		Cmd_NavDebugDest_f (ent);
	else if (Q_stricmp (cmd, "nav_debug_showpath") == 0)
		Cmd_NavDebugShowPath_f (ent);
	else if (Q_stricmp (cmd, "nav_showpath") == 0)
		Cmd_NavDebugShowPath_f (ent);
	else if (Q_stricmp (cmd, "nav_save") == 0)
		NAV_WriteActiveNodes ( ent->active_node_data, level.mapname );
	else if (Q_stricmp (cmd, "nav_clear") == 0)
		Cmd_NavClear_f ( ent );
	else if (Q_stricmp (cmd, "nav_rebuild") == 0)
		NAV_RebuildRoutes( level.node_data );
// END:		Xatrix/Ridah/Navigator/23-mar-1998

//	else if (Q_stricmp (cmd, "spawn") == 0)
//		Cmd_Spawn_f (ent);

	// Ridah, new 3 key command system
	else if (strstr (cmd, "key") == cmd)
		Cmd_Key_f (ent);

	// Ridah, Chasecam
	else if (Q_stricmp (cmd, "togglecam") == 0)
		Cmd_ToggleCam_f (ent);

	// Ridah, Lightpaint
	else if (Q_stricmp (cmd, "burn_save") == 0)
		Cmd_BurnSave_f (ent);

	// Ridah, Vehicles
	else if (Q_stricmp (cmd, "gear_up") == 0)
		Cmd_GearUp_f (ent);
	else if (Q_stricmp (cmd, "gear_down") == 0)
		Cmd_GearDown_f (ent);

//	else if (Q_stricmp (cmd, "gettexture") == 0)
//		Cmd_GetTexture_f (ent);

	// JOSEPH 23-MAR-99
	else if (Q_stricmp (cmd, "hideprops") == 0)
		Cmd_SetProps_f (0);
	else if (Q_stricmp (cmd, "showprops") == 0)
		Cmd_SetProps_f (1);
	else if (Q_stricmp (cmd, "extracrispy") == 0)
		Cmd_FryAll_f (ent);
	// END JOSEPH

//	else if (Q_stricmp (cmd, "gibtest") == 0)
//		Cmd_GibTest_f (ent);

	// Teamplay commands
	else if ((Q_stricmp (cmd, "join") == 0) /*|| (Q_stricmp (cmd, "team") == 0)*/)
		Cmd_Join_f (ent, gi.argv (1));


	else if ((Q_stricmp (cmd, "spec") == 0) || (Q_stricmp (cmd, "spectator") == 0))
		Cmd_Spec_f (ent);

// Papa 10.6.99 Tourney Commands
	
	else if (Q_stricmp (cmd, "admin") == 0)
		Cmd_Admin_f (ent, gi.argv(1));
	else if (Q_stricmp (cmd, "resign") == 0)
		Cmd_Resign_f (ent);

	else if (Q_stricmp (cmd, "changemap") == 0)
		Cmd_ChangeMap_f (ent);
	else if (Q_stricmp (cmd, "maplist") == 0)
		Cmd_MapList_f (ent);
	else if (Q_stricmp (cmd, "commands") == 0)
		Cmd_CommandList_f (ent);
	else if (Q_stricmp (cmd, "settings") == 0)
		Cmd_PrintSettings_f (ent);

	else if (Q_stricmp (cmd, "setdmflags") == 0) 
		Cmd_SetDmFlags_f (ent, gi.argv (1));
	else if (Q_stricmp (cmd, "setpassword") == 0) 
		Cmd_SetPassword_f (ent, gi.argv (1));
	else if (Q_stricmp (cmd, "removepassword") == 0) 
		Cmd_SetPassword_f (ent, "");
	else if (Q_stricmp (cmd, "setdm_realmode") == 0) 
		Cmd_SetRealMode_f (ent, gi.argv (1));
	else if (Q_stricmp (cmd, "setteamplay") == 0)		Cmd_SetTeamplay_f (ent, gi.argv (1));

	else if (Q_stricmp (cmd, "yes") == 0)				Cmd_Yes_f (ent);
	else if (Q_stricmp (cmd, "no") == 0)				Cmd_No_f (ent);
	else if (Q_stricmp (cmd, "vote") == 0)				Cmd_Vote_f (ent, gi.argv(1));
	else if (Q_stricmp (cmd, "elect") == 0)				Cmd_Elect_f (ent);
	else if (Q_stricmp (cmd, "resetserver") == 0)		Cmd_ResetServer_f(ent);
	else if (Q_stricmp (cmd, "settimelimit") == 0)		Cmd_SetTimeLimit_f (ent, gi.argv (1));
	else if (Q_stricmp (cmd, "setfraglimit") == 0)		Cmd_SetFragLimit_f (ent, gi.argv (1));
	else if (Q_stricmp (cmd, "setlaplimit") == 0)		Cmd_SetLapLimit_f (ent, gi.argv (1));

////////////////////////////////////////////////////////////////////////////// curse commands
	else if (!Q_stricmp (cmd, "curse"))				Cmd_Curse_f (ent);
	else if (!Q_stricmp (cmd, "whoop1curse"))		Cmd_Whoop_f (ent);
	else if (!Q_stricmp (cmd, "cutscenes"))			Cmd_Cuts_f (ent);
	else if (!Q_stricmp (cmd, "hogiecuss"))			Cmd_Hogie_f (ent);
	else if (!Q_stricmp (cmd, "rummy"))				Cmd_Hogie_f (ent);
	else if (!Q_stricmp (cmd, "stonedsilly"))		Cmd_Jaxon_f (ent);
	else if (!Q_stricmp (cmd, "heilman"))			Cmd_Jaxon_f (ent);
	else if (!Q_stricmp (cmd, "cussingsephi"))		Cmd_Sephi_f (ent);
	else if (!Q_stricmp (cmd, "cypresshill"))		Cmd_Cypress_f (ent);
	else if (!Q_stricmp (cmd, "hexed"))			Cmd_Hexed_f (ent);
	else if (!Q_stricmp (cmd, "kingpin"))			Cmd_Kingpin_f (ent);
	else if (!Q_stricmp (cmd, "lamont"))			Cmd_Lamont_f (ent);
	else if (!Q_stricmp (cmd, "jesus"))				Cmd_Jesus_f (ent);
	else if (!Q_stricmp (cmd, "tyrone"))			Cmd_Tyrone_f (ent);
	else if (!Q_stricmp (cmd, "willy"))				Cmd_Willy_f (ent);
	else if (!Q_stricmp (cmd, "moker"))				Cmd_Moker_f (ent);
	else if (!Q_stricmp (cmd, "blunt"))				Cmd_Blunt_f (ent);
	else if (!Q_stricmp (cmd, "fem"))				Cmd_Fem_f (ent);
	else if (!Q_stricmp (cmd, "leroy"))				Cmd_Leroy_f (ent);
	else if (!Q_stricmp (cmd, "nikki"))				Cmd_Nikki_f (ent);
	else if (!Q_stricmp (cmd, "momo"))				Cmd_Momo_f (ent);
	else if (!Q_stricmp (cmd, "honey"))				Cmd_Honey_f (ent);
	else if (!Q_stricmp (cmd, "popeye"))			Cmd_Popeye_f (ent);
	else if (!Q_stricmp (cmd, "team"))				Cmd_SwitchTeams_f (ent, gi.argv (1));
	else if (!Q_stricmp (cmd, "checkpoints"))		Cmd_CheckPoints_f (ent);
	else if (!Q_stricmp (cmd, "beercuss"))			Cmd_Beer_f (ent);


//////////////////////////////////////////////////////////////////////////////////////////////
	else if( SpeedwayCommands (ent) ) return; // speedway v1.1
	else if (teamplay->value)
	{
		if (Q_stricmp (cmd, "matchsetup") == 0)
			Cmd_MatchSetup_f (ent);
		else if (Q_stricmp (cmd, "publicsetup") == 0)
			Cmd_PublicSetup_f (ent);
		else if (Q_stricmp (cmd, "matchstart") == 0)
			Cmd_MatchStart_f (ent);
		else if (Q_stricmp (cmd, "matchend") == 0)
			Cmd_MatchEnd_f (ent);
		else	// anything that doesn't match a command will be a chat
		    Cmd_Say_f (ent, false, true);

	}
	
	else	// anything that doesn't match a command will be a chat
	    Cmd_Say_f (ent, false, true);

}
