/* TNTAPI.H - Phar Lap specific protected mode APIs and data structures */
/************************************************************************/
/*	Copyright (C) 1986-1992 Phar Lap Software, Inc.			*/
/*	Unpublished - rights reserved under the Copyright Laws of the	*/
/*	United States.  Use, duplication, or disclosure by the 		*/
/*	Government is subject to restrictions as set forth in 		*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 	*/
/*	Computer Software clause at 252.227-7013.			*/
/*	Phar Lap Software, Inc., 60 Aberdeen Ave., Cambridge, MA 02138	*/
/************************************************************************/
/* $Id: tntapi.h 1.15 93/02/01 15:00:38 andre Exp $ */

#ifndef TNTAPI_H_INCLUDED
#define TNTAPI_H_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

typedef unsigned long REALPTR;

#ifndef _WINDEF_

/* define some basic types */

typedef unsigned char BYTE;
typedef unsigned short WORD;
typedef unsigned long DWORD;

typedef DWORD BOOL;

typedef void VOID;
typedef void *PVOID;

typedef PVOID HANDLE;

#define APIENTRY __stdcall

#endif // _WINDEF_

//
// DOS compatibility mode file sharing extension to CreateFile
//
#define FILE_SHARE_DOS_COMPAT	0x80000000

//
// Phar Lap configuration info structure
//
typedef struct {
	DWORD	TntMajor;	// TNT major version number
	DWORD	TntMinor;	// TNT minor version number
	DWORD	TntFlags1;	// flags dword 1 
	DWORD	TntFlags2;	// flags dword 2
	DWORD	Processor;	// processor type
	DWORD	CoProcessor;	// Intel-compatible coprocessor type
	BOOL	fWeitek;	// T ==> Weitek coprocessor present
	BOOL	fCyrix;		// T ==> Cyrix EMC387 coprocessor (with
				// memory-mapped interface) present
	DWORD	Machine;	// machine type
	DWORD	MachineArch;	// machine architecture
	BOOL	fDPMI;		// T ==> DPMI present
	DWORD	DpmiMajor;	// DPMI major version number
	DWORD	DpmiMinor;	// DPMI minor version number
	BOOL	fVCPI;		// T ==> VCPI present
	DWORD	VcpiMajor;	// VCPI major version number
	DWORD	VcpiMinor;	// VCPI minor version number
	BOOL	fXMS;		// T ==> XMS present
	DWORD	XmsMajor;	// XMS major version number
	DWORD	XmsMinor;	// XMS minor version number
	DWORD   DosMajor;	// DOS major version number
	DWORD   DosMinor;	// DOS minor version number
	DWORD	unused[128-21];	// currently unused, always zeroed
} PLCONFIG;

//
// Processor type
//
#define PROC_386	3	// 386 processor
#define PROC_486	4	// 486 (or later) processor

//
// Intel-compatible coprocessor type
//
#define COPROC_NONE	0	// no Intel coprocessor
#define COPROC_287	2	// 287 coprocessor
#define COPROC_387	3	// 387 or equivalent (e.g., 486)

//
// Machine type
//
#define M_IBM		0	// IBM compatible
#define M_NEC		1	// NEC 9800 series compatible

//
// Machine architecture for IBM-compatibles
//
#define MA_ISA		0	// ISA architecture
#define MA_MCA		1	// MCA architecture
#define MA_XT		2	// XT architecture 
#define MA_EISA		3	// EISA architecture

// 
// Machine architecture for NEC 9800 series compatibles
//
#define MA_NORMRES	0	// normal mode
#define MA_HIGHRES	1	// high resolution mode

//
// Bit definitions for TntFlags1.  TntFlags2 is currently unused and is 
// always zeroed.
//
#define TF1_EMUL	0x00000001	// coprocessor emulation turned on
#define TF1_UNUSED	0xFFFFFFFE	// unused bits, always zeroed

#ifndef AR_PRESENT
//
// 80386 segment descriptors
//
typedef struct
{
	WORD limit0_15;			/* Bits 0-15 of the segment limit */
	WORD base0_15;			/* Bits 0-15 of the segment base */
	BYTE base16_23;			/* Bits 16-23 of the segment base */
	BYTE arights;			/* Access rights */
	BYTE limit16_19;		/* Bits 16-19 of the segment limit
					   plus some flags */
	BYTE base24_31;			/* Bits 24-31 of the segment base */
} CD_DES;

// 
// Access rights bit definitions
//
#define AR_PRESENT	0x80		/* Segment is present */
#define AR_ACCESSED	0x01		/* Segment was accessed */

#define AR_CREAD	0x02		/* Code segment is readable flag */
#define AR_CCONF	0x04		/* Code segment is conforming */
#define AR_CSEG		0x08		/* Is a code segment */

#define AR_DREADO	0x00		/* Read only data segment */
#define AR_DWRITE	0x02		/* Read/write data segment */
#define AR_EUP		0x00		/* Expand up */
#define AR_EDOWN	0x04		/* Expand down */

#define AR_SYS		0x00		/* System descriptor */
#define AR_USER		0x10		/* User descriptor */

#define AR_DPLM		0x60		/* DPL mask */
#define AR_DPLSC	5		/* DPL shift count */
#define AR_DPL0		0x00		/* DPL 0 */
#define AR_DPL1		0x20		/* DPL 1 */
#define AR_DPL2		0x40		/* DPL 2 */
#define AR_DPL3		0x60		/* DPL 3 */

#define AR_CODE	(AR_PRESENT | AR_USER | AR_CSEG | AR_CREAD)
#define AR_DATA	(AR_PRESENT | AR_USER | AR_DWRITE)

// 
// Flags (limit16_19) 
//
#define SG_BYTE	 0x00			/* Byte segment granularity */
#define SG_PAGE	 0x80			/* Page segment granularity */

#define DOS_16   0x00			/* Default operand size is 16 */
#define DOS_32   0x40			/* Default operand size is 32 */

#define SW_AVL	0x10			/* bit available for system software */

#define D6_HLIM	 0x0F			/* bits 16-19 of limit */

#endif	// CD_DES

/* real mode register structure */

typedef struct
{
	WORD r_ax;
	WORD r_bx;
	WORD r_cx;
	WORD r_dx;
	WORD r_si;
	WORD r_di;
	WORD r_bp;
	WORD r_ds;
	WORD r_es;
	WORD r_fs;
	WORD r_gs;
	WORD r_ss;
	WORD r_sp;
	WORD r_flags;
} REGS16;

typedef REGS16 *PREGS16;

/* real-mode far ptr maker */

#define MK_RMPTR(sel,off)	( (REALPTR) \
	((((DWORD)(sel)) << 16) | (((DWORD)(off)) & 0xffff)))

//
// Macro for referencing imported data variables from DLLs
//
#define IMPVAR(varname, type) (***(type ***)((UCHAR *)(&varname) + 2))

//
// Descriptor manipulation functions
//
WORD APIENTRY AllocDescriptor();
BOOL APIENTRY SetDescriptor(WORD Selector, CD_DES *pDesc);
BOOL APIENTRY GetDescriptor(WORD Selector, CD_DES *pDesc);

//
// FAR memory read/write with validation of addresses
//
BOOL APIENTRY ReadFarMemory(DWORD Offset, WORD Sel, void *pBuf, 
				DWORD nBytesToRead, DWORD *pnBytesRead);
BOOL APIENTRY WriteFarMemory(DWORD Offset, WORD Sel, void *pBuf, 
				DWORD nBytesToWrite, DWORD *pnBytesWrite);

/* Intermode calls functions */

BOOL APIENTRY GetRealDllRegs(HANDLE pRealDllHand, REGS16 *pRealRegs);
BOOL APIENTRY SetRealDllRegs(HANDLE pRealDllHand, REGS16 *pRealRegs);
BOOL APIENTRY RealDllCall(void (*pFunc)(), DWORD *pRealRet, int NumWords, ...);

// Macro for passing a DWORD value to a real mode function using
// RealCall or RealDllCall

#define LONGTOREAL(l)	((USHORT) ((ULONG) (l))), \
			((USHORT) (((ULONG) (l)) >> 16))

/* Stack management functions */

typedef PVOID HSTKPOOL;

HSTKPOOL APIENTRY StackPoolCreate(DWORD NumStacks, DWORD StackSize);
BOOL APIENTRY StackPoolKill(HSTKPOOL Handle);
VOID APIENTRY GetStackPoolInfo(HSTKPOOL Handle, DWORD *pStackSize);

DWORD APIENTRY StackAlloc(HSTKPOOL Handle);
VOID APIENTRY StackFree(HSTKPOOL Handle, DWORD pStack);

HSTKPOOL APIENTRY GetRealCallStackPool();
VOID APIENTRY SetRealCallStackPool(HSTKPOOL Handle);

BOOL APIENTRY IntrStackSwitch(HSTKPOOL Handle, void (*pFunc)());

//
// Loader functions
//
BOOL APIENTRY SetProcAddress(HANDLE pDllHand, char *pProcName, void (*pFunc)());
BOOL APIENTRY GetImageBase(HANDLE pDllHand, void **pBaseAddr);

//
// Miscellaneous functions
//
void APIENTRY GetPLConfigInfo(PLCONFIG *pConfig);


//
// New real mode functions
//

WORD APIENTRY GetDOSMemSelector(void);
REALPTR APIENTRY RealAlloc(WORD);
BOOL APIENTRY RealFree(REALPTR);
void APIENTRY WriteRealMem(REALPTR, PVOID, DWORD);
void APIENTRY ReadRealMem(PVOID, REALPTR, DWORD);
BOOL APIENTRY RealCall(REALPTR pFunc, DWORD *pRetVal, REGS16 *pRegs,
	      int NumWords, ...);
BOOL APIENTRY RealIntr(DWORD IntNum, DWORD *pRetVal, PREGS16 pRegs);


//
// More new functions
//

BOOL APIENTRY IsTNT(void);
BOOL APIENTRY TNTSetRealSwapState(BOOL new_state);

#ifdef __cplusplus
}
#endif

#endif // TNTAPI_H_INCLUDED
