/* gserver.h - Graphics server header file */

/************************************************************************/
/*	Copyright (C) 1986-1993 Phar Lap Software, Inc.			*/
/*	Unpublished - rights reserved under the Copyright Laws of the	*/
/*	United States.  Use, duplication, or disclosure by the 		*/
/*	Government is subject to restrictions as set forth in 		*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 	*/
/*	Computer Software clause at 252.227-7013.			*/
/*	Phar Lap Software, Inc., 60 Aberdeen Ave., Cambridge, MA 02138	*/
/************************************************************************/

/*

This file contains definitions for the graphics server
example program for 386|DOS-Extender.  It is included both 
by the real and protected mode sides of the server code.
It defines the protocol that the real and protected mode
code use to communicate.  The file contains the following
definitions:

	* Command codes
	* Offsets in the graphics commands buffer of arguments

*/

/*
 * Prototypes for functions available to the protected mode program only
 */
int _gbuffmode(int newmode);
void  _fmoveto(short x, short y);

/*
 * Size of graphics commands buffer, in bytes
 * We keep two commands buffers, one used by the protected mode code, and
 * one in real mode memory for real mode server.
 */
#define GBUFF_SIZE 4096

/*
 * Data types for pointers into the graphics commands buffer.  
 */
typedef char *GBPTR;
typedef short *GBSPTR;
typedef long *GBLPTR;
typedef double *GBDPTR;

/* 

Command codes

*/

/* For MSC 5.1 */
#define op_arc			1
#define op_clearscreen		2
#define op_displaycursor	3
#define op_ellipse		4
#define op_floodfill		5
#define op_getbkcolor		6
#define op_getcolor		7
#define op_getcurrentposition	8
#define op_getextposition	9
#define op_getfillmask		10
/* #define op_getimage		11 not supported */
#define op_getlinestyle		12
/* #define op_getlogcoord		13 no longer used -- #defined in
					terms of getviewcoord in graph.h */
#define op_getphyscoord		14
#define op_getpixel		15
#define op_gettextcolor		16
#define op_gettextposition	17
#define op_getvideoconfig	18
#define op_imagesize		19
#define op_lineto		20
#define op_logorg		21
#define op_moveto		22
#define op_outtext		23
#define op_pie			24
/* #define op_putimage		25 not supported */
#define op_rectangle		26
#define op_remapallpalette	27 
#define op_remappalette		28
#define op_selectpalette	29
#define op_setactivepage	30
#define op_setbkcolor		31	
#define op_setcliprgn		32
#define op_setcolor		33
#define op_setfillmask		34
#define op_setlinestyle		35
#define op_setlogorg		36
#define op_setpixel		37
#define op_settextcolor		38
#define op_settextposition	39
#define op_settextwindow	40	
#define op_setvideomode		41
#define op_setviewport		42
#define op_setvisualpage	43
#define op_wrapon		44
#define op_setnullmask		45


/* For MSC 6.0 */
#define op_arc_w		48
#define op_arc_wxy		49
#define op_ellipse_w		50
#define op_ellipse_wxy		51
#define op_floodfill_w		52
#define op_getactivepage	53
#define op_getarcinfo		54
#define op_getcurrentposition_w	55
#define op_getfontinfo		56
#define op_getgtextextent	57
#define op_getgtextvector	58
/* #define op_getimage_w		59 not supported */
/* #define op_getimage_wxy		60 not supported */
#define op_getpixel_w		61
#define op_gettextcursor	62
#define op_gettextwindow	63
#define op_getviewcoord_w	64
#define op_getviewcoord_wxy	65
#define op_getvisualpage	66
#define op_getwindowcoord	67
#define op_getwritemode		68
#define op_grstatus		69
#define op_imagesize_w		70
#define op_imagesize_wxy	71
#define op_lineto_w		72
#define op_moveto_w		73
#define op_outgtext		74
#define op_outmem		75
#define op_pie_w		76
#define op_pie_wxy		77
/* #define op_polygon		78 not supported */
/* #define op_polygon_w		79 not supported */
/* #define op_polygon_wxy		80 not supported */
/* #define op_putimage_w		81 not supported */
#define op_rectangle_w		82
#define op_rectangle_wxy	83
#define op_registerfonts	84
#define op_scrolltextwindow	85
#define op_setfont		86
#define op_setgtextvector	87
#define op_setpixel_w		88
#define op_settextcursor	89
#define op_settextrows		90
#define op_setvideomoderows	91
#define op_setwindow		93
#define op_setwritemode		94
#define op_unregisterfonts	95

#define op_getviewcoord		96

/* For MSC 7.0 */
#define op_inchar		97


/*

Defines for offsets of arguments in the graphics commands buffer

*/

#define SHORT0P		((GBSPTR)(bp + 0))
#define SHORT2P		((GBSPTR)(bp + 2))
#define SHORT4P		((GBSPTR)(bp + 4))
#define SHORT6P		((GBSPTR)(bp + 6))
#define SHORT8P		((GBSPTR)(bp + 8))
#define SHORT10P	((GBSPTR)(bp + 10))
#define SHORT12P	((GBSPTR)(bp + 12))
#define SHORT14P	((GBSPTR)(bp + 14))
#define SHORT16P	((GBSPTR)(bp + 16))
#define SHORT18P	((GBSPTR)(bp + 18))
#define SHORT20P	((GBSPTR)(bp + 20))
#define SHORT22P	((GBSPTR)(bp + 22))
#define SHORT24P	((GBSPTR)(bp + 24))
#define SHORT26P	((GBSPTR)(bp + 26))
#define SHORT28P	((GBSPTR)(bp + 28))
#define SHORT30P	((GBSPTR)(bp + 30))
#define SHORT32P	((GBSPTR)(bp + 32))
#define SHORT34P	((GBSPTR)(bp + 34))
#define SHORT36P	((GBSPTR)(bp + 36))
#define SHORT38P	((GBSPTR)(bp + 38))
#define SHORT40P	((GBSPTR)(bp + 40))
#define SHORT42P	((GBSPTR)(bp + 42))
#define SHORT44P	((GBSPTR)(bp + 44))
#define SHORT46P	((GBSPTR)(bp + 46))
#define SHORT48P	((GBSPTR)(bp + 48))
#define SHORT50P	((GBSPTR)(bp + 50))
#define SHORT52P	((GBSPTR)(bp + 52))
#define SHORT54P	((GBSPTR)(bp + 54))
#define SHORT56P	((GBSPTR)(bp + 56))
#define SHORT58P	((GBSPTR)(bp + 58))
#define SHORT60P	((GBSPTR)(bp + 60))
#define SHORT62P	((GBSPTR)(bp + 62))
#define SHORT64P	((GBSPTR)(bp + 64))
#define SHORT66P	((GBSPTR)(bp + 66))
#define SHORT124P	((GBSPTR)(bp + 124))

#define SHORT0		(*SHORT0P)
#define SHORT2		(*SHORT2P)
#define SHORT4		(*SHORT4P)
#define SHORT6		(*SHORT6P)
#define SHORT8		(*SHORT8P)
#define SHORT10		(*SHORT10P)
#define SHORT12		(*SHORT12P)
#define SHORT14		(*SHORT14P)
#define SHORT16		(*SHORT16P)
#define SHORT18		(*SHORT18P)
#define SHORT20		(*SHORT20P)
#define SHORT22		(*SHORT22P)
#define SHORT24		(*SHORT24P)
#define SHORT26		(*SHORT26P)
#define SHORT28		(*SHORT28P)
#define SHORT30		(*SHORT30P)
#define SHORT32		(*SHORT32P)
#define SHORT34		(*SHORT34P)
#define SHORT36		(*SHORT36P)
#define SHORT38		(*SHORT38P)
#define SHORT40		(*SHORT40P)
#define SHORT42		(*SHORT42P)
#define SHORT44		(*SHORT44P)
#define SHORT46		(*SHORT46P)
#define SHORT48		(*SHORT48P)
#define SHORT50		(*SHORT50P)
#define SHORT52		(*SHORT52P)
#define SHORT54		(*SHORT54P)
#define SHORT56		(*SHORT56P)
#define SHORT58		(*SHORT58P)
#define SHORT60		(*SHORT60P)
#define SHORT62		(*SHORT62P)
#define SHORT64		(*SHORT64P)
#define SHORT66		(*SHORT66P)
#define SHORT124	(*SHORT124P)

#define LONG0P		((GBLPTR)(bp + 0))
#define LONG2P		((GBLPTR)(bp + 2))
#define LONG4P		((GBLPTR)(bp + 4))
#define LONG6P		((GBLPTR)(bp + 6))
#define LONG8P		((GBLPTR)(bp + 8))
#define LONG10P		((GBLPTR)(bp + 10))
#define LONG12P		((GBLPTR)(bp + 12))
#define LONG14P		((GBLPTR)(bp + 14))
#define LONG16P		((GBLPTR)(bp + 16))
#define LONG32P		((GBLPTR)(bp + 32))

#define LONG0		(*LONG0P)
#define LONG2		(*LONG2P)
#define LONG4		(*LONG4P)
#define LONG6		(*LONG6P)
#define LONG8		(*LONG8P)
#define LONG10		(*LONG10P)
#define LONG12		(*LONG12P)
#define LONG14		(*LONG14P)
#define LONG16		(*LONG16P)
#define LONG32		(*LONG32P)

#define DOUBL0P		((GBDPTR)(bp + 0))
#define DOUBL2P		((GBDPTR)(bp + 2))
#define DOUBL4P		((GBDPTR)(bp + 4))
#define DOUBL6P		((GBDPTR)(bp + 6))
#define DOUBL8P		((GBDPTR)(bp + 8))
#define DOUBL10P	((GBDPTR)(bp + 10))
#define DOUBL12P	((GBDPTR)(bp + 12))
#define DOUBL14P	((GBDPTR)(bp + 14))
#define DOUBL16P	((GBDPTR)(bp + 16))
#define DOUBL18P	((GBDPTR)(bp + 18))
#define DOUBL20P	((GBDPTR)(bp + 20))
#define DOUBL22P	((GBDPTR)(bp + 22))
#define DOUBL24P	((GBDPTR)(bp + 24))
#define DOUBL26P	((GBDPTR)(bp + 26))
#define DOUBL28P	((GBDPTR)(bp + 28))
#define DOUBL30P	((GBDPTR)(bp + 30))
#define DOUBL32P	((GBDPTR)(bp + 32))
#define DOUBL34P	((GBDPTR)(bp + 34))
#define DOUBL36P	((GBDPTR)(bp + 36))
#define DOUBL38P	((GBDPTR)(bp + 38))
#define DOUBL40P	((GBDPTR)(bp + 40))
#define DOUBL42P	((GBDPTR)(bp + 42))
#define DOUBL44P	((GBDPTR)(bp + 44))
#define DOUBL46P	((GBDPTR)(bp + 46))
#define DOUBL48P	((GBDPTR)(bp + 48))
#define DOUBL50P	((GBDPTR)(bp + 50))
#define DOUBL52P	((GBDPTR)(bp + 52))
#define DOUBL54P	((GBDPTR)(bp + 54))
#define DOUBL56P	((GBDPTR)(bp + 56))
#define DOUBL58P	((GBDPTR)(bp + 58))
#define DOUBL60P	((GBDPTR)(bp + 60))

#define DOUBL0		(*DOUBL0P)
#define DOUBL2		(*DOUBL2P)
#define DOUBL4		(*DOUBL4P)
#define DOUBL6		(*DOUBL6P)
#define DOUBL8		(*DOUBL8P)
#define DOUBL10		(*DOUBL10P)
#define DOUBL12		(*DOUBL12P)
#define DOUBL14		(*DOUBL14P)
#define DOUBL16		(*DOUBL16P)
#define DOUBL18		(*DOUBL18P)
#define DOUBL20		(*DOUBL20P)
#define DOUBL22		(*DOUBL22P)
#define DOUBL24		(*DOUBL24P)
#define DOUBL26		(*DOUBL26P)
#define DOUBL28		(*DOUBL28P)
#define DOUBL30		(*DOUBL30P)
#define DOUBL32		(*DOUBL32P)
#define DOUBL34		(*DOUBL34P)
#define DOUBL36		(*DOUBL36P)
#define DOUBL38		(*DOUBL38P)
#define DOUBL40		(*DOUBL40P)
#define DOUBL42		(*DOUBL42P)
#define DOUBL44		(*DOUBL44P)
#define DOUBL46		(*DOUBL46P)
#define DOUBL48		(*DOUBL48P)
#define DOUBL50		(*DOUBL50P)
#define DOUBL52		(*DOUBL52P)
#define DOUBL54		(*DOUBL54P)
#define DOUBL56		(*DOUBL56P)
#define DOUBL58		(*DOUBL58P)
#define DOUBL60		(*DOUBL60P)
