// qserver.h

typedef struct QuakePlayerStatus {
	int id;				// This is the original ordinal for this player.
						// Since we sort the players, we need to save this.
	int score;			// Frag count.
	int ping;			// Ping, as measured by the server (not us).
	char name[64];		// Full name of player on server (not buddy abbreviation).
	BOOL isBuddy;		// Is this a buddy of ours (in the buddy list?)
} QuakePlayerStatus, *QuakePlayerStatusPtr;

#define MAX_PLAYERS 64

typedef struct QuakeServerStatus {
	char name[64];		// Name of the server, as reported by the server.
	char mapname[32];	// Current level being played.
	int nPlayers;		// Number of active players.
	int buddiesPlaying;	// How many of those players are buddies.
	time_t lastUpdate;	// Can be used to determine how old this status is.
	QuakePlayerStatus players[MAX_PLAYERS];
} QuakeServerStatus, *QuakeServerStatusPtr;

// Avoid re-announcing a buddy if they quit and then rejoined right away.
//
#define ANNOUNCE_DELAY 300

void PollQuakeServer(void);
void InitQuakeServerStatus(void);