// qserver.c

#include "syshdrs.h"

#include "TraySpy.h"
#include "wsock.h"
#include "qserver.h"
#include "prefs.h"
#include "Strn.h"

// The current data we read from our preferred server.
QuakeServerStatus gServerStatus;

extern HINSTANCE ghInstance;
extern Preferences gPrefs;

void InitQuakeServerStatus(void)
{
	ZeroMemory(&gServerStatus, sizeof(gServerStatus));
}	// InitQuakeServerStatus




// Look for the Q2 window class.
//
static BOOL IsQuakeRunning(void)
{
	HWND hWnd;

	hWnd = FindWindow("Quake 2", NULL);
	return (hWnd != (HWND) 0);
}	// IsQuakeRunning




static void AnnounceBuddy(int b, char *const playerName)
{
	char prog[512], *scp, *dcp, *dlim, *s2, *cp;
	char c;
	BOOL rc;
	int winExecResult;

	// Do not disrupt the user if s/he's already playing.
	//
	if (IsQuakeRunning())
		return;

	// Sound off, if a sound file was set.
	if (gPrefs.buddies[b].sound[0] != '\0')
		PlaySoundFile((LPCSTR) gPrefs.buddies[b].sound);

	if (gPrefs.buddies[b].program[0] != '\0') {
		// Try to "cd" to the same directory of the app
		// before we run it.
		//
		STRNCPY(prog, gPrefs.buddies[b].program);
		if (prog[1] == ':') {
			// Have a drive letter.
			cp = strrchr(prog, '\\');
			if ((cp == NULL) || (cp == (prog + 3))) {
				prog[2] = '\\';
				prog[3] = '\0';
			} else {
				*cp = '\0';
			}
			rc = SetCurrentDirectory(prog);
		} else if ((prog[0] == '\\') && (prog[1] == '\\') && (prog[2] != '\0') && (prog[2] != '\\')) {
			// Have a UNC path, like \\servername\share\directory\app.exe
			cp = strrchr(prog + 2, '\\');
			if (cp != NULL) {
				cp = strrchr(cp + 1, '\\');
				if (cp != NULL) {
					*cp = '\0';
					rc = SetCurrentDirectory(prog);
				}
			}
		}

		// Get the command line ready.
		//
		ZeroMemory(prog, sizeof(prog));
		scp = gPrefs.buddies[b].program;
		dcp = prog;
		dlim = dcp + sizeof(prog) - 1;
		for (;;) {
			c = *scp++;
			if (c == '\0') {
				break;
			} else if (c == '%') {
				if (*scp == 'b') {
					// Expand %b into buddy name (as configured by user).
					//
					for (s2 = gPrefs.buddies[b].name; *s2 != '\0'; s2++) {
						if (dcp < dlim)
							*dcp++ = *s2;
					}
					scp++;		// skip both the % and the char afterward.
				} else if (*scp == 'p') {
					// Expand %p into player name (as reported by server).
					//
					for (s2 = playerName; *s2 != '\0'; s2++) {
						if (dcp < dlim)
							*dcp++ = *s2;
					}
					scp++;		// skip both the % and the char afterward.
				} else if (*scp == 's') {
					// Expand %s into server name.
					//
					for (s2 = gServerStatus.name; *s2 != '\0'; s2++) {
						if (dcp < dlim)
							*dcp++ = *s2;
					}
					scp++;		// skip both the % and the char afterward.
				} else if (*scp == 'i') {
					// Expand %i into server IP address or DNS name.
					//
					for (s2 = gPrefs.serverAddrStr; *s2 != '\0'; s2++) {
						if (dcp < dlim)
							*dcp++ = *s2;
					}
					scp++;		// skip both the % and the char afterward.
				} else if (*scp == 'm') {
					// Expand %m into map name.
					//
					for (s2 = gServerStatus.mapname; *s2 != '\0'; s2++) {
						if (dcp < dlim)
							*dcp++ = *s2;
					}
					scp++;		// skip both the % and the char afterward.
				} else if (dcp < dlim) {
					*dcp++ = c;
				}
			} else if (dcp < dlim) {
				*dcp++ = c;
			}
		}
		*dcp = '\0';
		
		// Run the program.
		winExecResult = WinExec(prog, SW_SHOW);
		if (winExecResult <= 31) switch (winExecResult) {
			case ERROR_BAD_FORMAT:
				ErrBox("Could not run:  %s\nReason:  %s", prog, "The .EXE file is invalid (non-Win32 .EXE or error in .EXE image)");
				break;
			case ERROR_FILE_NOT_FOUND:
				ErrBox("Could not run:  %s\nReason:  %s", prog, "The specified file was not found.");
				break;
			case ERROR_PATH_NOT_FOUND:
				ErrBox("Could not run:  %s\nReason:  %s", prog, "The specified path was not found.");
				break;
			default:
				ErrBox("Could not run:  %s\nReason:  Unknown error #%d.", prog, winExecResult);
				break;
		}
	}
}	// AnnounceBuddy




static int SortPlayersByScore(const void *a, const void *b)
{
	QuakePlayerStatusPtr pspa, pspb;

	pspa = (QuakePlayerStatusPtr) a;
	pspb = (QuakePlayerStatusPtr) b;
	return (pspb->score - pspa->score);
}	// SortPlayersByScore




static void ParseServerStatus(char *msgbuf, int mbsize)
{
	char *lim;
	char *scp, *vars, *cp, *namestart;
	char *names;
	char *parsestr, *var, *value;
	QuakeServerStatusPtr qssp = &gServerStatus;
	int playerScore, playerPing, off, c;
	int n = 0;
	int i, b;
	int playing;
	int substringMatch;
	char playerName[64], buddyName[64];

	memset(qssp, 0, sizeof(QuakeServerStatus));

	lim = msgbuf + mbsize;
	scp = msgbuf + 4;

	vars = strchr(scp, '\n');
	if (vars == NULL)
		return;			// invalid reply
	*vars++ = '\0';
	if (stricmp(scp, "print") != 0)
		return;			// invalid reply
	names = strchr(vars, '\n');
	if (names == NULL)
		return;			// invalid reply
	*names++ = '\0';
	

	// Parse variables and their values
	parsestr = vars;
	for (;;) {
		var = strtok(parsestr, "\\");
		if (var == NULL)
			break;
		parsestr = NULL;

		value = strtok(parsestr, "\\");
		if (value == NULL)
			break;

		if (stricmp(var, "mapname") == 0) {
			STRNCPY(qssp->mapname, value);
		} else if (stricmp(var, "hostname") == 0) {
			STRNCPY(qssp->name, value);
		}
	}

	// Parse the players
	for (cp = names;;) {
		for (;;) {
			c = *cp++;
			if (c == '\0')
				goto done;
			if (isdigit(c) || ((c == '-') && (isdigit(*cp)))) {
				--cp;
				break;
			}
		}
		
		off = -1;
		if ((sscanf(cp, "%d%d%n", &playerScore, &playerPing, &off) < 2) || (off < 0))
			goto done;

		cp += off;

		for (;;) {
			c = *cp++;
			if (c == '\0')
				goto done;
			if (c == '"')
				break;	// found start of name
		}

		namestart = cp;

		for (;;) {
			c = *cp++;
			if (c == '\0')
				goto done;
			if (c == '\n')
				break;	// found end of name
		}

		cp[-1] = '\0';	// eat trailing \n
		cp[-2] = '\0';	// eat trailing "

		STRNCPY(qssp->players[n].name, namestart);
		if (playerPing == 0) {
			// It appears that when a new player
			// joins the server, the ping is 0,
			// but the score from the player that
			// previously occupied that slot on
			// the server has not been reset.
			//
			playerScore = 0;
		}
		qssp->players[n].ping = playerPing;
		qssp->players[n].score = playerScore;
		qssp->players[n].id = n;

		n++;
		if (n >= MAX_PLAYERS)
			break;	// no more room in structure for additional players!
	}

done:
	qssp->nPlayers = n;
	(void) qsort(qssp->players, (size_t) n, sizeof(QuakePlayerStatus), SortPlayersByScore);

	qssp->buddiesPlaying = 0;
	time(&qssp->lastUpdate);
	for (b=0; b<MAX_BUDDIES; b++) {
		// We normally match a buddy name by doing a substring search.
		// However, there is a special hack where you can do an exact
		// (but case-insensitive) search if you have the buddy name
		// start with an equal sign.  If your buddy happens to begin
		// with one (like =buddy), you can escape it with another
		// equal sign (like ==buddy).
		//
		substringMatch = 1;
		if (gPrefs.buddies[b].name[0] == '=') {
			if (gPrefs.buddies[b].name[1] != '=')
				substringMatch = 0;
			(void) STRNCPY(buddyName, gPrefs.buddies[b].name + 1);
		} else {
			(void) STRNCPY(buddyName, gPrefs.buddies[b].name);
		}
		(void) _strlwr(buddyName);
		playing = 0;
		for (i=0; i<n; i++) {
			(void) STRNCPY(playerName, qssp->players[i].name);
			(void) _strlwr(playerName);
			if ((buddyName[0] != '\0') &&
				(
					// The "*" wildcard hack doesn't work as you would
					// expect;  it only matches one player, not *each*
					// player.  So this is useful if you want to do
					// something when the first player joins, as opposed
					// to doing something for each player.
					//
					((buddyName[0] == '*') && (buddyName[1] == '\0')) ||

					// Default case: substring search.
					//
					((substringMatch != 0) && (strstr(playerName, buddyName) != NULL)) ||

					// Exact match.
					((substringMatch == 0) && (strcmp(playerName, buddyName) == 0))
				)
			) {
				playing = 1;
				break;
			}
		}
		if (playing) {
			if (gPrefs.buddies[b].playing == 0) {
				// Buddy just started playing!
				if ((gPrefs.buddies[b].quitPlayingAt + ANNOUNCE_DELAY) < qssp->lastUpdate) {
					// This ensures that we don't repeatedly announce
					// the buddy.  This could happen if the level
					// changed over and he hadn't yet rejoined.
					//
					AnnounceBuddy(b, qssp->players[i].name);
				}
			}
			qssp->buddiesPlaying++;
			qssp->players[i].isBuddy = 1;
		} else {
			if (gPrefs.buddies[b].playing != 0) {
				// Buddy just quit
				time(&gPrefs.buddies[b].quitPlayingAt);
			}
			qssp->players[i].isBuddy = 0;
		}
		gPrefs.buddies[b].playing = playing;
	}
}	// ParseServerStatus




// This function sends the status request and then waits for the reply.
// This makes it convenient to call this and know that the server has
// been refreshed, although it relies upon the fact that the status
// messages are subsecond (otherwise the program would be locked up
// until a reply came in).
//
void PollQuakeServer(void)
{
	static int sending = 0;
	char msgbuf[1500];

	if (sending != 0)	// Guard against re-entrancy.
		return;
	sending = 1;
	if ((SendStatusRequest() >= 0) && (WaitForReplyOrClose(3) == 0)) {
		if (ReadReply(msgbuf, sizeof(msgbuf)) >= 0) {
			ParseServerStatus(msgbuf, sizeof(msgbuf));
		}
	}
	sending = 0;
}	// PollQuakeServer
