// wsock.c

#include "syshdrs.h"

#include "TraySpy.h"
#include "wsock.h"

static WSADATA gWSAData;
int gSocket;
struct sockaddr_in gServerAddr;
fd_set gQuakeSocketSet;

int InitWinsock(void)
{
	gSocket = INVALID_SOCKET;
	ZeroMemory(&gServerAddr, (DWORD) sizeof(gServerAddr));
	return ((WSAStartup(MAKEWORD(1,1), &gWSAData) == 0) ? 0 : (-1));
}	// InitWinsock




void DisposeWinsock(void)
{
	CloseQuakeSocket();
	(void) WSACleanup();
}	// DisposeWinsock



int
StrAddr(const char *s, struct sockaddr_in *sa, int defaultport)
{
	char portstr[64];
	unsigned long ipnum;
	unsigned int port;
	struct hostent *hp;
	char *hostcp, *atsign, *colon;

	strncpy(portstr, s, sizeof(portstr));
	portstr[sizeof(portstr) - 1] = '\0';

	atsign = strchr(portstr, '@');
	if (atsign != NULL) {
		/* Look for port@host.name.domain */
		*atsign = '\0';
		hostcp = atsign + 1;
		port = (unsigned int) atoi(portstr);
	} else if ((colon = strchr(portstr, ':')) != NULL) {
		/* Look for host.name.domain:port */
		*colon = '\0';
		hostcp = portstr;
		port = (unsigned int) atoi(colon + 1);
	} else if (defaultport > 0) {
		/* Have just host.name.domain, use that w/ default port. */
		port = (unsigned int) defaultport;
		hostcp = portstr;
	} else {
		/* If defaultport <= 0, they must supply a port number
		 * in the host/port string.
		 */
		return (-1);
	}

	ZeroMemory(sa, (DWORD) sizeof(struct sockaddr_in));
	sa->sin_port = htons((short) port);

	ipnum = inet_addr(hostcp);
	if (ipnum != INADDR_NONE) {
		sa->sin_family = AF_INET;
		sa->sin_addr.s_addr = ipnum;
	} else {
		hp = gethostbyname(hostcp);
		if (hp == NULL) {
			fprintf(stderr, "Unknown host: %s", hostcp);
			return (-1);
		}
		sa->sin_family = hp->h_addrtype;
		memcpy(&sa->sin_addr.s_addr, hp->h_addr_list[0],
			(size_t) hp->h_length);
	}
	return (0);
}	/* StrAddr */




void
CloseQuakeSocket(void)
{
	if (gSocket != INVALID_SOCKET) {
		closesocket(gSocket);
		gSocket = INVALID_SOCKET;
	}
}	// CloseQuakeSocket



int
OpenQuakeSocket(void)
{
	if (gSocket != INVALID_SOCKET)
		return (0);		// Already open

	gSocket = socket(AF_INET, SOCK_DGRAM, 0);
	if (gSocket == INVALID_SOCKET) {
		return (-1);
	}
	return (0);
}	// OpenQuakeSocket




int SetQuakeServer(const char *const addrStr)
{
	if (addrStr[0] == '\0')
		return (-1);		// empty

	if (StrAddr(addrStr, &gServerAddr, 27910) < 0) {
		ZeroMemory(&gServerAddr, (DWORD) sizeof(gServerAddr));
		return (-1);
	}
	return (0);
}




int SendStatusRequest(void)
{
	int rc;
	unsigned char statusMsgRequestBuf[20];
	
	if (gServerAddr.sin_port == 0) {
		// Address has not been set.
		return (-1);
	}

	if (OpenQuakeSocket() < 0)
		return (-1);
	
	ZeroMemory(statusMsgRequestBuf, (DWORD) sizeof(statusMsgRequestBuf));
	statusMsgRequestBuf[0] = (unsigned char) 0xFF;
	statusMsgRequestBuf[1] = (unsigned char) 0xFF;
	statusMsgRequestBuf[2] = (unsigned char) 0xFF;
	statusMsgRequestBuf[3] = (unsigned char) 0xFF;
	strcpy((char *) statusMsgRequestBuf + 4, "status");
	
	rc = sendto(
		gSocket,
		(const char FAR *) statusMsgRequestBuf,
		sizeof(statusMsgRequestBuf),
		0,
		(const struct sockaddr *) &gServerAddr,
		sizeof(gServerAddr)
		);

	return (rc);
}	// SendStatusRequest




int WaitForReplyOrClose(int secs)
{
	struct timeval tv;

	tv.tv_sec = (long) secs;
	tv.tv_usec = 0;

	FD_ZERO(&gQuakeSocketSet);

#pragma warning(disable : 4127)
	FD_SET(gSocket, &gQuakeSocketSet);
#pragma warning(default : 4127)

	if (select(gSocket + 1, &gQuakeSocketSet, NULL, NULL, &tv) == 1)
		return (0);

	// Close this socket, and we will re-open it the next time.
	// We must do this because when we send the new request we
	// are no longer interested in the reply to the old request.
	//
	CloseQuakeSocket();
	return (-1);
}	// WaitForReplyOrClose



int ReadReply(char *msgbuf, int siz)
{
	int rc;
	struct sockaddr_in raddr;
	int raddrSize = sizeof(raddr);

	if (gSocket == INVALID_SOCKET)
		return (-1);

	// (Not necessary, but keep things clean)
	ZeroMemory(msgbuf, (size_t) siz);

	rc = recvfrom(
		gSocket,
		(char FAR *) msgbuf,
		siz,
		0,
		(struct sockaddr *) &raddr,
		&raddrSize
		);

	return (rc);
}	// ReadReply





int SendRconRequest(const char *const passwd, const char *const fmt, ...)
{
	int rc;
	unsigned char rcmdBuf[256];
	int len;
	va_list ap;

	if (gServerAddr.sin_port == 0) {
		// Address has not been set.
		return (-1);
	}

	if (OpenQuakeSocket() < 0)
		return (-1);
	
	ZeroMemory(rcmdBuf, (DWORD) sizeof(rcmdBuf));
	rcmdBuf[0] = (unsigned char) 0xFF;
	rcmdBuf[1] = (unsigned char) 0xFF;
	rcmdBuf[2] = (unsigned char) 0xFF;
	rcmdBuf[3] = (unsigned char) 0xFF;
	strcpy((char *) rcmdBuf + 4, "rcon ");
	if ((passwd != NULL) && (passwd[0] != '\0')) {
		strcat((char *) rcmdBuf + 4, passwd);
		strcat((char *) rcmdBuf + 4, " ");
	}
	len = strlen((char *) rcmdBuf + 4);

	va_start(ap, fmt);
	len = wvsprintf((char *) rcmdBuf + 4 + len, fmt, ap);
	va_end(ap);
	rcmdBuf[sizeof(rcmdBuf) - 1] = '\0';
	len = strlen((char *) rcmdBuf + 4) + 4;
	rcmdBuf[len] = '\0';

	rc = sendto(
		gSocket,
		(const char FAR *) rcmdBuf,
		len + 1,
		0,
		(const struct sockaddr *) &gServerAddr,
		sizeof(gServerAddr)
		);

	return (rc);
}	// SendRconRequest




