/*
  hl.cpp
		
	Q3Plug 1.1b5
		
  Half Life server query

  Author:   Markus Baumgartner
  Compiler: Microsoft Visual C++ 6.0
  Last Mod: 31/12/2000
	Tab size: 2
*/

#include <assert.h>
#include <string.h>
#include <windows.h>
#include <stdio.h>

#include "npapi.h"
#include "commctrl.h"

#ifndef _HL_H_
#include "hl.h"
#endif

#ifndef _Q3PLUG_H_
#include "q3plug.h"
#endif


// game-specific information
void HL_getInfo(char* text[]) {
  text[0] = "Half Life";
  text[1] = "Half Life server query code written by Markus Baumgartner\nmarkus.baumgartner@liwest.at";
  text[2] = "hl.exe";
  text[3] = "-console +connect %s:%s";                  // connect string used in command line (hostname:port)
}

// column names
void HL_getColumns(char* cols[]) {
  cols[0] = "Time    ";
  cols[1] = "Score";
  cols[2] = "Player";
}

// custom compare function to compare columns correctly
int HL_compareFunc(char *val1, char *val2, int sortCol, int sortDir) {
  assert(val1 && val2 && sortCol >= 0 && sortCol <=2);
  switch (sortCol) {
	  case 0: return sortDir*stricmp(val1,val2);
		case 1: return sortDir*(atoi(val1) - atoi(val2));
		case 2: return sortDir*stricmp(val1,val2);
    default: return 0;
  }
}

// do some initialization with data
// (buffer contains response from server)
// (HL: parsing is done here)
BOOL HL_initBuffer(PluginInstance *This) {
  int i,pos;
  char tmp[20];
  char tmp2[20];
  structRule rule;
  structPlayer player;
  int count=0;

  long frags;
  float time;
  int hours,secs,mins;
  char *cur;
  HLRuleInfo *ruleInfo;
  


  assert(This);
  assert(This->buffer);

  if (This->buffer[0] == -2)  // follow-up packet?
    ruleInfo = (HLRuleInfo*) &This->buffer[9];
  else 
    ruleInfo = (HLRuleInfo*) This->buffer;
	
  // check if valid packet
	switch (ruleInfo->id) {
    case 'E':
      i= ruleInfo->count1 / 2;
      i--;
      cur = &(ruleInfo->rules[0]);
      while (i>0) {
        rule.name = cur;
        cur += strlen(rule.name) + 1;
        rule.value = cur;
        cur += strlen(rule.value) + 1;
        UI_insertRule(This, rule);
        i--;
      };
      break;
    case 'D':
      i= ruleInfo->count1;
      sprintf(This->numplayers, "%d", i);
      while (i>0) {
        player.name = &(ruleInfo->rules[0]);
        pos = strlen(player.name)+1;
        memcpy(&frags, &(ruleInfo->rules[pos]),sizeof(frags));
        memcpy(&time, &(ruleInfo->rules[pos+4]),sizeof(time));
        hours= ((int) time) / 3600;
        secs = ((int) time) % 60;
        mins = (((int) time) / 60)%60;
        ruleInfo = (HLRuleInfo*)((long)ruleInfo+strlen(player.name)+10);
        sprintf(tmp, "%01d:%02d:%02d",hours,mins,secs);
        sprintf(tmp2,"%d",frags);
        player.frags = tmp2;
        player.ping = tmp;
        UI_insertPlayer(This, player);
        i--;
      }
      break;
    case 'C':
      cur = (char*) &ruleInfo->count1;
      cur+= strlen(cur)+1;
      strncpy(This->hostname,cur,64);
      cur+= strlen(cur)+1;
      rule.name = "_MAP";
      rule.value = cur;
      UI_insertRule(This, rule);
      cur+= strlen(cur)+1;
      rule.name = "_GAMEDIR";
      rule.value = cur;
      UI_insertRule(This, rule);
      cur+= strlen(cur)+1;
      rule.name = "_GAME";
      rule.value = cur;
      UI_insertRule(This, rule);
      cur+=strlen(cur)+1;
      cur++;
      i = (int) *cur;
      sprintf(This->maxclients,"%d",i);
      break;

    }

  return TRUE;	 	
}


// this procedure is called when the plugin window is notified of the arrival
// of a packet on its socket
BOOL HL_receivePacket(PluginInstance *p) {
	LARGE_INTEGER counter, freq;

  assert(p);
  assert(p->text);
  	 
  p->buffer = (char*) malloc(BUFSIZE);
	assert(p->buffer);

	// clear buffer (don't remove this!)
	memset(p->buffer, 0, BUFSIZE);

	/* receive packet */
  if (recv(p->sock, p->buffer, BUFSIZE, 0) == SOCKET_ERROR) {
    wsprintf(p->text, "Receive error (%d)", WSAGetLastError());
    free(p->buffer);
		return FALSE;
  }

  // have we already got ping time? if no, get packet time
	if (strlen(p->ping) == 0) {
    if (QueryPerformanceFrequency(&freq) && QueryPerformanceCounter(&counter))
	    p->ticks = 1000*(counter.QuadPart - p->ticks) / freq.QuadPart;
	  else
      p->ticks = GetTickCount() - p->ticks; 
  }

  // parse packet
  if (!HL_initBuffer(p)) {
		strcpy(p->text, "Invalid packet");
		free(p->buffer);
		return FALSE;
	 }
  
  // set packet time and reset status message 
  strcpy(p->text, "");
  sprintf(p->ping,"%d",(int)p->ticks);

  // now we can free the buffer 
	free(p->buffer);
    
  return TRUE;
}

// Sends a status-request packet to destination server */
BOOL HL_sendPacket(PluginInstance *p) {
  struct sockaddr_in sa;
  LARGE_INTEGER t;
  HOSTENT *host;
  int err1,err2,err3;

  assert(p);

  // close socket if still open
  if (isOpen(p->sock))
    closesocket(p->sock);

  /* create new socket */
  p->sock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
  if (p->sock == INVALID_SOCKET) {
    wsprintf(p->text, "Socket error (%d)", WSAGetLastError());
    return FALSE;
  }
    
  /* set parameters */
  sa.sin_family = AF_INET;
  sa.sin_port = htons(atoi(p->port));
  sa.sin_addr.S_un.S_addr = inet_addr(p->server);

  if (sa.sin_addr.S_un.S_addr == -1) {
    host = gethostbyname(p->server);
    if (!host) {
      strcpy(p->text, "Invalid server name");
      return FALSE;
    }
    memcpy(&(sa.sin_addr.s_addr), host->h_addr, sizeof(int));
  }
    
  /* send it (finally) */
  err1= sendto(p->sock, HL_getStatus3, sizeof(HL_getStatus3), 0, (sockaddr*) &sa, sizeof(sa));
  err2= sendto(p->sock, HL_getStatus2, sizeof(HL_getStatus2), 0, (sockaddr*) &sa, sizeof(sa));
  err3= sendto(p->sock, HL_getStatus, sizeof(HL_getStatus), 0, (sockaddr*) &sa, sizeof(sa));
  if (err1 == SOCKET_ERROR || err2 == SOCKET_ERROR || err3 == SOCKET_ERROR) {
    wsprintf(p->text, "Send error (%d)", WSAGetLastError());
    return FALSE;
  }

  // we use p->ping as a boolean flag to check if it is the first packet. so initialize it here
  strcpy(p->ping, "");

  if (QueryPerformanceCounter(&t))
		p->ticks = t.QuadPart;
	else
		p->ticks = GetTickCount();

  /* set socket to non-blocking mode */
  err1=WSAAsyncSelect(p->sock, p->fhWnd, WM_SERVER_RESPONSE, FD_READ);
  if (err1 == SOCKET_ERROR) {
    wsprintf(p->text, "Select error (%d)", WSAGetLastError());
    return FALSE;
  }
   
  return TRUE;
}


// custom draw procedure for colored names 
// return FALSE if default painting is required
BOOL HL_drawName(PluginInstance *This, HDC hdc, RECT win, char *name) {
  return FALSE;
}
