/*
  q3plug.cpp
		
	Q3Plug 1.2b1 
	
  Q3Plug main

  Author:   Markus Baumgartner
  Compiler: Microsoft Visual C++ 6.0 
  Last Mod: 03/11/2001
	Tab size: 2
*/

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <stdlib.h>
#include <winsock2.h>
#include <winuser.h>

#include "commctrl.h"
#include "resource.h"


#ifndef _NPAPI_H_
#include "npapi.h"
#endif

#ifndef _Q3_H_
#include "q3.h"
#endif

#ifndef _Q3PLUG_H_
#include "q3plug.h"
#endif

#ifndef _Q2_H_
#include "q2.h"
#endif

#ifndef _QW_H_
#include "qw.h"
#endif


#ifndef _HL_H_
#include "hl.h"
#endif

#ifndef _UT_H_
#include "ut.h"
#endif

#ifndef _TR_H_
#include "tr.h"
#endif

#ifndef _T2_H_
#include "t2.h"
#endif


////////////////////////////////////////////////////////////////////////////
// GLOBALS
////////////////////////////////////////////////////////////////////////////

HINSTANCE hInstance = NULL;
const char* gInstanceLookupString = "instance->pdata";
long int id = 0; 
DWORD autoRefresh=10;

HGDIOBJ bmp_cw=NULL, bmp_q3=NULL, bmp_hl=NULL, bmp_ut=NULL, bmp_q2=NULL, bmp_qw=NULL, bmp_tr=NULL, bmp_t2=NULL, bmp_jk=NULL,
bmp_mh=NULL;

char Q3_exepath[256]=""; char Q3_commandline[256]="";
char JK_exepath[256]=""; char JK_commandline[256]="";
char Q2_exepath[256]=""; char Q2_commandline[256]="";
char QW_exepath[256]=""; char QW_commandline[256]="";
char HL_exepath[256]=""; char HL_commandline[256]="";
char UT_exepath[256]=""; char UT_commandline[256]="";
char TR_exepath[256]=""; char TR_commandline[256]="";
char T2_exepath[256]=""; char T2_commandline[256]="";
char CW_exepath[256]=""; char CW_commandline[256]="";
char MH_exepath[256]=""; char MH_commandline[256]="";

  
////////////////////////////////////////////////////////////////////////////
// IMPLEMENTATION
////////////////////////////////////////////////////////////////////////////

long int nextid(void) {id++; return id;}
  											
// DllMain - just to save instance handle
BOOL WINAPI DllMain(HINSTANCE hinstDLL, WORD fdwReason, LPVOID lpvReserved)
{
	if (fdwReason == DLL_PROCESS_ATTACH) 
	  if (!hInstance)
      hInstance = hinstDLL;

 	return TRUE;
}

// checks if a given socket is open
BOOL isOpen(SOCKET s) {
  int result;
  char tmp[256];
  int size = sizeof(tmp);
   
  result = getsockopt (s, SOL_SOCKET, SO_TYPE, tmp, &size);
  return result==0;
}

// checks wheter a given menu item is checked
BOOL isChecked(HMENU menu, int index) {
  MENUITEMINFO mi;
  
  mi.cbSize = sizeof(mi);
  mi.fMask = MIIM_STATE;
  GetMenuItemInfo(menu,index,TRUE,&mi);
  return (mi.fState & MFS_CHECKED); 
}

// checks wheter a given menu item is checked
BOOL isGrayed(HMENU menu, int index) {
  MENUITEMINFO mi;
  
  mi.cbSize = sizeof(mi);
  mi.fMask = MIIM_STATE;
  GetMenuItemInfo(menu,index,TRUE,&mi);
  return (mi.fState & MFS_GRAYED); 
}

// sets the check on a given menu item 
void setChecked(HMENU menu, int index, BOOL checked) {
  MENUITEMINFO mi;
  mi.cbSize = sizeof(mi);
  mi.fMask = MIIM_STATE;
  GetMenuItemInfo(menu,index,TRUE,&mi);
  if (checked)
    mi.fState |= MFS_CHECKED;
  else
    mi.fState &= ~MFS_CHECKED;
 
  SetMenuItemInfo(menu,index,TRUE,&mi);
}

// sets the check on a given menu item 
void setGrayed(HMENU menu, int index, BOOL grayed) {
  MENUITEMINFO mi;
  mi.cbSize = sizeof(mi);
  mi.fMask = MIIM_STATE;

  GetMenuItemInfo(menu,index,TRUE,&mi);
   if (grayed)
    mi.fState |= MFS_GRAYED;
  else
    mi.fState &= ~MFS_GRAYED;

  SetMenuItemInfo(menu,index,TRUE,&mi);
}

// starts a process 
BOOL startProc(char *exepath, char *cmdline, char* connectstring) {
  PROCESS_INFORMATION pinfo;
  STARTUPINFO sinfo;
  char workdir[256];
  char final_cmdline[600];
  char *last;
  BOOL result;
   
  // extract working directory from exe path
  strncpy(workdir, exepath, sizeof(workdir)-1);
  last = strrchr(workdir, '\\');
  if (!last) 
		return FALSE;
  *(++last) = '\0';

  // build up final command line 
  strcpy(final_cmdline, exepath);
  strcat(final_cmdline, " ");
  strcat(final_cmdline, connectstring);
  strcat(final_cmdline, " ");
  strcat(final_cmdline, cmdline);

  memset(&sinfo, 0, sizeof(STARTUPINFO));
  sinfo.cb=sizeof(sinfo);
  sinfo.lpReserved=NULL; sinfo.lpTitle=NULL;

  result= CreateProcess(NULL, final_cmdline, NULL, NULL, FALSE, 
                        CREATE_NEW_PROCESS_GROUP | NORMAL_PRIORITY_CLASS, NULL,
                        workdir, &sinfo, &pinfo);

  if (result) {                 // close handles, we do not need them
    CloseHandle(pinfo.hProcess);
    CloseHandle(pinfo.hThread);
  }
  return result;
}

// read from the registry
BOOL readReg(char *key, char *value, char *result, int buflen) {
  int error;
  HKEY hkey;
  DWORD size=buflen;

  if (!key || !value || !result || buflen < 0)
    return FALSE;

  error=(RegOpenKeyEx(HKEY_CURRENT_USER, key,0, KEY_QUERY_VALUE, &hkey));
  if (error!=ERROR_SUCCESS) 
    return FALSE;
   
  error=(RegQueryValueEx(hkey, value, NULL, NULL, (unsigned char*)result, &size));
  if (error!=ERROR_SUCCESS) 
    return FALSE;

  if (!result)
    result="";
  return ERROR_SUCCESS==RegCloseKey(hkey);
}

// write a registry value
BOOL writeReg(char *key, char *value, char *newval, DWORD type, int typelen) {
  int error;
  HKEY hkey;

  if (!key || !value || !newval)
    return FALSE;

  error=RegCreateKeyEx(HKEY_CURRENT_USER,key,0,"",REG_OPTION_NON_VOLATILE,KEY_WRITE,NULL,&hkey,NULL);
  if (error!=ERROR_SUCCESS) 
    return FALSE;

  error=RegSetValueEx(hkey,value,0,type,(unsigned char*)newval,typelen);
  if (error!=ERROR_SUCCESS) 
    return FALSE;

  return ERROR_SUCCESS==RegCloseKey(hkey);
}

void UI_enableOSPMenu(BOOL enable) {


}

// creates the pop up context menu
void UI_createMenu(PluginInstance *This) {

  HMENU menu, subMenu;

  assert(This);
  
  menu = LoadMenu(hInstance, MAKEINTRESOURCE(IDR_MENU1));
  if (menu)
    subMenu = GetSubMenu(menu, 0);
  
  if (menu && subMenu)
    This->menu=menu, This->subMenu=subMenu;
}


// creates 4 buttons in the plugin window 
// todo: replace buttons with toolbar
void UI_createButtons(PluginInstance *This) {
  RECT win;
  
  assert(This);
  
  if (!GetClientRect(This->fhWnd, &win)) {
    MessageBox(This->fhWnd, "Error UI_createButtons", "Error", MB_ICONERROR);
    return;
  }

	This->button1 = CreateWindow("button", "", 
                               WS_CHILD | WS_VISIBLE | BS_CENTER |  BS_DEFPUSHBUTTON | BS_BITMAP,
                               3, 18,
                               55,20,
                               This->fhWnd, (HMENU)BUTTON1, hInstance, NULL);

  This->button2 = CreateWindow("button", "",
                               WS_CHILD | WS_VISIBLE | BS_CENTER |  BS_DEFPUSHBUTTON | BS_BITMAP,
                               3, 39,
                               55,20,
                               This->fhWnd, (HMENU)BUTTON2, hInstance, NULL);

  This->button3 = CreateWindow("button", "", 
                               WS_CHILD | WS_VISIBLE | BS_CENTER |  BS_DEFPUSHBUTTON | BS_BITMAP,
                               3, 60,
                               55,20,
                               This->fhWnd, (HMENU)BUTTON3, hInstance, NULL);

  assert(This->button1);
  assert(This->button2);
  assert(This->button3);
  
  SendMessage(This->button1, BM_SETIMAGE, (WPARAM)IMAGE_BITMAP, (LPARAM) LoadBitmap(hInstance,MAKEINTRESOURCE(IDB_REFRESH)));
  SendMessage(This->button3, BM_SETIMAGE, (WPARAM)IMAGE_BITMAP, (LPARAM) LoadBitmap(hInstance,MAKEINTRESOURCE(IDB_PLAY)));
  SendMessage(This->button2, BM_SETIMAGE, (WPARAM)IMAGE_BITMAP, (LPARAM) LoadBitmap(hInstance,MAKEINTRESOURCE(IDB_ABOUT)));
 
 
  EnableWindow(This->button3, FALSE);       // disable. enabled after successful server query
 }

// beware: the sorting code of this plugin is a rather dirty hack

// get index of list view item specified by param	(item's unique id)
int UI_getIndex(HWND win, LPARAM param) {
  LV_FINDINFO fi;
 	fi.flags = LVFI_PARAM;
	fi.lParam = param;
	return ListView_FindItem(win,-1,&fi);
}
	
// list view control sort function (rules)
int CALLBACK CompareFunc1(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)	{
 	char val1[128],val2[128];
	PluginInstance *This = (PluginInstance*) lParamSort;
	assert(This);
	HWND win = This->listbox;

	ListView_GetItemText(win,UI_getIndex(win,lParam1),This->sortCol1,val1,127);
	ListView_GetItemText(win,UI_getIndex(win,lParam2),This->sortCol1,val2,127);
	return This->sortDir1*stricmp(val1,val2);
}

// list view control sort function (players)
int CALLBACK CompareFunc2(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)	{
 	char val1[128],val2[128];
	PluginInstance *This = (PluginInstance*) lParamSort;
	assert(This);
	HWND win = This->listbox2;

	ListView_GetItemText(win,UI_getIndex(win,lParam1),This->sortCol2,val1,127);
	ListView_GetItemText(win,UI_getIndex(win,lParam2),This->sortCol2,val2,127);
	
	return This->compareFunc(val1,val2,This->sortCol2,This->sortDir2);
}


// insert a player record into the list view control
void UI_insertPlayer(PluginInstance *This, structPlayer p) {
  LVITEM lvItem;
	int nIndex;
	
	assert(This);

	// Add items to list view
	lvItem.state = 0;
	lvItem.stateMask = 0;
	lvItem.cchTextMax = 0;
	lvItem.lParam = nextid();

	lvItem.iIndent = 0;

	lvItem.mask = LVIF_TEXT|LVIF_PARAM;
	lvItem.iItem = 0;
	lvItem.iSubItem = 0;
	lvItem.pszText = p.ping;
	
	nIndex = ListView_InsertItem(This->listbox2,&lvItem);
	assert(nIndex != -1);

	lvItem.mask = LVIF_TEXT;
												 
	lvItem.iItem = nIndex;
	lvItem.iSubItem = 1;
	lvItem.pszText = p.frags;
	ListView_SetItem(This->listbox2,&lvItem);

	lvItem.iSubItem = 2;
	lvItem.pszText = p.name;
	ListView_SetItem(This->listbox2,&lvItem);
}

// insert a rule record into the list view control
void UI_insertRule(PluginInstance *This, structRule r) {
  LVITEM lvItem;
	int nIndex;

	assert(This);

	// Add items to list view
	lvItem.state = 0;
	lvItem.stateMask = 0;
	lvItem.cchTextMax = 0;
	lvItem.lParam = nextid();
	lvItem.iIndent = 0;

  lvItem.mask = LVIF_TEXT|LVIF_PARAM;
	lvItem.iItem = 0;
	lvItem.iSubItem = 0;
	lvItem.pszText = r.name;
	
	nIndex = ListView_InsertItem(This->listbox,&lvItem);
	assert(nIndex != -1);

	lvItem.mask = LVIF_TEXT;
	lvItem.iItem = nIndex;
	lvItem.iSubItem = 1;
	lvItem.pszText = r.value;
	ListView_SetItem(This->listbox,&lvItem);
}

// draw listboxes in plugin window
void UI_createLists(PluginInstance *This) {
  LVCOLUMN lvColumn;
	
	RECT  rectWin;
	POINT point1, point2;
	SIZE  size1, size2;
  char *colNames[3];
  int charWidth;

	assert(This);

  if (!GetClientRect(This->fhWnd, &rectWin)) {
    MessageBox(NULL, "Error UI_createLists", "Error", MB_ICONERROR);
    return;
  }
 
	point1.x = 59;
	point1.y = 19;
	size1.cx = 4*rectWin.right/10;       // 40% of total width for player window
	size1.cy = rectWin.bottom - 21;
 
	point2.x = point1.x + size1.cx + 3;
	point2.y = 19;
	size2.cx = rectWin.right - point2.x - 3;
	size2.cy = rectWin.bottom - 21;

  if (!This->listbox) {
    This->listbox= CreateWindow (WC_LISTVIEW, NULL, WS_CHILD | WS_VISIBLE |LVS_REPORT | LVS_SINGLESEL, 
                               point2.x, point2.y,
                               size2.cx, size2.cy,
                               This->fhWnd, (HMENU) LV1, hInstance, NULL);

	  assert(This->listbox);

    charWidth = ListView_GetStringWidth(This->listbox,"A");

	  // Add columns
	  lvColumn.mask = LVCF_TEXT|LVCF_WIDTH;

	  // Column 0
	  lvColumn.pszText = "Name";
	  lvColumn.cx = ListView_GetStringWidth(This->listbox,"Name")+2*charWidth;
	  ListView_InsertColumn(This->listbox,0,&lvColumn);
	
	  // Column 1
	  lvColumn.pszText = "Value";
	  lvColumn.cx = ListView_GetStringWidth(This->listbox,"Value")+2*charWidth;
	  ListView_InsertColumn(This->listbox,1,&lvColumn);
  }

  if (!This->listbox2) {
	  This->listbox2= CreateWindow (WC_LISTVIEW, NULL, WS_CHILD | WS_VISIBLE |LVS_REPORT  | LVS_SINGLESEL, 
                                point1.x, point1.y,
                                size1.cx, size1.cy,
																This->fhWnd, (HMENU) LV2, hInstance, NULL);
 

    charWidth = ListView_GetStringWidth(This->listbox,"A");

 	  // Add columns
	  lvColumn.mask = LVCF_TEXT|LVCF_WIDTH;

    // get column names
    This->getColumns(colNames);

	  // Column 0
	  lvColumn.pszText = colNames[0];
	  lvColumn.cx = ListView_GetStringWidth(This->listbox2,colNames[0])+2*charWidth;
	  ListView_InsertColumn(This->listbox2,0,&lvColumn);

	  // Column 1
	  lvColumn.pszText = colNames[1];
	  lvColumn.cx = ListView_GetStringWidth(This->listbox2,colNames[1])+2*charWidth;
	  ListView_InsertColumn(This->listbox2,1,&lvColumn);

	  // Column 2
	  lvColumn.pszText = colNames[2];
	  lvColumn.cx = ListView_GetStringWidth(This->listbox2,colNames[2])+2*charWidth;

	  ListView_InsertColumn(This->listbox2,2,&lvColumn);

    // set colors
    ListView_SetTextBkColor(This->listbox, This->bgcolor);
    ListView_SetTextBkColor(This->listbox2, This->bgcolor);
    ListView_SetBkColor(This->listbox, This->bgcolor);
    ListView_SetBkColor(This->listbox2, This->bgcolor);
    ListView_SetTextColor(This->listbox, This->color);
    ListView_SetTextColor(This->listbox2, This->color);
  }
}

/*+++++++++++++++++++++++++++++++++++++++++++++++++
 * NPP_Initialize:
 * Provides global initialization for a plug-in, and returns an error value. 
 *
 * This function is called once when a plug-in is loaded, before the first instance
 * is created. You should allocate any memory or resources shared by all
 * instances of your plug-in at this time. After the last instance has been deleted,
 * NPP_Shutdown will be called, where you can release any memory or
 * resources allocated by NPP_Initialize. 
 +++++++++++++++++++++++++++++++++++++++++++++++++*/
NPError
NPP_Initialize(void)
{
  int err;
  WSADATA WSAData;

  //try to get settings from registry
  readReg("SOFTWARE\\MB\\q3plug","Auto Refresh",(char*) &autoRefresh,sizeof(autoRefresh));
  
  readReg("SOFTWARE\\MB\\q3plug","Quake 3 exepath", Q3_exepath, sizeof(Q3_exepath));
  readReg("SOFTWARE\\MB\\q3plug","Quake 3 cmdline", Q3_commandline,sizeof(Q3_exepath));
  
  readReg("SOFTWARE\\MB\\q3plug","MOH exepath", MH_exepath, sizeof(MH_exepath));
  readReg("SOFTWARE\\MB\\q3plug","MOH cmdline", MH_commandline,sizeof(MH_exepath));
  
  readReg("SOFTWARE\\MB\\q3plug","JK2 exepath", JK_exepath, sizeof(JK_exepath));
  readReg("SOFTWARE\\MB\\q3plug","JK2 cmdline", JK_commandline,sizeof(JK_exepath));
  
  readReg("SOFTWARE\\MB\\q3plug","Quake 2 exepath", Q2_exepath, sizeof(Q2_exepath));
  readReg("SOFTWARE\\MB\\q3plug","Quake 2 cmdline", Q2_commandline,sizeof(Q2_exepath));
  readReg("SOFTWARE\\MB\\q3plug","Quakeworld exepath", QW_exepath, sizeof(QW_exepath));
  readReg("SOFTWARE\\MB\\q3plug","Quakeworld cmdline", QW_commandline,sizeof(QW_exepath));
  readReg("SOFTWARE\\MB\\q3plug","RTCW exepath", CW_exepath, sizeof(CW_exepath));
  readReg("SOFTWARE\\MB\\q3plug","RTCW cmdline", CW_commandline,sizeof(CW_exepath));
  readReg("SOFTWARE\\MB\\q3plug","Tribes cmdline", TR_commandline,sizeof(TR_exepath));
  readReg("SOFTWARE\\MB\\q3plug","Tribes exepath", TR_exepath,sizeof(TR_exepath));
  readReg("SOFTWARE\\MB\\q3plug","Tribes 2 cmdline", T2_commandline,sizeof(T2_exepath));
  readReg("SOFTWARE\\MB\\q3plug","Tribes 2 exepath", T2_exepath,sizeof(T2_exepath));
  readReg("SOFTWARE\\MB\\q3plug","Half Life exepath", HL_exepath, sizeof(HL_exepath));
  readReg("SOFTWARE\\MB\\q3plug","Half Life cmdline", HL_commandline,sizeof(HL_exepath));
  readReg("SOFTWARE\\MB\\q3plug","Unreal Tournament exepath", UT_exepath, sizeof(UT_exepath));
  readReg("SOFTWARE\\MB\\q3plug","Unreal Tournament cmdline", UT_commandline,sizeof(UT_exepath));
     
  


	// init common control library
  InitCommonControls();

  /* init winsock */
  err = WSAStartup(MAKEWORD(2,0), &WSAData);
  if (err != 0) {
    MessageBox(NULL, "Winsock 2 could not be started. Q3Plug requires	Win95B or higher.", "Winsock error", MB_ICONERROR);
    return NPERR_GENERIC_ERROR;
  }
    
  return NPERR_NO_ERROR;
}

/*+++++++++++++++++++++++++++++++++++++++++++++++++
 * NPP_GetJavaClass:
 * New in Netscape Navigator 3.0. 
 *
 * NPP_GetJavaClass is called during initialization to ask your plugin
 * what its associated Java class is. If you don't have one, just return
 * NULL. Otherwise, use the javah-generated "use_" function to both
 * initialize your class and return it. If you can't find your class, an
 * error will be signalled by "use_" and will cause the Navigator to
 * complain to the user.
 +++++++++++++++++++++++++++++++++++++++++++++++++*/
jref
NPP_GetJavaClass(void)
{
	return NULL;
}

/*+++++++++++++++++++++++++++++++++++++++++++++++++
 * NPP_Shutdown:
 * Provides global deinitialization for a plug-in. 
 * 
 * This function is called once after the last instance of your plug-in is destroyed.
 * Use this function to release any memory or resources shared across all
 * instances of your plug-in. You should be a good citizen and declare that
 * you're not using your java class any more. This allows java to unload
 * it, freeing up memory.
 +++++++++++++++++++++++++++++++++++++++++++++++++*/
void
NPP_Shutdown(void)
{
  
  if (bmp_q3) DeleteObject(bmp_q3);
  if (bmp_q2) DeleteObject(bmp_q2);
  if (bmp_mh) DeleteObject(bmp_mh);
  if (bmp_jk) DeleteObject(bmp_jk);
  if (bmp_qw) DeleteObject(bmp_qw);
  if (bmp_cw) DeleteObject(bmp_cw);
  if (bmp_ut) DeleteObject(bmp_ut);
  if (bmp_hl) DeleteObject(bmp_hl);
  if (bmp_tr) DeleteObject(bmp_tr);
  if (bmp_t2) DeleteObject(bmp_t2);

  // write settings to registry
  writeReg("SOFTWARE\\MB\\q3plug","Auto Refresh",(char*)&autoRefresh,REG_DWORD,sizeof(DWORD));
  
  writeReg("SOFTWARE\\MB\\q3plug","Quake 3 exepath", Q3_exepath, REG_SZ, 1+strlen(Q3_exepath));
  writeReg("SOFTWARE\\MB\\q3plug","Quake 3 cmdline", Q3_commandline, REG_SZ, 1+strlen(Q3_commandline));
  writeReg("SOFTWARE\\MB\\q3plug","Quake 2 exepath", Q2_exepath, REG_SZ, 1+strlen(Q2_exepath));
  writeReg("SOFTWARE\\MB\\q3plug","Quake 2 cmdline", Q2_commandline, REG_SZ, 1+strlen(Q2_commandline));
  
  writeReg("SOFTWARE\\MB\\q3plug","Quakeworld exepath", QW_exepath, REG_SZ, 1+strlen(QW_exepath));
  writeReg("SOFTWARE\\MB\\q3plug","Quakeworld cmdline", QW_commandline, REG_SZ, 1+strlen(QW_commandline));
  
  writeReg("SOFTWARE\\MB\\q3plug","RTCW exepath", CW_exepath, REG_SZ, 1+strlen(CW_exepath));
  writeReg("SOFTWARE\\MB\\q3plug","RTCW cmdline", CW_commandline, REG_SZ, 1+strlen(CW_commandline));
  
  writeReg("SOFTWARE\\MB\\q3plug","MOH exepath", MH_exepath, REG_SZ, 1+strlen(MH_exepath));
  writeReg("SOFTWARE\\MB\\q3plug","MOH cmdline", MH_commandline, REG_SZ, 1+strlen(MH_commandline));
  
  writeReg("SOFTWARE\\MB\\q3plug","JK2 exepath", JK_exepath, REG_SZ, 1+strlen(JK_exepath));
  writeReg("SOFTWARE\\MB\\q3plug","JK2 cmdline", JK_commandline, REG_SZ, 1+strlen(JK_commandline));
  

	writeReg("SOFTWARE\\MB\\q3plug","Half Life exepath", HL_exepath, REG_SZ, 1+strlen(HL_exepath));
  writeReg("SOFTWARE\\MB\\q3plug","Half Life cmdline", HL_commandline, REG_SZ, 1+strlen(HL_commandline));
  writeReg("SOFTWARE\\MB\\q3plug","Unreal Tournament exepath", UT_exepath, REG_SZ, 1+strlen(UT_exepath));
  writeReg("SOFTWARE\\MB\\q3plug","Unreal Tournament cmdline", UT_commandline, REG_SZ, 1+strlen(UT_commandline));

  writeReg("SOFTWARE\\MB\\q3plug","Tribes exepath", TR_exepath, REG_SZ, 1+strlen(TR_exepath));
  writeReg("SOFTWARE\\MB\\q3plug","Tribes cmdline", TR_commandline, REG_SZ, 1+strlen(TR_commandline));
  
  writeReg("SOFTWARE\\MB\\q3plug","Tribes 2 exepath", T2_exepath, REG_SZ, 1+strlen(T2_exepath));
  writeReg("SOFTWARE\\MB\\q3plug","Tribes 2 cmdline", T2_commandline, REG_SZ, 1+strlen(T2_commandline));

  // clean up Winsock                                                                                                                                                                                                 
  WSACleanup();	 
}

COLORREF colorFromString(const char *string) {
  char r[3], g[3], b[3];
  unsigned int i=0,rr,gg,bb;
  if (!string) 
    return RGB(0,0,0);
  if (string[0] == '#')
    i=1;
  if (strlen(string) < 6+i)
    return RGB(0,0,0);
  r[0] = string[0+i];
  r[1] = string[1+i];
  r[2] = 0;
  g[0] = string[2+i];
  g[1] = string[3+i];
  g[2] = 0;
  b[0] = string[4+i];
  b[1] = string[5+i];
  b[2] = 0;

  sscanf(r,"%x",&rr);
  sscanf(g,"%x",&gg);
  sscanf(b,"%x",&bb);
  return RGB(rr,gg,bb);
}


/*+++++++++++++++++++++++++++++++++++++++++++++++++
 * NPP_New:
 * Creates a new instance of a plug-in and returns an error value. 
 * 
 * NPP_New creates a new instance of your plug-in with MIME type specified
 * by pluginType. The parameter mode is NP_EMBED if the instance was created
 * by an EMBED tag, or NP_FULL if the instance was created by a separate file.
 * You can allocate any instance-specific private data in instance->pdata at this
 * time. The NPP pointer is valid until the instance is destroyed. 
 +++++++++++++++++++++++++++++++++++++++++++++++++*/
NPError 
NPP_New(NPMIMEType pluginType,
	NPP instance,
	uint16 mode,
	int16 argc,
	char* argn[],
	char* argv[],
	NPSavedData* saved)
{
  int type=GAME_Q3;
  BOOL autodetect=FALSE;
 
  NPError result = NPERR_NO_ERROR;
	PluginInstance* This;

	if (instance == NULL) {
		return NPERR_INVALID_INSTANCE_ERROR;
	}
	instance->pdata = NPN_MemAlloc(sizeof(PluginInstance));
	This = (PluginInstance*) instance->pdata;
	if (This == NULL) {
		return NPERR_OUT_OF_MEMORY_ERROR;
	}

  /* mode is NP_EMBED, NP_FULL, or NP_BACKGROUND (see npapi.h) */
	This->fWindow = NULL;
	This->fMode = mode;

  This->queryport=-1;

  This->fhWnd = NULL;
	This->fDefaultWindowProc = NULL;

	This->listbox = This->listbox2 = NULL;
  This->button1 = This->button2 = This->button3 = NULL;
 		
	strcpy(This->text, "Waiting for response");
	strcpy(This->ping, "");
	strcpy(This->hostname, "");
  strcpy(This->numplayers, "0");

  This->sortCol1 = 0;
  This->sortDir1 = 1;

  This->sortCol2 = 1;
  This->sortDir2 = -1;

  This->initialized = FALSE;
 	This->buffer = NULL;

  This->color = RGB(255,255,255);
  This->color2 = RGB(255,0,0);
  This->bgcolor = RGB(0,0,0);

  // extract arguments 
  strcpy(This->server, "");
  int i;
  for (i=0; i<argc; i++) {
    autodetect = autodetect || 0==stricmp("autodetect=yes", argn[i]) ;
    
    if ( 0==stricmp("bgcolor", argn[i])) {
      if (strlen(argv[i]) == 7 && argv[i][0] == '#') {
        This->bgcolor = colorFromString(argv[i]);
      }
    }
    
    if ( 0==stricmp("color", argn[i])) {
      if (strlen(argv[i]) == 7 && argv[i][0] == '#') {
        This->color = colorFromString(argv[i]);
      }
    }

    if ( 0==stricmp("color2", argn[i])) {
      if (strlen(argv[i]) == 7 && argv[i][0] == '#') {
        This->color2 = colorFromString(argv[i]);
      }
    }

    if ( 0==stricmp("queryport",argn[i])) {
      This->queryport = atoi(argv[i]);
    }

    if ( 0==stricmp("server", argn[i]) || 0==stricmp("name", argn[i]))
      strncpy(This->server, argv[i], 127);
    if ( 0==stricmp("game", argn[i])) {
       if (0==stricmp("q3",argv[i]))
         type=GAME_Q3;
       if (0==stricmp("q2",argv[i]))
         type=GAME_Q2;
       if (0==stricmp("mh",argv[i]))
         type=GAME_MH;
       if (0==stricmp("jk",argv[i]))
         type=GAME_JK;
       if (0==stricmp("cw",argv[i]))
         type=GAME_CW;
       if (0==stricmp("qw",argv[i]))
         type=GAME_QW;
       if (0==stricmp("hl",argv[i]))
         type=GAME_HL;
       if (0==stricmp("ut",argv[i]))
         type=GAME_UT;
       if (0==stricmp("tr",argv[i])) 
         type=GAME_TR;
       if (0==stricmp("t2",argv[i])) 
         type=GAME_T2;
     }
  }


  // additional support for q2plug tags
  if (stricmp(pluginType, "application/x-q2plug-plugin")==0)
    type=GAME_Q2;
    
  This->port = strchr(This->server, ':');
  if (This->port)
    *This->port++='\0';
	
  /*
  // auto detect game type depending on port (heuristic)
  if (autodetect && This->port) {
    port=atoi(This->port);
    type=GAME_Q3; // assume Q3 as default
    if (port >=27910 && port < 27960)
      type=GAME_Q2;
    if (port >=7000 && port <= 8000 || port==8888 || port==6666 || port==5555 || port=9999
       || port==4444 || port==3333 || port==2222 || port==1111)
      type=GAME_UT;
    if (port >=27015 && port < 27100)
      type=GAME_HL;
  }
  */

  // assign function pointers
	switch (type) {
    case GAME_Q2:
      This->receivePacketProc = &Q2_receivePacket;
	    This->sendPacketProc = &Q2_sendPacket;
	    This->compareFunc = &Q2_compareFunc;
      This->getColumns = &Q2_getColumns;
      This->drawName = &Q2_drawName;
      This->getInfo = &Q2_getInfo;
      if (!This->port) This->port="27910";
      if (!bmp_q2)
        bmp_q2 =  LoadBitmap(hInstance, MAKEINTRESOURCE(IDB_Q2));
      assert(bmp_q2);
      This->bitmap = bmp_q2;
      break;
    case GAME_QW:
      This->receivePacketProc = &QW_receivePacket;
	    This->sendPacketProc = &QW_sendPacket;
	    This->compareFunc = &QW_compareFunc;
      This->getColumns = &QW_getColumns;
      This->drawName = &QW_drawName;
      This->getInfo = &QW_getInfo;
      if (!This->port) This->port="27015";
      if (!bmp_qw)
        bmp_qw =  LoadBitmap(hInstance, MAKEINTRESOURCE(IDB_QW));
      assert(bmp_qw);
      This->bitmap = bmp_qw;
      break;
   case GAME_HL:
      This->receivePacketProc = &HL_receivePacket;
	    This->sendPacketProc = &HL_sendPacket;
	    This->compareFunc = &HL_compareFunc;
      This->getColumns = &HL_getColumns;
      This->drawName = &HL_drawName;
      This->getInfo = &HL_getInfo;
      if (!This->port) This->port="27015";
      if (!bmp_hl)
        bmp_hl =  LoadBitmap(hInstance, MAKEINTRESOURCE(IDB_HL));
      assert(bmp_hl);
      This->bitmap = bmp_hl;
      break;
    case GAME_UT:
      This->receivePacketProc = &UT_receivePacket;
	    This->sendPacketProc = &UT_sendPacket;
	    This->compareFunc = &UT_compareFunc;
      This->getColumns = &UT_getColumns;
      This->drawName = &UT_drawName;
      This->getInfo = &UT_getInfo;
      if (!This->port) This->port="7777";
      if (This->queryport==-1)
        This->queryport=1+atoi(This->port);
      if (!bmp_ut)
        bmp_ut =  LoadBitmap(hInstance, MAKEINTRESOURCE(IDB_UT));
      assert(bmp_ut);
      This->bitmap = bmp_ut;
      break;
    case GAME_MH:
      This->receivePacketProc = &UT_receivePacket;
	    This->sendPacketProc = &UT_sendPacket;
	    This->compareFunc = &UT_compareFunc;
      This->getColumns = &UT_getColumns;
      This->drawName = &UT_drawName;
      This->getInfo = &MH_getInfo;
      if (!This->port) This->port="12203";
      if (This->queryport==-1)
        This->queryport=12300;
      if (!bmp_mh)
        bmp_mh =  LoadBitmap(hInstance, MAKEINTRESOURCE(IDB_MH));
      assert(bmp_mh);
      This->bitmap = bmp_mh;
      break;
    case GAME_TR:
      This->receivePacketProc = &TR_receivePacket;
	    This->sendPacketProc = &TR_sendPacket;
	    This->compareFunc = &TR_compareFunc;
      This->getColumns = &TR_getColumns;
      This->drawName = &TR_drawName;
      This->getInfo = &TR_getInfo;
      if (!This->port) This->port="28000";
      if (!bmp_tr)
        bmp_tr =  LoadBitmap(hInstance, MAKEINTRESOURCE(IDB_TR));
      assert(bmp_tr);
      This->bitmap = bmp_tr;
      break;
    case GAME_T2:
      This->receivePacketProc = &T2_receivePacket;
	    This->sendPacketProc = &T2_sendPacket;
	    This->compareFunc = &T2_compareFunc;
      This->getColumns = &T2_getColumns;
      This->drawName = &T2_drawName;
      This->getInfo = &T2_getInfo;
      if (!This->port) This->port="28000";
      if (!bmp_t2)
        bmp_t2 =  LoadBitmap(hInstance, MAKEINTRESOURCE(IDB_TR));
      assert(bmp_t2);
      This->bitmap = bmp_t2;
      break;
    case GAME_CW:
      This->receivePacketProc = &Q3_receivePacket;
	    This->sendPacketProc = &Q3_sendPacket;
	    This->compareFunc = &Q3_compareFunc;
      This->getColumns = &Q3_getColumns;
      This->drawName = &Q3_drawName;
      This->getInfo = &CW_getInfo;
      if (!This->port) This->port="27960";
      if (!bmp_cw)
        bmp_cw =  LoadBitmap(hInstance, MAKEINTRESOURCE(IDB_CW));
      assert(bmp_cw);
      This->bitmap = bmp_cw;
      break;
    case GAME_JK:
      This->receivePacketProc = &Q3_receivePacket;
	    This->sendPacketProc = &Q3_sendPacket;
	    This->compareFunc = &Q3_compareFunc;
      This->getColumns = &Q3_getColumns;
      This->drawName = &Q3_drawName;
      This->getInfo = &JK_getInfo;
      if (!This->port) This->port="28070";
      if (!bmp_jk)
        bmp_jk =  LoadBitmap(hInstance, MAKEINTRESOURCE(IDB_JK));
      assert(bmp_jk);
      This->bitmap = bmp_jk;
      break;

    default:
      This->receivePacketProc = &Q3_receivePacket;
	    This->sendPacketProc = &Q3_sendPacket;
	    This->compareFunc = &Q3_compareFunc;
      This->getColumns = &Q3_getColumns;
      This->drawName = &Q3_drawName;
      This->getInfo = &Q3_getInfo;
      if (!This->port) This->port="27960";
      if (!bmp_q3)
        bmp_q3 =  LoadBitmap(hInstance, MAKEINTRESOURCE(IDB_Q3));
      assert(bmp_q3);
      This->bitmap = bmp_q3;
      break;
  }
   
  return result;
}

/*+++++++++++++++++++++++++++++++++++++++++++++++++
 * NPP_Destroy:
 * Deletes a specific instance of a plug-in and returns an error value. 

 * NPP_Destroy is called when a plug-in instance is deleted, typically because the
 * user has left the page containing the instance, closed the window, or quit the
 * application. You should delete any private instance-specific information stored
 * in instance->pdata. If the instance being deleted is the last instance created
 * by your plug-in, NPP_Shutdown will subsequently be called, where you can
 * delete any data allocated in NPP_Initialize to be shared by all your plug-in's
 * instances. Note that you should not perform any graphics operations in
 * NPP_Destroy as the instance's window is no longer guaranteed to be valid. 
 +++++++++++++++++++++++++++++++++++++++++++++++++*/
NPError 
NPP_Destroy(NPP instance, NPSavedData** save)
{
	PluginInstance* This;
  HANDLE img;
  
  if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;

	This = (PluginInstance*) instance->pdata;

	assert(This);

  if( This->fWindow ) { /* If we have a window, clean it up. */
		
    img = (HANDLE) SendMessage(This->button1, BM_GETIMAGE, (WPARAM)IMAGE_BITMAP,  0); 
    DeleteObject(img);
    img = (HANDLE) SendMessage(This->button2, BM_GETIMAGE, (WPARAM)IMAGE_BITMAP,  0); 
    DeleteObject(img);
    img = (HANDLE) SendMessage(This->button3, BM_GETIMAGE, (WPARAM)IMAGE_BITMAP,  0); 
    DeleteObject(img);
    
    DestroyWindow(This->button1);
    DestroyWindow(This->button2);
    DestroyWindow(This->button3);
    DestroyWindow(This->listbox);
    DestroyWindow(This->listbox2);
    DestroyMenu(This->menu);

    SetWindowLong( This->fhWnd, GWL_WNDPROC, (LONG)This->fDefaultWindowProc);
		This->fDefaultWindowProc = NULL;
		This->fhWnd = NULL;
	}

  // clean up instance data
	if (This) {
	  NPN_MemFree(instance->pdata);
		instance->pdata = NULL;
	}

	return NPERR_NO_ERROR;
}

/*+++++++++++++++++++++++++++++++++++++++++++++++++
 * NPP_SetWindow:
 * Sets the window in which a plug-in draws, and returns an error value. 
 * 
 * NPP_SetWindow informs the plug-in instance specified by instance of the
 * the window denoted by window in which the instance draws. This NPWindow
 * pointer is valid for the life of the instance, or until NPP_SetWindow is called
 * again with a different value. Subsequent calls to NPP_SetWindow for a given
 * instance typically indicate that the window has been resized. If either window
 * or window->window are NULL, the plug-in must not perform any additional
 * graphics operations on the window and should free any resources associated
 * with the window. 
 +++++++++++++++++++++++++++++++++++++++++++++++++*/
NPError 
NPP_SetWindow(NPP instance, NPWindow* window)
{
  NPError result = NPERR_NO_ERROR;
	PluginInstance* This;
  
  if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;

	This = (PluginInstance*) instance->pdata;
	
  assert(This);

	if( This->fWindow ) /* If we already have a window, clean
								       * it up before trying to subclass the new window. */
	{
		if( (window == NULL) || ( window->window == NULL ) ) {
			/* There is now no window to use. get rid of the old
			 * one and exit. */
	    
      SetWindowLong( This->fhWnd, GWL_WNDPROC, (LONG)This->fDefaultWindowProc);
			This->fDefaultWindowProc = NULL;
			This->fhWnd = NULL;
			This->fWindow=window;
			return NPERR_NO_ERROR;
		}

		else if ( This->fhWnd == (HWND) window->window ) {
			/* The new window is the same as the old one. Redraw and get out. */
			InvalidateRect( This->fhWnd, NULL, TRUE );
			UpdateWindow( This->fhWnd );
			This->fWindow=window;
  		return NPERR_NO_ERROR;
		}
		else {
			/* Clean up the old window, so that we can subclass the new
			 * one later. */
	    SetWindowLong( This->fhWnd, GWL_WNDPROC, (LONG)This->fDefaultWindowProc);
			This->fDefaultWindowProc = NULL;
			This->fhWnd = NULL;
		}
	}
	else if( (window == NULL) || ( window->window == NULL ) ) {
		/* We can just get out of here if there is no current
		 * window and there is no new window to use. */
	    This->fWindow=window;
		  return NPERR_NO_ERROR;
	}

	/* At this point, we will subclass
	 * window->window so that we can begin drawing and
	 * receiving window messages. */
	This->fDefaultWindowProc = (WNDPROC)SetWindowLong( (HWND)window->window, GWL_WNDPROC, (LONG)PluginWindowProc);
	This->fWindow = window;
  This->fhWnd = (HWND) window->window;
  SetProp( (HWND) This->fWindow->window, gInstanceLookupString, (HANDLE) This);
  
  /* Custom initialization */

	// just redraw the window so it gets initialized
	
 	InvalidateRect( This->fhWnd, NULL, TRUE );
	UpdateWindow( This->fhWnd );
  
  if (result != NPERR_NO_ERROR)
    MessageBox(NULL,"Initialisation error", "Error", MB_OK);

  return result;
}

/*+++++++++++++++++++++++++++++++++++++++++++++++++
 * NPP_NewStream:
 * Notifies an instance of a new data stream and returns an error value. 
 * 
 * NPP_NewStream notifies the instance denoted by instance of the creation of
 * a new stream specifed by stream. The NPStream* pointer is valid until the
 * stream is destroyed. The MIME type of the stream is provided by the
 * parameter type. 
 +++++++++++++++++++++++++++++++++++++++++++++++++*/
NPError 
NPP_NewStream(NPP instance,
	      NPMIMEType type,
	      NPStream *stream,
	      NPBool seekable,
	      uint16 *stype)
{
	PluginInstance* This;

	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;

	This = (PluginInstance*) instance->pdata;

	return NPERR_NO_ERROR;
}


/* PLUGIN DEVELOPERS:
 *	These next 2 functions are directly relevant in a plug-in which
 *	handles the data in a streaming manner. If you want zero bytes
 *	because no buffer space is YET available, return 0. As long as
 *	the stream has not been written to the plugin, Navigator will
 *	continue trying to send bytes.  If the plugin doesn't want them,
 *	just return some large number from NPP_WriteReady(), and
 *	ignore them in NPP_Write().  For a NP_ASFILE stream, they are
 *	still called but can safely be ignored using this strategy.
 */

int32 STREAMBUFSIZE = 0X0FFFFFFF; /* If we are reading from a file in NPAsFile
								   * mode so we can take any size stream in our
								   * write call (since we ignore it) */

/*+++++++++++++++++++++++++++++++++++++++++++++++++
 * NPP_WriteReady:
 * Returns the maximum number of bytes that an instance is prepared to accept
 * from the stream. 
 * 
 * NPP_WriteReady determines the maximum number of bytes that the
 * instance will consume from the stream in a subsequent call NPP_Write. This
 * function allows Netscape to only send as much data to the instance as the
 * instance is capable of handling at a time, allowing more efficient use of
 * resources within both Netscape and the plug-in. 
 +++++++++++++++++++++++++++++++++++++++++++++++++*/
int32 
NPP_WriteReady(NPP instance, NPStream *stream)
{
	PluginInstance* This;
	if (instance != NULL)
		This = (PluginInstance*) instance->pdata;

	/* Number of bytes ready to accept in NPP_Write() */
	return STREAMBUFSIZE;
}


/*+++++++++++++++++++++++++++++++++++++++++++++++++
 * NPP_Write:
 * Delivers data from a stream and returns the number of bytes written. 
 * 
 * NPP_Write is called after a call to NPP_NewStream in which the plug-in
 * requested a normal-mode stream, in which the data in the stream is delivered
 * progressively over a series of calls to NPP_WriteReady and NPP_Write. The
 * function delivers a buffer buf of len bytes of data from the stream identified
 * by stream to the instance. The parameter offset is the logical position of
 * buf from the beginning of the data in the stream. 
 * 
 * The function returns the number of bytes written (consumed by the instance).
 * A negative return value causes an error on the stream, which will
 * subsequently be destroyed via a call to NPP_DestroyStream. 
 * 
 * Note that a plug-in must consume at least as many bytes as it indicated in the
 * preceeding NPP_WriteReady call. All data consumed must be either processed
 * immediately or copied to memory allocated by the plug-in: the buf parameter
 * is not persistent. 
 +++++++++++++++++++++++++++++++++++++++++++++++++*/
int32 
NPP_Write(NPP instance, NPStream *stream, int32 offset, int32 len, void *buffer)
{
	if (instance != NULL) {
		PluginInstance* This = (PluginInstance*) instance->pdata;
	}
	return len;		/* The number of bytes accepted */
}

/*+++++++++++++++++++++++++++++++++++++++++++++++++
 * NPP_DestroyStream:
 * Indicates the closure and deletion of a stream, and returns an error value.
 * 
 * The NPP_DestroyStream function is called when the stream identified by
 * stream for the plug-in instance denoted by instance will be destroyed. You
 * should delete any private data allocated in stream->pdata at this time. 
 +++++++++++++++++++++++++++++++++++++++++++++++++*/
NPError 
NPP_DestroyStream(NPP instance, NPStream *stream, NPError reason)
{
	PluginInstance* This;

	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;
	This = (PluginInstance*) instance->pdata;

	return NPERR_NO_ERROR;
}

/*+++++++++++++++++++++++++++++++++++++++++++++++++
 * NPP_StreamAsFile:
 * Provides a local file name for the data from a stream. 
 * 
 * NPP_StreamAsFile provides the instance with a full path to a local file,
 * identified by fname, for the stream specified by stream. NPP_StreamAsFile is
 * called as a result of the plug-in requesting mode NP_ASFILEONLY or
 * NP_ASFILE in a previous call to NPP_NewStream. If an error occurs while
 * retrieving the data or writing the file, fname may be NULL. 
 +++++++++++++++++++++++++++++++++++++++++++++++++*/
void 
NPP_StreamAsFile(NPP instance, NPStream *stream, const char* fname)
{
	PluginInstance* This;
	if (instance != NULL)
		This = (PluginInstance*) instance->pdata;
}

/*+++++++++++++++++++++++++++++++++++++++++++++++++
 * NPP_Print:
 +++++++++++++++++++++++++++++++++++++++++++++++++*/
void 
NPP_Print(NPP instance, NPPrint* printInfo)
{
	if(printInfo == NULL)
		return;

	if (instance != NULL) {
		PluginInstance* This = (PluginInstance*) instance->pdata;
	
		if (printInfo->mode == NP_FULL) {
		    /*
		     * PLUGIN DEVELOPERS:
		     *	If your plugin would like to take over
		     *	printing completely when it is in full-screen mode,
		     *	set printInfo->pluginPrinted to TRUE and print your
		     *	plugin as you see fit.  If your plugin wants Netscape
		     *	to handle printing in this case, set
		     *	printInfo->pluginPrinted to FALSE (the default) and
		     *	do nothing.  If you do want to handle printing
		     *	yourself, printOne is true if the print button
		     *	(as opposed to the print menu) was clicked.
		     *	On the Macintosh, platformPrint is a THPrint; on
		     *	Windows, platformPrint is a structure
		     *	(defined in npapi.h) containing the printer name, port,
		     *	etc.
		     */

			void* platformPrint =
				printInfo->print.fullPrint.platformPrint;
			NPBool printOne =
				printInfo->print.fullPrint.printOne;
			
			/* Do the default*/
			printInfo->print.fullPrint.pluginPrinted = FALSE;
		}
		else {	/* If not fullscreen, we must be embedded */
		    /*
		     * PLUGIN DEVELOPERS:
		     *	If your plugin is embedded, or is full-screen
		     *	but you returned false in pluginPrinted above, NPP_Print
		     *	will be called with mode == NP_EMBED.  The NPWindow
		     *	in the printInfo gives the location and dimensions of
		     *	the embedded plugin on the printed page.  On the
		     *	Macintosh, platformPrint is the printer port; on
		     *	Windows, platformPrint is the handle to the printing
		     *	device context.
		     */

			NPWindow* printWindow =
				&(printInfo->print.embedPrint.window);
			void* platformPrint =
				printInfo->print.embedPrint.platformPrint;
		}
	}
}

/*+++++++++++++++++++++++++++++++++++++++++++++++++
 * NPP_URLNotify:
 * Notifies the instance of the completion of a URL request. 
 * 
 * NPP_URLNotify is called when Netscape completes a NPN_GetURLNotify or
 * NPN_PostURLNotify request, to inform the plug-in that the request,
 * identified by url, has completed for the reason specified by reason. The most
 * common reason code is NPRES_DONE, indicating simply that the request
 * completed normally. Other possible reason codes are NPRES_USER_BREAK,
 * indicating that the request was halted due to a user action (for example,
 * clicking the "Stop" button), and NPRES_NETWORK_ERR, indicating that the
 * request could not be completed (for example, because the URL could not be
 * found). The complete list of reason codes is found in npapi.h. 
 *
 * The parameter notifyData is the same plug-in-private value passed as an
 * argument to the corresponding NPN_GetURLNotify or NPN_PostURLNotify
 * call, and can be used by your plug-in to uniquely identify the request. 
 +++++++++++++++++++++++++++++++++++++++++++++++++*/
void
NPP_URLNotify(NPP instance, const char* url, NPReason reason, void* notifyData)
{
	
}

/*+++++++++++++++++++++++++++++++++++++++++++++++++
 * NPP_HandleEvent:
 * Mac-only, but stub must be present for Windows
 * Delivers a platform-specific event to the instance. 
 * 
 * On the Macintosh, event is a pointer to a standard Macintosh EventRecord.
 * All standard event types are passed to the instance as appropriate. In general,
 * return TRUE if you handle the event and FALSE if you ignore the event. 
 +++++++++++++++++++++++++++++++++++++++++++++++++*/
int16
NPP_HandleEvent(NPP instance, void* event)
{
	return 0;
}
/*******************************************************************************/



/*+++++++++++++++++++++++++++++++++++++++++++++++++
 * PluginWindowProc
 *
 * Handle the Windows window-event loop.
 +++++++++++++++++++++++++++++++++++++++++++++++++*/

LRESULT CALLBACK PluginWindowProc( HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam) {
	PluginInstance* This = (PluginInstance*) GetProp(hWnd, gInstanceLookupString);
  assert(This);
      
  const char *infotext="Q3Plug 1.3";
  char sname[256];
  char tmp[256],tmp2[64];
  char *cur, *exepath, *cmdline;
  char *text[INFO_ITEMS];

  int i=0,width,xPos,yPos;
  PAINTSTRUCT paintStruct;
	HDC hdc;
  RECT win, bounds;
  HGDIOBJ object,old;
  HBRUSH brush;
	HWND hW;
  HWND parent,current;
  HDC memdc;
 
  switch( Msg ) {
    case WM_NCHITTEST:
		  return HTCLIENT;

     case WM_NOTIFY:				 
			
      hW = ((LPNMHDR)lParam)->hwndFrom;
			
			// handle column clicks
			if (((LPNMHDR) lParam)->code == LVN_COLUMNCLICK) { 
			  
				
				if (hW==This->listbox) {
					This->sortCol1 = ((LPNMLISTVIEW) lParam)->iSubItem;
          This->sortDir1 = -This->sortDir1;
          ListView_SortItems(hW,CompareFunc1,(LPARAM)This);
        } else if (hW==This->listbox2) {
          This->sortCol2 = ((LPNMLISTVIEW) lParam)->iSubItem;
          This->sortDir2 = -This->sortDir2;
					ListView_SortItems(hW,CompareFunc2,(LPARAM)This);
        }
			}

			// handle custom drawing
			if ((( hW == This->listbox2)&& ((LPNMHDR) lParam)->code == NM_CUSTOMDRAW)) {
			  switch(((LPNMLVCUSTOMDRAW) lParam)->nmcd.dwDrawStage) {
				  case CDDS_PREPAINT :	   return CDRF_NOTIFYITEMDRAW;
					case CDDS_ITEMPREPAINT:  return CDRF_NOTIFYSUBITEMDRAW; 
					case CDDS_ITEMPREPAINT | CDDS_SUBITEM: 
						if (((LPNMLVCUSTOMDRAW) lParam)->iSubItem != 2)	// we only draw col 2 
						  return CDRF_DODEFAULT;
					  else {																					// draw text of col 2 
						  hdc = ((LPNMLVCUSTOMDRAW) lParam)->nmcd.hdc;
							ListView_GetItemRect(hW,								
																  ((LPNMLVCUSTOMDRAW) lParam)->nmcd.dwItemSpec,
																  &bounds,
																	LVIR_BOUNDS);
							
							win = ((LPNMLVCUSTOMDRAW) lParam)->nmcd.rc;
							win.top = bounds.top;
							win.bottom = bounds.bottom;
							win.right += bounds.left;
							win.left +=bounds.left;
						 	
							ListView_GetItemText(hW,((LPNMLVCUSTOMDRAW) lParam)->nmcd.dwItemSpec,2,sname,128);
							if (This->drawName(This, hdc, win, sname)) 
							  return CDRF_SKIPDEFAULT;
              else
                return CDRF_DODEFAULT;
						}
					}
    	}
			
			break;

    case WM_SERVER_RESPONSE:     // notified by Winsock of an available packet
      // kill timeout timer and re-enable the "refresh"-button
      KillTimer((HWND) This->fWindow->window, TIMER_TIMEOUT);
      EnableWindow(This->button1, TRUE);
      
      // create list views
      UI_createLists(This);                                   
      
      if (!This->receivePacketProc(This)) {                       // not a valid packet
        closesocket(This->sock);
        DestroyWindow(This->listbox); This->listbox=NULL;  
        DestroyWindow(This->listbox2); This->listbox2=NULL;
      } else {                                                    // valid
        EnableWindow(This->button3, TRUE);
        // resize columns
        i = ListView_GetColumnWidth(This->listbox2,0);
        i+= ListView_GetColumnWidth(This->listbox2,1);
        GetWindowRect(This->listbox2, &win);
        if (ListView_GetItemCount(This->listbox2) > ListView_GetCountPerPage(This->listbox2))
				  i+= GetSystemMetrics(SM_CXVSCROLL);											 // account for scrollbar
				ListView_SetColumnWidth(This->listbox2,2,(win.right-win.left)-i);
			  
        ListView_SetColumnWidth(This->listbox,0,LVSCW_AUTOSIZE);
			  i = ListView_GetColumnWidth(This->listbox,0);
        if (ListView_GetItemCount(This->listbox) > ListView_GetCountPerPage(This->listbox))
				  i+= GetSystemMetrics(SM_CXVSCROLL);											 // account for scrollbar
				GetWindowRect(This->listbox, &win);
        ListView_SetColumnWidth(This->listbox,1,(win.right-win.left)-i);
			  
				// sort columns      
        ListView_SortItems(This->listbox2,CompareFunc2,(LPARAM)This);
			  ListView_SortItems(This->listbox,CompareFunc1,(LPARAM)This);

        // adjust menu
        if (isGrayed(This->subMenu, 3)) {
          DeleteMenu(This->subMenu, 3, MF_BYPOSITION);
        }
      }
     			
      // redraw
			InvalidateRect( hWnd, NULL, TRUE );
	    UpdateWindow( hWnd );
      break;

    case WM_COMMAND:       // window was notified of a command

      // menu item (auto refresh)
      if (LOWORD(wParam) == MENU_REFRESH) {
        if (isChecked(This->subMenu,1)) {
          KillTimer(hWnd,TIMER_REFRESH);
          setChecked(This->subMenu,1,FALSE);
        } else {
          SetTimer(hWnd,TIMER_REFRESH,1000*autoRefresh,NULL);
          setChecked(This->subMenu,1,TRUE);
        }
        break;
      }

      // menu item (OSP)
      if (LOWORD(wParam) == MENU_OSP) {
        if (isChecked(This->subMenu,3)) {
          setChecked(This->subMenu,3,FALSE);
          SendMessage(hWnd,WM_COMMAND,MAKEWPARAM(BUTTON1,BN_CLICKED),NULL);
        } else {
          setChecked(This->subMenu,3,TRUE);
          SendMessage(hWnd,WM_COMMAND,MAKEWPARAM(BUTTON1,BN_CLICKED),NULL);
        }
        break; 
      }

      // menu item (options)
      if (LOWORD(wParam) == MENU_OPTIONS) {
        DialogBoxParam(hInstance, MAKEINTRESOURCE(OPTIONSDLG), hWnd, (DLGPROC) OptionsDlgProc,(LPARAM) This) ;
        // re-initialise auto-refresh (might have changed)        
        SendMessage(hWnd, WM_COMMAND, MAKEWPARAM(MENU_REFRESH,0), 0);
        SendMessage(hWnd, WM_COMMAND, MAKEWPARAM(MENU_REFRESH,0), 0);
        break;
      }

      // menu item (quit)
      if (LOWORD(wParam) == MENU_QUITBROWSER) {
        if (isChecked(This->subMenu,2)) {
          setChecked(This->subMenu,2,FALSE);
        } else {
          setChecked(This->subMenu,2,TRUE);
        }
        break; 
      }
  
      // refresh button 
      if (LOWORD(wParam) == BUTTON1 && HIWORD(wParam) == BN_CLICKED) {
        setGrayed(This->subMenu, 3, TRUE);
        strcpy(This->text, "Waiting for response");
        strcpy(This->ping, "");
        DestroyWindow(This->listbox); This->listbox=NULL;  
        DestroyWindow(This->listbox2); This->listbox2=NULL;
        EnableWindow(This->button1, FALSE);
        EnableWindow(This->button3, FALSE);
        if (This->sendPacketProc(This)) {
          // set timeout timer
          KillTimer(This->fhWnd, TIMER_TIMEOUT);
          SetTimer(This->fhWnd, TIMER_TIMEOUT, 1200, NULL);
        }
        InvalidateRect( hWnd, NULL, TRUE );
	      UpdateWindow(hWnd);
      }
      
      // about button 
      if (LOWORD(wParam) == BUTTON2 && HIWORD(wParam) == BN_CLICKED) {
        DialogBoxParam(hInstance, MAKEINTRESOURCE(ABOUTDLG), hWnd, (DLGPROC) AboutDlgProc,(LPARAM) This) ;
			}

      // connect  
      if (LOWORD(wParam) == BUTTON3 && HIWORD(wParam) == BN_CLICKED) {
        This->getInfo(text);
        if (strstr(text[0], "Quake 3")) {
          exepath = Q3_exepath;
          cmdline = Q3_commandline;
        }
        if (strstr(text[0], "Quake 2")) {
          exepath = Q2_exepath;
          cmdline = Q2_commandline;
        }
				if (strstr(text[0], "Quakeworld")) {
          exepath = QW_exepath;
          cmdline = QW_commandline;
        }
        if (strstr(text[0], "Return To Castle Wolfenstein")) {
          exepath = CW_exepath;
          cmdline = CW_commandline;
        } 
        if (strstr(text[0], "Half Life")) {
          exepath = HL_exepath;
          cmdline = HL_commandline;
        }
        if (strstr(text[0], "Unreal Tournament")) {
          exepath = UT_exepath;
          cmdline = UT_commandline;
        }
               
        if (strstr(text[0], "Tribes")) {
          exepath = TR_exepath;
          cmdline = TR_commandline;
        }
        if (strstr(text[0], "Tribes 2")) {
          exepath = T2_exepath;
          cmdline = T2_commandline;
        }

        if (strstr(text[0], "Jedi Knight 2")) {
          exepath = JK_exepath;
          cmdline = JK_commandline;
        }
        if (strstr(text[0], "Medal of Honor Allied Assault")) {
          exepath = MH_exepath;
          cmdline = MH_commandline;
        }


        // launch game
        wsprintf(tmp, text[3], This->server, This->port);
        if (!startProc(exepath, cmdline, tmp)) {
          MessageBox(hWnd, "Could not launch the game. Please use the options dialog to set the correct path (press right mouse button in plug-in window).", "Error", MB_OK);
        } else 
          if (isChecked(This->subMenu,2)) {  // quit browser?
            current = This->fhWnd;
				    parent = GetParent((HWND)current);
            while ( parent ) {
              current = parent;
              parent = GetParent((HWND)parent);
            }
            if (current != GetDesktopWindow()) 
              PostMessage(current, WM_CLOSE, 0, 0);
          }
      }
      break;
    
    case WM_CONTEXTMENU:
      xPos = LOWORD(lParam); 
      yPos = HIWORD(lParam); 
      TrackPopupMenu(This->subMenu, TPM_LEFTALIGN, xPos, yPos, 0, hWnd, NULL);
      break;

    case WM_TIMER:         // timer message
      if (wParam==TIMER_TIMEOUT) {
        // socket can be closed now
        closesocket(This->sock);
        // re-enable refresh button
        EnableWindow(This->button1, TRUE);     
        strcpy(This->text, "Timed out");
        KillTimer(hWnd, TIMER_TIMEOUT);
        InvalidateRect( hWnd, NULL, TRUE );
	      UpdateWindow( hWnd );
      }
      if (wParam==TIMER_REFRESH) {
        SendMessage(hWnd,WM_COMMAND,MAKEWPARAM(BUTTON1,BN_CLICKED),NULL);  
      }
      break;
                           // paint method for our plugin window
    case WM_PAINT: 
         
      // I don't like this either...  the window doesn't get a WM_CREATE or
      // WM_NCCREATE message upon creation (unless you don't use IE) 
      // So we have to initialize here using the flag not to initialize more than once
      if (!This->initialized) {
        UI_createButtons(This);
        UI_createMenu(This);
        This->initialized = TRUE;
        SendMessage(hWnd,WM_COMMAND,MAKEWPARAM(BUTTON1,BN_CLICKED),NULL);
      }
       
     
      
      // Do the painting
      strcpy(sname, "");
      if (strlen(This->hostname) > 0) {
        strcat(sname, This->hostname);
        strcat(sname, " - ");
      }
      strcat(sname, This->server);
      strcat(sname, ":");
      strcat(sname, This->port);

      GetClientRect(hWnd, &win);
            
      hdc = BeginPaint( hWnd, &paintStruct);
      assert(hdc);
      
      SetBkColor(hdc, This->bgcolor);
      SetTextColor(hdc, This->color);
      
      object = GetStockObject(ANSI_VAR_FONT);
      assert(object);
      SelectObject(hdc, object);

      brush = (HBRUSH) CreateSolidBrush(This->bgcolor);
      assert(brush);
      FillRect(hdc, &win, brush);
      DeleteObject(brush);

      if (win.bottom >= 134 && This->bgcolor == RGB(0,0,0)) {
        memdc = CreateCompatibleDC(hdc);
        old = SelectObject(memdc, This->bitmap);
        BitBlt(hdc, 5, 82, 50, 50, memdc, 0, 0,SRCCOPY);
        object = SelectObject(memdc, old);
        DeleteDC(memdc);
      }
      
      SetTextAlign(hdc, TA_TOP | TA_LEFT);
      TextOut(hdc, 3, 3, infotext, strlen(infotext) );
      
      SetTextAlign(hdc, TA_TOP | TA_CENTER);
      TextOut(hdc, win.right/2, 3, sname, strlen(sname));

      SetTextAlign(hdc, TA_BASELINE | TA_CENTER);
      TextOut(hdc, win.right/2, win.bottom/2, This->text, strlen(This->text));

      // draw colored ping and player display
      if (This->listbox2) {                  
        i=atoi(This->ping);
      
        if (i>=150)
          SetTextColor(hdc, This->color2);
        else
          SetTextColor(hdc, This->color);

        strcpy(tmp2, This->ping);
        strcat(tmp2, " ms");
        
        SetTextAlign(hdc, TA_TOP | TA_RIGHT);
        TextOut(hdc, win.right-3, 3, tmp2, strlen(tmp2));
			
        strcpy(tmp, This->numplayers);
        if (0==strcmp(tmp, This->maxclients))
          SetTextColor(hdc, This->color2);
        else
          SetTextColor(hdc, This->color);  

        strcat(tmp,"/");
        strcat(tmp,This->maxclients);
        
        cur = tmp2; i=0;            // get width of ping text 
        while (*cur) {
          GetCharWidth(hdc,*cur,*cur,&width);
          i+=width;
          cur++;
        }
        SetTextAlign(hdc, TA_TOP | TA_RIGHT);
        TextOut(hdc, win.right-i-10, 3, tmp, strlen(tmp));
      } 
    	EndPaint(hWnd, &paintStruct);
       
      break;
		
		default: 
			This->fDefaultWindowProc( hWnd, Msg, wParam, lParam);
		
	}
	return 0;
}

// dialog proc for about-dialog
LRESULT CALLBACK AboutDlgProc (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam) {
  
  PluginInstance* This;
  HWND win;
  char *text[INFO_ITEMS];

  switch (message) {
     case WM_INITDIALOG :
       This = (PluginInstance*) lParam;
       if (This) {
         This->getInfo(text);
         win = GetDlgItem(hDlg, TEXT1);
         if (win)
           SetWindowText(win, text[1]);
         win = GetDlgItem(hDlg, TEXT0);
         if (win)
           SetWindowText(win, text[0]);
       }
       return TRUE ;
     case WM_COMMAND :
       switch (LOWORD (wParam)) {
         case IDOK :
         case IDCANCEL :
           EndDialog (hDlg, 0) ;
           return TRUE ;
        }
        break ;
   }
     
   return FALSE ;
}


// dialog proc for options-dialog
LRESULT CALLBACK OptionsDlgProc (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam) {  
  PluginInstance* This;
  HWND win,win2;
  char *text[INFO_ITEMS];
  char tmp[256], path[256], cmdline[256];
  OPENFILENAME of;
  static PluginInstance *instance=NULL;

  switch (message) {
     case WM_INITDIALOG :
       This = (PluginInstance*) lParam;
       if (This) {
         instance = This;
         // init strings         
         This->getInfo(text);
         wsprintf(tmp,"Full path to %s executable (eg. c:\\%s\\%s)",text[0],text[0],text[2]);
         win = GetDlgItem(hDlg, OPT_PATH);
         SetWindowText(win, tmp);
         win = GetDlgItem(hDlg, OPT_HEADER);
         wsprintf(tmp,"Options for %s",text[0]);
         SetWindowText(win, tmp);
         win = GetDlgItem(hDlg, OPT_REFRESH);
         wsprintf(tmp,"%d", autoRefresh);
         SetWindowText(win, tmp);
         win = GetDlgItem(hDlg, OPT_PATH_EDIT);
         win2 = GetDlgItem(hDlg, OPT_CMDLINE_EDIT);
         if (strstr(text[0], "Quake 3")) {
           SetWindowText(win, Q3_exepath);
           SetWindowText(win2, Q3_commandline);
         }
         if (strstr(text[0], "Quake 2")) {
           SetWindowText(win, Q2_exepath);
           SetWindowText(win2, Q2_commandline);
         }
         if (strstr(text[0], "Medal of Honor Allied Assault")) {
           SetWindowText(win, MH_exepath);
           SetWindowText(win2, MH_commandline);
         }
				 
         if (strstr(text[0], "Jedi Knight 2")) {
           SetWindowText(win, JK_exepath);
           SetWindowText(win2, JK_commandline);
         }
				 
				 if (strstr(text[0], "Quakeworld")) {
           SetWindowText(win, QW_exepath);
           SetWindowText(win2, QW_commandline);
         }
         if (strstr(text[0], "Return To Castle Wolfenstein")) {
           SetWindowText(win, CW_exepath);
           SetWindowText(win2, CW_commandline);
         }          
         if (strstr(text[0], "Half Life")) {
           SetWindowText(win, HL_exepath);
           SetWindowText(win2, HL_commandline);
         }
         if (strstr(text[0], "Unreal Tournament")) {
           SetWindowText(win, UT_exepath);
           SetWindowText(win2, UT_commandline);
         }                       

         if (strstr(text[0], "Tribes")) {
           SetWindowText(win, TR_exepath);
           SetWindowText(win2, TR_commandline);
         }                       
         if (strstr(text[0], "Tribes 2")) {
           SetWindowText(win, T2_exepath);
           SetWindowText(win2, T2_commandline);
         }                       
       }
       return TRUE ;
     case WM_COMMAND :
       switch (LOWORD (wParam)) {
         case BROWSEBUTTON:
           assert(instance);
           of.lStructSize = sizeof (of);
           of.hwndOwner = hDlg;
           of.hInstance = NULL;
           of.lpstrFilter = "Executables\0*.exe\0\0";
           of.lpstrCustomFilter = NULL;
           of.nMaxCustFilter = 0;
           of.nFilterIndex = 1;
           strcpy(path, "");
           of.lpstrFile = path;
           of.nMaxFile = sizeof (path);
           of.lpstrFileTitle = NULL;
           of.lpstrInitialDir = NULL;
           instance->getInfo(text);
           wsprintf(tmp,"Select %s executable (%s)", text[0],text[2]);
           of.lpstrTitle = tmp;
           of.Flags = OFN_FILEMUSTEXIST | OFN_NOCHANGEDIR | OFN_HIDEREADONLY;
           of.nFileOffset = 0;
           of.nFileExtension = 0;
           of.lpstrDefExt = NULL;
           of.lCustData = 0;
           if (GetOpenFileName(&of) != 0) {
             win = GetDlgItem(hDlg, OPT_PATH_EDIT);
             if (strstr(text[0], "Quake 3")) { 
               strncpy(Q3_exepath, of.lpstrFile, sizeof(Q3_exepath)-1);
               SetWindowText(win, Q3_exepath);
             }
             if (strstr(text[0], "Quake 2")){ 
               strncpy(Q2_exepath, of.lpstrFile, sizeof(Q2_exepath)-1);
               SetWindowText(win, Q2_exepath);
             }
             if (strstr(text[0], "Quakeworld")){ 
               strncpy(QW_exepath, of.lpstrFile, sizeof(QW_exepath)-1);
               SetWindowText(win, QW_exepath);
             }
             if (strstr(text[0], "Return To Castle Wolfenstein")){ 
               strncpy(CW_exepath, of.lpstrFile, sizeof(CW_exepath)-1);
               SetWindowText(win, CW_exepath);
             }             
             if (strstr(text[0], "Half Life")){ 
               strncpy(HL_exepath, of.lpstrFile, sizeof(HL_exepath)-1);
               SetWindowText(win, HL_exepath);
             }
             if (strstr(text[0], "Unreal Tournament")){ 
               strncpy(UT_exepath, of.lpstrFile, sizeof(UT_exepath)-1);
               SetWindowText(win, UT_exepath);
             }
             if (strstr(text[0], "Tribes")){ 
               strncpy(TR_exepath, of.lpstrFile, sizeof(TR_exepath)-1);
               SetWindowText(win, TR_exepath);
             }
             
             if (strstr(text[0], "Tribes 2")){ 
               strncpy(T2_exepath, of.lpstrFile, sizeof(T2_exepath)-1);
               SetWindowText(win, T2_exepath);
             }

             if (strstr(text[0], "Medal of Honor Allied Assault")){ 
               strncpy(MH_exepath, of.lpstrFile, sizeof(MH_exepath)-1);
               SetWindowText(win, MH_exepath);
             }

             if (strstr(text[0], "Jedi Knight 2")){ 
               strncpy(JK_exepath, of.lpstrFile, sizeof(JK_exepath)-1);
               SetWindowText(win, JK_exepath);
             }
           }
           break;
         case IDOK :
           // update auto refresh
           win = GetDlgItem(hDlg, OPT_REFRESH);
           GetWindowText(win,tmp,6);                            
           autoRefresh=atoi(tmp);
           if (autoRefresh<2)
             autoRefresh=2;
       
           // update global path variables
           win = GetDlgItem(hDlg, OPT_HEADER);
           GetWindowText(win,tmp,128);
           win = GetDlgItem(hDlg, OPT_PATH_EDIT);
           GetWindowText(win,path,255);
           win = GetDlgItem(hDlg, OPT_CMDLINE_EDIT);
           GetWindowText(win,cmdline,255);
           
           if (strstr(tmp, "Quake 3")) {
             strcpy(Q3_exepath, path);
             strcpy(Q3_commandline, cmdline);
           }
           if (strstr(tmp, "Quake 2")) {
             strcpy(Q2_exepath, path);
             strcpy(Q2_commandline, cmdline);
           }
           if (strstr(tmp, "Quakeworld")) {
             strcpy(QW_exepath, path);
             strcpy(QW_commandline, cmdline);
           }        
           
           if (strstr(tmp, "Return To Castle Wolfenstein")) {
             strcpy(CW_exepath, path);
             strcpy(CW_commandline, cmdline);
           }        
					 if (strstr(tmp, "Half Life")) {
             strcpy(HL_exepath, path);
             strcpy(HL_commandline, cmdline);
           }
           if (strstr(tmp, "Unreal Tournament")) {
             strcpy(UT_exepath, path);
             strcpy(UT_commandline, cmdline);
           }
           
           if (strstr(tmp, "Tribes")) {
             strcpy(TR_exepath, path);
             strcpy(TR_commandline, cmdline);
           }
           
           if (strstr(tmp, "Tribes 2")) {
             strcpy(T2_exepath, path);
             strcpy(T2_commandline, cmdline);
           }

           if (strstr(tmp, "Medal of Honor Allied Assault")) {
             strcpy(MH_exepath, path);
             strcpy(MH_commandline, cmdline);
           }

           if (strstr(tmp, "Jedi Knight 2")) {
             strcpy(JK_exepath, path);
             strcpy(JK_commandline, cmdline);
           }

           // close dialog
           EndDialog(hDlg,0);
           return TRUE;
         case IDCANCEL :
           EndDialog (hDlg, 0) ;
           return TRUE ;
        }
        break ;
   }
     
   return FALSE ;
}











