unit Sfx;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, IniFiles;

type
  TSfxForm = class(TForm)
    Label1: TLabel;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    EditCaption: TEdit;
    GroupBox4: TGroupBox;
    EditPop: TEdit;
    RBOk: TRadioButton;
    RBOkCancel: TRadioButton;
    RBYesNo: TRadioButton;
    GroupBox5: TGroupBox;
    EditCommand: TEdit;
    RBConfirm: TRadioButton;
    RBAlways: TRadioButton;
    RBNever: TRadioButton;
    Memo1: TMemo;
    RBKpcmf: TRadioButton;
    RBSfx: TRadioButton;
    RBCustom: TRadioButton;
    BtnCustom: TButton;
    Panel1: TPanel;
    ImgIcon: TImage;
    BtnCancel: TButton;
    BtnOK: TButton;
    Label2: TLabel;
    Label3: TLabel;
    OpenDialog: TOpenDialog;
    procedure BtnCancelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure RBkpcmfClick(Sender: TObject);
    procedure RBSfxClick(Sender: TObject);
    procedure RBCustomClick(Sender: TObject);
    procedure BtnCustomClick(Sender: TObject);
    procedure BtnOKClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SfxForm: TSfxForm;


implementation

uses
   Main;    // uses MyDir

var
  CustomIconFileName: string;

{$R *.DFM}

procedure TSfxForm.BtnCancelClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TSfxForm.FormCreate(Sender: TObject);
var
  MyIni: TIniFile;
  str : string;
begin

  MyIni := TIniFile.Create(MyDir+'\q2cmf.ini');

  EditCaption.Text := MyIni.ReadString('SFX','Caption','Install Quake 2 Map');
  EditPop.Text := MyIni.ReadString('SFX','Message','<none>');

  str := MyIni.ReadString('SFX','MessageType','Standard');
  if str = 'Standard' then RBOk.Checked := True
  else if str = 'Information' then RBOkCancel.Checked := True
  else if str = 'Confirmation' then RBYesNo.Checked := True;

  EditCommand.Text := MyIni.ReadString('SFX','CommandLine','<none>');

  str := MyIni.ReadString('SFX','OverwriteMode','Confirm');
  if str = 'Confirm' then RBConfirm.Checked := True
  else if str = 'Always' then RBAlways.Checked := True
  else if str = 'Never' then RBNever.Checked := True;

  str := MyIni.ReadString('SFX','Icon','q2cmf');
  if str = 'q2cmf' then
  begin
      RBkpcmf.Checked := True;
      ImgIcon.Picture.Icon.LoadFromFile(MyDir+'\q2cmf.ico');
  end
  else if str = 'sfx' then
  begin
      RBSfx.Checked := True;
      ImgIcon.Picture.Icon.LoadFromFile(MyDir+'\sfx.ico');
  end
  else
  begin
    RBCustom.Checked := True;
    ImgIcon.Visible := True;
    ImgIcon.Picture.Icon.LoadFromFile(str);
    CustomIconFileName := str;
  end;

  MyIni.Free;
end;

procedure TSfxForm.RBkpcmfClick(Sender: TObject);
begin
  ImgIcon.Picture.Icon.LoadFromFile(MyDir+'\q2cmf.ico');
  BtnCustom.Enabled := False;
  ImgIcon.Visible := True;
end;

procedure TSfxForm.RBSfxClick(Sender: TObject);
begin
  ImgIcon.Picture.Icon.LoadFromFile(MyDir+'\Sfx.ico');
  BtnCustom.Enabled := False;
  ImgIcon.Visible := True;
end;

procedure TSfxForm.RBCustomClick(Sender: TObject);
begin
  BtnCustom.Enabled := True;
  CustomIconFileName := '';
  ImgIcon.Visible := False;
end;

procedure TSfxForm.BtnCustomClick(Sender: TObject);
begin
  OpenDialog.Title := 'Select An Icon';
  OpenDialog.Filter := 'Icon files (*.ico)|*.ICO';
  OpenDialog.OptionsEx := OpenDialog.OptionsEx + [ofExNoPlacesBar];
  if OpenDialog.Execute then
  begin
    Imgicon.Picture.Icon.LoadFromFile(OpenDialog.FileName);
    CustomIconFileName := OpenDialog.FileName;
    ImgIcon.Visible := True;
  end;
end;

procedure TSfxForm.BtnOKClick(Sender: TObject);
var
  MyIni : TIniFile;
  str : string;
begin
  If RBCustom.Checked and (CustomIconFileName = '') then
    ShowMessage('Please select a custom icon.')
  else
  begin
    MyIni := TIniFile.Create(MyDir+'\q2cmf.ini');
    MyIni.WriteString('SFX','Caption',EditCaption.Text);
    MyIni.WriteString('SFX','Message',EditPop.Text);

    if RBOk.Checked then str := 'Standard'
    else if RBOkCancel.Checked then str := 'Information'
    else if RBYesNo.Checked then str := 'Confirmation';
    MyIni.WriteString('SFX','MessageType', str);

    MyIni.WriteString('SFX','CommandLine',EditCommand.Text);

    if RBConfirm.Checked then str := 'Confirm'
    else if RBAlways.Checked then str := 'Always'
    else if RBNever.Checked then str := 'Never';
    MyIni.WriteString('SFX','OverwriteMode',str);

    if RBkpcmf.Checked then str := 'q2cmf'
    else if RBSfx.Checked then str := 'sfx'
    else if RBCustom.Checked then str := CustomIconFileName;
    MyIni.WriteString('SFX','Icon',str);

    MyIni.Free;
    ModalResult := mrOK;
  end;
end;

end.
