float4x4 matWVP;
float3 EyePosition;
float3 FogColor;
float FogDist;

sampler BaseSampler			: register(s0);
sampler LightmapSampler		: register(s1);

struct ZONE_VERTEX {
	float3	position: POSITION0;
	float3	normal: NORMAL0;
	float2	texcoord: TEXCOORD0;
	float2	lumelcoord: TEXCOORD1;
};

//transformed vertex
struct ZONE_TVERTEX {
	float4	Position: POSITION0;
	//rearranged because of limitations in 1.1
	//texcoord number must match sampler register number
	float2	texcoord: TEXCOORD0;
	float2	lumelcoord: TEXCOORD1;
	float3	position: TEXCOORD2;
	//float3	normal: TEXCOORD3;
	float positionDistance: PSIZE;
};

float3 GetLinearFog (const float3 worldPosition);

void TransformVertex (in ZONE_VERTEX IN, out ZONE_TVERTEX OUT)
{
	OUT.Position = mul(float4(IN.position.xyz, 1.0f), matWVP);
	OUT.position = IN.position;
	//OUT.normal = IN.normal;
	OUT.texcoord = IN.texcoord;
	OUT.lumelcoord = IN.lumelcoord;
	
	OUT.positionDistance = length(EyePosition - IN.position);
}

float4 ColorVertex (in ZONE_TVERTEX IN): COLOR0
{
	float4	color;
	float4	base;
	float4	lightmap;
	float3	fog;
	
	base = tex2D(BaseSampler, IN.texcoord);
	lightmap = tex2D(LightmapSampler, IN.lumelcoord);
	//fog = GetLinearFog(IN.position);
	fog.rgb = 1.0f - saturate(IN.positionDistance / FogDist);
	
	color.a = 0.0f;
	color.rgb = base.rgb * lightmap.rgb * fog.rgb;
	
	return color;
}

float3 GetLinearFog (const float3 worldPosition)
{
	float3 color;
	float dist;
	float atten;
	
	dist = length(worldPosition - EyePosition);
	atten = 1.0f - saturate(dist / FogDist);
	color = FogColor * atten;
	
	return color;
}

technique techDefault {
	pass p0 {
		VertexShader = compile vs_1_1 TransformVertex();
		PixelShader = compile ps_1_1 ColorVertex();
	}
}