sampler SceneSampler		: register(s0);
sampler BloomSampler		: register(s1);

struct PP_VERTEX {
	float4 position: POSITION0;
	float2 texcoord: TEXCOORD0;
};

struct PP_TVERTEX {
	float4 Position: POSITION0;
	float2 texcoord: TEXCOORD0;
};

void TransformVertex (in PP_VERTEX IN, out PP_TVERTEX OUT)
{
	OUT.Position = IN.position;
	OUT.texcoord = IN.texcoord;
}

//============================================

float4 ColorVertex_Final (in PP_TVERTEX v): COLOR0 
{
	float brightSpot;
	float sceneAverage;
	float4 scene;
	float4 bloom;
	float4 color;
	
	scene = tex2D(SceneSampler, v.texcoord);
	bloom = tex2D(BloomSampler, v.texcoord);
	
#if 0
	sceneAverage = (bloom.r + bloom.g + bloom.b) / 3;
	brightSpot = saturate(sceneAverage - 0.15f) * 12.0f;
#else
	sceneAverage = max(bloom.r, bloom.g);
	sceneAverage = max(sceneAverage, bloom.b);
	brightSpot = saturate(sceneAverage - 0.1f) * 7.0f;
#endif

	//return bloom;
	//return float4(brightSpot, brightSpot, brightSpot, brightSpot);

	color = pow(saturate(scene), 1.2f) + bloom * brightSpot;
	
	return color;
}

technique techBloom {
	pass p0 {
		VertexShader	= compile vs_2_0 TransformVertex();
		PixelShader		= compile ps_2_0 ColorVertex_Final();
	}
}

//============================================

float2 BlurTextureOffsets[15];
float BlurWeights[15];

float4 ColorVertex_Blur5x5 (in PP_TVERTEX v): COLOR0
{
	float4 color;
	float2 texcoord;
	
	color = (float4)0;
	for (int i=0; i<15; i++) {
		texcoord = v.texcoord + BlurTextureOffsets[i];
		color += tex2D(SceneSampler, texcoord) * BlurWeights[i];
	}
	
	return color;
}

technique techBlur {
	pass p0 {
		VertexShader	= compile vs_2_0 TransformVertex();
		PixelShader		= compile ps_2_0 ColorVertex_Blur5x5();
	}
}